/*
 * Decompiled with CFR 0.152.
 */
package gate.config;

import gate.config.ConfigXmlHandler;
import gate.util.GateException;
import gate.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigDataProcessor {
    protected static final boolean DEBUG = false;
    protected SAXParser parser = null;

    public ConfigDataProcessor() throws GateException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(true);
            this.parser = saxParserFactory.newSAXParser();
        }
        catch (SAXException e) {
            throw new GateException(e);
        }
        catch (ParserConfigurationException e) {
            throw new GateException(e);
        }
    }

    public void parseConfigFile(InputStream configStream, URL configUrl) throws GateException {
        String nl = Strings.getNl();
        Object configString = null;
        try {
            ConfigXmlHandler handler = new ConfigXmlHandler(configUrl);
            this.parser.parse(configStream, (DefaultHandler)handler);
        }
        catch (IOException e) {
            throw new GateException("Config data error 1 on " + configUrl + ": " + nl + e);
        }
        catch (SAXException e) {
            throw new GateException("Config data error 2 on " + configUrl + ": " + nl + e);
        }
    }
}

