/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.FeatureMap;
import gate.Gate;
import gate.Node;
import gate.annotation.AnnotationFactory;
import gate.annotation.AnnotationImpl;
import gate.annotation.DefaultAnnotationFactory;
import gate.annotation.ImmutableAnnotationSetImpl;
import gate.annotation.NodeImpl;
import gate.corpora.DocumentImpl;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.GateEvent;
import gate.event.GateListener;
import gate.relations.RelationSet;
import gate.util.InvalidOffsetException;
import gate.util.RBTreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class AnnotationSetImpl
extends AbstractSet<Annotation>
implements AnnotationSet {
    static final long serialVersionUID = 1479426765310434166L;
    String name = null;
    DocumentImpl doc;
    protected transient HashMap<Integer, Annotation> annotsById = new HashMap();
    transient RBTreeMap<Long, Node> nodesByOffset = null;
    private Annotation[] annotations;
    transient Map<String, AnnotationSet> annotsByType = null;
    transient Map<Integer, Object> annotsByStartNode;
    protected transient Vector<AnnotationSetListener> annotationSetListeners;
    private transient Vector<GateListener> gateListeners;
    protected transient Long longestAnnot = 0L;
    protected RelationSet relations = null;
    protected static AnnotationFactory annFactory;

    public AnnotationSetImpl(Document doc) {
        this.doc = (DocumentImpl)doc;
    }

    public AnnotationSetImpl(Document doc, String name) {
        this(doc);
        this.name = name;
    }

    public AnnotationSetImpl(AnnotationSet c) throws ClassCastException {
        this(c.getDocument(), c.getName());
        if (c instanceof AnnotationSetImpl) {
            AnnotationSetImpl theC = (AnnotationSetImpl)c;
            this.annotsById.putAll(theC.annotsById);
            if (theC.annotsByStartNode != null) {
                this.annotsByStartNode = new HashMap<Integer, Object>(4);
                this.annotsByStartNode.putAll(theC.annotsByStartNode);
            }
            if (theC.annotsByType != null) {
                this.annotsByType = new HashMap<String, AnnotationSet>(4);
                this.annotsByType.putAll(theC.annotsByType);
            }
            if (theC.nodesByOffset != null) {
                this.nodesByOffset = (RBTreeMap)theC.nodesByOffset.clone();
            }
        } else {
            Iterator<Annotation> iterannots = c.iterator();
            while (iterannots.hasNext()) {
                this.add(iterannots.next());
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.annotsById = new HashMap();
        this.nodesByOffset = null;
        this.annotsByStartNode = null;
        this.annotsByType = null;
        this.longestAnnot = 0L;
    }

    @Override
    public Iterator<Annotation> iterator() {
        return new AnnotationSetIterator();
    }

    @Override
    public boolean remove(Object o) throws ClassCastException {
        Annotation a = (Annotation)o;
        boolean wasPresent = this.removeFromIdIndex(a);
        if (wasPresent) {
            this.removeFromTypeIndex(a);
            this.removeFromOffsetIndex(a);
        }
        this.fireAnnotationRemoved(new AnnotationSetEvent(this, 202, this.getDocument(), a));
        return wasPresent;
    }

    protected boolean removeFromIdIndex(Annotation a) {
        return this.annotsById.remove(a.getId()) != null;
    }

    protected void removeFromTypeIndex(Annotation a) {
        if (this.annotsByType != null) {
            AnnotationSet sameType = this.annotsByType.get(a.getType());
            if (sameType != null) {
                sameType.remove(a);
            }
            if (sameType != null && sameType.isEmpty()) {
                this.annotsByType.remove(a.getType());
            }
        }
    }

    protected void removeFromOffsetIndex(Annotation a) {
        if (this.annotsByStartNode != null) {
            Integer id = a.getStartNode().getId();
            Object objectAtNode = this.annotsByStartNode.get(id);
            if (objectAtNode instanceof Annotation) {
                this.annotsByStartNode.remove(id);
                return;
            }
            Collection starterAnnots = (Collection)objectAtNode;
            starterAnnots.remove(a);
            if (starterAnnots.size() == 1) {
                this.annotsByStartNode.put(id, starterAnnots.iterator().next());
            }
        }
    }

    @Override
    public int size() {
        return this.annotsById.size();
    }

    @Override
    public Annotation get(Integer id) {
        return this.annotsById.get(id);
    }

    @Override
    public AnnotationSet get() {
        if (this.annotsById.isEmpty()) {
            return this.emptyAS();
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, this.annotsById.values());
    }

    @Override
    public AnnotationSet get(String type) {
        AnnotationSet byType;
        if (this.annotsByType == null) {
            this.indexByType();
        }
        if ((byType = this.annotsByType.get(type)) == null) {
            return this.emptyAS();
        }
        return byType.get();
    }

    @Override
    public AnnotationSet get(Set<String> types) throws ClassCastException {
        if (this.annotsByType == null) {
            this.indexByType();
        }
        Iterator<String> iter = types.iterator();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        while (iter.hasNext()) {
            String type = iter.next();
            AnnotationSet as = this.annotsByType.get(type);
            if (as == null) continue;
            Iterator<Annotation> iterAnnot = as.iterator();
            while (iterAnnot.hasNext()) {
                annotations.add(iterAnnot.next());
            }
        }
        if (annotations.isEmpty()) {
            return this.emptyAS();
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotations);
    }

    @Override
    public AnnotationSet get(String type, FeatureMap constraints) {
        AnnotationSet typeSet;
        if (this.annotsByType == null) {
            this.indexByType();
        }
        if ((typeSet = this.get(type)) == null) {
            return null;
        }
        Iterator<Annotation> iter = typeSet.iterator();
        ArrayList<Annotation> annotationsToAdd = new ArrayList<Annotation>();
        while (iter.hasNext()) {
            Annotation a = iter.next();
            if (!a.getFeatures().subsumes(constraints)) continue;
            annotationsToAdd.add(a);
        }
        if (annotationsToAdd.isEmpty()) {
            return this.emptyAS();
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public AnnotationSet get(String type, Set<? extends Object> featureNames) {
        if (this.annotsByType == null) {
            this.indexByType();
        }
        AnnotationSet typeSet = null;
        if (type != null && (typeSet = this.get(type)) == null) {
            return null;
        }
        ArrayList<Annotation> annotationsToAdd = new ArrayList<Annotation>();
        Iterator<Annotation> iter = null;
        iter = type != null ? typeSet.iterator() : this.annotsById.values().iterator();
        while (iter.hasNext()) {
            Annotation a = iter.next();
            if (!a.getFeatures().keySet().containsAll(featureNames)) continue;
            annotationsToAdd.add(a);
        }
        if (annotationsToAdd.isEmpty()) {
            return this.emptyAS();
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public AnnotationSet get(Long offset) {
        Node nextNode;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        if ((nextNode = this.nodesByOffset.getNextOf(offset)) == null) {
            return this.emptyAS();
        }
        Collection<Annotation> annotationsToAdd = this.getAnnotsByStartNode(nextNode.getId());
        while (annotationsToAdd == null) {
            if ((nextNode = this.nodesByOffset.getNextOf(nextNode.getOffset() + 1L)) == null) {
                return this.emptyAS();
            }
            annotationsToAdd = this.getAnnotsByStartNode(nextNode.getId());
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    public AnnotationSet getStartingAt(long offset) {
        Node node;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        if ((node = this.nodesByOffset.get(offset)) == null) {
            return this.emptyAS();
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, this.getAnnotsByStartNode(node.getId()));
    }

    @Override
    public List<Annotation> inDocumentOrder() {
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        Collection<Node> values = this.nodesByOffset.values();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Node nodeObj : values) {
            Collection<Annotation> anns = this.getAnnotsByStartNode(nodeObj.getId());
            if (anns == null) continue;
            result.addAll(anns);
        }
        return result;
    }

    @Override
    public AnnotationSet get(Long startOffset, Long endOffset) {
        return this.get(null, startOffset, endOffset);
    }

    public AnnotationSet getStrict(Long startOffset, Long endOffset) {
        Collection<Annotation> objFromPoint;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> annotationsToAdd = null;
        Node currentNode = this.nodesByOffset.get(startOffset);
        if (currentNode != null && (objFromPoint = this.getAnnotsByStartNode(currentNode.getId())) != null) {
            for (Annotation currentAnnot : objFromPoint) {
                if (currentAnnot.getEndNode().getOffset().compareTo(endOffset) != 0) continue;
                if (annotationsToAdd == null) {
                    annotationsToAdd = new ArrayList<Annotation>();
                }
                annotationsToAdd.add(currentAnnot);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public AnnotationSet get(String neededType, Long startOffset, Long endOffset) {
        Collection<Annotation> objFromPoint;
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> annotationsToAdd = new ArrayList<Annotation>();
        boolean checkType = StringUtils.isNotBlank((String)neededType);
        Long searchStart = startOffset - this.longestAnnot;
        if (searchStart < 0L) {
            searchStart = 0L;
        }
        for (Node currentNode : this.nodesByOffset.subMap((Object)searchStart, (Object)startOffset).values()) {
            objFromPoint = this.getAnnotsByStartNode(currentNode.getId());
            if (objFromPoint == null) continue;
            for (Annotation currentAnnot : objFromPoint) {
                if (checkType && !currentAnnot.getType().equals(neededType) || currentAnnot.getEndNode().getOffset().compareTo(startOffset) <= 0) continue;
                annotationsToAdd.add(currentAnnot);
            }
        }
        for (Node currentNode : this.nodesByOffset.subMap((Object)startOffset, (Object)endOffset).values()) {
            objFromPoint = this.getAnnotsByStartNode(currentNode.getId());
            if (objFromPoint == null) continue;
            if (!checkType) {
                annotationsToAdd.addAll(objFromPoint);
                continue;
            }
            for (Annotation currentAnnot : objFromPoint) {
                if (!currentAnnot.getType().equals(neededType)) continue;
                annotationsToAdd.add(currentAnnot);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public AnnotationSet getCovering(String neededType, Long startOffset, Long endOffset) {
        if (endOffset < startOffset) {
            return this.emptyAS();
        }
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        if (endOffset - startOffset > this.longestAnnot) {
            return this.emptyAS();
        }
        ArrayList<Annotation> annotationsToAdd = new ArrayList<Annotation>();
        boolean checkType = StringUtils.isNotBlank((String)neededType);
        Long searchStart = endOffset - 1L - this.longestAnnot;
        if (searchStart < 0L) {
            searchStart = 0L;
        }
        for (Node currentNode : this.nodesByOffset.subMap((Object)searchStart, (Object)(startOffset + 1L)).values()) {
            Collection<Annotation> objFromPoint = this.getAnnotsByStartNode(currentNode.getId());
            if (objFromPoint == null) continue;
            for (Annotation currentAnnot : objFromPoint) {
                if (checkType && !currentAnnot.getType().equals(neededType) || currentAnnot.getEndNode().getOffset().compareTo(endOffset) < 0) continue;
                annotationsToAdd.add(currentAnnot);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public AnnotationSet get(String type, FeatureMap constraints, Long offset) {
        AnnotationSet nextAnnots = this.get(offset);
        return nextAnnots.get(type, constraints);
    }

    @Override
    public AnnotationSet getContained(Long startOffset, Long endOffset) {
        if (endOffset < startOffset) {
            return this.emptyAS();
        }
        if (this.annotsByStartNode == null) {
            this.indexByStartOffset();
        }
        ArrayList<Annotation> annotationsToAdd = null;
        for (Node currentNode : this.nodesByOffset.subMap((Object)startOffset, (Object)endOffset).values()) {
            Collection<Annotation> objFromPoint = this.getAnnotsByStartNode(currentNode.getId());
            if (objFromPoint == null) continue;
            for (Annotation annot : objFromPoint) {
                if (annot.getEndNode().getOffset().compareTo(endOffset) > 0) continue;
                if (annotationsToAdd == null) {
                    annotationsToAdd = new ArrayList<Annotation>();
                }
                annotationsToAdd.add(annot);
            }
        }
        return new ImmutableAnnotationSetImpl((Document)this.doc, annotationsToAdd);
    }

    @Override
    public Node firstNode() {
        this.indexByStartOffset();
        if (this.nodesByOffset.isEmpty()) {
            return null;
        }
        return this.nodesByOffset.get(this.nodesByOffset.firstKey());
    }

    @Override
    public Node lastNode() {
        this.indexByStartOffset();
        if (this.nodesByOffset.isEmpty()) {
            return null;
        }
        return this.nodesByOffset.get(this.nodesByOffset.lastKey());
    }

    @Override
    public Node nextNode(Node node) {
        this.indexByStartOffset();
        return this.nodesByOffset.getNextOf(node.getOffset() + 1L);
    }

    public static void setAnnotationFactory(AnnotationFactory newFactory) {
        annFactory = newFactory;
    }

    @Override
    public Integer add(Node start, Node end, String type, FeatureMap features) {
        Integer id = this.doc.getNextAnnotationId();
        annFactory.createAnnotationInSet(this, id, start, end, type, features);
        return id;
    }

    @Override
    public boolean add(Annotation a) throws ClassCastException {
        Annotation oldValue = this.annotsById.put(a.getId(), a);
        if (oldValue != null) {
            if (this.annotsByType != null) {
                this.removeFromTypeIndex(oldValue);
            }
            if (this.annotsByStartNode != null) {
                this.removeFromOffsetIndex(oldValue);
            }
        }
        if (this.annotsByType != null) {
            this.addToTypeIndex(a);
        }
        if (this.annotsByStartNode != null) {
            this.addToStartOffsetIndex(a);
        }
        AnnotationSetEvent evt = new AnnotationSetEvent(this, 201, this.doc, a);
        this.fireAnnotationAdded(evt);
        this.fireGateEvent(evt);
        return oldValue != a;
    }

    @Override
    public boolean addAll(Collection<? extends Annotation> c) {
        Iterator<? extends Annotation> annIter = c.iterator();
        boolean changed = false;
        while (annIter.hasNext()) {
            Annotation a = annIter.next();
            try {
                this.add(a.getStartNode().getOffset(), a.getEndNode().getOffset(), a.getType(), a.getFeatures());
                changed = true;
            }
            catch (InvalidOffsetException ioe) {
                throw new IllegalArgumentException(ioe.toString());
            }
        }
        return changed;
    }

    protected boolean addAllKeepIDs(Collection<? extends Annotation> c) {
        Iterator<? extends Annotation> annIter = c.iterator();
        boolean changed = false;
        while (annIter.hasNext()) {
            Annotation a = annIter.next();
            changed |= this.add(a);
        }
        return changed;
    }

    private final Node[] getNodes(Long start, Long end) throws InvalidOffsetException {
        Node startNode;
        if (!this.doc.isValidOffsetRange(start, end)) {
            throw new InvalidOffsetException("Offsets [" + start + ":" + end + "] not valid for this document of size " + this.doc.getContent().size());
        }
        if (this.nodesByOffset == null) {
            this.indexByStartOffset();
        }
        if ((startNode = this.nodesByOffset.get(start)) == null) {
            startNode = new NodeImpl(this.doc.getNextNodeId(), start);
        }
        Node endNode = null;
        if (start.equals(end)) {
            endNode = startNode;
            return new Node[]{startNode, endNode};
        }
        endNode = this.nodesByOffset.get(end);
        if (endNode == null) {
            endNode = new NodeImpl(this.doc.getNextNodeId(), end);
        }
        return new Node[]{startNode, endNode};
    }

    @Override
    public Integer add(Long start, Long end, String type, FeatureMap features) throws InvalidOffsetException {
        Node[] nodes = this.getNodes(start, end);
        return this.add(nodes[0], nodes[1], type, features);
    }

    @Override
    public void add(Integer id, Long start, Long end, String type, FeatureMap features) throws InvalidOffsetException {
        Node[] nodes = this.getNodes(start, end);
        annFactory.createAnnotationInSet(this, id, nodes[0], nodes[1], type, features);
        if (id >= this.doc.peakAtNextAnnotationId()) {
            this.doc.setNextAnnotationId(id + 1);
        }
    }

    protected void indexByType() {
        if (this.annotsByType != null) {
            return;
        }
        this.annotsByType = new HashMap<String, AnnotationSet>(4);
        Iterator<Annotation> annotIter = this.annotsById.values().iterator();
        while (annotIter.hasNext()) {
            this.addToTypeIndex(annotIter.next());
        }
    }

    protected void indexByStartOffset() {
        if (this.annotsByStartNode != null) {
            return;
        }
        if (this.nodesByOffset == null) {
            this.nodesByOffset = new RBTreeMap();
        }
        this.annotsByStartNode = new HashMap<Integer, Object>(this.annotsById.size());
        Iterator<Annotation> annotIter = this.annotsById.values().iterator();
        while (annotIter.hasNext()) {
            this.addToStartOffsetIndex(annotIter.next());
        }
    }

    void addToTypeIndex(Annotation a) {
        if (this.annotsByType == null) {
            return;
        }
        String type = a.getType();
        AnnotationSet sameType = this.annotsByType.get(type);
        if (sameType == null) {
            sameType = new AnnotationSetImpl(this.doc);
            this.annotsByType.put(type, sameType);
        }
        sameType.add(a);
    }

    void addToStartOffsetIndex(Annotation a) {
        long annotLength;
        Node startNode = a.getStartNode();
        Node endNode = a.getEndNode();
        Long start = startNode.getOffset();
        Long end = endNode.getOffset();
        if (this.nodesByOffset != null) {
            this.nodesByOffset.put(start, startNode);
            this.nodesByOffset.put(end, endNode);
        }
        if ((annotLength = end - start) > this.longestAnnot) {
            this.longestAnnot = annotLength;
        }
        if (this.annotsByStartNode == null) {
            return;
        }
        Object thisNodeObject = this.annotsByStartNode.get(startNode.getId());
        if (thisNodeObject == null) {
            this.annotsByStartNode.put(startNode.getId(), a);
        } else {
            HashSet<Annotation> newCollection = null;
            if (thisNodeObject instanceof Annotation) {
                if (thisNodeObject.equals(a)) {
                    return;
                }
                newCollection = new HashSet<Annotation>(3);
                newCollection.add((Annotation)thisNodeObject);
                this.annotsByStartNode.put(startNode.getId(), newCollection);
            } else {
                newCollection = (HashSet<Annotation>)thisNodeObject;
            }
            newCollection.add(a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void edit(Long start, Long end, DocumentContent replacement) {
        this.indexByStartOffset();
        if (end.compareTo(start) > 0) {
            ArrayList<Node> affectedNodes = new ArrayList<Node>(this.nodesByOffset.subMap((Object)start, (Object)(end + 1L)).values());
            NodeImpl firstNode = null;
            if (!affectedNodes.isEmpty()) {
                void var11_25;
                firstNode = (NodeImpl)affectedNodes.get(0);
                ArrayList<Annotation> startingAnnotations = new ArrayList<Annotation>();
                ArrayList<Annotation> endingAnnotations = new ArrayList<Annotation>();
                ArrayList<Node> beforeNodes = new ArrayList<Node>(this.nodesByOffset.subMap((Object)0L, (Object)(end + 1L)).values());
                for (Node currentNode : beforeNodes) {
                    Collection<Annotation> collection = this.getAnnotsByStartNode(currentNode.getId());
                    if (collection == null) continue;
                    for (Annotation annotation : collection) {
                        long offsetEndAnnotation = annotation.getEndNode().getOffset();
                        if (offsetEndAnnotation < start || offsetEndAnnotation > end) continue;
                        endingAnnotations.add(annotation);
                    }
                }
                for (int i = 1; i < affectedNodes.size(); ++i) {
                    Node node = (Node)affectedNodes.get(i);
                    Collection<Annotation> annSet = this.getAnnotsByStartNode(node.getId());
                    if (annSet == null) continue;
                    startingAnnotations.addAll(annSet);
                }
                for (AnnotationImpl annotationImpl : startingAnnotations) {
                    annotationImpl.start = firstNode;
                    if (annotationImpl.start == annotationImpl.end) {
                        this.remove(annotationImpl);
                        continue;
                    }
                    this.addToStartOffsetIndex(annotationImpl);
                }
                for (AnnotationImpl annotationImpl : endingAnnotations) {
                    annotationImpl.end = firstNode;
                    if (annotationImpl.start != annotationImpl.end) continue;
                    this.remove(annotationImpl);
                }
                boolean bl = true;
                while (var11_25 < affectedNodes.size()) {
                    Node aNode = (Node)affectedNodes.get((int)var11_25);
                    this.nodesByOffset.remove(aNode.getOffset());
                    this.annotsByStartNode.remove(aNode.getId());
                    ++var11_25;
                }
                this.nodesByOffset.remove(firstNode.getOffset());
                firstNode.setOffset(start);
                this.nodesByOffset.put(firstNode.getOffset(), firstNode);
            }
        }
        boolean shouldPrepend = Gate.getUserConfig().getBoolean("docedit_insert_prepend");
        long s = start;
        long e = end;
        long rlen = replacement == null ? 0L : replacement.size();
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodesByOffset.tailMap(start).values());
        for (NodeImpl nodeImpl : arrayList) {
            this.nodesByOffset.remove(nodeImpl.getOffset());
        }
        for (NodeImpl nodeImpl : arrayList) {
            long oldOffset = nodeImpl.getOffset();
            long newOffset = oldOffset - (e - s) + rlen;
            if (oldOffset == s) {
                if (newOffset < s) {
                    newOffset = s;
                }
                if (shouldPrepend) {
                    newOffset = s;
                }
            }
            nodeImpl.setOffset(newOffset);
        }
        for (NodeImpl nodeImpl : arrayList) {
            this.nodesByOffset.put(nodeImpl.getOffset(), nodeImpl);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public Set<String> getAllTypes() {
        this.indexByType();
        return Collections.unmodifiableSet(this.annotsByType.keySet());
    }

    private final Collection<Annotation> getAnnotsByStartNode(Integer id) {
        Object objFromPoint = this.annotsByStartNode.get(id);
        if (objFromPoint == null) {
            return null;
        }
        if (objFromPoint instanceof Annotation) {
            ArrayList<Annotation> al = new ArrayList<Annotation>(2);
            al.add((Annotation)objFromPoint);
            return al;
        }
        return (Collection)objFromPoint;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public synchronized void removeAnnotationSetListener(AnnotationSetListener l) {
        if (this.annotationSetListeners != null && this.annotationSetListeners.contains(l)) {
            Vector v = (Vector)this.annotationSetListeners.clone();
            v.removeElement(l);
            this.annotationSetListeners = v;
        }
    }

    @Override
    public synchronized void addAnnotationSetListener(AnnotationSetListener l) {
        Vector v;
        Vector vector = v = this.annotationSetListeners == null ? new Vector(2) : (Vector)this.annotationSetListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.annotationSetListeners = v;
        }
    }

    protected void fireAnnotationAdded(AnnotationSetEvent e) {
        if (this.annotationSetListeners != null) {
            Vector<AnnotationSetListener> listeners = this.annotationSetListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).annotationAdded(e);
            }
        }
    }

    protected void fireAnnotationRemoved(AnnotationSetEvent e) {
        if (this.annotationSetListeners != null) {
            Vector<AnnotationSetListener> listeners = this.annotationSetListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).annotationRemoved(e);
            }
        }
    }

    @Override
    public synchronized void removeGateListener(GateListener l) {
        if (this.gateListeners != null && this.gateListeners.contains(l)) {
            Vector v = (Vector)this.gateListeners.clone();
            v.removeElement(l);
            this.gateListeners = v;
        }
    }

    @Override
    public synchronized void addGateListener(GateListener l) {
        Vector v;
        Vector vector = v = this.gateListeners == null ? new Vector(2) : (Vector)this.gateListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.gateListeners = v;
        }
    }

    protected void fireGateEvent(GateEvent e) {
        if (this.gateListeners != null) {
            Vector<GateListener> listeners = this.gateListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processGateEvent(e);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pf = out.putFields();
        pf.put("name", this.name);
        pf.put("doc", this.doc);
        this.annotations = new Annotation[this.annotsById.size()];
        this.annotations = this.annotsById.values().toArray(this.annotations);
        pf.put("annotations", this.annotations);
        pf.put("relations", this.relations);
        out.writeFields();
        this.annotations = null;
        boolean isIndexedByType = this.annotsByType != null;
        boolean isIndexedByStartNode = this.annotsByStartNode != null;
        out.writeBoolean(isIndexedByType);
        out.writeBoolean(isIndexedByStartNode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.longestAnnot = 0L;
        ObjectInputStream.GetField gf = in.readFields();
        this.name = (String)gf.get("name", null);
        this.doc = (DocumentImpl)gf.get("doc", null);
        boolean isIndexedByType = false;
        boolean isIndexedByStartNode = false;
        this.annotations = (Annotation[])gf.get("annotations", null);
        if (this.annotations == null) {
            Map annotsByIdMap = (Map)gf.get("annotsById", null);
            if (annotsByIdMap == null) {
                throw new IOException("Invalid serialised data: neither annotations array or map by id are present.");
            }
            this.annotations = annotsByIdMap.values().toArray(new Annotation[0]);
        } else {
            isIndexedByType = in.readBoolean();
            isIndexedByStartNode = in.readBoolean();
        }
        this.annotsById = new HashMap(this.annotations.length);
        if (isIndexedByType) {
            this.annotsByType = new HashMap<String, AnnotationSet>(4);
        }
        if (isIndexedByStartNode) {
            this.nodesByOffset = new RBTreeMap();
            this.annotsByStartNode = new HashMap<Integer, Object>(this.annotations.length);
        }
        for (int i = 0; i < this.annotations.length; ++i) {
            this.add(this.annotations[i]);
        }
        this.relations = (RelationSet)gf.get("relations", null);
        this.annotations = null;
    }

    @Override
    public RelationSet getRelations() {
        if (this.relations == null) {
            this.relations = new RelationSet(this);
        }
        return this.relations;
    }

    protected AnnotationSet emptyAS() {
        return new ImmutableAnnotationSetImpl((Document)this.doc, null);
    }

    static {
        AnnotationSetImpl.setAnnotationFactory(new DefaultAnnotationFactory());
    }

    class AnnotationSetIterator
    implements Iterator<Annotation> {
        private Iterator<Annotation> iter;
        protected Annotation lastNext = null;

        AnnotationSetIterator() {
            this.iter = AnnotationSetImpl.this.annotsById.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Annotation next() {
            this.lastNext = this.iter.next();
            return this.lastNext;
        }

        @Override
        public void remove() {
            this.iter.remove();
            if (this.lastNext == null) {
                return;
            }
            AnnotationSetImpl.this.removeFromTypeIndex(this.lastNext);
            AnnotationSetImpl.this.removeFromOffsetIndex(this.lastNext);
            AnnotationSetImpl.this.fireAnnotationRemoved(new AnnotationSetEvent(AnnotationSetImpl.this, 202, AnnotationSetImpl.this.getDocument(), this.lastNext));
        }
    }
}

