/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.DataStore;
import gate.Gate;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DataStoreRegister
extends HashSet<DataStore> {
    private static final long serialVersionUID = 1L;
    private transient Vector<CreoleListener> creoleListeners;

    public static Map<String, String> getDataStoreClassNames() {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put("gate.persist.SerialDataStore", "SerialDataStore: file-based storage using Java serialisation");
        names.put("gate.persist.LuceneDataStoreImpl", "Lucene Based Searchable DataStore");
        try {
            if (Class.forName("gleam.docservice.gate.DocServiceDataStore", true, Gate.getClassLoader()) != null) {
                names.put("gleam.docservice.gate.DocServiceDataStore", "SAFE DocService DataStore");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return names;
    }

    @Override
    public boolean add(DataStore o) {
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean res = super.remove(o);
        if (res) {
            this.fireDatastoreClosed(new CreoleEvent((DataStore)o, 5));
        }
        return res;
    }

    @Override
    public void clear() {
        HashSet<DataStore> datastores = new HashSet<DataStore>(this);
        super.clear();
        Iterator iter = datastores.iterator();
        while (iter.hasNext()) {
            this.fireDatastoreClosed(new CreoleEvent((DataStore)iter.next(), 5));
        }
    }

    public synchronized void removeCreoleListener(CreoleListener l) {
        if (this.creoleListeners != null && this.creoleListeners.contains(l)) {
            Vector v = (Vector)this.creoleListeners.clone();
            v.removeElement(l);
            this.creoleListeners = v;
        }
    }

    public synchronized void addCreoleListener(CreoleListener l) {
        Vector v;
        Vector vector = v = this.creoleListeners == null ? new Vector(2) : (Vector)this.creoleListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.creoleListeners = v;
        }
    }

    protected void fireDatastoreOpened(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreOpened(e);
            }
        }
    }

    protected void fireDatastoreCreated(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreCreated(e);
            }
        }
    }

    protected void fireDatastoreClosed(CreoleEvent e) {
        if (this.creoleListeners != null) {
            Vector<CreoleListener> listeners = this.creoleListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).datastoreClosed(e);
            }
        }
    }
}

