/*
 * Decompiled with CFR 0.152.
 */
package gate.xml;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentContentImpl;
import gate.corpora.RepositioningInfo;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.GateSaxException;
import gate.util.InvalidOffsetException;
import gate.util.OptionsMap;
import gate.xml.SimpleErrorHandler;
import gate.xml.XmlPositionCorrectionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDocumentHandler
extends XmlPositionCorrectionHandler {
    private static final boolean DEBUG = false;
    private RepositioningInfo reposInfo = null;
    private RepositioningInfo ampCodingInfo = null;
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    private boolean deserializeNamespaceInfo = false;
    private String namespaceURIFeature = null;
    private String namespacePrefixFeature = null;
    static final int ELEMENTS_RATE = 128;
    private Map<String, String> markupElementsMap = null;
    private Map<String, String> element2StringMap = null;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private StringBuffer tmpDocContent = null;
    private Stack<CustomObject> stack = null;
    private Document doc = null;
    private AnnotationSet basicAS = null;
    protected List<StatusListener> myStatusListeners = new LinkedList<StatusListener>();
    private int elements = 0;
    private LinkedList<CustomObject> colector = null;
    protected int customObjectsId = 0;

    public void setRepositioningInfo(RepositioningInfo info) {
        this.reposInfo = info;
    }

    public RepositioningInfo getRepositioningInfo() {
        return this.reposInfo;
    }

    public void setAmpCodingInfo(RepositioningInfo info) {
        this.ampCodingInfo = info;
    }

    public RepositioningInfo getAmpCodingInfo() {
        return this.ampCodingInfo;
    }

    public XmlDocumentHandler(Document aDocument, Map<String, String> aMarkupElementsMap, Map<String, String> anElement2StringMap) {
        this(aDocument, aMarkupElementsMap, anElement2StringMap, null);
    }

    public XmlDocumentHandler(Document aDocument, Map<String, String> aMarkupElementsMap, Map<String, String> anElement2StringMap, AnnotationSet anAnnotationSet) {
        this.stack = new Stack();
        this.tmpDocContent = new StringBuffer(aDocument.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = aDocument;
        this.markupElementsMap = aMarkupElementsMap;
        this.element2StringMap = anElement2StringMap;
        this.basicAS = anAnnotationSet;
        this.customObjectsId = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        OptionsMap configData = Gate.getUserConfig();
        boolean addNSFeature = Boolean.parseBoolean((String)configData.get("addNamespaceFeatures"));
        this.namespaceURIFeature = (String)configData.get("namespaceURI");
        this.namespacePrefixFeature = (String)configData.get("namespacePrefix");
        this.deserializeNamespaceInfo = addNSFeature && this.namespacePrefixFeature != null && !this.namespacePrefixFeature.isEmpty() && this.namespaceURIFeature != null && !this.namespaceURIFeature.isEmpty();
    }

    @Override
    public void endDocument() throws SAXException {
        this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
        this.fireStatusChangedEvent("Total elements: " + this.elements);
        if (this.basicAS == null) {
            this.basicAS = this.doc.getAnnotations("Original markups");
        }
        Collections.sort(this.colector);
        HashSet<Integer> testIdsSet = new HashSet<Integer>();
        while (!this.colector.isEmpty()) {
            CustomObject obj = this.colector.getFirst();
            if (testIdsSet.contains(obj.getId())) {
                throw new GateSaxException("Found two annotations with the same Id(" + obj.getId() + ").The document is inconsistent.");
            }
            testIdsSet.add(obj.getId());
            try {
                if (this.markupElementsMap == null) {
                    this.basicAS.add(obj.getId(), obj.getStart(), obj.getEnd(), obj.getElemName(), obj.getFM());
                } else {
                    String annotationType = this.markupElementsMap.get(obj.getElemName());
                    if (annotationType != null) {
                        this.basicAS.add(obj.getId(), obj.getStart(), obj.getEnd(), annotationType, obj.getFM());
                    }
                }
            }
            catch (InvalidOffsetException e) {
                Err.prln("InvalidOffsetException for annot :" + obj.getElemName() + " with Id =" + obj.getId() + ". Discarded...");
            }
            this.colector.remove(obj);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean hasNSUri;
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (++this.elements % 128 == 0) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        Integer customObjectId = null;
        FeatureMap fm = Factory.newFeatureMap();
        String elemName = qName;
        boolean bl = hasNSUri = uri != null && !uri.isEmpty();
        if (this.deserializeNamespaceInfo && hasNSUri) {
            elemName = localName;
            StringTokenizer strToken = new StringTokenizer(qName, ":");
            if (strToken.countTokens() > 1) {
                String nsPrefix = strToken.nextToken();
                fm.put(this.namespaceURIFeature, uri);
                fm.put(this.namespacePrefixFeature, nsPrefix);
            }
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attName = atts.getLocalName(i);
            String attValue = atts.getValue(i);
            String attUri = atts.getURI(i);
            if (attUri != null && "http://www.gate.ac.uk".equals(attUri)) {
                if ("gateId".equals(attName)) {
                    customObjectId = Integer.parseInt(attValue);
                }
                if ("annotMaxId".equals(attName)) {
                    this.customObjectsId = Integer.parseInt(attValue);
                }
                if (!"matches".equals(attName)) continue;
                StringTokenizer strTokenizer = new StringTokenizer(attValue, ";");
                ArrayList<Integer> list = new ArrayList<Integer>();
                while (strTokenizer.hasMoreTokens()) {
                    String token = strTokenizer.nextToken();
                    list.add(Integer.valueOf(token));
                }
                fm.put(attName, list);
                continue;
            }
            fm.put(atts.getQName(i), attValue);
        }
        Long startIndex = this.tmpDocContent.length();
        CustomObject obj = new CustomObject(customObjectId, elemName, fm, startIndex, startIndex);
        this.stack.push(obj);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean hasNSUri;
        String elemName = qName;
        boolean bl = hasNSUri = uri != null && !uri.isEmpty();
        if (this.deserializeNamespaceInfo && hasNSUri) {
            elemName = localName;
        }
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        CustomObject obj = null;
        if (!this.stack.isEmpty()) {
            obj = this.stack.pop();
            if (obj.getStart().equals(obj.getEnd())) {
                obj.getFM().put("isEmptyAndSpan", "true");
            }
            this.colector.add(obj);
        }
        if (this.element2StringMap != null) {
            String stringFromMap = null;
            stringFromMap = this.element2StringMap.get(elemName);
            if (stringFromMap != null) {
                this.tmpDocContent.append(stringFromMap);
            }
        }
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(text, start, length));
        } else {
            this.contentBuffer.append(new String(text, start, length));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] text, int start, int length) throws SAXException {
        super.characters(text, start, length);
        String content = new String(text, start, length);
        StringBuffer contentBuffer = new StringBuffer("");
        int tmpDocContentSize = this.tmpDocContent.length();
        boolean incrementStartIndex = false;
        boolean addExtraSpace = true;
        if (Gate.getUserConfig().get("Document_add_space_on_unpack") != null) {
            addExtraSpace = Gate.getUserConfig().getBoolean("Document_add_space_on_unpack");
        }
        if (tmpDocContentSize != 0 && content.length() != 0 && !Character.isWhitespace(content.charAt(0)) && !Character.isWhitespace(this.tmpDocContent.charAt(tmpDocContentSize - 1)) && (content.length() != 1 || content.charAt(0) != '&' && content.charAt(0) != '<' && content.charAt(0) != '>' && content.charAt(0) != '\"' && content.charAt(0) != '\'') && this.tmpDocContent.charAt(tmpDocContentSize - 1) != '&' && this.tmpDocContent.charAt(tmpDocContentSize - 1) != '<' && this.tmpDocContent.charAt(tmpDocContentSize - 1) != '>' && this.tmpDocContent.charAt(tmpDocContentSize - 1) != '\"' && this.tmpDocContent.charAt(tmpDocContentSize - 1) != '\'' && addExtraSpace) {
            contentBuffer.append(" ");
            incrementStartIndex = true;
        }
        if (this.reposInfo != null) {
            if (start != 0 || length != 1 || text.length > 2) {
                this.reposInfo.addPositionInfo(this.getRealOffset(), content.length(), this.tmpDocContent.length() + contentBuffer.length(), content.length());
            } else {
                RepositioningInfo.PositionInfo pi;
                long lastPosition = 0L;
                if (this.reposInfo.size() > 0) {
                    pi = (RepositioningInfo.PositionInfo)this.reposInfo.get(this.reposInfo.size() - 1);
                    lastPosition = pi.getOriginalPosition();
                }
                for (int i = 0; i < this.ampCodingInfo.size(); ++i) {
                    pi = (RepositioningInfo.PositionInfo)this.ampCodingInfo.get(i);
                    if (pi.getOriginalPosition() <= lastPosition) continue;
                    this.reposInfo.addPositionInfo(pi.getOriginalPosition(), pi.getOriginalLength(), this.tmpDocContent.length() + contentBuffer.length(), content.length());
                    break;
                }
            }
        }
        contentBuffer.append(content);
        Long end = this.tmpDocContent.length() + contentBuffer.length();
        CustomObject obj2 = null;
        for (CustomObject obj2 : this.stack) {
            if (incrementStartIndex && obj2.getStart().equals(obj2.getEnd())) {
                obj2.setStart(obj2.getStart() + 1L);
            }
            obj2.setEnd(end);
        }
        this.tmpDocContent.append(contentBuffer.toString());
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (!(this.tmpDocContent.length() == 0 || this.tmpDocContent.charAt(this.tmpDocContent.length() - 1) == '\n' && text.equalsIgnoreCase("\n"))) {
            this.tmpDocContent.append(text);
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this._seh.error(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this._seh.fatalError(ex);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this._seh.warning(ex);
    }

    public void comment(String text) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startParsedEntity(String name) throws SAXException {
    }

    public void endParsedEntity(String name, boolean included) throws SAXException {
    }

    public void addStatusListener(StatusListener listener) {
        this.myStatusListeners.add(listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.myStatusListeners.remove(listener);
    }

    protected void fireStatusChangedEvent(String text) {
        Iterator<StatusListener> listenersIter = this.myStatusListeners.iterator();
        while (listenersIter.hasNext()) {
            listenersIter.next().statusChanged(text);
        }
    }

    private String getMyLocalName(String aQName) {
        if (aQName == null) {
            return "";
        }
        StringTokenizer strToken = new StringTokenizer(aQName, ":");
        if (strToken.countTokens() <= 1) {
            return aQName;
        }
        strToken.nextToken();
        return strToken.nextToken();
    }

    private String getMyURI(String aQName) {
        if (aQName == null) {
            return "";
        }
        StringTokenizer strToken = new StringTokenizer(aQName, ":");
        if (strToken.countTokens() <= 1) {
            return "";
        }
        if ("gate".equalsIgnoreCase(strToken.nextToken())) {
            return "http://www.gate.ac.uk";
        }
        return "";
    }

    public int getCustomObjectsId() {
        return this.customObjectsId;
    }

    class CustomObject
    implements Comparable<CustomObject> {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public CustomObject(Integer anId, String anElemName, FeatureMap aFm, Long aStart, Long anEnd) {
            this.elemName = anElemName;
            this.fm = aFm;
            this.start = aStart;
            this.end = anEnd;
            if (anId == null) {
                this.id = XmlDocumentHandler.this.customObjectsId++;
            } else {
                this.id = anId;
                if (XmlDocumentHandler.this.customObjectsId <= anId) {
                    XmlDocumentHandler.this.customObjectsId = anId + 1;
                }
            }
        }

        @Override
        public int compareTo(CustomObject obj) {
            return this.id.compareTo(obj.getId());
        }

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public Integer getId() {
            return this.id;
        }

        public void setElemName(String anElemName) {
            this.elemName = anElemName;
        }

        public void setFM(FeatureMap aFm) {
            this.fm = aFm;
        }

        public void setStart(Long aStart) {
            this.start = aStart;
        }

        public void setEnd(Long anEnd) {
            this.end = anEnd;
        }
    }
}

