/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.AbstractPersistence;
import gate.util.persistence.PersistenceManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MapPersistence
extends AbstractPersistence {
    protected Class<?> mapType;
    protected Map<Serializable, Serializable> localMap;
    static final long serialVersionUID = 1835776085941379996L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof Map)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Map.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + Map.class.getName());
        }
        this.mapType = source.getClass();
        Map map = (Map)source;
        this.localMap = new HashMap<Serializable, Serializable>(map.size());
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.localMap.put(PersistenceManager.getPersistentRepresentation(key), PersistenceManager.getPersistentRepresentation(value));
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        HashMap<Object, Object> result = null;
        try {
            result = (HashMap<Object, Object>)this.mapType.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = new HashMap<Object, Object>(this.localMap.size());
        }
        for (Serializable serializable : this.localMap.keySet()) {
            Object value = this.localMap.get(serializable);
            Object object = PersistenceManager.getTransientRepresentation(serializable);
            value = PersistenceManager.getTransientRepresentation(value, this.containingControllerName, this.initParamOverrides);
            result.put(object, value);
        }
        return result;
    }
}

