/*
 * Decompiled with CFR 0.152.
 */
package gate.util.maven;

import gate.util.GateRuntimeException;
import gate.util.maven.ChainedProxySelector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final String envM2Home = System.getenv("M2_HOME");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final String settingsXml = System.getProperty("M2_SETTINGS_XML", DEFAULT_USER_SETTINGS_FILE.getPath());
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", envM2Home != null ? envM2Home : ""), "conf/settings.xml");
    public static final SecDispatcher PASSWORD_DECRYPTER = new DefaultSecDispatcher(){
        {
            this._configurationFile = "~/.m2/settings-security.xml";
            try {
                this._cipher = new DefaultPlexusCipher();
            }
            catch (PlexusCipherException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static List<File> extraCacheDirectories = new CopyOnWriteArrayList<File>();

    public static List<File> getExtraCacheDirectories() {
        return Collections.unmodifiableList(extraCacheDirectories);
    }

    public static void addCacheDirectory(File dir) {
        extraCacheDirectories.add(0, dir);
    }

    public static boolean removeCacheDirectory(File dir) {
        return extraCacheDirectories.remove(dir);
    }

    public static Settings loadMavenSettings() throws SettingsBuildingException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(new File(settingsXml));
        settingsBuildingRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        Settings effectiveSettings = settingsBuildingResult.getEffectiveSettings();
        return effectiveSettings;
    }

    public static List<RemoteRepository> getRepositoryList() throws SettingsBuildingException {
        Settings effectiveSettings = Utils.loadMavenSettings();
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
        RemoteRepository gateRepo = new RemoteRepository.Builder("gate", "default", "http://repo.gate.ac.uk/content/groups/public/").build();
        DefaultMirrorSelector mirrorSelector = null;
        List mirrors = effectiveSettings.getMirrors();
        if (!mirrors.isEmpty()) {
            RemoteRepository gateMirror;
            mirrorSelector = new DefaultMirrorSelector();
            for (Mirror mirror : mirrors) {
                mirrorSelector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
            }
            RemoteRepository centralMirror = mirrorSelector.getMirror(central);
            if (centralMirror != null) {
                central = centralMirror;
            }
            if ((gateMirror = mirrorSelector.getMirror(gateRepo)) != null) {
                gateRepo = gateMirror;
            }
        }
        List proxies = effectiveSettings.getProxies().stream().filter(p -> p.isActive()).collect(Collectors.toList());
        DefaultProxySelector defaultSelector = null;
        if (!proxies.isEmpty()) {
            defaultSelector = new DefaultProxySelector();
            for (org.apache.maven.settings.Proxy proxy : proxies) {
                try {
                    defaultSelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(PASSWORD_DECRYPTER.decrypt(proxy.getPassword())).build()), proxy.getNonProxyHosts());
                }
                catch (SecDispatcherException e) {
                    throw new GateRuntimeException("Unable to decrypt password for proxy " + proxy.getProtocol() + "://" + proxy.getHost() + ":" + proxy.getPort());
                }
            }
        }
        JreProxySelector jreSelector = new JreProxySelector();
        Map profilesMap = effectiveSettings.getProfilesAsMap();
        for (String profileName : effectiveSettings.getActiveProfiles()) {
            Profile profile = (Profile)profilesMap.get(profileName);
            List repositories = profile.getRepositories();
            for (Repository repo : repositories) {
                Proxy proxy;
                RemoteRepository mirrorRepo;
                RemoteRepository remoteRepo = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl()).build();
                if (mirrorSelector != null && (mirrorRepo = mirrorSelector.getMirror(remoteRepo)) != null) {
                    remoteRepo = mirrorRepo;
                }
                if ((proxy = Utils.getProxy(remoteRepo, new ProxySelector[]{defaultSelector, jreSelector})) != null) {
                    remoteRepo = new RemoteRepository.Builder(remoteRepo).setProxy(proxy).build();
                }
                repos.add(remoteRepo);
            }
        }
        Proxy proxy = Utils.getProxy(central, new ProxySelector[]{defaultSelector, jreSelector});
        if (proxy != null) {
            central = new RemoteRepository.Builder(central).setProxy(proxy).build();
        }
        if ((proxy = Utils.getProxy(gateRepo, new ProxySelector[]{defaultSelector, jreSelector})) != null) {
            gateRepo = new RemoteRepository.Builder(gateRepo).setProxy(proxy).build();
        }
        repos.add(central);
        repos.add(gateRepo);
        ListIterator<RemoteRepository> repoIter = repos.listIterator();
        while (repoIter.hasNext()) {
            RemoteRepository remoteRepo = (RemoteRepository)repoIter.next();
            Server server = effectiveSettings.getServer(remoteRepo.getId());
            if (server == null) continue;
            try {
                repoIter.set(new RemoteRepository.Builder(remoteRepo).setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(PASSWORD_DECRYPTER.decrypt(server.getPassword())).addPrivateKey(server.getPrivateKey(), PASSWORD_DECRYPTER.decrypt(server.getPassphrase())).build()).build());
            }
            catch (SecDispatcherException e) {
                throw new GateRuntimeException("Unable to decrypt password/passphrase for server " + server.getId());
            }
        }
        return repos;
    }

    private static Proxy getProxy(RemoteRepository repo, ProxySelector ... selectors) {
        Proxy proxy = null;
        for (ProxySelector selector : selectors) {
            if (selector != null) {
                proxy = selector.getProxy(repo);
            }
            if (proxy == null) continue;
            return proxy;
        }
        return proxy;
    }

    public Artifact getArtifact() {
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession getRepositorySession(RepositorySystem repoSystem, WorkspaceReader workspace) {
        DefaultRepositorySystemSession repoSystemSession = MavenRepositorySystemUtils.newSession();
        String repoLocation = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository/";
        ChainedProxySelector proxySelector = new ChainedProxySelector();
        try {
            List proxies;
            List servers;
            List mirrors;
            Settings effectiveSettings = Utils.loadMavenSettings();
            if (effectiveSettings.getLocalRepository() != null) {
                repoLocation = effectiveSettings.getLocalRepository();
            }
            if (!(mirrors = effectiveSettings.getMirrors()).isEmpty()) {
                DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
                for (Mirror mirror : mirrors) {
                    mirrorSelector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
                }
                repoSystemSession.setMirrorSelector((MirrorSelector)mirrorSelector);
            }
            if (!(servers = effectiveSettings.getServers()).isEmpty()) {
                DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
                for (Server server : servers) {
                    AuthenticationBuilder auth = new AuthenticationBuilder();
                    auth.addUsername(server.getUsername()).addPassword(PASSWORD_DECRYPTER.decrypt(server.getPassword()));
                    auth.addPrivateKey(server.getPrivateKey(), PASSWORD_DECRYPTER.decrypt(server.getPassphrase()));
                    selector.add(server.getId(), auth.build());
                }
                repoSystemSession.setAuthenticationSelector((AuthenticationSelector)new ConservativeAuthenticationSelector((AuthenticationSelector)selector));
            }
            if (!(proxies = effectiveSettings.getProxies().stream().filter(p -> p.isActive()).collect(Collectors.toList())).isEmpty()) {
                DefaultProxySelector defaultSelector = new DefaultProxySelector();
                for (org.apache.maven.settings.Proxy proxy : proxies) {
                    defaultSelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(PASSWORD_DECRYPTER.decrypt(proxy.getPassword())).build()), proxy.getNonProxyHosts());
                }
                proxySelector.addSelector((ProxySelector)defaultSelector);
            }
            repoSystemSession.setOffline(effectiveSettings.isOffline());
        }
        catch (RuntimeException | SettingsBuildingException | SecDispatcherException e) {
            log.warn((Object)"Unable to load Maven settings, using default repository location, and no mirrors, proxy or authentication settings.", e);
        }
        LocalRepository localRepo = new LocalRepository(repoLocation);
        log.debug((Object)("Using local repository at: " + repoLocation));
        repoSystemSession.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)repoSystemSession, localRepo));
        if (workspace != null) {
            repoSystemSession.setWorkspaceReader(workspace);
        }
        proxySelector.addSelector((ProxySelector)new JreProxySelector());
        repoSystemSession.setProxySelector((ProxySelector)proxySelector);
        return repoSystemSession;
    }
}

