/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Main;
import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 6108998766086857918L;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))*");

    @Override
    public int compare(String v1, String v2) {
        return VersionComparator.compareVersions(v1, v2);
    }

    public static int compareVersions(String v1, String v2) {
        if (v1.equalsIgnoreCase(v2)) {
            return 0;
        }
        Matcher m1 = VERSION_PATTERN.matcher(v1);
        Matcher m2 = VERSION_PATTERN.matcher(v2);
        if (!m1.find() || !m2.find()) {
            return v1.compareTo(v2);
        }
        int groups = Math.max(m1.groupCount(), m2.groupCount());
        for (int i = 1; i <= groups; ++i) {
            int g2;
            int g1 = m1.group(i) != null ? Integer.parseInt(m1.group(i)) : 0;
            int n = g2 = m2.group(i) != null ? Integer.parseInt(m2.group(i)) : 0;
            if (g1 < g2) {
                return -1;
            }
            if (g1 <= g2) continue;
            return 1;
        }
        boolean v1IsSnapshot = v1.toUpperCase().endsWith("-SNAPSHOT");
        boolean v2IsSnapshot = v2.toUpperCase().endsWith("-SNAPSHOT");
        if (v1IsSnapshot && !v2IsSnapshot) {
            return -1;
        }
        if (!v1IsSnapshot && v2IsSnapshot) {
            return 1;
        }
        return 0;
    }

    public static boolean isGATENewEnough(String version) {
        if (version == null) {
            return true;
        }
        if ((version = version.trim()).equals("") || version.equals("*")) {
            return true;
        }
        return VersionComparator.compareVersions(Main.version, version) >= 0;
    }

    public static boolean isGATEOldEnough(String version) {
        if (version == null) {
            return true;
        }
        if ((version = version.trim()).equals("") || version.equals("*")) {
            return true;
        }
        return VersionComparator.compareVersions(Main.version, version) <= 0;
    }

    public static boolean isCompatible(String min, String max) {
        return VersionComparator.isGATENewEnough(min) && VersionComparator.isGATEOldEnough(max);
    }
}

