/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ThreadWarningSystem {
    private final Timer threadCheck = new Timer("Thread Monitor", true);
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static final int DEADLOCK_CHECK_PERIOD = 500;
    private static final int THREAD_NUMBER_CHECK_PERIOD = 20;
    private static final int MAX_STACK_DEPTH = 30;
    private boolean threadThresholdNotified = false;
    private Set<Long> deadlockedThreads = new HashSet<Long>();

    public ThreadWarningSystem() {
        this.threadCheck.schedule(new TimerTask(){

            @Override
            public void run() {
                long[] ids = ThreadWarningSystem.this.mbean.findMonitorDeadlockedThreads();
                if (ids != null && ids.length > 0) {
                    long[] lArray = ids;
                    int n = lArray.length;
                    for (int i = 0; i < n; ++i) {
                        Long l = lArray[i];
                        if (ThreadWarningSystem.this.deadlockedThreads.contains(l)) continue;
                        ThreadWarningSystem.this.deadlockedThreads.add(l);
                        ThreadInfo ti = ThreadWarningSystem.this.mbean.getThreadInfo(l, 30);
                        ThreadWarningSystem.this.fireDeadlockDetected(ti);
                    }
                }
            }
        }, 10L, 500L);
    }

    public ThreadWarningSystem(final int threadThreshold) {
        this();
        this.threadCheck.schedule(new TimerTask(){

            @Override
            public void run() {
                if (ThreadWarningSystem.this.mbean.getThreadCount() > threadThreshold) {
                    if (!ThreadWarningSystem.this.threadThresholdNotified) {
                        ThreadWarningSystem.this.fireThresholdExceeded();
                        ThreadWarningSystem.this.threadThresholdNotified = true;
                    }
                } else {
                    ThreadWarningSystem.this.threadThresholdNotified = false;
                }
            }
        }, 10L, 20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeadlockDetected(ThreadInfo thread) {
        Collection<Listener> collection = this.listeners;
        synchronized (collection) {
            for (Listener l : this.listeners) {
                l.deadlockDetected(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireThresholdExceeded() {
        ThreadInfo[] allThreads = this.mbean.getThreadInfo(this.mbean.getAllThreadIds());
        Collection<Listener> collection = this.listeners;
        synchronized (collection) {
            for (Listener l : this.listeners) {
                l.thresholdExceeded(allThreads);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(Listener l) {
        Collection<Listener> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener l) {
        Collection<Listener> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.remove(l);
        }
    }

    public static interface Listener {
        public void deadlockDetected(ThreadInfo var1);

        public void thresholdExceeded(ThreadInfo[] var1);
    }
}

