/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class CreoleXmlUpperCaseFilter
extends XMLFilterImpl {
    private Set<String> knownElements = new HashSet<String>(Arrays.asList("CREOLE-DIRECTORY", "CREOLE", "RESOURCE", "AUTOINSTANCE", "HIDDEN-AUTOINSTANCE", "PARAM", "PARAMETER", "GUI", "OR", "NAME", "JAR", "CLASS", "COMMENT", "INTERFACE", "ICON", "PRIVATE", "TOOL", "MAIN_VIEWER", "RESOURCE_DISPLAYED", "ANNOTATION_TYPE_DISPLAYED", "HELPURL"));

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String upperCaseName = localName.toUpperCase();
        if (this.knownElements.contains(upperCaseName)) {
            super.endElement(uri, upperCaseName, name.substring(0, name.indexOf(58) + 1) + upperCaseName);
        } else {
            super.endElement(uri, localName, name);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String upperCaseName = localName.toUpperCase();
        if (this.knownElements.contains(upperCaseName)) {
            AttributesImpl newAtts = new AttributesImpl();
            for (int i = 0; i < atts.getLength(); ++i) {
                String upperCaseAttrName = atts.getLocalName(i).toUpperCase();
                String attrQName = atts.getQName(i);
                newAtts.addAttribute(atts.getURI(i), upperCaseAttrName, attrQName.substring(0, attrQName.indexOf(58) + 1) + upperCaseAttrName, atts.getType(i), atts.getValue(i));
            }
            super.startElement(uri, upperCaseName, name.substring(0, name.indexOf(58) + 1) + upperCaseName, newAtts);
        } else {
            super.startElement(uri, localName, name, atts);
        }
    }
}

