/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class BomStrippingInputStreamReader
extends BufferedReader {
    private IOException pendingConstructionException;
    private boolean pendingEOF;
    private boolean pendingChecked;

    public BomStrippingInputStreamReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public BomStrippingInputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charsetName));
    }

    public BomStrippingInputStreamReader(InputStream in, String charsetName, int bufferSize) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charsetName), bufferSize);
    }

    public BomStrippingInputStreamReader(InputStream in, Charset cs) {
        this(new InputStreamReader(in, cs));
    }

    public BomStrippingInputStreamReader(InputStream in, int bufferSize) {
        this(new InputStreamReader(in), bufferSize);
    }

    public BomStrippingInputStreamReader(InputStream in, CharsetDecoder dec, int bufferSize) {
        this(new InputStreamReader(in, dec), bufferSize);
    }

    private BomStrippingInputStreamReader(InputStreamReader isr, int bufferSize) {
        super(isr, bufferSize);
        this.stripBomIfPresent();
    }

    private BomStrippingInputStreamReader(InputStreamReader isr) {
        super(isr);
        this.stripBomIfPresent();
    }

    public BomStrippingInputStreamReader(InputStream in, CharsetDecoder dec) {
        super(new InputStreamReader(in, dec));
        this.stripBomIfPresent();
    }

    private void stripBomIfPresent() {
        try {
            super.mark(1);
            int firstChar = super.read();
            if (firstChar == -1) {
                this.pendingEOF = true;
            } else if (firstChar != 65279) {
                super.reset();
            }
        }
        catch (IOException e) {
            this.pendingConstructionException = e;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private boolean checkPending() throws IOException {
        if (!this.pendingChecked) {
            if (this.pendingEOF) {
                return true;
            }
            if (this.pendingConstructionException != null) {
                throw this.pendingConstructionException;
            }
            this.pendingChecked = true;
        }
        return false;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(target);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(cbuf);
    }

    @Override
    public int read() throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.checkPending()) {
            return -1;
        }
        return super.read(cbuf, off, len);
    }

    @Override
    public String readLine() throws IOException {
        if (this.checkPending()) {
            return null;
        }
        return super.readLine();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.checkPending()) {
            return 0L;
        }
        return super.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        if (this.checkPending()) {
            return false;
        }
        return super.ready();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.checkPending();
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.checkPending();
        super.reset();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

