/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JMenuButton
extends JToggleButton {
    protected JPopupMenu popup;
    protected JMenu menu;

    public JMenuButton(JMenu menu) {
        this(menu.getPopupMenu());
        this.menu = menu;
    }

    public JMenuButton(JPopupMenu popup) {
        this.popup = popup;
        popup.setInvoker(this);
        this.initListeners();
    }

    protected void initListeners() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(JMenuButton.this.isSelected());
                }
                if (JMenuButton.this.isSelected()) {
                    Point p = JMenuButton.this.getPopupMenuOrigin();
                    JMenuButton.this.popup.show(JMenuButton.this, p.x, p.y);
                } else {
                    JMenuButton.this.popup.setVisible(false);
                }
            }
        });
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JMenuButton.this.setSelected(false);
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JMenuButton.this.setSelected(false);
                if (JMenuButton.this.menu != null) {
                    JMenuButton.this.menu.setSelected(false);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }

    protected Point getPopupMenuOrigin() {
        int x = 0;
        int y = 0;
        Dimension s = this.getSize();
        Dimension pmSize = this.popup.getSize();
        if (pmSize.width == 0) {
            pmSize = this.popup.getPreferredSize();
        }
        Point position = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        for (int i = 0; i < gd.length; ++i) {
            GraphicsConfiguration dgc;
            if (gd[i].getType() != 0 || !(dgc = gd[i].getDefaultConfiguration()).getBounds().contains(position)) continue;
            gc = dgc;
            break;
        }
        if (gc != null) {
            screenBounds = gc.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            position.x -= Math.abs(screenInsets.left);
            position.y -= Math.abs(screenInsets.top);
        }
        int xOffset = UIManager.getInt("Menu.menuPopupOffsetX");
        int yOffset = UIManager.getInt("Menu.menuPopupOffsetY");
        if (this.getComponentOrientation().isLeftToRight()) {
            x = xOffset;
            if (position.x + x + pmSize.width >= screenBounds.width + screenBounds.x && screenBounds.width - s.width < 2 * (position.x - screenBounds.x)) {
                x = s.width - xOffset - pmSize.width;
            }
        } else {
            x = s.width - xOffset - pmSize.width;
            if (position.x + x < screenBounds.x && screenBounds.width - s.width > 2 * (position.x - screenBounds.x)) {
                x = xOffset;
            }
        }
        if (position.y + (y = s.height + yOffset) + pmSize.height >= screenBounds.height && screenBounds.height - s.height < 2 * (position.y - screenBounds.y)) {
            y = 0 - yOffset - pmSize.height;
        }
        return new Point(x, y);
    }
}

