/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class WindowNewIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        Shape shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.56725144f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(17.36831f, 25.681941986083984), 11.799845f, new Point2D.Double(17.36831f, 25.681941986083984), new float[]{0.0f, 1.0f}, new Color[]{WindowNewIcon.getColor(0, 0, 0, 255, disabled), WindowNewIcon.getColor(0, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.945734f, 0.0f, 0.0f, 0.627274f, -9.628455f, 24.25921f));
        shape = new GeneralPath();
        ((Path2D.Float)shape).moveTo(47.12502, 40.368813);
        ((Path2D.Float)shape).curveTo(47.12667, 44.457054, 36.846928, 47.77151, 24.165659, 47.77151);
        ((Path2D.Float)shape).curveTo(11.484387, 47.77151, 1.2046481, 44.457054, 1.206299, 40.368813);
        ((Path2D.Float)shape).curveTo(1.2046481, 36.28057, 11.484387, 32.966114, 24.165659, 32.966114);
        ((Path2D.Float)shape).curveTo(36.846928, 32.966114, 47.12667, 36.28057, 47.12502, 40.368813);
        ((Path2D.Float)shape).lineTo(47.12502, 40.368813);
        ((Path2D)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        float alpha__0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1 = g.getClip();
        AffineTransform defaultTransform__0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(17.88068f, 11.072587966918945), new Point2D.Double(17.88068f, 21.767578125), new float[]{0.0f, 1.0f}, new Color[]{WindowNewIcon.getColor(255, 255, 255, 255, disabled), WindowNewIcon.getColor(224, 224, 224, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.797614f, 0.0f, 0.0f, 2.581671f, -13.88904f, -17.13621f));
        shape = new RoundRectangle2D.Double(1.497833013534546, 3.496351480484009, 45.00431442260742, 41.00729751586914, 2.2123091220855713, 2.21231f);
        g.setPaint(paint);
        g.fill(shape);
        paint = WindowNewIcon.getColor(141, 141, 141, 255, disabled);
        stroke = new BasicStroke(1.0000004f, 0, 0, 4.0f, null, 0.0f);
        shape = new RoundRectangle2D.Double(1.497833013534546, 3.496351480484009, 45.00431442260742, 41.00729751586914, 2.2123091220855713, 2.21231f);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_1;
        g.setTransform(defaultTransform__0_1);
        g.setClip(clip__0_1);
        float alpha__0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_2 = g.getClip();
        AffineTransform defaultTransform__0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(13.267746925354004, 7.7190704345703125), new Point2D.Double(13.267746925354004, 12.48076057434082), new float[]{0.0f, 1.0f}, new Color[]{WindowNewIcon.getColor(32, 74, 135, 255, disabled), WindowNewIcon.getColor(32, 74, 135, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(2.930758f, 0.0f, 0.0f, 2.798505f, -14.88456f, -18.22945f));
        shape = new RoundRectangle2D.Double(3.0, 5.0, 42.0, 7.0, 0.4445417821407318, 0.4445417f);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_2;
        g.setTransform(defaultTransform__0_2);
        g.setClip(clip__0_2);
        float alpha__0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_3 = g.getClip();
        AffineTransform defaultTransform__0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = WindowNewIcon.getColor(255, 255, 255, 122, disabled);
        stroke = new BasicStroke(1.000001f, 0, 0, 4.0f, null, 0.0f);
        shape = new RoundRectangle2D.Double(2.5085136890411377, 4.507357597351074, 42.97444534301758, 38.97792434692383, 0.8081382513046265, 0.7123106718063354);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_3;
        g.setTransform(defaultTransform__0_3);
        g.setClip(clip__0_3);
        float alpha__0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_4 = g.getClip();
        AffineTransform defaultTransform__0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new RadialGradientPaint(new Point2D.Double(55.0, 125.0), 14.375f, new Point2D.Double(55.0, 125.0), new float[]{0.0f, 0.5f, 1.0f}, new Color[]{WindowNewIcon.getColor(255, 255, 255, 255, disabled), WindowNewIcon.getColor(255, 245, 32, 227, disabled), WindowNewIcon.getColor(255, 243, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.626087f, 0.0f, 0.0f, 0.637205f, 4.565218f, -70.81045f));
        shape = new GeneralPath();
        ((Path2D.Float)shape).moveTo(48.000004, 8.840175);
        ((GeneralPath)shape).curveTo(48.000004, 13.899003, 43.970566, 17.999996, 39.000004, 17.999996);
        ((GeneralPath)shape).curveTo(34.02944, 17.999996, 30.000002, 13.899003, 30.000002, 8.840175);
        ((GeneralPath)shape).curveTo(30.000002, 3.7813473, 34.02944, -0.31964687, 39.000004, -0.31964687);
        ((GeneralPath)shape).curveTo(43.970566, -0.31964687, 48.000004, 3.7813473, 48.000004, 8.840175);
        ((GeneralPath)shape).lineTo(48.000004, 8.840175);
        ((GeneralPath)shape).closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_4;
        g.setTransform(defaultTransform__0_4);
        g.setClip(clip__0_4);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 1;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public WindowNewIcon() {
        this(WindowNewIcon.getOrigWidth(), WindowNewIcon.getOrigHeight(), false);
    }

    public WindowNewIcon(boolean disabled) {
        this(WindowNewIcon.getOrigWidth(), WindowNewIcon.getOrigHeight(), disabled);
    }

    public WindowNewIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public WindowNewIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public WindowNewIcon(int width, int height) {
        this(width, height, false);
    }

    public WindowNewIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)WindowNewIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)WindowNewIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        WindowNewIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

