/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class SearchIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = SearchIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(27.78125, 4.0625);
        shape.curveTo(15.787691, 4.0625, 6.03125, 13.571562, 6.03125, 25.28125);
        shape.curveTo(6.03125, 36.990936, 15.787691, 46.5, 27.78125, 46.5);
        shape.curveTo(31.135649, 46.5, 34.256382, 45.702133, 37.09375, 44.375);
        shape.lineTo(51.0, 62.03125);
        shape.lineTo(61.53125, 53.53125);
        shape.lineTo(46.96875, 35.03125);
        shape.curveTo(48.53361, 32.10184, 49.5, 28.81177, 49.5, 25.28125);
        shape.curveTo(49.5, 13.571562, 39.77481, 4.0625, 27.78125, 4.0625);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = SearchIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(27.78125, 4.0625);
        shape.curveTo(15.787691, 4.0625, 6.03125, 13.571562, 6.03125, 25.28125);
        shape.curveTo(6.03125, 36.990936, 15.787691, 46.5, 27.78125, 46.5);
        shape.curveTo(31.135649, 46.5, 34.256382, 45.702133, 37.09375, 44.375);
        shape.lineTo(51.0, 62.03125);
        shape.lineTo(61.53125, 53.53125);
        shape.lineTo(46.96875, 35.03125);
        shape.curveTo(48.53361, 32.10184, 49.5, 28.81177, 49.5, 25.28125);
        shape.curveTo(49.5, 13.571562, 39.77481, 4.0625, 27.78125, 4.0625);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(0.661709f, -0.530979f, 0.62138f, 0.56544f, -18.57514f, 52.80791f));
        paint = SearchIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(63.65396, 61.107292);
        shape.curveTo(63.65567, 62.499535, 62.13404, 63.786377, 59.662655, 64.482735);
        shape.curveTo(57.19127, 65.1791, 54.145905, 65.1791, 51.67452, 64.482735);
        shape.curveTo(49.203133, 63.786377, 47.681503, 62.499535, 47.683212, 61.107292);
        shape.curveTo(47.681503, 59.71505, 49.203133, 58.428207, 51.67452, 57.731846);
        shape.curveTo(54.145905, 57.035484, 57.19127, 57.035484, 59.662655, 57.731846);
        shape.curveTo(62.13404, 58.428207, 63.65567, 59.71505, 63.65396, 61.107292);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = SearchIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(63.65396, 61.107292);
        shape.curveTo(63.65567, 62.499535, 62.13404, 63.786377, 59.662655, 64.482735);
        shape.curveTo(57.19127, 65.1791, 54.145905, 65.1791, 51.67452, 64.482735);
        shape.curveTo(49.203133, 63.786377, 47.681503, 62.499535, 47.683212, 61.107292);
        shape.curveTo(47.681503, 59.71505, 49.203133, 58.428207, 51.67452, 57.731846);
        shape.curveTo(54.145905, 57.035484, 57.19127, 57.035484, 59.662655, 57.731846);
        shape.curveTo(62.13404, 58.428207, 63.65567, 59.71505, 63.65396, 61.107292);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(0.989891f, 0.0f, 0.0f, 0.978989f, 5.574255f, -10.33604f));
        paint = SearchIcon.getColor(162, 249, 164, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(45.383396, 32.758736);
        shape.curveTo(45.385696, 40.33898, 41.24497, 47.344376, 34.521523, 51.135147);
        shape.curveTo(27.798079, 54.92592, 19.51379, 54.92592, 12.790344, 51.135147);
        shape.curveTo(6.0669, 47.344376, 1.9261721, 40.33898, 1.9284725, 32.758736);
        shape.curveTo(1.9261721, 25.178492, 6.0669, 18.173096, 12.790344, 14.382325);
        shape.curveTo(19.51379, 10.591555, 27.798079, 10.591555, 34.521523, 14.382325);
        shape.curveTo(41.24497, 18.173096, 45.385696, 25.178492, 45.383396, 32.758736);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = SearchIcon.getColor(41, 165, 19, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(45.383396, 32.758736);
        shape.curveTo(45.385696, 40.33898, 41.24497, 47.344376, 34.521523, 51.135147);
        shape.curveTo(27.798079, 54.92592, 19.51379, 54.92592, 12.790344, 51.135147);
        shape.curveTo(6.0669, 47.344376, 1.9261721, 40.33898, 1.9284725, 32.758736);
        shape.curveTo(1.9261721, 25.178492, 6.0669, 18.173096, 12.790344, 14.382325);
        shape.curveTo(19.51379, 10.591555, 27.798079, 10.591555, 34.521523, 14.382325);
        shape.curveTo(41.24497, 18.173096, 45.385696, 25.178492, 45.383396, 32.758736);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = SearchIcon.getColor(255, 97, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(26.355799, 32.82302);
        shape.lineTo(26.355799, 32.82302);
        shape.lineTo(26.355799, 32.82302);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = SearchIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.355799, 32.82302);
        shape.lineTo(26.355799, 32.82302);
        shape.lineTo(26.355799, 32.82302);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 5.571527f, -10.47194f));
        paint = new RadialGradientPaint(new Point2D.Double(27.87637710571289, 42.43628692626953), 22.227463f, new Point2D.Double(27.87637710571289, 42.43628692626953), new float[]{0.0f, 1.0f}, new Color[]{SearchIcon.getColor(255, 255, 255, 255, disabled), SearchIcon.getColor(150, 163, 150, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(0.822692f, 1.409866f, -0.922425f, 0.538258f, 47.48016f, -37.55484f));
        shape = new GeneralPath();
        shape.moveTo(45.383396, 32.758736);
        shape.curveTo(45.385696, 40.33898, 41.24497, 47.344376, 34.521523, 51.135147);
        shape.curveTo(27.798079, 54.92592, 19.51379, 54.92592, 12.790344, 51.135147);
        shape.curveTo(6.0669, 47.344376, 1.9261721, 40.33898, 1.9284725, 32.758736);
        shape.curveTo(1.9261721, 25.178492, 6.0669, 18.173096, 12.790344, 14.382325);
        shape.curveTo(19.51379, 10.591555, 27.798079, 10.591555, 34.521523, 14.382325);
        shape.curveTo(41.24497, 18.173096, 45.385696, 25.178492, 45.383396, 32.758736);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = SearchIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(45.383396, 32.758736);
        shape.curveTo(45.385696, 40.33898, 41.24497, 47.344376, 34.521523, 51.135147);
        shape.curveTo(27.798079, 54.92592, 19.51379, 54.92592, 12.790344, 51.135147);
        shape.curveTo(6.0669, 47.344376, 1.9261721, 40.33898, 1.9284725, 32.758736);
        shape.curveTo(1.9261721, 25.178492, 6.0669, 18.173096, 12.790344, 14.382325);
        shape.curveTo(19.51379, 10.591555, 27.798079, 10.591555, 34.521523, 14.382325);
        shape.curveTo(41.24497, 18.173096, 45.385696, 25.178492, 45.383396, 32.758736);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 6;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public SearchIcon() {
        this(SearchIcon.getOrigWidth(), SearchIcon.getOrigHeight(), false);
    }

    public SearchIcon(boolean disabled) {
        this(SearchIcon.getOrigWidth(), SearchIcon.getOrigHeight(), disabled);
    }

    public SearchIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public SearchIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public SearchIcon(int width, int height) {
        this(width, height, false);
    }

    public SearchIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)SearchIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)SearchIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        SearchIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

