/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class MavenIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        Object stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = MavenIcon.getColor(255, 104, 4, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(40.1875, 34.125);
        shape.quadTo(36.4375, 34.4375, 33.15625, 34.867188);
        shape.quadTo(29.875, 35.296875, 27.57031, 36.117188);
        shape.quadTo(25.1875, 36.976562, 23.9375, 38.539062);
        shape.quadTo(22.6875, 40.101562, 22.6875, 42.679688);
        shape.quadTo(22.6875, 44.945312, 24.32812, 45.882812);
        shape.quadTo(26.007809, 46.78125, 29.17187, 46.78125);
        shape.quadTo(31.24218, 46.78125, 33.58593, 45.84375);
        shape.quadTo(35.96875, 44.867188, 38.03906, 43.382812);
        shape.lineTo(40.1875, 34.125);
        shape.closePath();
        shape.moveTo(36.47656, 50.179688);
        shape.quadTo(35.14843, 51.039062, 33.27343, 52.25);
        shape.quadTo(31.39843, 53.460938, 29.79687, 54.164062);
        shape.quadTo(27.60937, 55.0625, 25.69531, 55.53125);
        shape.quadTo(23.78125, 56.0, 20.38281, 56.0);
        shape.quadTo(14.91406, 56.0, 11.4375, 52.953125);
        shape.quadTo(8.0, 49.867188, 8.0, 44.945312);
        shape.quadTo(8.0, 39.75, 10.46093, 36.15625);
        shape.quadTo(12.921869, 32.523438, 17.76562, 30.375);
        shape.quadTo(22.29687, 28.34375, 28.54687, 27.445312);
        shape.quadTo(34.83593, 26.546875, 42.140617, 26.117188);
        shape.quadTo(42.179718, 25.882812, 42.296867, 25.375);
        shape.quadTo(42.41406, 24.828125, 42.41406, 24.164062);
        shape.quadTo(42.41406, 21.390627, 39.83593, 20.296877);
        shape.quadTo(37.25781, 19.164064, 32.14062, 19.164064);
        shape.quadTo(28.66406, 19.164064, 24.44531, 20.33594);
        shape.quadTo(20.265621, 21.507814, 18.15625, 22.289062);
        shape.lineTo(16.86718, 22.289062);
        shape.lineTo(18.9375, 11.8984375);
        shape.quadTo(21.39843, 11.2734375, 26.55468, 10.4921875);
        shape.quadTo(31.71093, 9.7109375, 36.82812, 9.7109375);
        shape.quadTo(47.14062, 9.7109375, 51.945312, 12.406252);
        shape.quadTo(56.789062, 15.1015625, 56.789062, 20.765627);
        shape.quadTo(56.789062, 21.546877, 56.632812, 22.796875);
        shape.quadTo(56.51562, 24.046875, 56.281254, 24.984375);
        shape.lineTo(49.406254, 54.828125);
        shape.lineTo(35.421875, 54.828125);
        shape.lineTo(36.476566, 50.179688);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 8;
    }

    public static int getOrigY() {
        return 10;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public MavenIcon() {
        this(MavenIcon.getOrigWidth(), MavenIcon.getOrigHeight(), false);
    }

    public MavenIcon(boolean disabled) {
        this(MavenIcon.getOrigWidth(), MavenIcon.getOrigHeight(), disabled);
    }

    public MavenIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public MavenIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public MavenIcon(int width, int height) {
        this(width, height, false);
    }

    public MavenIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)MavenIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)MavenIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        MavenIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

