/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class LRIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LRIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(5.0524583, 32.240707);
        shape.curveTo(6.915303, 33.431885, 8.859203, 34.66524, 10.491922, 36.186295);
        shape.curveTo(11.886881, 37.471813, 11.994406, 38.833916, 11.997412, 40.595398);
        shape.curveTo(11.995306, 41.720547, 11.978867, 42.84694, 12.016185, 43.9708);
        shape.curveTo(12.213796, 45.153645, 13.122118, 45.69885, 14.221764, 45.878708);
        shape.curveTo(16.242958, 46.054974, 17.266466, 45.22585, 15.829596, 45.9133);
        shape.curveTo(17.077576, 44.824924, 18.141602, 43.62627, 18.347767, 41.958168);
        shape.curveTo(18.381378, 41.242832, 18.36135, 40.526337, 18.353834, 39.81057);
        shape.lineTo(20.0, 38.970966);
        shape.curveTo(19.999294, 39.691784, 20.001446, 40.412712, 19.991322, 41.133446);
        shape.curveTo(19.821568, 42.86491, 18.75874, 44.08438, 17.494589, 45.24347);
        shape.curveTo(15.770958, 46.340492, 14.716709, 47.2323, 12.714776, 46.94589);
        shape.curveTo(11.56239, 46.69183, 10.625208, 46.05591, 10.377526, 44.82971);
        shape.curveTo(10.330151, 43.696896, 10.3691, 42.556915, 10.373747, 41.421356);
        shape.curveTo(10.392895, 39.731834, 10.294959, 38.366486, 8.999476, 37.106094);
        shape.curveTo(7.4310613, 35.584637, 5.4865184, 34.243847, 3.523226, 33.35176);
        shape.lineTo(5.0524583, 32.240707);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LRIcon.getColor(255, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(23.77273, 22.32101);
        shape.curveTo(22.863638, 41.822727, 40.226547, 49.52101, 20.772728, 40.835297);
        shape.curveTo(10.32207, 36.169304, 2.5, 34.50844, 2.5, 30.09244);
        shape.curveTo(2.5, 25.67644, 10.272939, 21.472744, 19.68182, 14.092437);
        shape.curveTo(40.95382, -2.5932791, 23.227276, 9.447866, 23.77273, 22.32101);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = LRIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.1212239f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(23.77273, 22.32101);
        shape.curveTo(22.863638, 41.822727, 40.226547, 49.52101, 20.772728, 40.835297);
        shape.curveTo(10.32207, 36.169304, 2.5, 34.50844, 2.5, 30.09244);
        shape.curveTo(2.5, 25.67644, 10.272939, 21.472744, 19.68182, 14.092437);
        shape.curveTo(40.95382, -2.5932791, 23.227276, 9.447866, 23.77273, 22.32101);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(0.523636f, 0.0f, -0.02886516f, 1.681365f, 0.46087f, -20.54159f));
        paint = LRIcon.getColor(7, 4, 4, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(78.909096, 27.636364);
        shape.curveTo(78.909096, 34.665443, 71.46074, 40.36364, 62.272728, 40.36364);
        shape.curveTo(53.084717, 40.36364, 45.636364, 34.665443, 45.636364, 27.636364);
        shape.curveTo(45.636364, 20.607285, 53.084717, 14.909089, 62.272728, 14.909089);
        shape.curveTo(71.46074, 14.909089, 78.909096, 20.607285, 78.909096, 27.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = LRIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(78.909096, 27.636364);
        shape.curveTo(78.909096, 34.665443, 71.46074, 40.36364, 62.272728, 40.36364);
        shape.curveTo(53.084717, 40.36364, 45.636364, 34.665443, 45.636364, 27.636364);
        shape.curveTo(45.636364, 20.607285, 53.084717, 14.909089, 62.272728, 14.909089);
        shape.curveTo(71.46074, 14.909089, 78.909096, 20.607285, 78.909096, 27.636364);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(0.523636f, 0.0f, -0.02886516f, 1.681365f, 0.73628f, -20.39201f));
        paint = new LinearGradientPaint(new Point2D.Double(75.63566589355469, 27.636363983154297), new Point2D.Double(36.35351f, 27.636363983154297), new float[]{0.0f, 1.0f}, new Color[]{LRIcon.getColor(255, 0, 0, 255, disabled), LRIcon.getColor(255, 0, 0, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(78.909096, 27.636364);
        shape.curveTo(78.909096, 34.665443, 71.46074, 40.36364, 62.272728, 40.36364);
        shape.curveTo(53.084717, 40.36364, 45.636364, 34.665443, 45.636364, 27.636364);
        shape.curveTo(45.636364, 20.607285, 53.084717, 14.909089, 62.272728, 14.909089);
        shape.curveTo(71.46074, 14.909089, 78.909096, 20.607285, 78.909096, 27.636364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = LRIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(78.909096, 27.636364);
        shape.curveTo(78.909096, 34.665443, 71.46074, 40.36364, 62.272728, 40.36364);
        shape.curveTo(53.084717, 40.36364, 45.636364, 34.665443, 45.636364, 27.636364);
        shape.curveTo(45.636364, 20.607285, 53.084717, 14.909089, 62.272728, 14.909089);
        shape.curveTo(71.46074, 14.909089, 78.909096, 20.607285, 78.909096, 27.636364);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LRIcon.getColor(253, 253, 253, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(7.045453, 25.52101);
        shape.curveTo(8.760065, 21.688988, 13.084932, 19.671581, 11.40909, 22.321009);
        shape.curveTo(8.40909, 27.063866, 11.40909, 36.49244, 11.40909, 36.49244);
        shape.lineTo(7.954544, 34.663868);
        shape.curveTo(7.954544, 34.663868, 5.409089, 29.178152, 7.045453, 25.52101);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = LRIcon.getColor(253, 253, 253, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(13.030176, 21.696106);
        shape.curveTo(14.744788, 17.864084, 19.796928, 14.246679, 18.121086, 16.896107);
        shape.curveTo(15.121086, 21.638964, 12.232409, 24.628113, 17.211994, 33.810394);
        shape.curveTo(22.106625, 42.836014, 13.939267, 37.01039, 13.939267, 37.01039);
        shape.curveTo(13.939267, 37.01039, 11.393812, 25.353249, 13.030176, 21.696106);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        float alpha__0_0_6 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_6 = g.getClip();
        AffineTransform defaultTransform__0_0_6 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(39.959034, 32.0);
        shape.lineTo(26.996792, 32.0);
        shape.lineTo(26.996792, 16.97526);
        shape.lineTo(29.617886, 16.97526);
        shape.lineTo(29.617886, 29.378906);
        shape.lineTo(39.959034, 29.378906);
        shape.lineTo(39.959034, 32.0);
        shape.closePath();
        paint = LRIcon.getColor(255, 249, 249, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_6;
        g.setTransform(defaultTransform__0_0_6);
        g.setClip(clip__0_0_6);
        float alpha__0_0_7 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_7 = g.getClip();
        AffineTransform defaultTransform__0_0_7 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(59.997997, 32.0);
        shape.lineTo(56.13081, 32.0);
        shape.lineTo(51.927032, 27.77474);
        shape.lineTo(46.26948, 27.77474);
        shape.lineTo(46.26948, 25.182291);
        shape.lineTo(53.309193, 25.182291);
        shape.quadTo(54.76297, 25.182291, 55.75125, 24.544922);
        shape.quadTo(56.8756, 23.792969, 56.8756, 22.410807);
        shape.quadTo(56.8756, 19.589193, 53.309193, 19.589193);
        shape.lineTo(44.729767, 19.589193);
        shape.lineTo(44.729767, 32.0);
        shape.lineTo(42.115833, 32.0);
        shape.lineTo(42.115833, 16.97526);
        shape.lineTo(52.89383, 16.97526);
        shape.quadTo(55.80138, 16.97526, 57.577423, 18.228516);
        shape.quadTo(59.6256, 19.660807, 59.6256, 22.432291);
        shape.quadTo(59.6256, 24.322916, 58.4368, 25.683594);
        shape.quadTo(57.341095, 26.965494, 55.44331, 27.466797);
        shape.lineTo(59.997997, 32.0);
        shape.closePath();
        paint = LRIcon.getColor(0, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_7;
        g.setTransform(defaultTransform__0_0_7);
        g.setClip(clip__0_0_7);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public LRIcon() {
        this(LRIcon.getOrigWidth(), LRIcon.getOrigHeight(), false);
    }

    public LRIcon(boolean disabled) {
        this(LRIcon.getOrigWidth(), LRIcon.getOrigHeight(), disabled);
    }

    public LRIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public LRIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public LRIcon(int width, int height) {
        this(width, height, false);
    }

    public LRIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)LRIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)LRIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        LRIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

