/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class GazetteerIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(9, 176, 15, 103, disabled);
        shape = new GeneralPath();
        shape.moveTo(33.01564, 36.136364);
        shape.lineTo(51.742912, 45.772728);
        shape.curveTo(54.504368, 47.227272, 49.923187, 45.30316, 47.924732, 45.681816);
        shape.curveTo(45.077576, 46.22128, 33.958916, 51.045452, 43.924732, 62.5);
        shape.lineTo(8.652004, 45.590908);
        shape.curveTo(6.4360046, 45.590908, 7.5271354, 34.87475, 11.197458, 31.5);
        shape.curveTo(17.01564, 26.150364, 30.79964, 36.136364, 33.01564, 36.136364);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(33.01564, 36.136364);
        shape.lineTo(51.742912, 45.772728);
        shape.curveTo(54.504368, 47.227272, 49.923187, 45.30316, 47.924732, 45.681816);
        shape.curveTo(45.077576, 46.22128, 33.958916, 51.045452, 43.924732, 62.5);
        shape.lineTo(8.652004, 45.590908);
        shape.curveTo(6.4360046, 45.590908, 7.5271354, 34.87475, 11.197458, 31.5);
        shape.curveTo(17.01564, 26.150364, 30.79964, 36.136364, 33.01564, 36.136364);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.022388f, 0.0f, 0.0f, 1.002538f, 31.43257f, 21.83064f));
        float alpha__0_0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(9, 176, 15, 103, disabled);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_0;
        g.setTransform(defaultTransform__0_0_1_0);
        g.setClip(clip__0_0_1_0);
        float alpha__0_0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1_1 = g.getTransform();
        g.transform(new AffineTransform(0.783582f, 0.0f, 0.0f, 0.784264f, 4.092437f, 7.141845f));
        paint = GazetteerIcon.getColor(9, 176, 15, 103, disabled);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_1;
        g.setTransform(defaultTransform__0_0_1_1);
        g.setClip(clip__0_0_1_1);
        float alpha__0_0_1_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_1_2 = g.getClip();
        AffineTransform defaultTransform__0_0_1_2 = g.getTransform();
        g.transform(new AffineTransform(0.552239f, 0.0f, 0.0f, 0.515228f, 8.346759f, 16.6202f));
        paint = GazetteerIcon.getColor(9, 176, 15, 103, disabled);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.181818, 33.0);
        shape.curveTo(26.181818, 37.669315, 22.315186, 41.454544, 17.545454, 41.454544);
        shape.curveTo(12.775722, 41.454544, 8.90909, 37.669315, 8.90909, 33.0);
        shape.curveTo(8.90909, 28.330685, 12.775722, 24.545456, 17.545454, 24.545456);
        shape.curveTo(22.315186, 24.545456, 26.181818, 28.330685, 26.181818, 33.0);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1_2;
        g.setTransform(defaultTransform__0_0_1_2);
        g.setClip(clip__0_0_1_2);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(7.545454025268555, 72.18104553222656), new Point2D.Double(37.643924713134766, 14.908315658569336), new float[]{0.0f, 1.0f}, new Color[]{GazetteerIcon.getColor(9, 176, 15, 255, disabled), GazetteerIcon.getColor(9, 176, 15, 0, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(12.570151, 29.280361);
        shape.lineTo(19.316214, 25.510654);
        shape.curveTo(32.305244, 14.353301, 23.107044, 0.25323445, 26.264399, 3.060446);
        shape.lineTo(60.053017, 15.482296);
        shape.curveTo(59.755825, 28.653143, 47.254307, 36.71087, 43.41231, 41.88502);
        shape.curveTo(42.60481, 42.97252, 39.236183, 43.321293, 38.120796, 53.291096);
        shape.curveTo(37.002983, 63.2826, 53.602695, 64.91215, 37.718067, 60.28676);
        shape.lineTo(7.0203595, 46.410362);
        shape.curveTo(3.8630052, 43.603153, 5.5811214, 31.16499, 12.570151, 29.280361);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(0.9999999f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(12.570151, 29.280361);
        shape.lineTo(19.316214, 25.510654);
        shape.curveTo(32.305244, 14.353301, 23.107044, 0.25323445, 26.264399, 3.060446);
        shape.lineTo(60.053017, 15.482296);
        shape.curveTo(59.755825, 28.653143, 47.254307, 36.71087, 43.41231, 41.88502);
        shape.curveTo(42.60481, 42.97252, 39.236183, 43.321293, 38.120796, 53.291096);
        shape.curveTo(37.002983, 63.2826, 53.602695, 64.91215, 37.718067, 60.28676);
        shape.lineTo(7.0203595, 46.410362);
        shape.curveTo(3.8630052, 43.603153, 5.5811214, 31.16499, 12.570151, 29.280361);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        float alpha__0_0_3 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_3 = g.getClip();
        AffineTransform defaultTransform__0_0_3 = g.getTransform();
        g.transform(new AffineTransform(0.902324f, 0.344845f, -0.314982f, 0.987871f, 0.0f, 0.0f));
        shape = new GeneralPath();
        shape.moveTo(35.100815, 1.5398921);
        shape.lineTo(32.512104, 1.5398921);
        shape.quadTo(31.62266, 1.5398921, 31.041025, 0.9495186);
        shape.quadTo(30.45939, 0.35914516, 30.45939, -0.5419511);
        shape.quadTo(30.45939, -1.4372214, 31.035198, -1.9858415);
        shape.quadTo(31.611008, -2.5344615, 32.512104, -2.5344615);
        shape.lineTo(34.81534, -2.5344615);
        shape.lineTo(34.81534, -1.825625);
        shape.lineTo(32.512104, -1.825625);
        shape.quadTo(31.927557, -1.825625, 31.548862, -1.4498445);
        shape.quadTo(31.17017, -1.074064, 31.17017, -0.48174858);
        shape.quadTo(31.17017, 0.10279881, 31.548862, 0.46595615);
        shape.quadTo(31.927557, 0.82911354, 32.512104, 0.82911354);
        shape.lineTo(34.391975, 0.82911354);
        shape.lineTo(34.391975, -0.05838868);
        shape.lineTo(32.459667, -0.05838868);
        shape.lineTo(32.459667, -0.7089647);
        shape.lineTo(35.100815, -0.7089647);
        shape.lineTo(35.100815, 1.5398921);
        shape.closePath();
        shape.moveTo(40.98444, 1.5398921);
        shape.lineTo(40.07169, 1.5340661);
        shape.lineTo(39.386158, 0.3941015);
        shape.lineTo(37.45191, 0.3941015);
        shape.lineTo(37.881092, -0.308909);
        shape.lineTo(38.960857, -0.308909);
        shape.lineTo(38.252018, -1.4857719);
        shape.lineTo(36.41487, 1.5340661);
        shape.lineTo(35.50212, 1.5340661);
        shape.lineTo(37.71408, -2.1460578);
        shape.quadTo(37.79759, -2.2897673, 37.947124, -2.4101725);
        shape.quadTo(38.12579, -2.5461137, 38.269497, -2.5461137);
        shape.quadTo(38.42486, -2.5461137, 38.591873, -2.4159985);
        shape.quadTo(38.73558, -2.3014195, 38.824913, -2.1460578);
        shape.lineTo(40.98444, 1.5398921);
        shape.closePath();
        shape.moveTo(45.506092, 1.5398921);
        shape.lineTo(41.699734, 1.5398921);
        shape.quadTo(41.24142, 1.5398921, 41.24142, 1.2466474);
        shape.quadTo(41.24142, 1.0621557, 41.46087, 0.8485337);
        shape.lineTo(44.12726, -1.825625);
        shape.lineTo(41.138493, -1.825625);
        shape.lineTo(41.138493, -2.5344615);
        shape.lineTo(44.886585, -2.5344615);
        shape.quadTo(45.07108, -2.5344615, 45.201195, -2.456781);
        shape.quadTo(45.356556, -2.367448, 45.356556, -2.1946084);
        shape.quadTo(45.356556, -2.0159428, 45.17789, -1.8431032);
        shape.lineTo(42.511497, 0.82911354);
        shape.lineTo(45.506092, 0.82911354);
        shape.lineTo(45.506092, 1.5398921);
        shape.closePath();
        shape.moveTo(49.44998, -0.17296773);
        shape.lineTo(47.123444, -0.17296773);
        shape.lineTo(47.123444, -0.8818043);
        shape.lineTo(49.44998, -0.8818043);
        shape.lineTo(49.44998, -0.17296773);
        shape.closePath();
        shape.moveTo(49.63447, 1.5398921);
        shape.lineTo(46.115536, 1.5398921);
        shape.lineTo(46.115536, -2.5344615);
        shape.lineTo(49.63447, -2.5344615);
        shape.lineTo(49.63447, -1.825625);
        shape.lineTo(46.824375, -1.825625);
        shape.lineTo(46.824375, 0.82911354);
        shape.lineTo(49.63447, 0.82911354);
        shape.lineTo(49.63447, 1.5398921);
        shape.closePath();
        shape.moveTo(54.09721, -1.825625);
        shape.lineTo(52.493103, -1.825625);
        shape.lineTo(52.493103, 1.5398921);
        shape.lineTo(51.78815, 1.5398921);
        shape.lineTo(51.78815, -1.825625);
        shape.lineTo(50.178215, -1.825625);
        shape.lineTo(50.178215, -2.5344615);
        shape.lineTo(54.09721, -2.5344615);
        shape.lineTo(54.09721, -1.825625);
        shape.closePath();
        shape.moveTo(58.255436, -1.825625);
        shape.lineTo(56.65133, -1.825625);
        shape.lineTo(56.65133, 1.5398921);
        shape.lineTo(55.946377, 1.5398921);
        shape.lineTo(55.946377, -1.825625);
        shape.lineTo(54.33644, -1.825625);
        shape.lineTo(54.33644, -2.5344615);
        shape.lineTo(58.255436, -2.5344615);
        shape.lineTo(58.255436, -1.825625);
        shape.closePath();
        shape.moveTo(62.073807, -0.17296773);
        shape.lineTo(59.74727, -0.17296773);
        shape.lineTo(59.74727, -0.8818043);
        shape.lineTo(62.073807, -0.8818043);
        shape.lineTo(62.073807, -0.17296773);
        shape.closePath();
        shape.moveTo(62.258297, 1.5398921);
        shape.lineTo(58.73936, 1.5398921);
        shape.lineTo(58.73936, -2.5344615);
        shape.lineTo(62.258297, -2.5344615);
        shape.lineTo(62.258297, -1.825625);
        shape.lineTo(59.4482, -1.825625);
        shape.lineTo(59.4482, 0.82911354);
        shape.lineTo(62.258297, 0.82911354);
        shape.lineTo(62.258297, 1.5398921);
        shape.closePath();
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_3;
        g.setTransform(defaultTransform__0_0_3);
        g.setClip(clip__0_0_3);
        float alpha__0_0_4 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_4 = g.getClip();
        AffineTransform defaultTransform__0_0_4 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(27.0, 18.0);
        shape.curveTo(35.0, 22.0, 35.0, 22.0, 35.0, 22.0);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_4;
        g.setTransform(defaultTransform__0_0_4);
        g.setClip(clip__0_0_4);
        float alpha__0_0_5 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_5 = g.getClip();
        AffineTransform defaultTransform__0_0_5 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(25.090908, 22.363636);
        shape.curveTo(33.090908, 26.363636, 33.090908, 26.363636, 33.090908, 26.363636);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_5;
        g.setTransform(defaultTransform__0_0_5);
        g.setClip(clip__0_0_5);
        float alpha__0_0_6 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_6 = g.getClip();
        AffineTransform defaultTransform__0_0_6 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.5, 20.5);
        shape.curveTo(34.5, 24.5, 34.5, 24.5, 34.5, 24.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_6;
        g.setTransform(defaultTransform__0_0_6);
        g.setClip(clip__0_0_6);
        float alpha__0_0_7 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_7 = g.getClip();
        AffineTransform defaultTransform__0_0_7 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(20.5, 27.5);
        shape.curveTo(28.5, 31.5, 28.5, 31.5, 28.5, 31.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_7;
        g.setTransform(defaultTransform__0_0_7);
        g.setClip(clip__0_0_7);
        float alpha__0_0_8 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_8 = g.getClip();
        AffineTransform defaultTransform__0_0_8 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(22.5, 25.5);
        shape.curveTo(30.5, 29.5, 30.5, 29.5, 30.5, 29.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_8;
        g.setTransform(defaultTransform__0_0_8);
        g.setClip(clip__0_0_8);
        float alpha__0_0_9 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_9 = g.getClip();
        AffineTransform defaultTransform__0_0_9 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(17.5, 28.90909);
        shape.curveTo(25.5, 32.90909, 25.5, 32.90909, 25.5, 32.90909);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_9;
        g.setTransform(defaultTransform__0_0_9);
        g.setClip(clip__0_0_9);
        float alpha__0_0_10 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_10 = g.getClip();
        AffineTransform defaultTransform__0_0_10 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(13.5, 31.5);
        shape.curveTo(21.5, 35.5, 21.5, 35.5, 21.5, 35.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_10;
        g.setTransform(defaultTransform__0_0_10);
        g.setClip(clip__0_0_10);
        float alpha__0_0_11 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_11 = g.getClip();
        AffineTransform defaultTransform__0_0_11 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(11.5, 34.5);
        shape.curveTo(19.5, 38.5, 19.5, 38.5, 19.5, 38.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_11;
        g.setTransform(defaultTransform__0_0_11);
        g.setClip(clip__0_0_11);
        float alpha__0_0_12 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_12 = g.getClip();
        AffineTransform defaultTransform__0_0_12 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(9.5, 37.5);
        shape.curveTo(17.5, 41.5, 17.5, 41.5, 17.5, 41.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_12;
        g.setTransform(defaultTransform__0_0_12);
        g.setClip(clip__0_0_12);
        float alpha__0_0_13 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_13 = g.getClip();
        AffineTransform defaultTransform__0_0_13 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(8.5, 41.090908);
        shape.curveTo(16.5, 45.090908, 16.5, 45.090908, 16.5, 45.090908);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_13;
        g.setTransform(defaultTransform__0_0_13);
        g.setClip(clip__0_0_13);
        float alpha__0_0_14 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_14 = g.getClip();
        AffineTransform defaultTransform__0_0_14 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(41.0, 23.5);
        shape.curveTo(49.0, 27.5, 49.0, 27.5, 49.0, 27.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_14;
        g.setTransform(defaultTransform__0_0_14);
        g.setClip(clip__0_0_14);
        float alpha__0_0_15 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_15 = g.getClip();
        AffineTransform defaultTransform__0_0_15 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(40.5, 26.5);
        shape.curveTo(48.5, 30.5, 48.5, 30.5, 48.5, 30.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_15;
        g.setTransform(defaultTransform__0_0_15);
        g.setClip(clip__0_0_15);
        float alpha__0_0_16 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_16 = g.getClip();
        AffineTransform defaultTransform__0_0_16 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(36.5, 29.5);
        shape.curveTo(44.5, 33.5, 44.5, 33.5, 44.5, 33.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_16;
        g.setTransform(defaultTransform__0_0_16);
        g.setClip(clip__0_0_16);
        float alpha__0_0_17 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_17 = g.getClip();
        AffineTransform defaultTransform__0_0_17 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(34.5, 31.5);
        shape.curveTo(42.5, 35.5, 42.5, 35.5, 42.5, 35.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_17;
        g.setTransform(defaultTransform__0_0_17);
        g.setClip(clip__0_0_17);
        float alpha__0_0_18 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_18 = g.getClip();
        AffineTransform defaultTransform__0_0_18 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(31.5, 35.5);
        shape.curveTo(39.5, 39.5, 39.5, 39.5, 39.5, 39.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_18;
        g.setTransform(defaultTransform__0_0_18);
        g.setClip(clip__0_0_18);
        float alpha__0_0_19 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_19 = g.getClip();
        AffineTransform defaultTransform__0_0_19 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(29.5, 37.5);
        shape.curveTo(37.5, 41.5, 37.5, 41.5, 37.5, 41.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_19;
        g.setTransform(defaultTransform__0_0_19);
        g.setClip(clip__0_0_19);
        float alpha__0_0_20 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_20 = g.getClip();
        AffineTransform defaultTransform__0_0_20 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.977272, 39.5);
        shape.curveTo(34.977272, 43.5, 34.977272, 43.5, 34.977272, 43.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_20;
        g.setTransform(defaultTransform__0_0_20);
        g.setClip(clip__0_0_20);
        float alpha__0_0_21 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_21 = g.getClip();
        AffineTransform defaultTransform__0_0_21 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(25.5, 42.5);
        shape.curveTo(33.5, 46.5, 33.5, 46.5, 33.5, 46.5);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_21;
        g.setTransform(defaultTransform__0_0_21);
        g.setClip(clip__0_0_21);
        float alpha__0_0_22 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_22 = g.getClip();
        AffineTransform defaultTransform__0_0_22 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(24.795456, 45.840908);
        shape.curveTo(32.795456, 49.840908, 32.795456, 49.840908, 32.795456, 49.840908);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_22;
        g.setTransform(defaultTransform__0_0_22);
        g.setClip(clip__0_0_22);
        float alpha__0_0_23 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_23 = g.getClip();
        AffineTransform defaultTransform__0_0_23 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GazetteerIcon.getColor(0, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(24.295456, 48.340908);
        shape.curveTo(32.295456, 52.340908, 32.295456, 52.340908, 32.295456, 52.340908);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_23;
        g.setTransform(defaultTransform__0_0_23);
        g.setClip(clip__0_0_23);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 4;
    }

    public static int getOrigY() {
        return 1;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public GazetteerIcon() {
        this(GazetteerIcon.getOrigWidth(), GazetteerIcon.getOrigHeight(), false);
    }

    public GazetteerIcon(boolean disabled) {
        this(GazetteerIcon.getOrigWidth(), GazetteerIcon.getOrigHeight(), disabled);
    }

    public GazetteerIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public GazetteerIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public GazetteerIcon(int width, int height) {
        this(width, height, false);
    }

    public GazetteerIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)GazetteerIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)GazetteerIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        GazetteerIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

