/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class GATEIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 60.0, 60.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -116.65451f, -204.47197f));
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        float alpha__0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1 = g.getClip();
        AffineTransform defaultTransform__0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -116.65451f, -204.47197f));
        float alpha__0_1_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1_0 = g.getClip();
        AffineTransform defaultTransform__0_1_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        origAlpha = alpha__0_1_0;
        g.setTransform(defaultTransform__0_1_0);
        g.setClip(clip__0_1_0);
        float alpha__0_1_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1_1 = g.getClip();
        AffineTransform defaultTransform__0_1_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GATEIcon.getColor(255, 255, 255, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(170.63737, 234.47195);
        shape.curveTo(170.80554, 263.7357, 122.67123, 258.0005, 122.67123, 258.0005);
        shape.lineTo(122.67123, 210.94342);
        shape.curveTo(122.67123, 210.94342, 170.46924, 205.20825, 170.63737, 234.47195);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = GATEIcon.getColor(0, 128, 0, 255, disabled);
        stroke = new BasicStroke(2.0333996f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(170.63737, 234.47195);
        shape.curveTo(170.80554, 263.7357, 122.67123, 258.0005, 122.67123, 258.0005);
        shape.lineTo(122.67123, 210.94342);
        shape.curveTo(122.67123, 210.94342, 170.46924, 205.20825, 170.63737, 234.47195);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_1_1;
        g.setTransform(defaultTransform__0_1_1);
        g.setClip(clip__0_1_1);
        float alpha__0_1_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_1_2 = g.getClip();
        AffineTransform defaultTransform__0_1_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = GATEIcon.getColor(255, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(159.5505, 249.17284);
        shape.lineTo(140.4545, 249.17284);
        shape.curveTo(136.08382, 249.17284, 132.46115, 247.72084, 129.5865, 244.81683);
        shape.curveTo(126.74117, 241.91283, 125.318504, 238.24617, 125.318504, 233.81683);
        shape.curveTo(125.318504, 229.41685, 126.7265, 225.86752, 129.54251, 223.16884);
        shape.curveTo(132.38785, 220.4702, 136.02518, 219.12086, 140.45451, 219.12083);
        shape.lineTo(157.4385, 219.12083);
        shape.lineTo(157.4385, 224.35684);
        shape.lineTo(140.45451, 224.35684);
        shape.curveTo(137.57983, 224.35686, 135.20383, 225.28087, 133.3265, 227.12885);
        shape.curveTo(131.4785, 228.97687, 130.5545, 231.35286, 130.5545, 234.25685);
        shape.curveTo(130.5545, 237.13153, 131.4785, 239.46352, 133.3265, 241.25285);
        shape.curveTo(135.20383, 243.04219, 137.57983, 243.93686, 140.45451, 243.93686);
        shape.lineTo(154.31451, 243.93686);
        shape.lineTo(154.31451, 237.38086);
        shape.lineTo(140.05852, 237.38086);
        shape.lineTo(140.05852, 232.58485);
        shape.lineTo(159.55052, 232.58485);
        shape.lineTo(159.55052, 249.17285);
        g.setPaint(paint);
        g.fill(shape);
        paint = GATEIcon.getColor(128, 0, 0, 255, disabled);
        stroke = new BasicStroke(1.0f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(159.5505, 249.17284);
        shape.lineTo(140.4545, 249.17284);
        shape.curveTo(136.08382, 249.17284, 132.46115, 247.72084, 129.5865, 244.81683);
        shape.curveTo(126.74117, 241.91283, 125.318504, 238.24617, 125.318504, 233.81683);
        shape.curveTo(125.318504, 229.41685, 126.7265, 225.86752, 129.54251, 223.16884);
        shape.curveTo(132.38785, 220.4702, 136.02518, 219.12086, 140.45451, 219.12083);
        shape.lineTo(157.4385, 219.12083);
        shape.lineTo(157.4385, 224.35684);
        shape.lineTo(140.45451, 224.35684);
        shape.curveTo(137.57983, 224.35686, 135.20383, 225.28087, 133.3265, 227.12885);
        shape.curveTo(131.4785, 228.97687, 130.5545, 231.35286, 130.5545, 234.25685);
        shape.curveTo(130.5545, 237.13153, 131.4785, 239.46352, 133.3265, 241.25285);
        shape.curveTo(135.20383, 243.04219, 137.57983, 243.93686, 140.45451, 243.93686);
        shape.lineTo(154.31451, 243.93686);
        shape.lineTo(154.31451, 237.38086);
        shape.lineTo(140.05852, 237.38086);
        shape.lineTo(140.05852, 232.58485);
        shape.lineTo(159.55052, 232.58485);
        shape.lineTo(159.55052, 249.17285);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_1_2;
        g.setTransform(defaultTransform__0_1_2);
        g.setClip(clip__0_1_2);
        origAlpha = alpha__0_1;
        g.setTransform(defaultTransform__0_1);
        g.setClip(clip__0_1);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 0;
    }

    public static int getOrigY() {
        return 0;
    }

    public static int getOrigWidth() {
        return 60;
    }

    public static int getOrigHeight() {
        return 60;
    }

    public GATEIcon() {
        this(GATEIcon.getOrigWidth(), GATEIcon.getOrigHeight(), false);
    }

    public GATEIcon(boolean disabled) {
        this(GATEIcon.getOrigWidth(), GATEIcon.getOrigHeight(), disabled);
    }

    public GATEIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public GATEIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public GATEIcon(int width, int height) {
        this(width, height, false);
    }

    public GATEIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)GATEIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)GATEIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        GATEIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

