/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class CreolePluginIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Color paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 64.0, 64.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(0.9524061f, 0.0f, 0.0f, 0.9524061f, 1.0951877f, 2.7528741f));
        float alpha__0_0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = CreolePluginIcon.getColor(15, 194, 18, 255, disabled);
        stroke = new BasicStroke(1.75f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(26.023392, 5.875);
        shape.curveTo(13.932483, 21.875, -7.622566, 21.7323, 8.841574, 39.69318);
        shape.curveTo(19.841574, 51.69318, 24.750664, 56.965904, 24.750664, 56.965904);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_0;
        g.setTransform(defaultTransform__0_0_0_0);
        g.setClip(clip__0_0_0_0);
        float alpha__0_0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = CreolePluginIcon.getColor(15, 194, 18, 255, disabled);
        stroke = new BasicStroke(1.75f, 0, 1, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(38.875, 5.875);
        shape.curveTo(50.965908, 21.875, 72.52096, 21.7323, 56.056816, 39.69318);
        shape.curveTo(45.056816, 51.69318, 40.147724, 56.965904, 40.147724, 56.965904);
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0_1;
        g.setTransform(defaultTransform__0_0_0_1);
        g.setClip(clip__0_0_0_1);
        float alpha__0_0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0_2_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0_2_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0_2_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = CreolePluginIcon.getColor(0, 0, 0, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(52.0, 26.312);
        shape.curveTo(51.999966, 29.256021, 50.75197, 31.592018, 48.256, 33.32);
        shape.curveTo(46.047974, 34.792015, 43.391975, 35.528015, 40.288002, 35.528);
        shape.lineTo(26.608002, 35.528);
        shape.lineTo(26.608002, 41.816);
        shape.lineTo(20.896002, 41.816);
        shape.lineTo(20.896002, 32.696003);
        shape.curveTo(20.896, 31.92802, 21.184, 31.256021, 21.760002, 30.680002);
        shape.curveTo(22.335999, 30.104023, 22.991999, 29.816023, 23.728003, 29.816002);
        shape.lineTo(41.200005, 29.816002);
        shape.curveTo(42.511982, 29.816021, 43.66398, 29.560022, 44.656006, 29.048002);
        shape.curveTo(45.90398, 28.408024, 46.527977, 27.480026, 46.528008, 26.264002);
        shape.curveTo(46.52798, 25.048027, 45.90398, 24.120028, 44.656006, 23.480001);
        shape.curveTo(43.663982, 22.968029, 42.511982, 22.712029, 41.200005, 22.712002);
        shape.lineTo(20.896004, 22.712002);
        shape.lineTo(20.896004, 17.000002);
        shape.lineTo(40.288002, 17.000002);
        shape.curveTo(43.39198, 17.000034, 46.047974, 17.752033, 48.256, 19.256002);
        shape.curveTo(50.75197, 20.984032, 51.99997, 23.33603, 52.0, 26.312002);
        shape.moveTo(26.608, 47.0);
        shape.curveTo(26.607992, 47.864002, 26.335993, 48.568, 25.792, 49.112);
        shape.curveTo(25.247993, 49.656002, 24.543995, 49.928, 23.68, 49.928);
        shape.curveTo(22.847998, 49.928, 22.143997, 49.656002, 21.568, 49.112);
        shape.curveTo(21.023998, 48.568, 20.751999, 47.864002, 20.752, 47.0);
        shape.curveTo(20.751999, 46.168003, 21.023998, 45.480003, 21.568, 44.936);
        shape.curveTo(22.143997, 44.392006, 22.847998, 44.120007, 23.68, 44.120003);
        shape.curveTo(24.543995, 44.12001, 25.247993, 44.39201, 25.792, 44.936005);
        shape.curveTo(26.335993, 45.48001, 26.607992, 46.168007, 26.608, 47.000004);
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_0_2_0;
        g.setTransform(defaultTransform__0_0_0_2_0);
        g.setClip(clip__0_0_0_2_0);
        origAlpha = alpha__0_0_0_2;
        g.setTransform(defaultTransform__0_0_0_2);
        g.setClip(clip__0_0_0_2);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 2;
    }

    public static int getOrigY() {
        return 8;
    }

    public static int getOrigWidth() {
        return 64;
    }

    public static int getOrigHeight() {
        return 64;
    }

    public CreolePluginIcon() {
        this(CreolePluginIcon.getOrigWidth(), CreolePluginIcon.getOrigHeight(), false);
    }

    public CreolePluginIcon(boolean disabled) {
        this(CreolePluginIcon.getOrigWidth(), CreolePluginIcon.getOrigHeight(), disabled);
    }

    public CreolePluginIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public CreolePluginIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public CreolePluginIcon(int width, int height) {
        this(width, height, false);
    }

    public CreolePluginIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)CreolePluginIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)CreolePluginIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        CreolePluginIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

