/*
 * Decompiled with CFR 0.152.
 */
package gate.html;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.DocumentContentImpl;
import gate.corpora.RepositioningInfo;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlDocumentHandler
extends HTMLEditorKit.ParserCallback {
    private RepositioningInfo reposInfo = null;
    private RepositioningInfo ampCodingInfo = null;
    private boolean isInsideStyleTag = false;
    static final int ELEMENTS_RATE = 128;
    private Map<String, String> markupElementsMap = null;
    private StringBuffer tmpDocContent = null;
    private Stack<CustomObject> stack = null;
    private Document doc = null;
    private AnnotationSet basicAS;
    protected List<StatusListener> myStatusListeners = new LinkedList<StatusListener>();
    private int elements = 0;
    protected long customObjectsId = 0L;
    private LinkedList<CustomObject> colector = null;

    public HtmlDocumentHandler(Document aDocument, Map<String, String> aMarkupElementsMap) {
        this(aDocument, aMarkupElementsMap, null);
    }

    public HtmlDocumentHandler(Document aDocument, Map<String, String> aMarkupElementsMap, AnnotationSet anAnnotationSet) {
        this.stack = new Stack();
        this.tmpDocContent = new StringBuffer(aDocument.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = aDocument;
        this.markupElementsMap = aMarkupElementsMap;
        this.basicAS = anAnnotationSet;
        this.customObjectsId = 0L;
    }

    public void setRepositioningInfo(RepositioningInfo info) {
        this.reposInfo = info;
    }

    public RepositioningInfo getRepositioningInfo() {
        return this.reposInfo;
    }

    public void setAmpCodingInfo(RepositioningInfo info) {
        this.ampCodingInfo = info;
    }

    public RepositioningInfo getAmpCodingInfo() {
        return this.ampCodingInfo;
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (0 == ++this.elements % 128) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        if (HTML.Tag.STYLE.equals(t)) {
            this.isInsideStyleTag = true;
        }
        FeatureMap fm = Factory.newFeatureMap();
        if (0 != a.getAttributeCount()) {
            Enumeration<?> enumeration = a.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object attribute = enumeration.nextElement();
                fm.put(attribute.toString(), a.getAttribute(attribute).toString());
            }
        }
        this.customizeAppearanceOfDocumentWithStartTag(t);
        int tmpDocContentSize = this.tmpDocContent.length();
        if (tmpDocContentSize != 0 && !Character.isWhitespace(this.tmpDocContent.charAt(tmpDocContentSize - 1))) {
            this.tmpDocContent.append(" ");
        }
        Long startIndex = new Long(this.tmpDocContent.length());
        CustomObject obj = new CustomObject(t.toString(), fm, startIndex, startIndex);
        this.stack.push(obj);
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        CustomObject obj = null;
        if (HTML.Tag.STYLE.equals(t)) {
            this.isInsideStyleTag = false;
        }
        if (!this.stack.isEmpty()) {
            obj = this.stack.pop();
            if (obj.getStart().equals(obj.getEnd())) {
                obj.getFM().put("isEmptyAndSpan", "true");
            }
            this.colector.add(obj);
        }
        if (obj != null && obj.getStart().longValue() != obj.getEnd().longValue()) {
            this.customizeAppearanceOfDocumentWithEndTag(t);
        }
        if (t == HTML.Tag.HTML) {
            this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
            if (this.basicAS == null) {
                this.basicAS = this.doc.getAnnotations("Original markups");
            }
            Collections.sort(this.colector);
            while (!this.colector.isEmpty()) {
                obj = this.colector.getFirst();
                this.colector.remove(obj);
                try {
                    if (this.markupElementsMap == null) {
                        this.basicAS.add(obj.getStart(), obj.getEnd(), obj.getElemName(), obj.getFM());
                        continue;
                    }
                    String annotationType = this.markupElementsMap.get(obj.getElemName());
                    if (annotationType == null) continue;
                    this.basicAS.add(obj.getStart(), obj.getEnd(), annotationType, obj.getFM());
                }
                catch (InvalidOffsetException e) {
                    Err.prln("Error creating an annot :" + obj + " Discarded...");
                }
            }
            this.fireStatusChangedEvent("Total elements : " + this.elements);
        }
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (++this.elements % 128 == 0) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        FeatureMap fm = Factory.newFeatureMap();
        if (0 != a.getAttributeCount()) {
            Enumeration<?> enumeration = a.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object attribute = enumeration.nextElement();
                fm.put(attribute.toString(), a.getAttribute(attribute).toString());
            }
        }
        Long startIndex = new Long(this.tmpDocContent.length());
        CustomObject obj = new CustomObject(t.toString(), fm, startIndex, startIndex);
        this.colector.add(obj);
        this.customizeAppearanceOfDocumentWithSimpleTag(t);
    }

    @Override
    public void handleText(char[] text, int pos) {
        if (this.isInsideStyleTag) {
            return;
        }
        String content = new String(text);
        String trimContent = content.trim();
        if (trimContent.length() == 0) {
            return;
        }
        int trimCorrection = content.indexOf(trimContent.charAt(0));
        content = trimContent;
        StringBuffer contentBuffer = new StringBuffer("");
        int tmpDocContentSize = this.tmpDocContent.length();
        boolean incrementStartIndex = false;
        if (tmpDocContentSize != 0 && content.length() != 0 && !Character.isWhitespace(content.charAt(0)) && !Character.isWhitespace(this.tmpDocContent.charAt(tmpDocContentSize - 1))) {
            contentBuffer.append(" ");
            incrementStartIndex = true;
        }
        if (this.reposInfo != null) {
            int extractedPos = this.tmpDocContent.length() + contentBuffer.length();
            this.addRepositioningInfo(content, pos + trimCorrection, extractedPos);
        }
        contentBuffer.append(content);
        Long end = new Long(this.tmpDocContent.length() + contentBuffer.length());
        CustomObject obj2 = null;
        for (CustomObject obj2 : this.stack) {
            if (incrementStartIndex && obj2.getStart().equals(obj2.getEnd())) {
                obj2.setStart(new Long(obj2.getStart() + 1L));
            }
            obj2.setEnd(end);
        }
        this.tmpDocContent.append(contentBuffer.toString());
    }

    public void addRepositioningInfo(String content, int pos, int extractedPos) {
        long offsetInExtracted;
        long remainingLen;
        int contentLength = content.length();
        RepositioningInfo.PositionInfo pi = null;
        long startPos = pos;
        long correction = 0L;
        for (int i = 0; i < this.ampCodingInfo.size(); ++i) {
            pi = (RepositioningInfo.PositionInfo)this.ampCodingInfo.get(i);
            long substituteStart = pi.getOriginalPosition();
            if (substituteStart < startPos) continue;
            if (substituteStart > (long)(pos + contentLength) + correction) break;
            remainingLen = substituteStart - (startPos + correction);
            offsetInExtracted = startPos - (long)pos;
            if (remainingLen > 0L) {
                this.reposInfo.addPositionInfo(startPos + correction, remainingLen, (long)extractedPos + offsetInExtracted, remainingLen);
            }
            this.reposInfo.addPositionInfo(substituteStart, pi.getOriginalLength(), (long)extractedPos + offsetInExtracted + remainingLen, pi.getCurrentLength());
            startPos = startPos + remainingLen + pi.getCurrentLength();
            correction += pi.getOriginalLength() - pi.getCurrentLength();
        }
        if ((remainingLen = (long)contentLength - (offsetInExtracted = startPos - (long)pos)) > 0L) {
            this.reposInfo.addPositionInfo(startPos + correction, remainingLen, (long)extractedPos + offsetInExtracted, remainingLen);
        }
    }

    protected void customizeAppearanceOfDocumentWithSimpleTag(HTML.Tag t) {
        boolean modification = false;
        if (HTML.Tag.BR == t) {
            this.tmpDocContent.append("\n");
            modification = true;
        }
        if (modification) {
            Long end = new Long(this.tmpDocContent.length());
            for (CustomObject obj : this.stack) {
                obj.setEnd(end);
            }
        }
    }

    protected void customizeAppearanceOfDocumentWithStartTag(HTML.Tag t) {
        int tmpDocContentSize;
        boolean modification = false;
        if (HTML.Tag.P == t && (tmpDocContentSize = this.tmpDocContent.length()) >= 2 && '\n' != this.tmpDocContent.charAt(tmpDocContentSize - 2)) {
            this.tmpDocContent.append("\n");
            modification = true;
        }
        if (modification) {
            Long end = new Long(this.tmpDocContent.length());
            for (CustomObject obj : this.stack) {
                obj.setEnd(end);
            }
        }
    }

    protected void customizeAppearanceOfDocumentWithEndTag(HTML.Tag t) {
        boolean modification = false;
        if (HTML.Tag.P == t || HTML.Tag.H1 == t || HTML.Tag.H2 == t || HTML.Tag.H3 == t || HTML.Tag.H4 == t || HTML.Tag.H5 == t || HTML.Tag.H6 == t || HTML.Tag.TR == t || HTML.Tag.CENTER == t || HTML.Tag.LI == t) {
            this.tmpDocContent.append("\n");
            modification = true;
        }
        if (HTML.Tag.TITLE == t) {
            this.tmpDocContent.append("\n\n");
            modification = true;
        }
        if (modification) {
            Long end = new Long(this.tmpDocContent.length());
            for (CustomObject obj : this.stack) {
                obj.setEnd(end);
            }
        }
    }

    @Override
    public void handleError(String errorMsg, int pos) {
    }

    @Override
    public void flush() throws BadLocationException {
    }

    @Override
    public void handleComment(char[] text, int pos) {
    }

    public void addStatusListener(StatusListener listener) {
        this.myStatusListeners.add(listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.myStatusListeners.remove(listener);
    }

    protected void fireStatusChangedEvent(String text) {
        Iterator<StatusListener> listenersIter = this.myStatusListeners.iterator();
        while (listenersIter.hasNext()) {
            listenersIter.next().statusChanged(text);
        }
    }

    class CustomObject
    implements Comparable<CustomObject> {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Long id = null;

        public CustomObject(String anElemName, FeatureMap aFm, Long aStart, Long anEnd) {
            this.elemName = anElemName;
            this.fm = aFm;
            this.start = aStart;
            this.end = anEnd;
            this.id = new Long(HtmlDocumentHandler.this.customObjectsId++);
        }

        @Override
        public int compareTo(CustomObject obj) {
            return this.id.compareTo(obj.getId());
        }

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public Long getId() {
            return this.id;
        }

        public void setElemName(String anElemName) {
            this.elemName = anElemName;
        }

        public void setFM(FeatureMap aFm) {
            this.fm = aFm;
        }

        public void setStart(Long aStart) {
            this.start = aStart;
        }

        public void setEnd(Long anEnd) {
            this.end = anEnd;
        }
    }
}

