/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import gate.Controller;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.Parameter;
import gate.creole.ResourceData;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TeamwareUtils {
    public static final String INPUT_ANNOTATION_SETS_FEATURE = "gate.teamware.inputAnnotationSets";
    public static final String OUTPUT_ANNOTATION_SETS_FEATURE = "gate.teamware.outputAnnotationSets";

    private TeamwareUtils() {
    }

    public static Set<String> getInputAnnotationSets(Controller c) {
        Object setNamesObj = c.getFeatures().get(INPUT_ANNOTATION_SETS_FEATURE);
        if (setNamesObj != null && setNamesObj instanceof Set) {
            return (Set)setNamesObj;
        }
        HashSet<String> setNames = new HashSet<String>();
        c.getFeatures().put(INPUT_ANNOTATION_SETS_FEATURE, setNames);
        TeamwareUtils.populateInputSetNamesForController(setNames, c, true);
        return setNames;
    }

    public static Set<String> getLikelyInputAnnotationSets(Controller c) {
        HashSet<String> likelySets = new HashSet<String>();
        TeamwareUtils.populateInputSetNamesForController(likelySets, c, false);
        return likelySets;
    }

    private static void populateInputSetNamesForController(Set<String> setNames, Controller c, boolean strict) {
        HashSet<String> outputSetNamesSoFar = new HashSet<String>();
        Collection<ProcessingResource> prs = c.getPRs();
        try {
            for (ProcessingResource pr : prs) {
                ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
                List<List<Parameter>> runtimeParams = rd.getParameterList().getRuntimeParameters();
                for (List<Parameter> disjunction : runtimeParams) {
                    for (Parameter param : disjunction) {
                        if (param.getName().equals("inputASName")) {
                            String setName = (String)pr.getParameterValue(param.getName());
                            if (strict && (setName == null || outputSetNamesSoFar.contains(setName))) continue;
                            setNames.add(setName);
                            continue;
                        }
                        if (strict || !param.getName().equals("annotationSetName")) continue;
                        setNames.add((String)pr.getParameterValue(param.getName()));
                    }
                }
                if (!strict) continue;
                for (List<Parameter> disjunction : runtimeParams) {
                    for (Parameter param : disjunction) {
                        if (!param.getName().equals("outputASName") && !param.getName().equals("annotationSetName")) continue;
                        outputSetNamesSoFar.add(String.valueOf(pr.getParameterValue(param.getName())));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<String> getOutputAnnotationSets(Controller c) {
        Object setNamesObj = c.getFeatures().get(OUTPUT_ANNOTATION_SETS_FEATURE);
        if (setNamesObj != null && setNamesObj instanceof Set) {
            return (Set)setNamesObj;
        }
        HashSet<String> setNames = new HashSet<String>();
        c.getFeatures().put(OUTPUT_ANNOTATION_SETS_FEATURE, setNames);
        TeamwareUtils.populateOutputSetNamesForController(setNames, c, true);
        return setNames;
    }

    public static Set<String> getLikelyOutputAnnotationSets(Controller c) {
        HashSet<String> likelySets = new HashSet<String>();
        TeamwareUtils.populateOutputSetNamesForController(likelySets, c, false);
        return likelySets;
    }

    private static void populateOutputSetNamesForController(Set<String> setNames, Controller c, boolean strict) {
        Collection<ProcessingResource> prs = c.getPRs();
        try {
            for (ProcessingResource pr : prs) {
                ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
                List<List<Parameter>> runtimeParams = rd.getParameterList().getRuntimeParameters();
                if (strict) {
                    for (List<Parameter> disjunction : runtimeParams) {
                        for (Parameter param : disjunction) {
                            if (!param.getName().equals("inputASName") && !param.getName().equals("annotationSetName")) continue;
                            setNames.remove(pr.getParameterValue(param.getName()));
                        }
                    }
                }
                for (List<Parameter> disjunction : runtimeParams) {
                    for (Parameter param : disjunction) {
                        if (!param.getName().equals("outputASName") && !param.getName().equals("annotationSetName")) continue;
                        setNames.add((String)pr.getParameterValue(param.getName()));
                    }
                }
            }
            if (!strict) {
                setNames.add(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

