/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.gui.MainFrame;
import gate.gui.annedit.AnnotationData;
import gate.gui.annedit.AnnotationDataImpl;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationListView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.AnnotationStack;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;

public class AnnotationStackView
extends AbstractDocumentView
implements AnnotationListener {
    TextualDocumentView textView;
    AnnotationSetsView annotationSetsView;
    AnnotationListView annotationListView;
    JLabel targetSetLabel;
    String targetSetName;
    JCheckBox overlappingCheckBox;
    AnnotationStack stackPanel;
    JScrollPane scroller;
    JPanel mainPanel;
    PreviousAnnotationAction previousAnnotationAction;
    NextAnnotationAction nextAnnotationAction;
    Map<String, String> typesFeatures = new HashMap<String, String>();
    AnnotationMouseListener annotationMouseListener = new AnnotationMouseListener();
    HeaderMouseListener headerMouseListener = new HeaderMouseListener();

    @Override
    public void cleanup() {
        super.cleanup();
        this.textView = null;
    }

    @Override
    protected void initGUI() {
        Iterator<DocumentView> centralViewsIter = this.owner.getCentralViews().iterator();
        while (this.textView == null && centralViewsIter.hasNext()) {
            DocumentView aView = centralViewsIter.next();
            if (!(aView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)aView;
        }
        Iterator<DocumentView> verticalViewsIter = this.owner.getVerticalViews().iterator();
        while (this.annotationSetsView == null && verticalViewsIter.hasNext()) {
            DocumentView aView = verticalViewsIter.next();
            if (!(aView instanceof AnnotationSetsView)) continue;
            this.annotationSetsView = (AnnotationSetsView)aView;
        }
        Iterator<DocumentView> horizontalViewsIter = this.owner.getHorizontalViews().iterator();
        while (this.annotationListView == null && horizontalViewsIter.hasNext()) {
            DocumentView aView = horizontalViewsIter.next();
            if (!(aView instanceof AnnotationListView)) continue;
            this.annotationListView = (AnnotationListView)aView;
        }
        this.annotationListView.setOwner(this.owner);
        this.document = this.textView.getDocument();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.addSeparator();
        this.previousAnnotationAction = new PreviousAnnotationAction();
        toolBar.add(this.previousAnnotationAction);
        this.nextAnnotationAction = new NextAnnotationAction();
        toolBar.add(this.nextAnnotationAction);
        this.overlappingCheckBox = new JCheckBox("Overlapping");
        this.overlappingCheckBox.setToolTipText("Skip non overlapping annotations.");
        toolBar.add(this.overlappingCheckBox);
        toolBar.addSeparator();
        this.targetSetLabel = new JLabel("Target set: Undefined");
        toolBar.add(this.targetSetLabel);
        this.targetSetLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnnotationStackView.this.askTargetSet();
            }
        });
        this.targetSetLabel.setToolTipText("<html>Target set to copy annotation when double clicked.<br>Click to change it.</html>");
        this.mainPanel.add((Component)toolBar, "North");
        this.stackPanel = new AnnotationStack(100, 30);
        this.scroller = new JScrollPane(this.stackPanel);
        this.scroller.getViewport().setOpaque(true);
        this.mainPanel.add((Component)this.scroller, "Center");
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    protected void initListeners() {
        this.stackPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AnnotationStackView.this.updateStackView();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.textView.getTextView().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                AnnotationStackView.this.updateStackView();
            }
        });
    }

    @Override
    protected void registerHooks() {
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void annotationUpdated(AnnotationEvent e) {
        this.updateStackView();
    }

    public void updateStackView() {
        if (this.textView == null) {
            return;
        }
        int caretPosition = this.textView.getTextView().getCaretPosition();
        int context = 40;
        String text = "";
        try {
            text = this.document.getContent().getContent(Math.max(0L, (long)(caretPosition - context)), Math.min(this.document.getContent().size(), (long)(caretPosition + 1 + context))).toString();
        }
        catch (InvalidOffsetException e) {
            e.printStackTrace();
        }
        this.stackPanel.setText(text);
        this.stackPanel.setExpressionStartOffset(caretPosition);
        this.stackPanel.setExpressionEndOffset(caretPosition + 1);
        this.stackPanel.setContextBeforeSize(Math.min(caretPosition, context));
        this.stackPanel.setContextAfterSize(Math.min(this.document.getContent().size().intValue() - 1 - caretPosition, context));
        this.stackPanel.setAnnotationMouseListener(this.annotationMouseListener);
        this.stackPanel.setHeaderMouseListener(this.headerMouseListener);
        this.stackPanel.clearAllRows();
        for (AnnotationSetsView.SetHandler setHandler : this.annotationSetsView.setHandlers) {
            for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!typeHandler.isSelected()) continue;
                this.stackPanel.addRow(setHandler.set.getName(), typeHandler.name, this.typesFeatures.get(typeHandler.name), null, null, 1);
                AnnotationSet annotations = setHandler.set.get(typeHandler.name).get(Math.max(0L, (long)(caretPosition - context)), Math.min(this.document.getContent().size(), (long)(caretPosition + 1 + context)));
                for (Annotation annotation : annotations) {
                    this.stackPanel.addAnnotation(annotation);
                }
            }
        }
        this.stackPanel.drawStack();
    }

    boolean askTargetSet() {
        Object[] messageObjects;
        final JTextField setsTextField = new JTextField("consensus", 15);
        if (this.document.getAnnotationSetNames() != null && !this.document.getAnnotationSetNames().isEmpty()) {
            Collator collator = Collator.getInstance(Locale.ENGLISH);
            collator.setStrength(2);
            TreeSet<Object> setNames = new TreeSet<Object>(collator);
            setNames.addAll(this.document.getAnnotationSetNames());
            JList<String> list = new JList<String>(setNames.toArray(new String[setNames.size()]));
            list.setVisibleRowCount(Math.min(10, setNames.size()));
            list.setSelectionMode(0);
            list.setSelectedValue(this.targetSetName, true);
            JScrollPane scroll = new JScrollPane(list);
            JPanel vspace = new JPanel();
            vspace.setSize(0, 5);
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    JList list = (JList)e.getSource();
                    if (list.getSelectedValue() != null) {
                        setsTextField.setText((String)list.getSelectedValue());
                    }
                }
            });
            messageObjects = new Object[]{"Existing annotation sets:", scroll, vspace, "Target set:", setsTextField};
        } else {
            messageObjects = new Object[]{"Target set:", setsTextField};
        }
        Object[] options = new String[]{"Use this target set", "Cancel"};
        JOptionPane optionPane = new JOptionPane(messageObjects, 3, 0, null, options, "Cancel");
        JDialog optionDialog = optionPane.createDialog(this.owner, "Copy annotation to another set");
        setsTextField.requestFocus();
        optionDialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null || selectedValue.equals("Cancel") || setsTextField.getText().trim().length() == 0) {
            this.textView.getTextView().requestFocusInWindow();
            return false;
        }
        this.targetSetName = setsTextField.getText();
        this.targetSetLabel.setText("Target set: " + this.targetSetName);
        this.textView.getTextView().requestFocusInWindow();
        return true;
    }

    protected class HeaderMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        JWindow popupWindow;

        public HeaderMouseListener() {
        }

        public HeaderMouseListener(String type, String feature) {
            this.type = type;
            this.feature = feature;
            this.init();
        }

        public HeaderMouseListener(String type) {
            this.type = type;
            this.init();
        }

        void init() {
            AnnotationStackView.this.mainPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    if (HeaderMouseListener.this.popupWindow != null) {
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
        }

        @Override
        public MouseInputAdapter createListener(String ... parameters) {
            switch (parameters.length) {
                case 1: {
                    return new HeaderMouseListener(parameters[0]);
                }
                case 2: {
                    return new HeaderMouseListener(parameters[0], parameters[1]);
                }
            }
            return null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.dispose();
                return;
            }
            if (e.getButton() != 1 || e.getClickCount() != 2) {
                return;
            }
            TreeSet<String> features = new TreeSet<String>();
            HashSet<String> setNames = new HashSet<String>();
            if (AnnotationStackView.this.document.getAnnotationSetNames() != null) {
                setNames.addAll(AnnotationStackView.this.document.getAnnotationSetNames());
            }
            setNames.add(null);
            block0: for (String setName : setNames) {
                int count = 0;
                for (Annotation annotation : AnnotationStackView.this.document.getAnnotations(setName).get(this.type)) {
                    for (Object feature : annotation.getFeatures().keySet()) {
                        features.add((String)feature);
                    }
                    if (++count != 50) continue;
                    continue block0;
                }
            }
            features.add("          ");
            final JList<String> list = new JList<String>(features.toArray(new String[features.size()]));
            list.setVisibleRowCount(Math.min(8, features.size()));
            list.setSelectionMode(0);
            list.setBackground(Color.WHITE);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        String feature = (String)list.getSelectedValue();
                        if (feature.equals("          ")) {
                            AnnotationStackView.this.typesFeatures.remove(HeaderMouseListener.this.type);
                        } else {
                            AnnotationStackView.this.typesFeatures.put(HeaderMouseListener.this.type, feature);
                        }
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                        AnnotationStackView.this.updateStackView();
                        AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
                    }
                }
            });
            this.popupWindow = new JWindow();
            this.popupWindow.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.popupWindow.add(new JScrollPane(list));
            Component component = e.getComponent();
            this.popupWindow.setBounds(component.getLocationOnScreen().x, component.getLocationOnScreen().y + component.getHeight(), component.getWidth(), Math.min(8 * component.getHeight(), features.size() * component.getHeight()));
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String newFeature = AnnotationStackView.this.typesFeatures.get(HeaderMouseListener.this.type);
                    if (newFeature == null) {
                        newFeature = "          ";
                    }
                    list.setSelectedValue(newFeature, true);
                    HeaderMouseListener.this.popupWindow.requestFocusInWindow();
                }
            });
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof JLabel && ((JLabel)component).getToolTipText() == null) {
                ((JLabel)component).setToolTipText("Double click to choose a feature.");
            }
        }
    }

    class AnnotationMouseListener
    extends AnnotationStack.StackMouseListener {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        int dismissDelay;
        int initialDelay;
        int reshowDelay;
        boolean enabled;
        Annotation annotation;
        AnnotationData annotationData;

        public AnnotationMouseListener() {
        }

        public AnnotationMouseListener(String setName, String annotationId) {
            AnnotationSet set = AnnotationStackView.this.document.getAnnotations(setName);
            this.annotation = set.get(Integer.valueOf(annotationId));
            if (this.annotation != null) {
                this.annotationData = new AnnotationDataImpl(set, this.annotation);
            }
        }

        @Override
        public MouseInputAdapter createListener(String ... parameters) {
            switch (parameters.length) {
                case 3: {
                    return new AnnotationMouseListener(parameters[0], parameters[2]);
                }
                case 5: {
                    return new AnnotationMouseListener(parameters[0], parameters[4]);
                }
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.processMouseEvent(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.processMouseEvent(me);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.processMouseEvent(me);
        }

        public void processMouseEvent(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu();
                List<Action> specificEditorActions = AnnotationStackView.this.annotationListView.getSpecificEditorActions(this.annotationData.getAnnotationSet(), this.annotationData.getAnnotation());
                for (Action action : specificEditorActions) {
                    popup.add(action);
                }
                List<Action> genericEditorActions = AnnotationStackView.this.annotationListView.getGenericEditorActions(this.annotationData.getAnnotationSet(), this.annotationData.getAnnotation());
                for (Action action : genericEditorActions) {
                    if (specificEditorActions.contains(action)) continue;
                    popup.add(action);
                }
                if (specificEditorActions.size() + genericEditorActions.size() > 1) {
                    popup.show(me.getComponent(), me.getX(), me.getY());
                } else if (specificEditorActions.size() == 1) {
                    specificEditorActions.get(0).actionPerformed(null);
                } else {
                    genericEditorActions.get(0).actionPerformed(null);
                }
            } else if (me.getID() == 500 && me.getButton() == 1 && me.getClickCount() == 1 && (me.getModifiersEx() & 0x80) != 0 && (me.getModifiersEx() & 0x40) != 0) {
                this.annotationData.getAnnotationSet().remove(this.annotation);
            } else if (me.getID() == 500 && me.getButton() == 1 && me.getClickCount() == 1 && (me.getModifiersEx() & 0x80) != 0) {
                String featureDisplayed = AnnotationStackView.this.typesFeatures.get(this.annotation.getType());
                Object[] features = featureDisplayed != null ? new Object[]{featureDisplayed} : this.annotation.getFeatures().keySet().toArray();
                for (Object feature : features) {
                    Pattern pattern;
                    Matcher matcher;
                    String value = (String)this.annotation.getFeatures().get(feature);
                    if (value == null || !(matcher = (pattern = Pattern.compile("(https?://[^\\s,;]+)")).matcher(value)).find()) continue;
                    MainFrame.getInstance().showHelpFrame(matcher.group(), "Annotation Stack View");
                }
            } else if (me.getID() == 500 && me.getButton() == 1 && me.getClickCount() == 2) {
                if (AnnotationStackView.this.targetSetName == null && !AnnotationStackView.this.askTargetSet()) {
                    return;
                }
                try {
                    FeatureMap params = Factory.newFeatureMap();
                    params.putAll(this.annotation.getFeatures());
                    AnnotationStackView.this.document.getAnnotations(AnnotationStackView.this.targetSetName).add(this.annotation.getStartNode().getOffset(), this.annotation.getEndNode().getOffset(), this.annotation.getType(), params);
                }
                catch (InvalidOffsetException e) {
                    e.printStackTrace();
                }
                Date timeToRun = new Date(System.currentTimeMillis() + 500L);
                Timer timer = new Timer("Annotation stack view select type", true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AnnotationStackView.this.annotationSetsView.setTypeSelected(AnnotationStackView.this.targetSetName, AnnotationMouseListener.this.annotation.getType(), true);
                            }
                        });
                    }
                }, timeToRun);
            }
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dismissDelay = this.toolTipManager.getDismissDelay();
            this.initialDelay = this.toolTipManager.getInitialDelay();
            this.reshowDelay = this.toolTipManager.getReshowDelay();
            this.enabled = this.toolTipManager.isEnabled();
            Component component = e.getComponent();
            if (component instanceof JLabel && !((JLabel)component).getToolTipText().contains("Ctr-Sh-click")) {
                JLabel label = (JLabel)component;
                String toolTip = label.getToolTipText() == null ? "" : label.getToolTipText();
                toolTip = toolTip.replaceAll("</?html>", "");
                toolTip = "<html>" + (toolTip.length() == 0 ? "" : "<b>" + toolTip + "</b><br>") + "Double-click to copy. Right-click to edit.<br>Ctr-click to show URL. Ctr-Sh-click to delete.</html>";
                label.setToolTipText(toolTip);
            }
            this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
            this.toolTipManager.setInitialDelay(0);
            this.toolTipManager.setReshowDelay(0);
            this.toolTipManager.setEnabled(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.toolTipManager.setDismissDelay(this.dismissDelay);
            this.toolTipManager.setInitialDelay(this.initialDelay);
            this.toolTipManager.setReshowDelay(this.reshowDelay);
            this.toolTipManager.setEnabled(this.enabled);
        }
    }

    class NextAnnotationAction
    extends AbstractAction {
        public NextAnnotationAction() {
            super("Next boundary");
            this.putValue("ShortDescription", "<html>Move to the next annotation boundary&nbsp;&nbsp;<font color=#667799><small>Alt-Right&nbsp;&nbsp;</small></font></html>");
            this.putValue("MnemonicKey", 39);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnnotationStackView.this.previousAnnotationAction.setEnabled(true);
            ArrayList<Object> list = new ArrayList<Annotation>();
            for (AnnotationSetsView.SetHandler setHandler : AnnotationStackView.this.annotationSetsView.setHandlers) {
                for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                    if (!typeHandler.isSelected()) continue;
                    list.addAll(setHandler.set.get(typeHandler.name).getContained(Long.valueOf(AnnotationStackView.this.textView.getTextView().getCaretPosition()), AnnotationStackView.this.document.getContent().size() - 1L));
                }
            }
            boolean enabled = false;
            if (list.size() > 0) {
                if (AnnotationStackView.this.overlappingCheckBox.isSelected()) {
                    Collections.sort(list, new OffsetComparator());
                    boolean found = false;
                    for (int i = 0; i < list.size() - 1; ++i) {
                        if (!((Annotation)list.get(i)).overlaps((Annotation)list.get(i + 1))) continue;
                        if (found) {
                            enabled = true;
                            break;
                        }
                        AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)list.get(i)).getEndNode().getOffset().intValue());
                        found = true;
                    }
                } else {
                    TreeSet<Annotation> set = new TreeSet<Annotation>(new OffsetComparator());
                    set.addAll(list);
                    list = new ArrayList<Annotation>(set);
                    AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)list.get(0)).getEndNode().getOffset().intValue());
                    enabled = list.size() > 1;
                }
                try {
                    AnnotationStackView.this.textView.getTextView().scrollRectToVisible(AnnotationStackView.this.textView.getTextView().modelToView(AnnotationStackView.this.textView.getTextView().getCaretPosition()));
                }
                catch (BadLocationException exception) {
                    exception.printStackTrace();
                }
            }
            this.setEnabled(enabled);
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }
    }

    class PreviousAnnotationAction
    extends AbstractAction {
        public PreviousAnnotationAction() {
            super("Previous boundary");
            this.putValue("ShortDescription", "<html>Move to the previous annotation boundary&nbsp;&nbsp;<font color=#667799><small>Alt-Left&nbsp;&nbsp;</small></font></html>");
            this.putValue("MnemonicKey", 37);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnnotationStackView.this.nextAnnotationAction.setEnabled(true);
            ArrayList<Object> list = new ArrayList<Annotation>();
            for (AnnotationSetsView.SetHandler setHandler : AnnotationStackView.this.annotationSetsView.setHandlers) {
                for (AnnotationSetsView.TypeHandler typeHandler : setHandler.typeHandlers) {
                    if (!typeHandler.isSelected()) continue;
                    list.addAll(setHandler.set.get(typeHandler.name).getContained(0L, (long)AnnotationStackView.this.textView.getTextView().getCaretPosition() - 1L));
                }
            }
            boolean enabled = false;
            if (list.size() > 0) {
                if (AnnotationStackView.this.overlappingCheckBox.isSelected()) {
                    Collections.sort(list, new OffsetComparator());
                    boolean found = false;
                    for (int i = list.size() - 1; i > 0; --i) {
                        if (!((Annotation)list.get(i)).overlaps((Annotation)list.get(i - 1))) continue;
                        if (found) {
                            enabled = true;
                            break;
                        }
                        AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)list.get(i)).getEndNode().getOffset().intValue());
                        found = true;
                    }
                } else {
                    TreeSet<Annotation> set = new TreeSet<Annotation>(new OffsetComparator());
                    set.addAll(list);
                    list = new ArrayList<Annotation>(set);
                    AnnotationStackView.this.textView.getTextView().setCaretPosition(((Annotation)list.get(list.size() - 1)).getEndNode().getOffset().intValue());
                    enabled = list.size() > 1;
                }
                try {
                    AnnotationStackView.this.textView.getTextView().scrollRectToVisible(AnnotationStackView.this.textView.getTextView().modelToView(AnnotationStackView.this.textView.getTextView().getCaretPosition()));
                }
                catch (BadLocationException exception) {
                    exception.printStackTrace();
                }
            }
            this.setEnabled(enabled);
            AnnotationStackView.this.textView.getTextView().requestFocusInWindow();
        }
    }
}

