/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.util.GateRuntimeException;
import java.util.List;

public class ParameterDisjunction
implements CreoleListener {
    int selectedIndex;
    String[] names;
    String[] comments;
    String[] types;
    Object[] values;
    Boolean[] required;
    Parameter[] params;
    Resource resource;

    public ParameterDisjunction(Resource resource, List<Parameter> parameters) {
        Gate.getCreoleRegister().addCreoleListener(this);
        this.resource = resource;
        this.params = new Parameter[parameters.size()];
        this.names = new String[parameters.size()];
        this.values = new Object[parameters.size()];
        this.comments = new String[parameters.size()];
        this.types = new String[parameters.size()];
        this.required = new Boolean[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            this.params[i] = parameters.get(i);
            this.names[i] = this.params[i].getName();
            this.comments[i] = this.params[i].getComment();
            this.types[i] = this.params[i].getTypeName();
            try {
                Object object = this.values[i] = resource == null ? null : resource.getParameterValue(this.params[i].getName());
                if (this.values[i] == null) {
                    this.values[i] = this.params[i].getDefaultValue();
                }
            }
            catch (ResourceInstantiationException rie) {
                throw new GateRuntimeException("Could not get read accessor method for \"" + this.names[i] + "\"property of " + resource.getClass().getName(), rie);
            }
            catch (ParameterException pe) {
                throw new GateRuntimeException("Could not get default value for \"" + this.names[i] + "\"property of " + resource.getClass().getName(), pe);
            }
            this.required[i] = new Boolean(!this.params[i].isOptional());
        }
        this.setSelectedIndex(0);
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int size() {
        return this.params.length;
    }

    public Boolean isRequired() {
        return this.required[this.selectedIndex];
    }

    public String getName() {
        return this.names[this.selectedIndex];
    }

    public String getComment() {
        return this.comments[this.selectedIndex];
    }

    public String getType() {
        return this.types[this.selectedIndex];
    }

    public String[] getNames() {
        return this.names;
    }

    public void setValue(Object value) {
        this.values[this.selectedIndex] = value;
    }

    public Object getValue() {
        return this.values[this.selectedIndex];
    }

    public Parameter[] getParameters() {
        return this.params;
    }

    public Parameter getParameter() {
        return this.params[this.selectedIndex];
    }

    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
        this.resource = null;
    }

    void removeCreoleListenerLink() {
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    protected void updateValues(Resource res) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != res) continue;
            this.values[i] = null;
            try {
                Object object = this.values[i] = this.resource == null ? null : this.resource.getParameterValue(this.params[i].getName());
                if (this.values[i] != null) continue;
                this.values[i] = this.params[i].getDefaultValue();
                continue;
            }
            catch (ResourceInstantiationException rie) {
                throw new GateRuntimeException("Could not get read accessor method for \"" + this.names[i] + "\"property of " + this.resource.getClass().getName());
            }
            catch (ParameterException pe) {
                throw new GateRuntimeException("Could not get default value for \"" + this.names[i] + "\"property of " + this.resource.getClass().getName());
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        this.updateValues(null);
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        this.updateValues(e.getResource());
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
        this.updateValues(resource);
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }
}

