/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.CorpusExporter;
import gate.Document;
import gate.DocumentExporter;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.Utils;
import gate.corpora.export.GateXMLExporter;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ResourceData;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.gui.ResourceParametersEditor;
import gate.swing.XJFileChooser;
import gate.swing.XJMenu;
import gate.util.Err;
import gate.util.Files;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public class DocumentExportMenu
extends XJMenu
implements CreoleListener {
    private static final Logger log = Logger.getLogger(DocumentExportMenu.class);
    static DocumentExportDialog dialog = new DocumentExportDialog();
    protected IdentityHashMap<Resource, JMenuItem> itemByResource = new IdentityHashMap();
    private Handle handle;

    public DocumentExportMenu(NameBearerHandle handle) {
        super("Save as...", "", handle.sListenerProxy);
        if (!(handle.getTarget() instanceof Document) && !(handle.getTarget() instanceof Corpus)) {
            throw new IllegalArgumentException("We only deal with documents and corpora");
        }
        this.handle = handle;
        this.init();
    }

    private void init() {
        DocumentExporter gateXMLExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get(GateXMLExporter.class.getCanonicalName())).getInstantiations().iterator().next();
        this.addExporter(gateXMLExporter);
        Set<String> toolTypes = Gate.getCreoleRegister().getToolTypes();
        for (String type : toolTypes) {
            List<Resource> instances = ((ResourceData)Gate.getCreoleRegister().get(type)).getInstantiations();
            for (Resource res : instances) {
                if (!(res instanceof DocumentExporter)) continue;
                this.addExporter((DocumentExporter)res);
            }
        }
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    private File getSelectedFile(List<List<Parameter>> params, DocumentExporter de, FeatureMap options) {
        boolean singleFile;
        File selectedFile = null;
        Document document = this.handle.getTarget() instanceof Document ? (Document)this.handle.getTarget() : null;
        boolean bl = singleFile = document != null || de instanceof CorpusExporter;
        if (document != null && document.getSourceUrl() != null) {
            try {
                selectedFile = Files.fileFromURL(document.getSourceUrl());
            }
            catch (IllegalArgumentException e) {
                String path;
                String fileName = null;
                if (document.getNamedAnnotationSets().containsKey("Original markups") && !document.getAnnotations("Original markups").get("title").isEmpty()) {
                    fileName = Utils.stringFor(document, document.getAnnotations("Original markups").get("title"));
                }
                if (fileName == null && !(path = document.getSourceUrl().getPath()).isEmpty()) {
                    fileName = path.substring(1 + path.lastIndexOf("/"));
                }
                if (fileName == null) {
                    fileName = document.getName();
                }
                fileName = fileName.replaceAll("[^/a-zA-Z0-9._-]+", "_");
                fileName = fileName.replaceAll("__+", "_");
                selectedFile = new File(fileName);
            }
            String fileName = selectedFile.getName();
            fileName = fileName.replaceAll("\\.[a-zA-Z]{1,4}$", "." + de.getDefaultExtension());
            if (!fileName.endsWith("." + de.getDefaultExtension())) {
                fileName = fileName + "." + de.getDefaultExtension();
            }
            selectedFile = new File(selectedFile, fileName);
        }
        if (params == null || params.isEmpty()) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.resetChoosableFileFilters();
            fileChooser.setFileFilter(de.getFileFilter());
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setDialogTitle("Save as " + de.getFileType());
            fileChooser.setFileSelectionMode(singleFile ? 0 : 1);
            if (selectedFile != null) {
                fileChooser.ensureFileIsVisible(selectedFile);
                fileChooser.setSelectedFile(selectedFile);
            }
            if (fileChooser.showSaveDialog(MainFrame.getInstance()) != 0) {
                return null;
            }
            selectedFile = fileChooser.getSelectedFile();
        } else {
            if (!dialog.show(de, params, singleFile, selectedFile != null ? selectedFile.getAbsolutePath() : "")) {
                return null;
            }
            options.putAll(dialog.getSelectedParameters());
            selectedFile = new File(dialog.getSelectedFileName());
        }
        return selectedFile;
    }

    private void addExporter(final DocumentExporter de) {
        if (this.itemByResource.containsKey(de)) {
            return;
        }
        final ResourceData rd = (ResourceData)Gate.getCreoleRegister().get(de.getClass().getCanonicalName());
        if (this.getItemCount() == 1) {
            this.addSeparator();
        }
        JMenuItem item = this.add(new AbstractAction(de.getFileType() + " (." + de.getDefaultExtension() + ")", MainFrame.getIcon(rd.getIcon(), rd.getResourceClassLoader())){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FeatureMap options;
                List<List<Parameter>> params = rd.getParameterList().getRuntimeParameters();
                final File selectedFile = DocumentExportMenu.this.getSelectedFile(params, de, options = Factory.newFeatureMap());
                if (selectedFile == null) {
                    return;
                }
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (DocumentExportMenu.this.handle.getTarget() instanceof Document) {
                            long start = System.currentTimeMillis();
                            DocumentExportMenu.this.listener.statusChanged("Saving as " + de.getFileType() + " to " + selectedFile.toString() + "...");
                            try {
                                de.export((Document)DocumentExportMenu.this.handle.getTarget(), selectedFile, options);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            long time = System.currentTimeMillis() - start;
                            DocumentExportMenu.this.listener.statusChanged("Finished saving as " + de.getFileType() + " into  the file: " + selectedFile.toString() + " in " + (double)time / 1000.0 + "s");
                        } else if (de instanceof CorpusExporter) {
                            long start = System.currentTimeMillis();
                            DocumentExportMenu.this.listener.statusChanged("Saving as " + de.getFileType() + " to " + selectedFile.toString() + "...");
                            try {
                                ((CorpusExporter)de).export((Corpus)DocumentExportMenu.this.handle.getTarget(), selectedFile, options);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            long time = System.currentTimeMillis() - start;
                            DocumentExportMenu.this.listener.statusChanged("Finished saving as " + de.getFileType() + " into  the file: " + selectedFile.toString() + " in " + (double)time / 1000.0 + "s");
                        } else {
                            try {
                                File dir = selectedFile;
                                if (!dir.exists() && !dir.mkdirs()) {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Could not create top directory!", "GATE", 0);
                                    return;
                                }
                                MainFrame.lockGUI("Saving...");
                                Corpus corpus = (Corpus)DocumentExportMenu.this.handle.getTarget();
                                Iterator docIter = corpus.iterator();
                                boolean overwriteAll = false;
                                int docCnt = corpus.size();
                                int currentDocIndex = 0;
                                HashSet<String> usedFileNames = new HashSet<String>();
                                while (docIter.hasNext()) {
                                    boolean docWasLoaded = corpus.isDocumentLoaded(currentDocIndex);
                                    Document currentDoc = (Document)docIter.next();
                                    URL sourceURL = currentDoc.getSourceUrl();
                                    String fileName = null;
                                    if (sourceURL != null) {
                                        fileName = sourceURL.getPath();
                                        fileName = Files.getLastPathComponent(fileName);
                                    }
                                    if (fileName == null || fileName.length() == 0) {
                                        fileName = currentDoc.getName();
                                    }
                                    if ((fileName = fileName.replaceAll("[\\/:\\*\\?\"<>|]", "_")).toLowerCase().endsWith("." + de.getDefaultExtension())) {
                                        fileName = fileName.substring(0, fileName.length() - de.getDefaultExtension().length() - 1);
                                    }
                                    if (usedFileNames.contains(fileName)) {
                                        String fileNameBase = fileName;
                                        int uniqId = 0;
                                        fileName = fileNameBase + "-" + uniqId++;
                                        while (usedFileNames.contains(fileName)) {
                                            fileName = fileNameBase + "-" + uniqId++;
                                        }
                                    }
                                    usedFileNames.add(fileName);
                                    if (!fileName.toLowerCase().endsWith("." + de.getDefaultExtension())) {
                                        fileName = fileName + "." + de.getDefaultExtension();
                                    }
                                    File docFile = null;
                                    boolean nameOK = false;
                                    do {
                                        if ((docFile = new File(dir, fileName)).exists() && !overwriteAll) {
                                            Object[] opts = new Object[]{"Yes", "All", "No", "Cancel"};
                                            MainFrame.unlockGUI();
                                            int answer = JOptionPane.showOptionDialog(MainFrame.getInstance(), "File " + docFile.getName() + " already exists!\nOverwrite?", "GATE", -1, 2, null, opts, opts[2]);
                                            MainFrame.lockGUI("Saving...");
                                            switch (answer) {
                                                case 0: {
                                                    nameOK = true;
                                                    break;
                                                }
                                                case 1: {
                                                    nameOK = true;
                                                    overwriteAll = true;
                                                    break;
                                                }
                                                case 2: {
                                                    MainFrame.unlockGUI();
                                                    fileName = (String)JOptionPane.showInputDialog(MainFrame.getInstance(), "Please provide an alternative file name", "GATE", 3, null, null, fileName);
                                                    if (fileName == null) {
                                                        DocumentExportMenu.this.handle.processFinished();
                                                        return;
                                                    }
                                                    MainFrame.lockGUI("Saving");
                                                    break;
                                                }
                                                case 3: {
                                                    DocumentExportMenu.this.handle.processFinished();
                                                    return;
                                                }
                                            }
                                            continue;
                                        }
                                        nameOK = true;
                                    } while (!nameOK);
                                    try {
                                        de.export(currentDoc, docFile, options);
                                    }
                                    catch (Exception ioe) {
                                        MainFrame.unlockGUI();
                                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "Could not create write file:" + ioe.toString(), "GATE", 0);
                                        ioe.printStackTrace(Err.getPrintWriter());
                                        MainFrame.unlockGUI();
                                        return;
                                    }
                                    DocumentExportMenu.this.listener.statusChanged(currentDoc.getName() + " saved");
                                    if (!docWasLoaded) {
                                        corpus.unloadDocument(currentDoc);
                                        Factory.deleteResource(currentDoc);
                                    }
                                    DocumentExportMenu.this.handle.progressChanged(100 * currentDocIndex++ / docCnt);
                                }
                                DocumentExportMenu.this.listener.statusChanged("Corpus Saved");
                                DocumentExportMenu.this.handle.processFinished();
                            }
                            finally {
                                MainFrame.unlockGUI();
                            }
                        }
                    }
                };
                Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Document Exporter Thread");
                thread.setPriority(1);
                thread.start();
            }
        });
        this.itemByResource.put(de, item);
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
        final Resource res = e.getResource();
        if (res instanceof DocumentExporter) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DocumentExportMenu.this.addExporter((DocumentExporter)res);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception ex) {
                    log.warn((Object)"Exception registering document exporter", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        final Resource res = e.getResource();
        if (res instanceof DocumentExporter) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMenuItem item = DocumentExportMenu.this.itemByResource.get(res);
                    if (item != null) {
                        DocumentExportMenu.this.remove(item);
                        DocumentExportMenu.this.itemByResource.remove(res);
                    }
                    if (DocumentExportMenu.this.getItemCount() == 2) {
                        DocumentExportMenu.this.remove(1);
                    }
                }
            });
        }
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    private static class DocumentExportDialog
    extends JDialog {
        private DocumentExporter de;
        private JButton okBtn;
        private JButton fileBtn;
        private JButton cancelBtn;
        private JTextField txtFileName;
        private ResourceParametersEditor parametersEditor;
        private boolean singleFile;
        private boolean userCanceled;
        private FeatureMap parameters;

        public DocumentExportDialog() {
            super(MainFrame.getInstance(), "Save As...", true);
            MainFrame.getGuiRoots().add(this);
            this.initGuiComponents();
            this.initListeners();
        }

        protected void initGuiComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            Box nameBox = Box.createHorizontalBox();
            nameBox.add(Box.createHorizontalStrut(5));
            nameBox.add(new JLabel("Save To:"));
            nameBox.add(Box.createHorizontalStrut(5));
            this.txtFileName = new JTextField(30);
            this.txtFileName.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.txtFileName.getPreferredSize().height));
            this.txtFileName.setRequestFocusEnabled(true);
            this.txtFileName.setVerifyInputWhenFocusTarget(false);
            nameBox.add(this.txtFileName);
            nameBox.add(Box.createHorizontalStrut(5));
            this.fileBtn = new JButton(MainFrame.getIcon("OpenFile"));
            nameBox.add(this.fileBtn);
            nameBox.add(Box.createHorizontalGlue());
            this.getContentPane().add(nameBox);
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.parametersEditor = new ResourceParametersEditor();
            this.getContentPane().add(new JScrollPane(this.parametersEditor));
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.getContentPane().add(Box.createVerticalGlue());
            JPanel buttonsBox = new JPanel();
            buttonsBox.setLayout(new BoxLayout(buttonsBox, 0));
            buttonsBox.add(Box.createHorizontalStrut(10));
            this.okBtn = new JButton("OK");
            buttonsBox.add(this.okBtn);
            buttonsBox.add(Box.createHorizontalStrut(10));
            this.cancelBtn = new JButton("Cancel");
            buttonsBox.add(this.cancelBtn);
            buttonsBox.add(Box.createHorizontalStrut(10));
            this.getContentPane().add(buttonsBox);
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.setSize(400, 300);
            this.getRootPane().setDefaultButton(this.okBtn);
        }

        protected void initListeners() {
            AbstractAction fileAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    XJFileChooser fileChooser = MainFrame.getFileChooser();
                    fileChooser.resetChoosableFileFilters();
                    fileChooser.setFileFilter(de.getFileFilter());
                    fileChooser.setMultiSelectionEnabled(false);
                    fileChooser.setDialogTitle("Save as " + de.getFileType());
                    fileChooser.setFileSelectionMode(singleFile ? 0 : 1);
                    try {
                        File f = new File(txtFileName.getText());
                        fileChooser.ensureFileIsVisible(f);
                        fileChooser.setSelectedFile(f);
                    }
                    catch (Exception f) {
                        // empty catch block
                    }
                    if (fileChooser.showSaveDialog(this) != 0) {
                        return;
                    }
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile == null) {
                        return;
                    }
                    txtFileName.setText(selectedFile.getAbsolutePath());
                }
            };
            AbstractAction applyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    userCanceled = false;
                    TableCellEditor cellEditor = parametersEditor.getCellEditor();
                    if (cellEditor != null) {
                        cellEditor.stopCellEditing();
                    }
                    this.setVisible(false);
                }
            };
            AbstractAction cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    userCanceled = true;
                    this.setVisible(false);
                }
            };
            this.fileBtn.addActionListener(fileAction);
            this.okBtn.addActionListener(applyAction);
            this.cancelBtn.addActionListener(cancelAction);
            InputMap im = this.parametersEditor.getInputMap(1);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            im.put(enter, "none");
            InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
            ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
            actionMap.put("Apply", applyAction);
            inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
            actionMap.put("Cancel", cancelAction);
        }

        public synchronized boolean show(DocumentExporter de, List<List<Parameter>> params, boolean singleFile, String filePath) {
            this.singleFile = singleFile;
            this.de = de;
            this.parameters = null;
            this.setTitle("Save as " + de.getFileType());
            this.txtFileName.setText(filePath);
            this.parametersEditor.init(null, params);
            this.pack();
            this.txtFileName.requestFocusInWindow();
            this.userCanceled = true;
            this.setModal(true);
            this.setLocationRelativeTo(this.getOwner());
            super.setVisible(true);
            this.dispose();
            if (this.userCanceled) {
                return false;
            }
            this.parameters = this.parametersEditor.getParameterValues();
            for (List<Parameter> disjunction : params) {
                for (Parameter param : disjunction) {
                    Object value;
                    if (param.getTypeName().equals("java.lang.String") || !this.parameters.containsKey(param.getName()) || !((value = this.parameters.get(param.getName())) instanceof String)) continue;
                    try {
                        this.parameters.put(param.getName(), param.calculateValueFromString((String)value));
                    }
                    catch (ParameterException pe) {
                        pe.printStackTrace();
                        this.parameters = null;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public void dispose() {
            this.de = null;
        }

        public FeatureMap getSelectedParameters() {
            return this.parameters;
        }

        public String getSelectedFileName() {
            return this.txtFileName.getText();
        }
    }
}

