/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CorpusFillerComponent
extends JPanel {
    JTextField urlTextField;
    JButton filerBtn;
    JTextField extensionsTextField;
    JButton listEditBtn;
    JCheckBox recurseCheckBox;
    JTextField encodingTextField;
    JTextField mimeTypeTextField;
    private List<String> extensions;

    public CorpusFillerComponent() {
        this.initLocalData();
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.extensions = new ArrayList<String>();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Directory URL:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        this.urlTextField = new JTextField(40);
        this.add((Component)this.urlTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        this.filerBtn = new JButton(MainFrame.getIcon("open-file"));
        this.add((Component)this.filerBtn, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Extensions:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 1;
        constraints.gridwidth = 5;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 10);
        this.extensionsTextField = new JTextField(40);
        this.add((Component)this.extensionsTextField, constraints);
        this.extensionsTextField.setEditable(false);
        this.extensionsTextField.setText(this.extensions.toString());
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 18;
        this.listEditBtn = new JButton(MainFrame.getIcon("edit-list"));
        this.add((Component)this.listEditBtn, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Encoding:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 2;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.encodingTextField = new JTextField(15);
        this.add((Component)this.encodingTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Mime Type:"), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 3;
        constraints.gridwidth = 4;
        constraints.fill = 2;
        this.mimeTypeTextField = new JTextField(15);
        this.add((Component)this.mimeTypeTextField, constraints);
        this.recurseCheckBox = new JCheckBox("Recurse directories");
        this.recurseCheckBox.setSelected(true);
        this.recurseCheckBox.setHorizontalTextPosition(2);
        constraints = new GridBagConstraints();
        constraints.gridx = -1;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.anchor = 18;
        this.add((Component)this.recurseCheckBox, constraints);
    }

    protected void initListeners() {
        this.filerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XJFileChooser filer = MainFrame.getFileChooser();
                filer.setFileSelectionMode(1);
                filer.setDialogTitle("Select a directory");
                filer.resetChoosableFileFilters();
                filer.setAcceptAllFileFilterUsed(true);
                filer.setFileFilter(filer.getAcceptAllFileFilter());
                int res = filer.showOpenDialog(CorpusFillerComponent.this);
                if (res == 0) {
                    try {
                        CorpusFillerComponent.this.urlTextField.setText(filer.getSelectedFile().toURI().toURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.listEditBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorDialog listEditor = new ListEditorDialog(CorpusFillerComponent.this, CorpusFillerComponent.this.extensions, String.class.getName());
                List answer = listEditor.showDialog();
                if (answer != null) {
                    CorpusFillerComponent.this.extensions.clear();
                    CorpusFillerComponent.this.extensions.addAll(answer);
                    CorpusFillerComponent.this.extensionsTextField.setText(CorpusFillerComponent.this.extensions.toString());
                }
            }
        });
    }

    public void setUrlString(String urlString) {
        this.urlTextField.setText(urlString);
    }

    public String getUrlString() {
        return this.urlTextField.getText();
    }

    public String getEncoding() {
        return this.encodingTextField.getText();
    }

    public void setEncoding(String enc) {
        this.encodingTextField.setText(enc);
    }

    public String getMimeType() {
        return this.mimeTypeTextField.getText();
    }

    public void setMimeType(String mimeType) {
        this.mimeTypeTextField.setText(mimeType);
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
        this.extensionsTextField.setText(extensions.toString());
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Gate.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Foo");
        CorpusFillerComponent comp = new CorpusFillerComponent();
        frame.getContentPane().add(comp);
        frame.pack();
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public void setRecurseDirectories(boolean recurseDirectories) {
        this.recurseCheckBox.setSelected(recurseDirectories);
    }

    public boolean isRecurseDirectories() {
        return this.recurseCheckBox.isSelected();
    }
}

