/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.MainFrame;
import gate.swing.XJPopupMenu;
import gate.swing.XJTable;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

@CreoleResource(name="Corpus editor", guiType=GuiType.LARGE, resourceDisplayed="gate.Corpus", mainViewer=true)
public class CorpusEditor
extends AbstractVisualResource
implements CorpusListener {
    protected XJTable docTable;
    protected DocumentTableModel docTableModel;
    protected DocumentNameRenderer renderer;
    protected JToolBar toolbar;
    protected Corpus corpus;
    protected NewDocumentAction newDocumentAction;
    protected RemoveDocumentsAction removeDocumentsAction;
    protected MoveUpAction moveUpAction;
    protected MoveDownAction moveDownAction;
    protected OpenDocumentsAction openDocumentsAction;
    protected JLabel messageLabel;
    protected int documentsLoadedCount;

    @Override
    public Resource init() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.docTableModel = new DocumentTableModel();
        try {
            this.documentsLoadedCount = Gate.getCreoleRegister().getAllInstances("gate.Document").size();
        }
        catch (GateException exception) {
            exception.printStackTrace();
        }
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.renderer = new DocumentNameRenderer();
        this.docTable = new XJTable(this.docTableModel);
        this.docTable.setSortable(true);
        this.docTable.setSortedColumn(0);
        this.docTable.setAutoResizeMode(3);
        this.docTable.getColumnModel().getColumn(1).setCellRenderer(this.renderer);
        this.docTable.setDragEnabled(true);
        this.docTable.setTransferHandler(new TransferHandler(){
            String source = "";

            @Override
            public int getSourceActions(JComponent c) {
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                int[] selectedRows = CorpusEditor.this.docTable.getSelectedRows();
                Arrays.sort(selectedRows);
                return new StringSelection("CorpusEditor" + Arrays.toString(selectedRows));
            }

            @Override
            protected void exportDone(JComponent c, Transferable data, int action) {
            }

            @Override
            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                for (DataFlavor flavor : flavors) {
                    if (!DataFlavor.stringFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                if (!this.canImport(c, t.getTransferDataFlavors())) {
                    return false;
                }
                try {
                    this.source = (String)t.getTransferData(DataFlavor.stringFlavor);
                    if (this.source.startsWith("ResourcesTree")) {
                        List<Resource> loadedDocuments;
                        int insertion = CorpusEditor.this.docTable.getSelectedRow();
                        ArrayList<Document> documents = new ArrayList<Document>();
                        this.source = this.source.replaceFirst("^ResourcesTree\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        final String[] documentsNames = this.source.split(", ");
                        try {
                            loadedDocuments = Gate.getCreoleRegister().getAllInstances("gate.Document");
                        }
                        catch (GateException e) {
                            e.printStackTrace();
                            return false;
                        }
                        for (String documentName : documentsNames) {
                            for (Resource loadedDocument : loadedDocuments) {
                                if (!loadedDocument.getName().equals(documentName) || CorpusEditor.this.corpus.contains(loadedDocument)) continue;
                                documents.add((Document)loadedDocument);
                            }
                        }
                        for (Document document : documents) {
                            if (insertion != -1) {
                                CorpusEditor.this.corpus.add(CorpusEditor.this.docTable.rowViewToModel(insertion), document);
                                if (insertion != CorpusEditor.this.docTable.getRowCount()) continue;
                                ++insertion;
                                continue;
                            }
                            CorpusEditor.this.corpus.add(document);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CorpusEditor.this.docTable.clearSelection();
                                for (String documentName : documentsNames) {
                                    for (int row = 0; row < CorpusEditor.this.docTable.getRowCount(); ++row) {
                                        if (!CorpusEditor.this.docTable.getValueAt(row, CorpusEditor.this.docTable.convertColumnIndexToView(1)).equals(documentName)) continue;
                                        CorpusEditor.this.docTable.addRowSelectionInterval(row, row);
                                    }
                                }
                            }
                        });
                        CorpusEditor.this.changeMessage();
                        return true;
                    }
                    if (this.source.startsWith("CorpusEditor")) {
                        int insertion;
                        int initialInsertion = insertion = CorpusEditor.this.docTable.getSelectedRow();
                        ArrayList documents = new ArrayList();
                        this.source = this.source.replaceFirst("^CorpusEditor\\[", "");
                        this.source = this.source.replaceFirst("\\]$", "");
                        String[] selectedRows = this.source.split(", ");
                        if (Integer.parseInt(selectedRows[0]) < insertion) {
                            ++insertion;
                        }
                        for (String row : selectedRows) {
                            if (Integer.parseInt(row) == initialInsertion) {
                                return false;
                            }
                            documents.add(CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(Integer.parseInt(row))));
                            if (Integer.parseInt(row) >= initialInsertion) continue;
                            --insertion;
                        }
                        for (Document document : documents) {
                            CorpusEditor.this.corpus.remove(document);
                        }
                        for (Document document : documents) {
                            CorpusEditor.this.corpus.add(CorpusEditor.this.docTable.rowViewToModel(insertion), document);
                            ++insertion;
                        }
                        CorpusEditor.this.docTable.addRowSelectionInterval(insertion - selectedRows.length, insertion - 1);
                        return true;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException ufe) {
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.docTable);
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.getViewport().setBackground(this.docTable.getBackground());
        this.add((Component)scroller, "Center");
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.newDocumentAction = new NewDocumentAction();
        this.toolbar.add(this.newDocumentAction);
        this.removeDocumentsAction = new RemoveDocumentsAction();
        this.toolbar.add(this.removeDocumentsAction);
        this.toolbar.addSeparator();
        this.moveUpAction = new MoveUpAction();
        this.toolbar.add(this.moveUpAction);
        this.moveDownAction = new MoveDownAction();
        this.toolbar.add(this.moveDownAction);
        this.toolbar.addSeparator();
        this.openDocumentsAction = new OpenDocumentsAction();
        this.toolbar.add(this.openDocumentsAction);
        this.removeDocumentsAction.setEnabled(false);
        this.moveUpAction.setEnabled(false);
        this.moveDownAction.setEnabled(false);
        this.openDocumentsAction.setEnabled(false);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.toolbar, "North");
        this.messageLabel = new JLabel();
        this.changeMessage();
        topPanel.add((Component)this.messageLabel, "South");
        this.add((Component)topPanel, "North");
    }

    protected void initListeners() {
        this.docTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processMouseEvent(e);
                }
            }

            private void processMouseEvent(MouseEvent e) {
                int row = CorpusEditor.this.docTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    if (!CorpusEditor.this.docTable.isRowSelected(row)) {
                        CorpusEditor.this.docTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    XJPopupMenu popup = new XJPopupMenu();
                    popup.add(CorpusEditor.this.openDocumentsAction);
                    popup.add(CorpusEditor.this.removeDocumentsAction);
                    popup.show(CorpusEditor.this.docTable, e.getPoint().x, e.getPoint().y);
                } else if (e.getID() == 500 && e.getClickCount() == 2) {
                    CorpusEditor.this.openDocumentsAction.actionPerformed(null);
                }
            }
        });
        this.docTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CorpusEditor.this.openDocumentsAction.actionPerformed(null);
                }
            }
        });
        this.docTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CorpusEditor.this.removeDocumentsAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0);
                CorpusEditor.this.openDocumentsAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0);
                CorpusEditor.this.moveUpAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0 && !CorpusEditor.this.docTable.isRowSelected(0));
                CorpusEditor.this.moveDownAction.setEnabled(CorpusEditor.this.docTable.getSelectedRowCount() > 0 && !CorpusEditor.this.docTable.isRowSelected(CorpusEditor.this.docTable.getRowCount() - 1));
            }
        });
        Gate.getCreoleRegister().addCreoleListener(new CreoleListener(){

            @Override
            public void resourceLoaded(CreoleEvent e) {
                if (e.getResource() instanceof Document) {
                    ++CorpusEditor.this.documentsLoadedCount;
                    CorpusEditor.this.changeMessage();
                }
            }

            @Override
            public void resourceUnloaded(CreoleEvent e) {
                if (e.getResource() instanceof Document) {
                    --CorpusEditor.this.documentsLoadedCount;
                    CorpusEditor.this.changeMessage();
                }
            }

            @Override
            public void datastoreOpened(CreoleEvent e) {
            }

            @Override
            public void datastoreCreated(CreoleEvent e) {
            }

            @Override
            public void datastoreClosed(CreoleEvent e) {
            }

            @Override
            public void resourceRenamed(Resource resource, String oldName, String newName) {
            }
        });
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.corpus = null;
    }

    @Override
    public void setTarget(Object target) {
        if (this.corpus != null && this.corpus != target) {
            this.corpus.removeCorpusListener(this);
        }
        if (!(target instanceof Corpus)) {
            throw new IllegalArgumentException("The GATE corpus editor can only be used with a GATE corpus!\n" + target.getClass().toString() + " is not a GATE corpus!");
        }
        this.corpus = (Corpus)target;
        this.corpus.addCorpusListener(this);
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusEditor.this.docTableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void documentAdded(final CorpusEvent e) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusEditor.this.changeMessage();
                CorpusEditor.this.docTableModel.fireTableRowsInserted(e.getDocumentIndex(), e.getDocumentIndex());
            }
        });
    }

    @Override
    public void documentRemoved(final CorpusEvent e) {
        this.docTableModel.dataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CorpusEditor.this.changeMessage();
                CorpusEditor.this.docTableModel.fireTableRowsDeleted(e.getDocumentIndex(), e.getDocumentIndex());
            }
        });
    }

    protected void changeMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CorpusEditor.this.corpus == null || CorpusEditor.this.corpus.size() == 0) {
                    CorpusEditor.this.newDocumentAction.setEnabled(true);
                    CorpusEditor.this.messageLabel.setText("<html>To add or remove documents to this corpus:<ul><li>use the toolbar buttons at the top of this view<li>drag documents from the left resources tree and drop them below<li>right click on the corpus in the resources tree and choose 'Populate'</ul></html>");
                    CorpusEditor.this.messageLabel.setVisible(true);
                } else if (CorpusEditor.this.documentsLoadedCount == 0) {
                    CorpusEditor.this.newDocumentAction.setEnabled(false);
                    if (CorpusEditor.this.corpus.getDataStore() == null) {
                        CorpusEditor.this.messageLabel.setText("There are no documents loaded in the system. Press F1 for help.");
                    } else {
                        CorpusEditor.this.messageLabel.setText("Open a document to load it from the datastore.");
                    }
                    CorpusEditor.this.messageLabel.setVisible(true);
                } else {
                    CorpusEditor.this.newDocumentAction.setEnabled(true);
                    CorpusEditor.this.messageLabel.setVisible(false);
                }
            }
        });
    }

    class OpenDocumentsAction
    extends AbstractAction {
        public OpenDocumentsAction() {
            super("Open documents", MainFrame.getIcon("document"));
            this.putValue("ShortDescription", "Opens selected document(s) in a document editor");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component root = SwingUtilities.getRoot(CorpusEditor.this);
            if (!(root instanceof MainFrame)) {
                return;
            }
            final MainFrame mainFrame = (MainFrame)root;
            final int[] selectedRows = CorpusEditor.this.docTable.getSelectedRows();
            if (selectedRows.length > 10) {
                Object[] possibleValues = new Object[]{"Open the " + selectedRows.length + " documents", "Don't open"};
                int selectedValue = JOptionPane.showOptionDialog(CorpusEditor.this.docTable, "Do you want to open " + selectedRows.length + " documents in the central tabbed pane ?", "Warning", -1, 3, null, possibleValues, possibleValues[1]);
                if (selectedValue == 1 || selectedValue == -1) {
                    return;
                }
            }
            for (int row : selectedRows) {
                CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(row));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int row : selectedRows) {
                        Document doc = (Document)CorpusEditor.this.corpus.get(CorpusEditor.this.docTable.rowViewToModel(row));
                        mainFrame.select(doc);
                    }
                }
            });
        }
    }

    class RemoveDocumentsAction
    extends AbstractAction {
        public RemoveDocumentsAction() {
            super("Remove documents", MainFrame.getIcon("remove-document"));
            this.putValue("ShortDescription", "Removes selected document(s) from this corpus");
            this.putValue("MnemonicKey", 127);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] selectedIndexes = CorpusEditor.this.docTable.getSelectedRows();
            int[] corpusIndexes = new int[selectedIndexes.length];
            for (i = 0; i < selectedIndexes.length; ++i) {
                corpusIndexes[i] = CorpusEditor.this.docTable.rowViewToModel(selectedIndexes[i]);
            }
            Arrays.sort(corpusIndexes);
            for (i = corpusIndexes.length - 1; i >= 0; --i) {
                CorpusEditor.this.corpus.remove(corpusIndexes[i]);
            }
            CorpusEditor.this.docTable.clearSelection();
            CorpusEditor.this.changeMessage();
        }
    }

    class NewDocumentAction
    extends AbstractAction {
        public NewDocumentAction() {
            super("Add document", MainFrame.getIcon("add-document"));
            this.putValue("ShortDescription", "Add new document(s) to this corpus");
            this.putValue("MnemonicKey", 10);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Resource> loadedDocuments;
            try {
                loadedDocuments = Gate.getCreoleRegister().getAllInstances("gate.Document");
            }
            catch (GateException ge) {
                throw new GateRuntimeException("gate.Document is not registered in the creole register!\nSomething must be terribly wrong...take a vacation!");
            }
            Vector<String> docNames = new Vector<String>();
            for (Resource loadedDocument : new ArrayList<Resource>(loadedDocuments)) {
                if (CorpusEditor.this.corpus.contains(loadedDocument)) {
                    loadedDocuments.remove(loadedDocument);
                    continue;
                }
                docNames.add(loadedDocument.getName());
            }
            JList<String> docList = new JList<String>(docNames);
            docList.getSelectionModel().setSelectionInterval(0, docNames.size() - 1);
            docList.setCellRenderer(CorpusEditor.this.renderer);
            final JOptionPane optionPane = new JOptionPane(new JScrollPane(docList), 3, 2);
            final JDialog dialog = optionPane.createDialog(CorpusEditor.this, "Add document(s) to this corpus");
            docList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        optionPane.setValue(0);
                        dialog.dispose();
                    }
                }
            });
            dialog.setVisible(true);
            if (optionPane.getValue().equals(0)) {
                int[] selectedIndices;
                for (int selectedIndice : selectedIndices = docList.getSelectedIndices()) {
                    CorpusEditor.this.corpus.add((Document)loadedDocuments.get(selectedIndice));
                }
            }
            CorpusEditor.this.changeMessage();
        }
    }

    class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            super("Move down", MainFrame.getIcon("down"));
            this.putValue("ShortDescription", "Moves selected document(s) down");
            this.putValue("MnemonicKey", 40);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] rowsTable = CorpusEditor.this.docTable.getSelectedRows();
            int[] rowsCorpus = new int[rowsTable.length];
            for (i = 0; i < rowsTable.length; ++i) {
                rowsCorpus[i] = CorpusEditor.this.docTable.rowViewToModel(rowsTable[i]);
            }
            Arrays.sort(rowsCorpus);
            for (i = rowsCorpus.length - 1; i >= 0; --i) {
                if (rowsCorpus[i] >= CorpusEditor.this.corpus.size() - 1) continue;
                boolean wasLoaded = CorpusEditor.this.corpus.isDocumentLoaded(rowsCorpus[i]);
                Document doc = (Document)CorpusEditor.this.corpus.get(rowsCorpus[i]);
                CorpusEditor.this.corpus.remove(rowsCorpus[i]);
                int n = i;
                rowsCorpus[n] = rowsCorpus[n] + 1;
                CorpusEditor.this.corpus.add(rowsCorpus[i], doc);
                if (wasLoaded) continue;
                CorpusEditor.this.corpus.unloadDocument(doc);
                Factory.deleteResource(doc);
            }
            final int[] selectedRowsCorpus = new int[rowsCorpus.length];
            System.arraycopy(rowsCorpus, 0, selectedRowsCorpus, 0, rowsCorpus.length);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < selectedRowsCorpus.length; ++i) {
                        int rowTable = CorpusEditor.this.docTable.rowModelToView(selectedRowsCorpus[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(rowTable, rowTable);
                    }
                }
            });
        }
    }

    class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            super("Move up", MainFrame.getIcon("up"));
            this.putValue("ShortDescription", "Moves selected document(s) up");
            this.putValue("MnemonicKey", 38);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] rowsTable = CorpusEditor.this.docTable.getSelectedRows();
            int[] rowsCorpus = new int[rowsTable.length];
            for (i = 0; i < rowsTable.length; ++i) {
                rowsCorpus[i] = CorpusEditor.this.docTable.rowViewToModel(rowsTable[i]);
            }
            Arrays.sort(rowsCorpus);
            for (i = 0; i < rowsCorpus.length; ++i) {
                if (rowsCorpus[i] <= 0) continue;
                boolean wasLoaded = CorpusEditor.this.corpus.isDocumentLoaded(rowsCorpus[i]);
                Document doc = (Document)CorpusEditor.this.corpus.get(rowsCorpus[i]);
                CorpusEditor.this.corpus.remove(rowsCorpus[i]);
                rowsCorpus[i] = rowsCorpus[i] - 1;
                CorpusEditor.this.corpus.add(rowsCorpus[i], doc);
                if (wasLoaded) continue;
                CorpusEditor.this.corpus.unloadDocument(doc);
                Factory.deleteResource(doc);
            }
            final int[] selectedRowsCorpus = new int[rowsCorpus.length];
            System.arraycopy(rowsCorpus, 0, selectedRowsCorpus, 0, rowsCorpus.length);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CorpusEditor.this.docTable.clearSelection();
                    for (int i = 0; i < selectedRowsCorpus.length; ++i) {
                        int rowTable = CorpusEditor.this.docTable.rowModelToView(selectedRowsCorpus[i]);
                        CorpusEditor.this.docTable.getSelectionModel().addSelectionInterval(rowTable, rowTable);
                    }
                }
            });
        }
    }

    class DocumentNameRenderer
    extends DefaultTableCellRenderer
    implements ListCellRenderer<String> {
        public DocumentNameRenderer() {
            this.setIcon(MainFrame.getIcon("document"));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.getTableCellRendererComponent(CorpusEditor.this.docTable, value, isSelected, cellHasFocus, index, 1);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dim = super.getMaximumSize();
            if (dim != null) {
                dim.width = Integer.MAX_VALUE;
                this.setMaximumSize(dim);
            }
            return dim;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class DocumentTableModel
    extends AbstractTableModel {
        private List<String> documentNames;
        private final String[] COLUMN_NAMES = new String[]{"Index", "Document name"};
        private static final int COL_INDEX = 0;
        private static final int COL_NAME = 1;
        private static final int COLUMN_COUNT = 2;

        public DocumentTableModel() {
            this.documentNames = new ArrayList<String>();
        }

        private void dataChanged() {
            ArrayList<String> newDocs = new ArrayList<String>();
            if (CorpusEditor.this.corpus != null) {
                newDocs.addAll(CorpusEditor.this.corpus.getDocumentNames());
            }
            List<String> oldDocs = this.documentNames;
            this.documentNames = newDocs;
            oldDocs.clear();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.documentNames.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.documentNames.size() || columnIndex < 0 || columnIndex > 2) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return rowIndex;
                }
                case 1: {
                    return this.documentNames.get(rowIndex);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

