/*
 * Decompiled with CFR 0.152.
 */
package gate.email;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.event.StatusListener;
import gate.util.InvalidOffsetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class EmailDocumentHandler {
    private String content = null;
    private long documentSize = 0L;
    private static final int EMAILS_RATE = 16;
    private Document gateDocument = null;
    private AnnotationSet basicAS = null;
    private Map<String, String> markupElementsMap = null;
    private Map<String, String> element2StringMap = null;
    protected List<StatusListener> myStatusListeners = new LinkedList<StatusListener>();
    private int emails = 0;
    private String fieldName = null;
    private Collection<String> day = null;
    private Collection<String> month = null;
    private Collection<String> zone = null;

    public EmailDocumentHandler() {
        this.setUp();
    }

    public EmailDocumentHandler(Document aGateDocument, Map<String, String> aMarkupElementsMap, Map<String, String> anElement2StringMap) {
        this.gateDocument = aGateDocument;
        if (this.basicAS == null) {
            this.basicAS = this.gateDocument.getAnnotations("Original markups");
        }
        this.markupElementsMap = aMarkupElementsMap;
        this.element2StringMap = anElement2StringMap;
        this.setUp();
    }

    public void annotateMessages() throws IOException, InvalidOffsetException {
        BufferedReader gateDocumentReader = null;
        this.content = this.gateDocument.getContent().toString();
        this.documentSize = this.gateDocument.getContent().size();
        gateDocumentReader = new BufferedReader(new StringReader(this.content));
        String line = null;
        String aFieldName = null;
        long cursor = 0L;
        long endEmail = 0L;
        long startEmail = 0L;
        long endHeader = 0L;
        long startHeader = 0L;
        long endBody = 0L;
        long startBody = 0L;
        long endField = 0L;
        long startField = 0L;
        boolean insideAnEmail = false;
        boolean insideHeader = false;
        boolean emailReadBefore = false;
        boolean fieldReadBefore = false;
        long nlSize = this.detectNLSize();
        while ((line = gateDocumentReader.readLine()) != null) {
            if (this.lineBeginsMessage(line)) {
                if (++this.emails % 16 == 0) {
                    this.fireStatusChangedEvent("Reading emails : " + this.emails);
                }
                if (emailReadBefore) {
                    endEmail = cursor - nlSize;
                    endBody = cursor - nlSize;
                    this.createAnnotation("Body", startBody, endBody, null);
                    this.createAnnotation("Message", startEmail, endEmail, null);
                }
                emailReadBefore = true;
                startEmail = cursor;
                startHeader = cursor;
                cursor += (long)line.length() + nlSize;
                insideAnEmail = true;
                insideHeader = true;
                fieldReadBefore = false;
                continue;
            }
            if (!insideAnEmail) {
                cursor += (long)line.length() + nlSize;
                continue;
            }
            if (insideHeader) {
                if (line.equals("")) {
                    insideHeader = false;
                    endHeader = cursor - nlSize;
                    startBody = cursor += (long)line.length() + nlSize;
                    if (!fieldReadBefore) continue;
                    endField = endHeader;
                    this.createAnnotation(aFieldName, startField, endField, null);
                    this.createAnnotation("Header", startHeader, endHeader, null);
                    continue;
                }
                if (this.lineBeginsWithField(line)) {
                    if (fieldReadBefore) {
                        endField = cursor - nlSize;
                        this.createAnnotation(aFieldName, startField, endField, null);
                    }
                    fieldReadBefore = true;
                    aFieldName = this.getFieldName();
                    startField = cursor + (long)aFieldName.length() + (long)":".length();
                }
                cursor += (long)line.length() + nlSize;
                continue;
            }
            cursor += (long)line.length() + nlSize;
        }
        if (emailReadBefore) {
            endBody = cursor - nlSize;
            endEmail = cursor - nlSize;
            this.createAnnotation("Body", startBody, endBody, null);
            this.createAnnotation("Message", startEmail, endEmail, null);
        }
    }

    private int detectNLSize() {
        char[] document = null;
        document = this.gateDocument.getContent().toString().toCharArray();
        for (int i = 0; i < document.length; ++i) {
            if (document[i] != '\n') continue;
            if (i + 1 < document.length && document[i + 1] == '\r' || i - 1 >= 0 && document[i - 1] == '\r') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void createAnnotation(String anAnnotationName, long anAnnotationStart, long anAnnotationEnd, FeatureMap aFeatureMap) throws InvalidOffsetException {
        if (this.canCreateAnnotation(anAnnotationStart, anAnnotationEnd, this.documentSize)) {
            if (aFeatureMap == null) {
                aFeatureMap = Factory.newFeatureMap();
            }
            this.basicAS.add(new Long(anAnnotationStart), new Long(anAnnotationEnd), anAnnotationName.toLowerCase(), aFeatureMap);
        }
    }

    private boolean canCreateAnnotation(long start, long end, long gateDocumentSize) {
        if (start < 0L || end < 0L) {
            return false;
        }
        if (start > end) {
            return false;
        }
        return start <= gateDocumentSize && end <= gateDocumentSize;
    }

    protected boolean lineBeginsMessage(String aTextLine) {
        int score = 0;
        StringTokenizer tokenizer = new StringTokenizer(aTextLine, " ");
        String firstToken = null;
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        firstToken = tokenizer.nextToken();
        firstToken = firstToken.trim();
        if (!firstToken.equals("From")) {
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!this.hasAMeaning(token = token.trim())) continue;
            ++score;
        }
        return score >= 5;
    }

    protected boolean lineBeginsWithField(String aTextLine) {
        if (this.containsSemicolon(aTextLine)) {
            StringTokenizer tokenizer = new StringTokenizer(aTextLine, ":");
            String firstToken = null;
            if (!tokenizer.hasMoreTokens()) {
                return false;
            }
            firstToken = tokenizer.nextToken();
            if (firstToken != null) {
                if (this.containsWhiteSpaces(firstToken = firstToken.trim())) {
                    return false;
                }
                this.fieldName = firstToken;
            }
            return true;
        }
        return false;
    }

    protected boolean containsWhiteSpaces(String aString) {
        for (int i = 0; i < aString.length(); ++i) {
            if (!Character.isWhitespace(aString.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean containsSemicolon(String aString) {
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) != ':') continue;
            return true;
        }
        return false;
    }

    protected boolean hasAMeaning(String aToken) {
        if (this.day.contains(aToken)) {
            return true;
        }
        if (this.month.contains(aToken)) {
            return true;
        }
        if (this.zone.contains(aToken)) {
            return true;
        }
        Integer dayNumberOrYear = null;
        try {
            dayNumberOrYear = new Integer(aToken);
        }
        catch (NumberFormatException e) {
            dayNumberOrYear = null;
        }
        if (dayNumberOrYear != null) {
            int number = dayNumberOrYear;
            if (number > 0 && number < 32) {
                return true;
            }
            if (number > 1900 && number < 3000) {
                return true;
            }
            if (number >= 0 && number <= 99) {
                return true;
            }
        }
        return this.isTime(aToken);
    }

    protected boolean isTime(String aToken) {
        StringTokenizer st = new StringTokenizer(aToken, ":");
        String hourString = null;
        if (st.hasMoreTokens()) {
            hourString = st.nextToken();
        }
        if (hourString == null) {
            return false;
        }
        Integer hourInteger = null;
        try {
            hourInteger = new Integer(hourString);
        }
        catch (NumberFormatException e) {
            hourInteger = null;
        }
        if (hourInteger == null) {
            return false;
        }
        int hour = hourInteger;
        if (hour < 0 || hour > 23) {
            return false;
        }
        String minutesString = null;
        if (st.hasMoreTokens()) {
            minutesString = st.nextToken();
        }
        if (minutesString == null) {
            return false;
        }
        Integer minutesInteger = null;
        try {
            minutesInteger = new Integer(minutesString);
        }
        catch (NumberFormatException e) {
            minutesInteger = null;
        }
        if (minutesInteger == null) {
            return false;
        }
        int minutes = minutesInteger;
        if (minutes < 0 || minutes > 59) {
            return false;
        }
        String secondsString = null;
        if (st.hasMoreTokens()) {
            secondsString = st.nextToken();
        }
        if (secondsString == null) {
            return false;
        }
        Integer secondsInteger = null;
        try {
            secondsInteger = new Integer(secondsString);
        }
        catch (NumberFormatException e) {
            secondsInteger = null;
        }
        if (secondsInteger == null) {
            return false;
        }
        int seconds = secondsInteger;
        if (seconds < 0 || seconds > 59) {
            return false;
        }
        return !st.hasMoreTokens();
    }

    private void setUp() {
        this.day = new HashSet<String>();
        this.day.add("Mon");
        this.day.add("Tue");
        this.day.add("Wed");
        this.day.add("Thu");
        this.day.add("Fri");
        this.day.add("Sat");
        this.day.add("Sun");
        this.month = new HashSet<String>();
        this.month.add("Jan");
        this.month.add("Feb");
        this.month.add("Mar");
        this.month.add("Apr");
        this.month.add("May");
        this.month.add("Jun");
        this.month.add("Jul");
        this.month.add("Aug");
        this.month.add("Sep");
        this.month.add("Oct");
        this.month.add("Nov");
        this.month.add("Dec");
        this.zone = new HashSet<String>();
        this.zone.add("UT");
        this.zone.add("GMT");
        this.zone.add("EST");
        this.zone.add("EDT");
        this.zone.add("CST");
        this.zone.add("CDT");
        this.zone.add("MST");
        this.zone.add("MDT");
        this.zone.add("PST");
        this.zone.add("PDT");
    }

    private String getFieldName() {
        if (this.fieldName == null) {
            return new String("");
        }
        return this.fieldName;
    }

    public void addStatusListener(StatusListener listener) {
        this.myStatusListeners.add(listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.myStatusListeners.remove(listener);
    }

    protected void fireStatusChangedEvent(String text) {
        Iterator<StatusListener> listenersIter = this.myStatusListeners.iterator();
        while (listenersIter.hasNext()) {
            listenersIter.next().statusChanged(text);
        }
    }
}

