/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;

public class OUtils {
    private static Pattern badPunctPattern = Pattern.compile("[\\p{P}\\p{S}&&[^;\\?@&=\\+\\$,_\\.!~\\*\\(\\)\\-]]");
    private static Pattern spacesPattern = Pattern.compile("\\s+");

    private OUtils() {
    }

    public static String toResourceName(String text) {
        return OUtils.uriEncode(spacesPattern.matcher(badPunctPattern.matcher(text).replaceAll(" ")).replaceAll("_"));
    }

    public static String uriEncode(String uriRef) {
        try {
            byte[] utf8 = uriRef.getBytes("UTF-8");
            byte[] rsltAscii = new byte[utf8.length * 6];
            int in = 0;
            int out = 0;
            block8: while (in < utf8.length) {
                switch (utf8[in]) {
                    case 33: 
                    case 35: 
                    case 36: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 93: 
                    case 95: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 126: {
                        rsltAscii[out] = utf8[in];
                        ++out;
                        ++in;
                        continue block8;
                    }
                    case 37: {
                        try {
                            if (in + 2 >= utf8.length) break;
                            byte first = OUtils.hexEncode(OUtils.hexDecode(utf8[in + 1]));
                            byte second = OUtils.hexEncode(OUtils.hexDecode(utf8[in + 2]));
                            rsltAscii[out++] = 37;
                            rsltAscii[out++] = first;
                            rsltAscii[out++] = second;
                            in += 3;
                            continue block8;
                        }
                        catch (IllegalArgumentException first) {
                            // empty catch block
                        }
                    }
                }
                rsltAscii[out++] = 37;
                int c = utf8[in] & 0xFF;
                rsltAscii[out++] = OUtils.hexEncode(c / 16);
                rsltAscii[out++] = OUtils.hexEncode(c % 16);
                ++in;
            }
            return new String(rsltAscii, 0, out, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("The JVM is required to support UTF-8 and US-ASCII encodings.");
        }
    }

    public static String uriDecode(String uri) {
        try {
            byte[] ascii = uri.getBytes("US-ASCII");
            byte[] utf8 = new byte[ascii.length];
            int in = 0;
            int out = 0;
            while (in < ascii.length) {
                if (ascii[in] == 37) {
                    utf8[out++] = (byte)(OUtils.hexDecode(ascii[++in]) * 16 | OUtils.hexDecode(ascii[in + 1]));
                    in += 2;
                    continue;
                }
                utf8[out++] = ascii[in++];
            }
            return new String(utf8, 0, out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("The JVM is required to support UTF-8 and US-ASCII encodings.");
        }
        catch (ArrayIndexOutOfBoundsException ee) {
            throw new IllegalArgumentException("Incomplete Hex escape sequence in " + uri);
        }
    }

    private static final byte hexEncode(int i) {
        if (i < 10) {
            return (byte)(48 + i);
        }
        return (byte)(65 + i - 10);
    }

    private static final int hexDecode(byte b) {
        switch (b) {
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (b & 0xFF) - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return b - 65 + 10;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return b - 48;
            }
        }
        throw new IllegalArgumentException("Bad Hex escape character: " + (b & 0xFF));
    }
}

