/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.DataType;
import gate.creole.ontology.InvalidValueException;
import java.util.Locale;

public class Literal {
    private String value;
    private Locale language;
    private DataType dataType;

    public Literal(String value) {
        this.value = value;
        this.language = null;
        this.dataType = null;
    }

    @Deprecated
    public Literal(String value, Locale language) {
        this.value = value;
        this.language = language;
        this.dataType = null;
    }

    public Literal(String value, String languagetag) {
        this.value = value;
        this.language = new Locale(languagetag);
        this.dataType = null;
    }

    public Literal(String value, DataType dataType) throws InvalidValueException {
        this.value = value;
        this.language = null;
        this.dataType = dataType;
        if (!dataType.isValidValue(this.value)) {
            throw new InvalidValueException("The value :\"" + this.value + "\" is not compatible with the dataType \"" + dataType.getXmlSchemaURIString() + "\"");
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated
    public Locale getLanguage() {
        return this.language;
    }

    public String getLanguageTag() {
        if (this.language == null) {
            return null;
        }
        return this.language.getLanguage();
    }

    public String toString() {
        return this.value;
    }

    public String toTurtle() {
        String val = this.value;
        val = val.replace("\"", "\\\"");
        val = "\"" + val + "\"";
        if (this.dataType == null) {
            if (this.language != null) {
                val = val + "@" + this.language;
            }
        } else {
            val = val + "^^<" + this.dataType.getXmlSchemaURIString() + ">";
        }
        return val;
    }

    public int hashCode() {
        int hash = 17 + (this.value == null ? 0 : this.value.hashCode());
        hash = 37 * hash + (this.language == null ? 0 : this.language.hashCode());
        hash = 37 * hash + (this.dataType == null ? 0 : this.dataType.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Literal other = (Literal)obj;
        if (this.value == null && other.value == null) {
            return true;
        }
        return (this.dataType == null ? other.dataType == null : this.dataType.equals(other.dataType)) && (this.language == null ? other.language == null : this.language.equals(other.language)) && (this.value != null ? this.value.equals(other.value) : other.value == null);
    }
}

