/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.annotation.AnnotationSetImpl;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.lucene.LuceneReader;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LuceneDocument {
    /*
     * WARNING - void declaration
     */
    public List<gate.creole.annic.apache.lucene.document.Document> createDocuments(String corpusPersistenceID, Document gateDoc, String documentID, List<String> annotSetsToInclude, List<String> annotSetsToExclude, List<String> featuresToInclude, List<String> featuresToExclude, String indexLocation, String baseTokenAnnotationType, Boolean createTokensAutomatically, String indexUnitAnnotationType) {
        Set<Object> namedAnnotSets;
        if (baseTokenAnnotationType != null) {
            baseTokenAnnotationType = baseTokenAnnotationType.trim();
        }
        ArrayList<gate.creole.annic.apache.lucene.document.Document> toReturnBack = new ArrayList<gate.creole.annic.apache.lucene.document.Document>();
        List<Object> annotSetsToIndex = new ArrayList();
        if (annotSetsToInclude.size() > 0) {
            annotSetsToIndex = annotSetsToInclude;
        } else if (annotSetsToExclude.size() > 0) {
            namedAnnotSets = new HashSet();
            if (gateDoc.getNamedAnnotationSets() != null && gateDoc.getNamedAnnotationSets().keySet() != null) {
                namedAnnotSets = gateDoc.getNamedAnnotationSets().keySet();
            }
            for (String setName : namedAnnotSets) {
                if (annotSetsToExclude.contains(setName)) continue;
                annotSetsToIndex.add(setName);
            }
            if (!annotSetsToExclude.contains("<null>")) {
                annotSetsToIndex.add("<null>");
            }
        } else {
            namedAnnotSets = new HashSet();
            if (gateDoc.getNamedAnnotationSets() != null && gateDoc.getNamedAnnotationSets().keySet() != null) {
                namedAnnotSets = gateDoc.getNamedAnnotationSets().keySet();
            }
            for (String setName : namedAnnotSets) {
                annotSetsToIndex.add(setName);
            }
            annotSetsToIndex.add("<null>");
        }
        AnnotationSet baseTokenAnnotationSet = null;
        boolean searchBaseTokensInAllAnnotationSets = false;
        boolean searchIndexUnitInAllAnnotationSets = false;
        boolean createManualTokens = false;
        int index = -1;
        if (baseTokenAnnotationType != null && baseTokenAnnotationType.length() > 0) {
            index = baseTokenAnnotationType.lastIndexOf(46);
        }
        if (index >= 0) {
            String setName = baseTokenAnnotationType.substring(0, index);
            baseTokenAnnotationType = baseTokenAnnotationType.substring(index + 1, baseTokenAnnotationType.length());
            baseTokenAnnotationSet = setName.equals("<null>") ? gateDoc.getAnnotations().get(baseTokenAnnotationType) : gateDoc.getAnnotations(setName).get(baseTokenAnnotationType);
            if (baseTokenAnnotationSet == null || baseTokenAnnotationSet.size() == 0) {
                System.err.println("Base Tokens " + baseTokenAnnotationType + " counldn't be found under the specified annotation set " + (String)setName + "\n searching them in other annotation sets");
                searchBaseTokensInAllAnnotationSets = true;
            }
        } else {
            searchBaseTokensInAllAnnotationSets = true;
        }
        if (baseTokenAnnotationType != null && baseTokenAnnotationType.length() > 0 && searchBaseTokensInAllAnnotationSets) {
            createManualTokens = true;
            for (String string : annotSetsToIndex) {
                if (string.equals("<null>")) {
                    AnnotationSet annotationSet = gateDoc.getAnnotations().get(baseTokenAnnotationType);
                    if (annotationSet.size() <= 0) continue;
                    baseTokenAnnotationSet = annotationSet;
                    createManualTokens = false;
                    break;
                }
                AnnotationSet annotationSet = gateDoc.getAnnotations(string).get(baseTokenAnnotationType);
                if (annotationSet.size() <= 0) continue;
                baseTokenAnnotationSet = annotationSet;
                createManualTokens = false;
                break;
            }
        }
        if (baseTokenAnnotationType == null || baseTokenAnnotationType.length() == 0) {
            createManualTokens = true;
        }
        if (createManualTokens) {
            if (!createTokensAutomatically.booleanValue()) {
                System.out.println("Tokens couldn't be found in the document - Ignoring the document " + gateDoc.getName());
                return null;
            }
            baseTokenAnnotationType = "Token";
            if (baseTokenAnnotationSet == null) {
                baseTokenAnnotationSet = new AnnotationSetImpl(gateDoc);
            }
            if (!this.createTokens(gateDoc, baseTokenAnnotationSet)) {
                System.out.println("Tokens couldn't be created manually - Ignoring the document " + gateDoc.getName());
                return null;
            }
        }
        AnnotationSet indexUnitAnnotationSet = null;
        index = -1;
        if (indexUnitAnnotationType != null && indexUnitAnnotationType.trim().length() > 0) {
            index = indexUnitAnnotationType.lastIndexOf(46);
        }
        if (index >= 0) {
            String string = indexUnitAnnotationType.substring(0, index);
            indexUnitAnnotationType = indexUnitAnnotationType.substring(index + 1, indexUnitAnnotationType.length());
            indexUnitAnnotationSet = string.equals("<null>") ? gateDoc.getAnnotations().get(indexUnitAnnotationType) : gateDoc.getAnnotations(string).get(indexUnitAnnotationType);
            if (indexUnitAnnotationSet == null || indexUnitAnnotationSet.size() == 0) {
                System.err.println("Index Unit " + indexUnitAnnotationType + " counldn't be found under the specified annotation set " + string + "\n searching them in other annotation sets");
                searchIndexUnitInAllAnnotationSets = true;
            }
        } else {
            searchIndexUnitInAllAnnotationSets = true;
        }
        if (indexUnitAnnotationType != null && indexUnitAnnotationType.length() > 0 && searchIndexUnitInAllAnnotationSets) {
            for (String string : annotSetsToIndex) {
                if (string.equals("<null>")) {
                    AnnotationSet annotationSet = gateDoc.getAnnotations().get(indexUnitAnnotationType);
                    if (annotationSet.size() <= 0) continue;
                    indexUnitAnnotationSet = annotationSet;
                    break;
                }
                AnnotationSet annotationSet = gateDoc.getAnnotations(string).get(indexUnitAnnotationType);
                if (annotationSet.size() <= 0) continue;
                indexUnitAnnotationSet = annotationSet;
                break;
            }
        }
        if (indexUnitAnnotationSet == null) {
            indexUnitAnnotationType = null;
        }
        boolean bl = false;
        for (String string : annotSetsToIndex) {
            HashSet<String> indexedFeatures;
            AnnotationSet aSetToIndex = string.equals("<null>") ? gateDoc.getAnnotations() : gateDoc.getAnnotations(string);
            List<Token>[] tokenStreams = this.getTokens(gateDoc, aSetToIndex, featuresToInclude, featuresToExclude, baseTokenAnnotationType, baseTokenAnnotationSet, indexUnitAnnotationType, indexUnitAnnotationSet, indexedFeatures = new HashSet<String>());
            if (tokenStreams == null) {
                return null;
            }
            StringBuffer indexedFeaturesString = new StringBuffer();
            for (String aFeat : indexedFeatures) {
                indexedFeaturesString.append(aFeat + ";");
            }
            gate.creole.annic.apache.lucene.document.Document[] toReturn = new gate.creole.annic.apache.lucene.document.Document[tokenStreams.length];
            int i = 0;
            while (i < tokenStreams.length) {
                void var20_28;
                gate.creole.annic.apache.lucene.document.Document doc = new gate.creole.annic.apache.lucene.document.Document();
                LuceneReader reader = new LuceneReader(gateDoc, tokenStreams[i]);
                doc.add(Field.Keyword("DOCUMENT_ID", documentID));
                doc.add(Field.Keyword("DOCUMENT_ID_FOR_SERIALIZED_FILE", documentID + "-" + (int)var20_28));
                doc.add(Field.Keyword("INDEXED_FEATURES", indexedFeaturesString.substring(0, indexedFeaturesString.length() - 1)));
                if (corpusPersistenceID != null) {
                    doc.add(Field.Keyword("CORPUS_ID", corpusPersistenceID));
                }
                doc.add(Field.Keyword("ANNOTATION_SET_ID", string));
                doc.add(Field.Text("contents", reader));
                try {
                    this.writeOnDisk(tokenStreams[i], documentID, documentID + "-" + (int)var20_28, indexLocation);
                }
                catch (Exception e) {
                    Err.println("\nIgnoring the document : " + gateDoc.getName() + " since its token stream cannot be written on the disk");
                    Err.println("Reason: " + e.getMessage());
                    return null;
                }
                toReturn[i] = doc;
                ++i;
                ++var20_28;
            }
            toReturnBack.addAll(Arrays.asList(toReturn));
        }
        return toReturnBack;
    }

    private boolean createTokens(Document gateDocument, AnnotationSet set) {
        String gateContent = gateDocument.getContent().toString();
        int start = -1;
        for (int i = 0; i < gateContent.length(); ++i) {
            char c = gateContent.charAt(i);
            if (Character.isWhitespace(c)) {
                if (start == -1) continue;
                FeatureMap features = Factory.newFeatureMap();
                String string = gateContent.substring(start, i);
                if (string.trim().length() > 0) {
                    features.put("string", string);
                    try {
                        set.add(Long.valueOf(start), Long.valueOf(i), "Token", features);
                    }
                    catch (InvalidOffsetException ioe) {
                        ioe.printStackTrace();
                        return false;
                    }
                }
                start = i + 1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start == -1) {
            return false;
        }
        if (start < gateContent.length()) {
            FeatureMap features = Factory.newFeatureMap();
            String string = gateContent.substring(start, gateContent.length());
            if (string.trim().length() > 0) {
                features.put("string", string);
                try {
                    set.add(Long.valueOf(start), Long.valueOf(gateContent.length()), "Token", features);
                }
                catch (InvalidOffsetException ioe) {
                    ioe.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private String getCompatibleName(String name) {
        return name.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    private void writeOnDisk(List<Token> tokenStream, String folderName, String fileName, String location) throws Exception {
        File locationFile;
        File folder;
        fileName = this.getCompatibleName(fileName);
        folderName = this.getCompatibleName(folderName);
        if (location.startsWith("file:/")) {
            location = location.substring(6, location.length());
        }
        if (location.charAt(1) != ':') {
            location = "/" + location;
        }
        if (!(folder = new File(locationFile = new File(location), "serialized-files")).exists() && !folder.mkdirs()) {
            throw new IOException("Directory could not be created :" + folder.getAbsolutePath());
        }
        if (!(folder = new File(folder, folderName)).exists() && !folder.mkdirs()) {
            throw new IOException("Directory could not be created :" + folder.getAbsolutePath());
        }
        File outputFile = new File(folder, fileName + ".annic");
        try (FileOutputStream file = new FileOutputStream(outputFile);
             BufferedOutputStream buffer = new BufferedOutputStream(file);
             ObjectOutputStream output = new ObjectOutputStream(buffer);){
            output.writeObject(tokenStream);
            output.flush();
        }
    }

    private List<Token>[] getTokens(Document document, AnnotationSet inputAs, List<String> featuresToInclude, List<String> featuresToExclude, String baseTokenAnnotationType, AnnotationSet baseTokenSet, String indexUnitAnnotationType, AnnotationSet indexUnitSet, Set<String> indexedFeatures) {
        boolean excludeFeatures = false;
        boolean includeFeatures = false;
        if (!featuresToInclude.isEmpty()) {
            includeFeatures = true;
        } else if (!featuresToExclude.isEmpty()) {
            excludeFeatures = true;
        }
        HashSet<OffsetGroup> unitOffsetsSet = new HashSet<OffsetGroup>();
        if (indexUnitAnnotationType == null || indexUnitAnnotationType.trim().length() == 0 || indexUnitSet == null || indexUnitSet.size() == 0) {
            OffsetGroup group = new OffsetGroup();
            group.startOffset = 0L;
            group.endOffset = document.getContent().size();
            unitOffsetsSet.add(group);
        } else {
            for (Object annotation : indexUnitSet) {
                OffsetGroup offsetGroup = new OffsetGroup();
                offsetGroup.startOffset = annotation.getStartNode().getOffset();
                offsetGroup.endOffset = annotation.getEndNode().getOffset();
                unitOffsetsSet.add(offsetGroup);
            }
        }
        HashSet<String> allTypes = new HashSet<String>();
        for (String string : inputAs.getAllTypes()) {
            if (string.indexOf(".") > -1 || string.indexOf("=") > -1 || string.indexOf(";") > -1 || string.indexOf(",") > -1) {
                System.err.println("Annotations of type " + string + " cannot be indexed as the type name contains one of the ., =, or ; character");
                continue;
            }
            allTypes.add(string);
        }
        if (baseTokenSet != null && baseTokenSet.size() > 0) {
            allTypes.remove(baseTokenAnnotationType);
        }
        if (indexUnitSet != null && indexUnitSet.size() > 0) {
            allTypes.remove(indexUnitAnnotationType);
        }
        AnnotationSetImpl toUseSet = new AnnotationSetImpl(document);
        for (String string : allTypes) {
            for (Annotation a : inputAs.get(string)) {
                try {
                    toUseSet.add(a.getStartNode().getOffset(), a.getEndNode().getOffset(), a.getType(), a.getFeatures());
                }
                catch (InvalidOffsetException ioe) {
                    throw new GateRuntimeException(ioe);
                }
            }
        }
        List[] listArray = new List[unitOffsetsSet.size()];
        Iterator iterator = unitOffsetsSet.iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            OffsetGroup group = (OffsetGroup)iterator.next();
            ArrayList<Token> newTokens = new ArrayList<Token>();
            ArrayList<Annotation> tokens = new ArrayList<Annotation>(toUseSet.getContained(group.startOffset, group.endOffset));
            if (baseTokenSet != null && baseTokenSet.size() != 0) {
                tokens.addAll(baseTokenSet.getContained(group.startOffset, group.endOffset));
            }
            if (tokens.isEmpty()) {
                return null;
            }
            Collections.sort(tokens, new OffsetComparator());
            int position = -1;
            for (int i = 0; i < tokens.size(); ++i) {
                int inc = 1;
                Annotation annot = (Annotation)tokens.get(i);
                String type = annot.getType();
                if (excludeFeatures && featuresToExclude.contains(type) || includeFeatures && !featuresToInclude.contains(type)) continue;
                int startOffset = annot.getStartNode().getOffset().intValue();
                int endOffset = annot.getEndNode().getOffset().intValue();
                String text = document.getContent().toString().substring(startOffset, endOffset);
                Token token1 = new Token(type, startOffset, endOffset, "*");
                if (i > 0 && annot.getStartNode().getOffset().longValue() == ((Annotation)tokens.get(i - 1)).getStartNode().getOffset().longValue()) {
                    token1.setPositionIncrement(0);
                    inc = 0;
                }
                token1.setPosition(position += inc);
                newTokens.add(token1);
                if (!type.equals(baseTokenAnnotationType) || annot.getFeatures().get("string") == null) {
                    Token tk1 = new Token(text, startOffset, endOffset, type + ".string");
                    indexedFeatures.add(type + ".string");
                    tk1.setPositionIncrement(0);
                    tk1.setPosition(position);
                    newTokens.add(tk1);
                }
                FeatureMap features = annot.getFeatures();
                Iterator fIter = features.keySet().iterator();
                while (fIter.hasNext()) {
                    Object tempText;
                    String type1 = fIter.next().toString();
                    if (excludeFeatures && featuresToExclude.contains(type + "." + type1) || includeFeatures && !featuresToInclude.contains(type + "." + type1) || (tempText = features.get(type1)) == null) continue;
                    String text1 = tempText.toString();
                    Token tempToken = new Token(text1, startOffset, endOffset, type + "." + type1);
                    indexedFeatures.add(type + "." + type1);
                    tempToken.setPositionIncrement(0);
                    tempToken.setPosition(position);
                    newTokens.add(tempToken);
                    Token onlyATFeature = new Token(type + "." + type1, startOffset, endOffset, "**");
                    onlyATFeature.setPosition(position);
                    onlyATFeature.setPositionIncrement(0);
                    newTokens.add(onlyATFeature);
                }
            }
            listArray[counter] = newTokens;
            ++counter;
        }
        return listArray;
    }

    private static class OffsetGroup {
        Long startOffset;
        Long endOffset;

        private OffsetGroup() {
        }
    }
}

