/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.SegmentInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.Vector;

final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public int counter = 0;
    private long version = 0L;

    SegmentInfos() {
    }

    public final SegmentInfo info(int i) {
        return (SegmentInfo)this.elementAt(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory) throws IOException {
        try (InputStream input = directory.openFile("segments");){
            int format = input.readInt();
            if (format < 0) {
                if (format < -1) {
                    throw new IOException("Unknown format version: " + format);
                }
                this.version = input.readLong();
                this.counter = input.readInt();
            } else {
                this.counter = format;
            }
            for (int i = input.readInt(); i > 0; --i) {
                SegmentInfo si = new SegmentInfo(input.readString(), input.readInt(), directory);
                this.addElement(si);
            }
            if (format >= 0) {
                this.version = input.getFilePointer() >= input.length() ? 0L : input.readLong();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory directory) throws IOException {
        try (OutputStream output = directory.createFile("segments.new");){
            output.writeInt(-1);
            output.writeLong(++this.version);
            output.writeInt(this.counter);
            output.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                SegmentInfo si = this.info(i);
                output.writeString(si.name);
                output.writeInt(si.docCount);
            }
        }
        directory.renameFile("segments.new", "segments");
    }

    public long getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readCurrentVersion(Directory directory) throws IOException {
        InputStream input = directory.openFile("segments");
        int format = 0;
        long version = 0L;
        try {
            format = input.readInt();
            if (format < 0) {
                if (format < -1) {
                    throw new IOException("Unknown format version: " + format);
                }
                version = input.readLong();
            }
        }
        finally {
            input.close();
        }
        if (format < 0) {
            return version;
        }
        SegmentInfos sis = new SegmentInfos();
        sis.read(directory);
        return sis.getVersion();
    }
}

