/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

final class FieldsReader {
    private FieldInfos fieldInfos;
    private InputStream fieldsStream;
    private InputStream indexStream;
    private int size;

    FieldsReader(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.openFile(segment + ".fdt");
        this.indexStream = d.openFile(segment + ".fdx");
        this.size = (int)(this.indexStream.length() / 8L);
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n) throws IOException {
        this.indexStream.seek((long)n * 8L);
        long position = this.indexStream.readLong();
        this.fieldsStream.seek(position);
        Document doc = new Document();
        int numFields = this.fieldsStream.readVInt();
        for (int i = 0; i < numFields; ++i) {
            int fieldNumber = this.fieldsStream.readVInt();
            FieldInfo fi = this.fieldInfos.fieldInfo(fieldNumber);
            byte bits = this.fieldsStream.readByte();
            doc.add(new Field(fi.name, this.fieldsStream.readString(), true, fi.isIndexed, (bits & 1) != 0, fi.storeTermVector));
        }
        return doc;
    }
}

