/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Parser {
    public static final String HITS = "HITS";
    public static final String HIT = "HIT";
    public static final String DOC_ID = "DOC_ID";
    public static final String ANNOTATION_SET_NAME = "ANNOTATION_SET_NAME";
    public static final String START_OFFSET = "START_OFFSET";
    public static final String END_OFFSET = "END_OFFSET";
    public static final String QUERY = "QUERY";
    public static final String LEFT_CONTEXT_START_OFFSET = "LEFT_CONTEXT_START_OFFSET";
    public static final String RIGHT_CONTEXT_END_OFFSET = "RIGHT_CONTEXT_END_OFFSET";
    public static final String PATTERN_TEXT = "PATTERN_TEXT";
    public static final String PATTERN_ANNOTATIONS = "PATTERN_ANNOTATIONS";
    public static final String PATTERN_ANNOTATION = "PATTERN_ANNOTATION";
    public static final String START = "START";
    public static final String END = "END";
    public static final String TEXT = "TEXT";
    public static final String TYPE = "TYPE";
    public static final String POSITION = "POSITION";
    public static final String FEATURES = "FEATURES";
    public static final String FEATURE = "FEATURE";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";

    public static String toXML(Hit[] hits) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append(Parser.wrap(HITS, true));
        for (int i = 0; i < hits.length; ++i) {
            sb.append(Parser.wrap(HIT, true));
            sb.append(Parser.wrap(DOC_ID, hits[i].documentID));
            sb.append(Parser.wrap(ANNOTATION_SET_NAME, hits[i].annotationSetName));
            sb.append(Parser.wrap(START_OFFSET, hits[i].startOffset));
            sb.append(Parser.wrap(END_OFFSET, hits[i].endOffset));
            sb.append(Parser.wrap(QUERY, hits[i].queryString));
            if (hits[i] instanceof Pattern) {
                Pattern pat = (Pattern)hits[i];
                sb.append(Parser.wrap(LEFT_CONTEXT_START_OFFSET, pat.getLeftContextStartOffset()));
                sb.append(Parser.wrap(RIGHT_CONTEXT_END_OFFSET, pat.getRightContextEndOffset()));
                sb.append(Parser.wrap(PATTERN_TEXT, pat.getPatternText()));
                PatternAnnotation[] annots = pat.getPatternAnnotations();
                sb.append(Parser.wrap(PATTERN_ANNOTATIONS, true));
                for (int j = 0; j < annots.length; ++j) {
                    sb.append(Parser.wrap(PATTERN_ANNOTATION, true));
                    sb.append(Parser.wrap(START, annots[j].getStartOffset()));
                    sb.append(Parser.wrap(END, annots[j].getEndOffset()));
                    sb.append(Parser.wrap(TEXT, annots[j].getText()));
                    sb.append(Parser.wrap(TYPE, annots[j].getType()));
                    sb.append(Parser.wrap(POSITION, annots[j].getPosition()));
                    Map<String, String> features = annots[j].getFeatures();
                    sb.append(Parser.wrap(FEATURES, true));
                    for (Map.Entry<String, String> entry : features.entrySet()) {
                        sb.append(Parser.wrap(FEATURE, true));
                        String key = entry.getKey();
                        sb.append(Parser.wrap(KEY, key));
                        String value = entry.getValue();
                        sb.append(Parser.wrap(VALUE, value));
                        sb.append(Parser.wrap(FEATURE, false));
                    }
                    sb.append(Parser.wrap(FEATURES, false));
                    sb.append(Parser.wrap(PATTERN_ANNOTATION, false));
                }
                sb.append(Parser.wrap(PATTERN_ANNOTATIONS, false));
            }
            sb.append(Parser.wrap(HIT, false));
        }
        sb.append(Parser.wrap(HITS, false));
        return sb.toString();
    }

    public static String replaceAmpChars(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("'", "&apos;");
        return s;
    }

    public static Hit[] fromXML(String xml) throws IOException, JDOMException {
        SAXBuilder saxBuilder = new SAXBuilder(false);
        Document jdomDoc = saxBuilder.build((Reader)new StringReader(xml));
        Element rootElement = jdomDoc.getRootElement();
        if (!rootElement.getName().equalsIgnoreCase(HITS)) {
            throw new IOException("Root element must be HITS");
        }
        List hitsChildren = rootElement.getChildren(HIT);
        Hit[] hits = new Hit[hitsChildren.size()];
        for (int i = 0; i < hitsChildren.size(); ++i) {
            Element hitElem = (Element)hitsChildren.get(i);
            int startOffset = Integer.parseInt(hitElem.getChildText(START_OFFSET));
            int endOffset = Integer.parseInt(hitElem.getChildText(END_OFFSET));
            String docID = hitElem.getChildText(DOC_ID);
            String annotationSetName = hitElem.getChildText(ANNOTATION_SET_NAME);
            String queryString = hitElem.getChildText(QUERY);
            Element patternAnnotations = hitElem.getChild(PATTERN_ANNOTATIONS);
            if (patternAnnotations == null) {
                hits[i] = new Hit(docID, annotationSetName, startOffset, endOffset, queryString);
                continue;
            }
            List patAnnots = patternAnnotations.getChildren(PATTERN_ANNOTATION);
            ArrayList<PatternAnnotation> patAnnotsList = new ArrayList<PatternAnnotation>();
            for (int j = 0; j < patAnnots.size(); ++j) {
                Element patAnnot = (Element)patAnnots.get(j);
                PatternAnnotation pa = new PatternAnnotation();
                pa.setStOffset(Integer.parseInt(patAnnot.getChildText(START)));
                pa.setEnOffset(Integer.parseInt(patAnnot.getChildText(END)));
                pa.setPosition(Integer.parseInt(patAnnot.getChildText(POSITION)));
                pa.setText(patAnnot.getChildText(TEXT));
                pa.setType(patAnnot.getChildText(TYPE));
                Element featuresElem = patAnnot.getChild(FEATURES);
                List featuresElemsList = featuresElem.getChildren(FEATURE);
                for (int k = 0; k < featuresElemsList.size(); ++k) {
                    Element featureElem = (Element)featuresElemsList.get(k);
                    String key = featureElem.getChildText(KEY);
                    String value = featureElem.getChildText(VALUE);
                    pa.addFeature(key, value);
                }
                patAnnotsList.add(pa);
            }
            String patternText = hitElem.getChildText(PATTERN_TEXT);
            int leftCSO = Integer.parseInt(hitElem.getChildText(LEFT_CONTEXT_START_OFFSET));
            int rightCEO = Integer.parseInt(hitElem.getChildText(RIGHT_CONTEXT_END_OFFSET));
            hits[i] = new Pattern(docID, annotationSetName, patternText, startOffset, endOffset, leftCSO, rightCEO, patAnnotsList, queryString);
        }
        return hits;
    }

    public static String wrap(String elementText, String elementValue) {
        if (elementValue == null) {
            return "<" + elementText + "> </" + elementText + ">\n";
        }
        return "<" + elementText + ">" + Parser.replaceAmpChars(elementValue) + "</" + elementText + ">\n";
    }

    public static String wrap(String elementText, int elementValue) {
        return Parser.wrap(elementText, "" + elementValue);
    }

    public static String wrap(String elementText, boolean startElement) {
        return "<" + (startElement ? "" : "/") + elementText + ">\n";
    }
}

