/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic;

import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class HTMLGenerator {
    private static int noOfColumnsToDraw = 0;

    public static String generateHTMLTable(Pattern pattern) {
        int j;
        PatternAnnotation[] patternAnnotations = pattern.getPatternAnnotations();
        StringBuilder html = new StringBuilder("<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\" width=\"100%\" style=\"border-collapse: collapse; border: medium none; background: #E6E6E6\">");
        List<String> rows = HTMLGenerator.getRowData(patternAnnotations);
        Collections.sort(rows);
        List<String> colPositions = HTMLGenerator.getColsPositions(patternAnnotations);
        Collections.sort(colPositions, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                int aVal = Integer.parseInt(a);
                int bVal = Integer.parseInt(b);
                return aVal - bVal;
            }
        });
        patternAnnotations = HTMLGenerator.sort(patternAnnotations);
        html.append("\n").append("<tr> ").append("<td style=\"width: 85.25pt; border-left: medium none; border-right: 1.0pt dashed blue; ").append("border-top: 1.0pt dashed blue; border-bottom: 1.0pt dashed blue; padding-left: 5.4pt; ").append("padding-right: 5.4pt; padding-top: 0cm; padding-bottom: 0cm\">").append("<p class=\"MsoNormal\" align=\"center\">Pattern Text : </td>");
        int endPos = patternAnnotations[0].getStartOffset();
        int startPos = 0;
        for (j = 1; j < colPositions.size(); ++j) {
            startPos = endPos;
            endPos = Integer.parseInt(colPositions.get(j));
            String text = pattern.getPatternText(startPos, endPos);
            html.append("\n").append("<td style=\"border: 1.0pt dashed blue;\" align=\"center\">").append(text).append("</td>");
        }
        for (j = 0; j < rows.size(); ++j) {
            int k;
            html.append("\n").append("<tr width=\"100%\" height=\"19\"> <td>").append(rows.get(j)).append("</td>");
            List<PatternAnnotation> rowAnnotations = HTMLGenerator.findOutAnnotationsOfType(patternAnnotations, rows.get(j));
            int columnsDrawn = 0;
            for (k = 0; k < rowAnnotations.size(); ++k) {
                int colSpan;
                int m;
                PatternAnnotation annot = rowAnnotations.get(k);
                html.append("\n").append(HTMLGenerator.columnsToDraw(patternAnnotations, rowAnnotations, k, colPositions));
                columnsDrawn += noOfColumnsToDraw;
                ArrayList<PatternAnnotation> tempList = new ArrayList<PatternAnnotation>();
                tempList.add(annot);
                int maxEndOffset = annot.getEndOffset();
                for (m = k + 1; m < rowAnnotations.size(); ++m) {
                    PatternAnnotation annot1 = rowAnnotations.get(m);
                    if (annot.getStartOffset() == annot1.getStartOffset()) {
                        tempList.add(annot1);
                        if (annot1.getEndOffset() <= maxEndOffset) continue;
                        maxEndOffset = annot1.getEndOffset();
                        continue;
                    }
                    --m;
                    break;
                }
                if (k != m) {
                    k = m;
                }
                if ((colSpan = HTMLGenerator.getColSpan(annot.getStartOffset(), maxEndOffset, colPositions)) > 0) {
                    html.append("\n").append("<td style=\"border: 1.0pt dashed blue;\" align=\"center\" colspan=\"").append(colSpan + "\" <p align=\"center\">");
                    columnsDrawn += colSpan;
                } else {
                    html.append("\n").append("<td style=\"border: 1.0pt dashed blue;\" align=\"center\"> <p align=\"center\">");
                    ++columnsDrawn;
                }
                for (m = 0; m < tempList.size(); ++m) {
                    html.append(HTMLGenerator.addFeatures(((PatternAnnotation)tempList.get(m)).getFeatures())).append("<br>");
                }
                html.append("</td>");
            }
            for (k = 0; k < colPositions.size() - columnsDrawn; ++k) {
                html.append("\n").append("<td style=\"border: 1.0pt dashed blue;\">&nbsp;</td>");
            }
            html.append("\n").append("</tr>");
        }
        html.append("\n").append("</table>");
        return html.toString();
    }

    private static PatternAnnotation[] sort(PatternAnnotation[] annots) {
        block0: for (int i = 0; i < annots.length; ++i) {
            for (int j = 0; j < annots.length - 1; ++j) {
                PatternAnnotation temp;
                if (annots[j].getStartOffset() > annots[j + 1].getStartOffset()) {
                    temp = annots[j + 1];
                    annots[j + 1] = annots[j];
                    annots[j] = temp;
                    continue block0;
                }
                if (annots[j].getEndOffset() <= annots[j + 1].getEndOffset()) continue;
                temp = annots[j + 1];
                annots[j + 1] = annots[j];
                annots[j] = temp;
                continue block0;
            }
        }
        return annots;
    }

    private static String columnsToDraw(PatternAnnotation[] currentTableAnnotations, List<PatternAnnotation> rowAnnotations, int currentPos, List<String> colPositions) {
        int startPoint = 0;
        startPoint = currentPos == 0 ? currentTableAnnotations[0].getStartOffset() : rowAnnotations.get(currentPos - 1).getEndOffset();
        noOfColumnsToDraw = HTMLGenerator.noOfColumnsToDraw(startPoint, rowAnnotations.get(currentPos).getStartOffset(), colPositions);
        StringBuilder html = new StringBuilder();
        for (int i = 0; i < noOfColumnsToDraw; ++i) {
            html.append("\n").append("<td style=\"border: 1.0pt dashed blue;\">&nbsp;</td>");
        }
        return html.toString();
    }

    private static int noOfColumnsToDraw(int start, int end, List<String> colPositions) {
        int i;
        if (start == end) {
            return 0;
        }
        int counter = 0;
        for (i = 0; i < colPositions.size(); ++i) {
            if (Integer.parseInt(colPositions.get(i)) != start) continue;
            ++i;
            break;
        }
        if (i == colPositions.size() || i < 0) {
            i = 0;
        }
        while (i < colPositions.size()) {
            if (end == Integer.parseInt(colPositions.get(i))) {
                ++counter;
                break;
            }
            ++counter;
            ++i;
        }
        return counter;
    }

    private static List<PatternAnnotation> findOutAnnotationsOfType(PatternAnnotation[] annotations, String type) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].getType().equals(type)) continue;
            annots.add(annotations[i]);
        }
        return annots;
    }

    private static int getColSpan(int startOffset, int endOffset, List<String> colPositions) {
        int i;
        int counter = 0;
        for (i = 0; i < colPositions.size(); ++i) {
            if (Integer.parseInt(colPositions.get(i)) != startOffset) continue;
            ++i;
            break;
        }
        if (i == colPositions.size() || i < 0) {
            i = 0;
        }
        while (i < colPositions.size()) {
            if (endOffset == Integer.parseInt(colPositions.get(i))) {
                ++counter;
                break;
            }
            ++counter;
            ++i;
        }
        return counter;
    }

    private static List<String> getColsPositions(PatternAnnotation[] annotations) {
        ArrayList<String> offsets = new ArrayList<String>();
        for (int i = 0; i < annotations.length; ++i) {
            int endOffset = annotations[i].getEndOffset();
            int startOffset = annotations[i].getStartOffset();
            if (!offsets.contains("" + endOffset)) {
                offsets.add("" + endOffset);
            }
            if (offsets.contains("" + startOffset)) continue;
            offsets.add("" + startOffset);
        }
        return offsets;
    }

    private static List<String> getRowData(PatternAnnotation[] annotations) {
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < annotations.length; ++i) {
            String type = annotations[i].getType();
            if (types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    private static String addFeatures(Map<String, String> features) {
        StringBuilder html = new StringBuilder("<select size=\"1\" >");
        for (Map.Entry<String, String> feature : features.entrySet()) {
            html.append("\n").append("<option>").append(feature.getKey()).append(" = \"").append(feature.getValue()).append("\"</option>");
        }
        html.append("\n").append("</select>");
        return html.toString();
    }
}

