/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Document;
import gate.FeatureMap;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.creole.RunningStrategy;
import gate.util.GateRuntimeException;

public class AnalyserRunningStrategy
implements RunningStrategy {
    protected LanguageAnalyser pr;
    protected int runMode = 1;
    protected String featureName;
    protected String featureValue;

    public AnalyserRunningStrategy(LanguageAnalyser pr, int runMode, String featureName, String featureValue) {
        this.pr = pr;
        this.runMode = runMode;
        this.featureName = featureName;
        this.featureValue = featureValue;
    }

    @Override
    public boolean shouldRun() {
        if (this.runMode == 1) {
            return true;
        }
        if (this.runMode == 2) {
            return false;
        }
        if (this.runMode == 4) {
            if (this.featureName == null || this.featureName.length() == 0) {
                return true;
            }
            Document doc = this.pr.getDocument();
            if (doc != null) {
                FeatureMap fm = doc.getFeatures();
                if (fm != null) {
                    Object actualValue = fm.get(this.featureName);
                    return actualValue == null && this.featureValue == null || actualValue != null && actualValue.equals(this.featureValue);
                }
                return this.featureName == null;
            }
            return false;
        }
        throw new GateRuntimeException("Unknown run mode!");
    }

    @Override
    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int mode) {
        this.runMode = mode;
    }

    public void setFeatureName(String name) {
        this.featureName = name;
    }

    public void setFeatureValue(String value) {
        this.featureValue = value;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public ProcessingResource getPR() {
        return this.pr;
    }

    public void setProcessingResource(ProcessingResource pr) {
        if (!(pr instanceof LanguageAnalyser)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used for " + LanguageAnalyser.class.getName() + "!\n" + pr.getClass().getName() + " is not a " + LanguageAnalyser.class.getName() + "!");
        }
        this.pr = (LanguageAnalyser)pr;
    }
}

