/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractResource;
import gate.creole.ExecutionException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import java.util.Vector;

public abstract class AbstractProcessingResource
extends AbstractResource
implements ProcessingResource,
ANNIEConstants {
    private static final long serialVersionUID = -5919543745701986862L;
    private transient Vector<StatusListener> statusListeners;
    private transient Vector<ProgressListener> progressListeners;
    protected volatile boolean interrupted = false;

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    @Override
    public void execute() throws ExecutionException {
        throw new ExecutionException("Resource " + this.getClass() + " hasn't overriden the execute() method");
    }

    @Override
    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    public synchronized void removeStatusListener(StatusListener l) {
        if (this.statusListeners != null && this.statusListeners.contains(l)) {
            Vector v = (Vector)this.statusListeners.clone();
            v.removeElement(l);
            this.statusListeners = v;
        }
    }

    public synchronized void addStatusListener(StatusListener l) {
        Vector v;
        Vector vector = v = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.statusListeners = v;
        }
    }

    protected void fireStatusChanged(String e) {
        if (this.statusListeners != null) {
            Vector<StatusListener> listeners = this.statusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).statusChanged(e);
            }
        }
    }

    public synchronized void addProgressListener(ProgressListener l) {
        Vector v;
        Vector vector = v = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.progressListeners = v;
        }
    }

    public synchronized void removeProgressListener(ProgressListener l) {
        if (this.progressListeners != null && this.progressListeners.contains(l)) {
            Vector v = (Vector)this.progressListeners.clone();
            v.removeElement(l);
            this.progressListeners = v;
        }
    }

    protected void fireProgressChanged(int e) {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).progressChanged(e);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector<ProgressListener> listeners = this.progressListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).processFinished();
            }
        }
    }

    public static FeatureMap getRuntimeParameterValues(Resource res) throws ResourceInstantiationException {
        ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(res.getClass().getName());
        if (rData == null) {
            throw new ResourceInstantiationException("Could not find CREOLE data for " + res.getClass().getName());
        }
        ParameterList params = rData.getParameterList();
        return AbstractResource.getParameterValues(res, params.getRuntimeParameters());
    }

    public FeatureMap getRuntimeParameterValues() throws ResourceInstantiationException {
        return AbstractProcessingResource.getRuntimeParameterValues(this);
    }

    protected class InternalStatusListener
    implements StatusListener {
        @Override
        public void statusChanged(String message) {
            AbstractProcessingResource.this.fireStatusChanged(message);
        }
    }

    protected class IntervalProgressListener
    implements ProgressListener {
        int start;
        int end;

        public IntervalProgressListener(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void progressChanged(int i) {
            AbstractProcessingResource.this.fireProgressChanged(this.start + (this.end - this.start) * i / 100);
        }

        @Override
        public void processFinished() {
            AbstractProcessingResource.this.fireProgressChanged(this.end);
        }
    }
}

