/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.corpora.DocumentContentImpl;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.XmlDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.util.DocumentFormatException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@CreoleResource(name="UIMA Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class UimaDocumentFormat
extends XmlDocumentFormat {
    private static final long serialVersionUID = -3804187336078120808L;

    @Override
    public void unpackMarkup(Document doc, RepositioningInfo repInfo, RepositioningInfo ampCodingInfo) throws DocumentFormatException {
        super.unpackMarkup(doc, repInfo, ampCodingInfo);
        this.unpackCasMarkup(doc);
    }

    private void unpackCasMarkup(Document doc) throws DocumentFormatException {
        FeatureMap features;
        String idName;
        String casPrefix;
        AnnotationSet inputAS = doc.getAnnotations("Original markups");
        AnnotationSet outputAS = doc.getAnnotations("Original markups");
        if (!inputAS.get("CAS").isEmpty()) {
            casPrefix = "uima.cas.";
            idName = "_id";
        } else if (!inputAS.get("xmi:XMI").isEmpty()) {
            casPrefix = "cas:";
            idName = "xmi:id";
        } else {
            throw new DocumentFormatException("The document \"" + doc.getName() + "\" is neither of XCAS nor XMICAS format.");
        }
        for (Annotation annotation : inputAS) {
            if (!annotation.getType().matches(casPrefix + "[a-zA-Z]+(List|Array)")) continue;
            try {
                String elements = doc.getContent().getContent(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toString();
                if (elements.trim().equals("")) continue;
                annotation.getFeatures().put("elements", elements);
            }
            catch (InvalidOffsetException e) {
                throw new DocumentFormatException(e);
            }
        }
        AnnotationSet sofaSet = inputAS.get(casPrefix + "Sofa");
        if (sofaSet.size() > 1) {
            Out.prln("More than one UIMA SOFA, annotation offsets won't be correct.");
        }
        StringBuilder documentContent = new StringBuilder();
        for (Object annotation : sofaSet) {
            documentContent.append((String)annotation.getFeatures().get("sofaString"));
        }
        doc.setContent(new DocumentContentImpl(documentContent.toString()));
        inputAS.removeAll(sofaSet);
        inputAS.removeAll(inputAS.get("CAS"));
        inputAS.removeAll(inputAS.get("xmi:XMI"));
        inputAS.removeAll(inputAS.get("cas:NULL"));
        ArrayList<List<String>> viewList = new ArrayList<List<String>>();
        for (Iterator<Annotation> view : inputAS.get(casPrefix + "View")) {
            viewList.add(Arrays.asList(((String)view.getFeatures().get("members")).split("\\s+")));
        }
        inputAS.removeAll(inputAS.get(casPrefix + "View"));
        HashMap<String, String> entityMap = new HashMap<String, String>();
        for (Annotation entity : inputAS.get("com.temis.uima.Entity")) {
            features = entity.getFeatures();
            entityMap.put((String)features.get(idName), (String)features.get("value"));
        }
        try {
            for (Annotation annotation : new HashSet<Annotation>(inputAS)) {
                features = Factory.newFeatureMap();
                features.putAll(annotation.getFeatures());
                String start = (String)features.get("begin");
                String end = (String)features.get("end");
                String id = (String)features.get(idName);
                features.remove("begin");
                features.remove("end");
                features.remove("isEmptyAndSpan");
                features.remove("_indexed");
                if (start == null || end == null) {
                    features.remove(idName);
                    for (Map.Entry entry : features.entrySet()) {
                        doc.getFeatures().put(annotation.getType() + '_' + id + '.' + entry.getKey(), entry.getValue());
                    }
                } else {
                    String entityReference = (String)features.get("_ref_entity");
                    String type = entityMap.containsKey(entityReference) ? (String)entityMap.get(entityReference) : annotation.getType();
                    Integer gateId = outputAS.add(Long.valueOf(start), Long.valueOf(end), type, features);
                    int viewCount = 0;
                    for (List list : viewList) {
                        if (list.contains(id)) {
                            doc.getAnnotations("CasView" + viewCount).add(outputAS.get(gateId));
                        }
                        ++viewCount;
                    }
                }
                inputAS.remove(annotation);
            }
        }
        catch (InvalidOffsetException e) {
            throw new DocumentFormatException("Couldn't create annotation.", e);
        }
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        MimeType mime = new MimeType("text", "xmi+xml");
        mimeString2ClassHandlerMap.put(mime.getType() + "/" + mime.getSubtype(), this);
        mimeString2mimeTypeMap.put(mime.getType() + "/" + mime.getSubtype(), mime);
        suffixes2mimeTypeMap.put("xcas", mime);
        suffixes2mimeTypeMap.put("xmicas", mime);
        suffixes2mimeTypeMap.put("xmi", mime);
        magic2mimeTypeMap.put("<CAS version=\"2\">", mime);
        magic2mimeTypeMap.put("xmlns:cas=", mime);
        this.setMimeType(mime);
        return this;
    }
}

