/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.CorpusImpl;
import gate.corpora.DocumentData;
import gate.creole.AbstractLanguageResource;
import gate.creole.CustomDuplication;
import gate.creole.ResourceInstantiationException;
import gate.creole.ir.IREngine;
import gate.creole.ir.IndexDefinition;
import gate.creole.ir.IndexException;
import gate.creole.ir.IndexManager;
import gate.creole.ir.IndexStatistics;
import gate.creole.ir.IndexedCorpus;
import gate.creole.metadata.CreoleResource;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.MethodNotImplementedException;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

@CreoleResource(name="GATE Serial Corpus", isPrivate=true, comment="GATE persistent corpus (serialisation)", icon="corpus", helpURL="http://gate.ac.uk/userguide/sec:developer:datastores")
public class SerialCorpusImpl
extends AbstractLanguageResource
implements Corpus,
CreoleListener,
DatastoreListener,
IndexedCorpus,
CustomDuplication {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 3632609241787241616L;
    protected transient Vector<CorpusListener> corpusListeners;
    protected List<DocumentData> docDataList = null;
    protected transient List<Document> documents = null;
    protected transient IndexManager indexManager = null;
    protected transient List<Document> addedDocs = null;
    protected transient List<String> removedDocIDs = null;
    protected transient List<Document> changedDocs = null;

    public SerialCorpusImpl() {
    }

    protected SerialCorpusImpl(Corpus tCorpus) {
        this.setName(tCorpus.getName());
        this.setFeatures(tCorpus.getFeatures());
        this.docDataList = new ArrayList<DocumentData>();
        List<String> docNames = tCorpus.getDocumentNames();
        for (int i = 0; i < docNames.size(); ++i) {
            Document doc = (Document)tCorpus.get(i);
            this.docDataList.add(new DocumentData(docNames.get(i), null, doc.getClass().getName()));
        }
        this.documents = new ArrayList<Document>();
        this.documents.addAll(tCorpus);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public List<String> getDocumentNames() {
        ArrayList<String> docsNames = new ArrayList<String>();
        if (this.docDataList == null) {
            return docsNames;
        }
        Iterator<DocumentData> iterator = this.docDataList.iterator();
        while (iterator.hasNext()) {
            DocumentData aDocDataList;
            DocumentData data = aDocDataList = iterator.next();
            docsNames.add(data.getDocumentName());
        }
        return docsNames;
    }

    public List<Object> getDocumentPersistentIDs() {
        ArrayList<Object> docsIDs = new ArrayList<Object>();
        if (this.docDataList == null) {
            return docsIDs;
        }
        for (DocumentData data : this.docDataList) {
            docsIDs.add(data.getPersistentID());
        }
        return docsIDs;
    }

    public List<String> getDocumentClassTypes() {
        ArrayList<String> docsIDs = new ArrayList<String>();
        if (this.docDataList == null) {
            return docsIDs;
        }
        for (DocumentData data : this.docDataList) {
            docsIDs.add(data.getClassType());
        }
        return docsIDs;
    }

    public void setDocumentPersistentID(int index, Object persID) {
        if (index >= this.docDataList.size()) {
            return;
        }
        this.docDataList.get(index).setPersistentID(persID);
    }

    @Override
    public String getDocumentName(int index) {
        if (index >= this.docDataList.size()) {
            return "No such document";
        }
        return this.docDataList.get(index).getDocumentName();
    }

    public Object getDocumentPersistentID(int index) {
        if (index >= this.docDataList.size()) {
            return null;
        }
        return this.docDataList.get(index).getPersistentID();
    }

    public String getDocumentClassType(int index) {
        if (index >= this.docDataList.size()) {
            return null;
        }
        return this.docDataList.get(index).getClassType();
    }

    public void unloadDocument(int index, boolean sync) {
        if (!this.isDocumentLoaded(index) && this.isPersistentDocument(index)) {
            return;
        }
        if (sync) {
            Document doc = this.documents.get(index);
            try {
                if (doc.getLRPersistenceId() == null) {
                    doc = (Document)this.getDataStore().adopt(doc);
                    this.getDataStore().sync(doc);
                    this.setDocumentPersistentID(index, doc.getLRPersistenceId());
                } else {
                    this.getDataStore().sync(doc);
                }
            }
            catch (PersistenceException ex) {
                throw new GateRuntimeException("Error unloading document from corpusbecause document sync failed: " + ex.getMessage(), ex);
            }
        }
        this.documents.set(index, null);
    }

    public void unloadDocument(Document doc, boolean sync) {
        int index = this.findDocument(doc);
        if (index == -1) {
            return;
        }
        this.unloadDocument(index, sync);
    }

    @Override
    public void unloadDocument(Document doc) {
        this.unloadDocument(doc, true);
    }

    public void unloadDocument(int index) {
        this.unloadDocument(index, true);
    }

    @Override
    public boolean isDocumentLoaded(int index) {
        if (this.documents == null || this.documents.isEmpty()) {
            return false;
        }
        return this.documents.get(index) != null;
    }

    public boolean isPersistentDocument(int index) {
        if (this.documents == null || this.documents.isEmpty()) {
            return false;
        }
        return this.docDataList.get(index).getPersistentID() != null;
    }

    @Override
    public void cleanup() {
        if (this.corpusListeners != null) {
            this.corpusListeners = null;
        }
        if (this.documents != null) {
            this.documents.clear();
        }
        this.docDataList.clear();
        Gate.getCreoleRegister().removeCreoleListener(this);
        if (this.dataStore != null) {
            this.dataStore.removeDatastoreListener(this);
        }
    }

    @Override
    public void populate(URL directory, FileFilter filter, String encoding, boolean recurseDirectories) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, directory, filter, encoding, recurseDirectories);
    }

    @Override
    public void populate(URL directory, FileFilter filter, String encoding, String mimeType, boolean recurseDirectories) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, directory, filter, encoding, mimeType, recurseDirectories);
    }

    @Override
    public long populate(URL singleConcatenatedFile, String documentRootElement, String encoding, int numberOfFilesToExtract, String documentNamePrefix, String mimeType, boolean includeRootElement) throws IOException, ResourceInstantiationException {
        return CorpusImpl.populate(this, singleConcatenatedFile, documentRootElement, encoding, numberOfFilesToExtract, documentNamePrefix, mimeType, includeRootElement);
    }

    @Override
    public synchronized void removeCorpusListener(CorpusListener l) {
        if (this.corpusListeners != null && this.corpusListeners.contains(l)) {
            Vector v = (Vector)this.corpusListeners.clone();
            v.removeElement(l);
            this.corpusListeners = v;
        }
    }

    @Override
    public synchronized void addCorpusListener(CorpusListener l) {
        Vector v;
        Vector vector = v = this.corpusListeners == null ? new Vector(2) : (Vector)this.corpusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.corpusListeners = v;
        }
    }

    protected void fireDocumentAdded(CorpusEvent e) {
        if (this.corpusListeners != null) {
            Vector<CorpusListener> listeners = this.corpusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).documentAdded(e);
            }
        }
    }

    protected void fireDocumentRemoved(CorpusEvent e) {
        if (this.corpusListeners != null) {
            Vector<CorpusListener> listeners = this.corpusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).documentRemoved(e);
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        Resource res = e.getResource();
        if (res instanceof Document) {
            Document doc = (Document)res;
            if (doc.getDataStore() != this.getDataStore()) {
                this.remove(doc);
            } else {
                int index = this.indexOf(res);
                if (index < 0) {
                    return;
                }
                this.documents.set(index, null);
            }
        }
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
        if (!e.getDatastore().equals(this.getDataStore())) {
            return;
        }
        if (this.getDataStore() != null) {
            this.getDataStore().removeDatastoreListener(this);
        }
        Factory.deleteResource(this);
    }

    @Override
    public void resourceAdopted(DatastoreEvent evt) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent evt) {
        DataStore ds = (DataStore)evt.getSource();
        if (!ds.equals(this.dataStore)) {
            return;
        }
        Object docID = evt.getResourceID();
        if (docID == null) {
            return;
        }
        if (docID.equals(this.getLRPersistenceId())) {
            Factory.deleteResource(this);
            return;
        }
        boolean isDirty = false;
        for (int i = 0; i < this.docDataList.size(); ++i) {
            DocumentData docData = this.docDataList.get(i);
            if (!docID.equals(docData.getPersistentID())) continue;
            if (evt.getResource() == null) {
                this.documentRemoved(this.docDataList.get((int)i).persistentID.toString());
                this.docDataList.remove(i);
                this.documents.remove(i);
                isDirty = true;
                --i;
                continue;
            }
            this.remove(i);
            isDirty = true;
        }
        if (isDirty) {
            try {
                this.dataStore.sync(this);
            }
            catch (PersistenceException ex) {
                throw new GateRuntimeException("SerialCorpusImpl: " + ex.getMessage());
            }
            catch (SecurityException sex) {
                throw new GateRuntimeException("SerialCorpusImpl: " + sex.getMessage());
            }
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent evt) {
        if (evt.getResourceID().equals(this.getLRPersistenceId())) {
            this.thisResourceWritten();
        }
    }

    @Override
    public int size() {
        return this.docDataList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.docDataList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Document)) {
            return false;
        }
        int index = this.findDocument((Document)o);
        return index >= 0;
    }

    @Override
    public Iterator<Document> iterator() {
        return new Iterator<Document>(){
            Iterator<DocumentData> docDataIter;
            {
                this.docDataIter = SerialCorpusImpl.this.docDataList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.docDataIter.hasNext();
            }

            @Override
            public Document next() {
                DocumentData docData = this.docDataIter.next();
                int index = SerialCorpusImpl.this.docDataList.indexOf(docData);
                return SerialCorpusImpl.this.get(index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("SerialCorpusImpl does not support remove in the iterators");
            }
        };
    }

    @Override
    public String toString() {
        return "document data " + this.docDataList.toString() + " documents " + this.documents;
    }

    @Override
    public Object[] toArray() {
        throw new MethodNotImplementedException("toArray() is not implemented for SerialCorpusImpl");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new MethodNotImplementedException("toArray(Object[] a) is not implemented for SerialCorpusImpl");
    }

    @Override
    public boolean add(Document o) {
        if (o == null) {
            return false;
        }
        Document doc = o;
        if (doc.getDataStore() != null && !this.dataStore.equals(doc.getDataStore())) {
            Err.prln("Error: Persistent corpus can only accept documents from its own datastore!");
            return false;
        }
        DocumentData docData = new DocumentData(doc.getName(), doc.getLRPersistenceId(), doc.getClass().getName());
        boolean result = this.docDataList.add(docData);
        this.documents.add(doc);
        this.documentAdded(doc);
        this.fireDocumentAdded(new CorpusEvent(this, doc, this.docDataList.size() - 1, doc.getLRPersistenceId(), 401));
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Document)) {
            return false;
        }
        Document doc = (Document)o;
        int index = this.findDocument(doc);
        if (index == -1) {
            return false;
        }
        if (index < this.docDataList.size()) {
            String docName = this.docDataList.get(index).getDocumentName();
            Object docPersistentID = this.getDocumentPersistentID(index);
            this.docDataList.remove(index);
            this.documents.remove(index);
            if (docPersistentID != null) {
                this.documentRemoved(docPersistentID.toString());
            }
            this.fireDocumentRemoved(new CorpusEvent(this, (Document)o, index, docPersistentID, 402));
        }
        return true;
    }

    public int findDocument(Document doc) {
        boolean found = false;
        DocumentData docData = null;
        int index = this.documents.indexOf(doc);
        if (index > -1 && index < this.docDataList.size()) {
            return index;
        }
        Iterator<DocumentData> iter = this.docDataList.iterator();
        index = 0;
        while (iter.hasNext()) {
            docData = iter.next();
            if (docData.getDocumentName().equals(doc.getName()) && docData.getPersistentID().equals(doc.getLRPersistenceId()) && docData.getClassType().equals(doc.getClass().getName())) {
                found = true;
                break;
            }
            ++index;
        }
        if (found && index < this.docDataList.size()) {
            return index;
        }
        return -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Document> c) {
        boolean allAdded = true;
        Iterator<? extends Document> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.add(iter.next())) continue;
            allAdded = false;
        }
        return allAdded;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Document> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean allRemoved = true;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.remove(iter.next())) continue;
            allRemoved = false;
        }
        return allRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.documents.clear();
        this.docDataList.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SerialCorpusImpl)) {
            return false;
        }
        SerialCorpusImpl oCorpus = (SerialCorpusImpl)o;
        if (oCorpus == this) {
            return true;
        }
        return (oCorpus.lrPersistentId == this.lrPersistentId || this.lrPersistentId != null && this.lrPersistentId.equals(oCorpus.lrPersistentId)) && oCorpus.name.equals(this.name) && (oCorpus.dataStore == this.dataStore || oCorpus.dataStore.equals(this.dataStore)) && oCorpus.docDataList.equals(this.docDataList);
    }

    @Override
    public int hashCode() {
        return this.docDataList.hashCode();
    }

    @Override
    public Document get(int index) {
        if (index >= this.docDataList.size()) {
            return null;
        }
        Document res = this.documents.get(index);
        if (res == null) {
            FeatureMap parameters = Factory.newFeatureMap();
            parameters.put("DataStore", this.dataStore);
            try {
                Document lr;
                parameters.put("LRPersistenceId", this.docDataList.get(index).getPersistentID());
                res = lr = (Document)Factory.createResource(this.docDataList.get(index).getClassType(), parameters);
                this.documents.set(index, lr);
            }
            catch (ResourceInstantiationException ex) {
                Err.prln("Error reading document inside a serialised corpus.");
                throw new GateRuntimeException(ex);
            }
        }
        return res;
    }

    @Override
    public Document set(int index, Document element) {
        throw new MethodNotImplementedException();
    }

    @Override
    public void add(int index, Document o) {
        if (o == null) {
            return;
        }
        Document doc = o;
        DocumentData docData = new DocumentData(doc.getName(), doc.getLRPersistenceId(), doc.getClass().getName());
        this.docDataList.add(index, docData);
        this.documents.add(index, doc);
        this.documentAdded(doc);
        this.fireDocumentAdded(new CorpusEvent(this, doc, index, doc.getLRPersistenceId(), 401));
    }

    @Override
    public Document remove(int index) {
        Document res = this.isDocumentLoaded(index) ? this.get(index) : null;
        Object docLRID = this.docDataList.get((int)index).persistentID;
        if (docLRID != null) {
            this.documentRemoved(docLRID.toString());
        }
        this.docDataList.remove(index);
        this.documents.remove(index);
        this.fireDocumentRemoved(new CorpusEvent(this, res, index, docLRID, 402));
        return res;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Document) {
            return this.findDocument((Document)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new MethodNotImplementedException();
    }

    @Override
    public ListIterator<Document> listIterator() {
        throw new MethodNotImplementedException();
    }

    @Override
    public ListIterator<Document> listIterator(int index) {
        throw new MethodNotImplementedException();
    }

    @Override
    public List<Document> subList(int fromIndex, int toIndex) {
        throw new MethodNotImplementedException();
    }

    @Override
    public void setDataStore(DataStore dataStore) throws PersistenceException {
        super.setDataStore(dataStore);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    public void setTransientSource(Object source) {
        if (!(source instanceof Corpus)) {
            return;
        }
        if (this.dataStore != null && this.lrPersistentId != null) {
            return;
        }
        Corpus tCorpus = (Corpus)source;
        this.setName(tCorpus.getName());
        this.setFeatures(tCorpus.getFeatures());
        this.docDataList = new ArrayList<DocumentData>();
        List<String> docNames = tCorpus.getDocumentNames();
        for (int i = 0; i < docNames.size(); ++i) {
            Document aDoc = (Document)tCorpus.get(i);
            this.docDataList.add(new DocumentData(docNames.get(i), null, aDoc.getClass().getName()));
        }
        this.documents = new ArrayList<Document>();
        this.documents.addAll(tCorpus);
        this.addedDocs = new Vector<Document>();
        this.removedDocIDs = new Vector<String>();
        this.changedDocs = new Vector<Document>();
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    public Object getTransientSource() {
        return null;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        return this;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.documents = new ArrayList<Document>(this.docDataList.size());
        for (int i = 0; i < this.docDataList.size(); ++i) {
            this.documents.add(null);
        }
        this.corpusListeners = new Vector();
        Gate.getCreoleRegister().addCreoleListener(this);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    @Override
    public void setIndexDefinition(IndexDefinition definition) {
        if (definition != null) {
            this.getFeatures().put("Index_definition_feature_key", definition);
            String className = definition.getIrEngineClassName();
            try {
                Class<?> aClass = Class.forName(className, true, Gate.getClassLoader());
                IREngine engine = (IREngine)aClass.newInstance();
                this.indexManager = engine.getIndexmanager();
                this.indexManager.setIndexDefinition(definition);
                this.indexManager.setCorpus(this);
            }
            catch (Exception e) {
                e.printStackTrace(Err.getPrintWriter());
            }
            this.addedDocs = new Vector<Document>();
            this.removedDocIDs = new Vector<String>();
            this.changedDocs = new Vector<Document>();
        }
    }

    @Override
    public IndexDefinition getIndexDefinition() {
        return (IndexDefinition)this.getFeatures().get("Index_definition_feature_key");
    }

    @Override
    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    @Override
    public IndexStatistics getIndexStatistics() {
        return (IndexStatistics)this.getFeatures().get("Index_statistics_feature_key");
    }

    private void documentAdded(Document doc) {
        if (this.indexManager != null) {
            this.addedDocs.add(doc);
        }
    }

    private void documentRemoved(String lrID) {
        if (this.indexManager != null) {
            this.removedDocIDs.add(lrID);
        }
    }

    private void thisResourceWritten() {
        if (this.indexManager != null) {
            try {
                for (int i = 0; i < this.documents.size(); ++i) {
                    Document doc;
                    if (this.documents.get(i) == null || this.addedDocs.contains(doc = this.documents.get(i)) || !doc.isModified()) continue;
                    this.changedDocs.add(doc);
                }
                this.indexManager.sync(this.addedDocs, this.removedDocIDs, this.changedDocs);
            }
            catch (IndexException ie) {
                ie.printStackTrace();
            }
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext ctx) throws ResourceInstantiationException {
        throw new ResourceInstantiationException("Duplication of " + this.getClass().getName() + " not permitted");
    }
}

