/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import java.io.Serializable;
import java.util.ArrayList;

public class RepositioningInfo
extends ArrayList<PositionInfo> {
    static final long serialVersionUID = -2895662600168468559L;
    private static final boolean DEBUG = false;

    public void addPositionInfo(long origPos, long origLength, long currPos, long currLength) {
        int insertPos = 0;
        for (int i = this.size(); i > 0; --i) {
            PositionInfo lastPI = (PositionInfo)this.get(i - 1);
            if (lastPI.getOriginalPosition() >= origPos) continue;
            insertPos = i;
            break;
        }
        this.add(insertPos, new PositionInfo(origPos, origLength, currPos, currLength));
    }

    public long getExtractedPos(long absPos) {
        long result = absPos;
        PositionInfo currPI = null;
        int size = this.size();
        if (size != 0) {
            boolean found = false;
            for (int i = 0; i < size; ++i) {
                long origLen;
                currPI = (PositionInfo)this.get(i);
                long origPos = currPI.getOriginalPosition();
                if (absPos > origPos + (origLen = currPI.getOriginalLength())) continue;
                if (absPos < origPos) {
                    result = -1L;
                } else {
                    result = absPos == origPos + origLen ? currPI.getCurrentPosition() + currPI.getCurrentLength() : currPI.getCurrentPosition() + absPos - origPos;
                    if (result > currPI.getCurrentPosition() + currPI.getCurrentLength()) {
                        result = currPI.getCurrentPosition() + currPI.getCurrentLength();
                    }
                }
                found = true;
                break;
            }
            if (!found) {
                result = -1L;
            }
        }
        return result;
    }

    public long getOriginalPos(long relPos) {
        return this.getOriginalPos(relPos, false);
    }

    public long getOriginalPos(long relPos, boolean afterChar) {
        long result = relPos;
        PositionInfo currPI = null;
        int size = this.size();
        if (size != 0) {
            boolean found = false;
            for (int i = 0; i < size; ++i) {
                currPI = (PositionInfo)this.get(i);
                long currPos = currPI.getCurrentPosition();
                long currLen = currPI.getCurrentLength();
                if ((afterChar || i == size - 1) && relPos == currPos + currLen) {
                    result = currPI.getOriginalPosition() + currPI.getOriginalLength();
                    found = true;
                    break;
                }
                if (relPos >= currPos + currLen) continue;
                result = relPos < currPos ? -1L : currPI.getOriginalPosition() + relPos - currPos;
                found = true;
                break;
            }
            if (!found) {
                result = -1L;
            }
        }
        return result;
    }

    public long getExtractedPosFlow(long absPos) {
        long result = -1L;
        return result;
    }

    public long getOriginalPosFlow(long relPos) {
        long result = -1L;
        return result;
    }

    public int getIndexByOriginalPosition(long absPos) {
        PositionInfo currPI = null;
        int result = -1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            long origLen;
            currPI = (PositionInfo)this.get(i);
            long origPos = currPI.getOriginalPosition();
            if (absPos > origPos + (origLen = currPI.getOriginalLength())) continue;
            if (absPos < origPos) break;
            result = i;
            break;
        }
        return result;
    }

    public int getIndexByOriginalPositionFlow(long absPos) {
        int size;
        PositionInfo currPI = null;
        int result = size = this.size();
        for (int i = 0; i < size; ++i) {
            long origLen;
            currPI = (PositionInfo)this.get(i);
            long origPos = currPI.getOriginalPosition();
            if (absPos > origPos + (origLen = currPI.getOriginalLength())) continue;
            if (absPos >= origPos) {
                result = i;
                break;
            }
            result = i - 1;
            break;
        }
        return result;
    }

    public void correctInformation(long originalPos, long origLen, long newLen) {
        PositionInfo currPI;
        int index = this.getIndexByOriginalPositionFlow(originalPos);
        if (index == -1) {
            index = 0;
        }
        for (int i = index; i < this.size(); ++i) {
            PositionInfo positionInfo = currPI = (PositionInfo)this.get(i);
            positionInfo.m_currPos = positionInfo.m_currPos - (origLen - newLen);
        }
        currPI = (PositionInfo)this.get(index);
        if (originalPos >= currPI.m_origPos && currPI.m_origPos + currPI.m_origLength >= originalPos + origLen) {
            long frontLen = originalPos - currPI.m_origPos;
            PositionInfo frontPI = new PositionInfo(currPI.m_origPos, frontLen, currPI.m_currPos, frontLen);
            PositionInfo correctPI = new PositionInfo(originalPos, origLen, currPI.m_currPos + frontLen, newLen);
            long endLen = currPI.m_origLength - frontLen - origLen;
            PositionInfo endPI = new PositionInfo(originalPos + origLen, endLen, currPI.m_currPos + frontLen + newLen, endLen);
            this.set(index, frontPI);
            if (endPI.m_origLength > 0L) {
                this.add(index + 1, endPI);
            }
            if (correctPI.m_origLength > 0L) {
                this.add(index + 1, correctPI);
            }
        }
    }

    public void correctInformationOriginalMove(long originalPos, long moveLen) {
        PositionInfo currPI;
        int index = this.getIndexByOriginalPositionFlow(originalPos);
        if (index == -1) {
            index = 0;
        }
        if (index == this.size()) {
            return;
        }
        for (int i = index + 1; i < this.size(); ++i) {
            PositionInfo positionInfo = currPI = (PositionInfo)this.get(i);
            positionInfo.m_origPos = positionInfo.m_origPos + moveLen;
        }
        currPI = (PositionInfo)this.get(index);
        if (originalPos > currPI.m_origPos) {
            if (originalPos < currPI.m_origPos + currPI.m_origLength) {
                long frontLen = originalPos - currPI.m_origPos;
                PositionInfo frontPI = new PositionInfo(currPI.m_origPos, frontLen, currPI.m_currPos, frontLen);
                long endLen = currPI.m_origLength - frontLen;
                PositionInfo endPI = new PositionInfo(originalPos + moveLen, endLen, currPI.m_currPos + frontLen, endLen);
                this.set(index, frontPI);
                if (endPI.m_origLength != 0L) {
                    this.add(index + 1, endPI);
                }
            }
        } else {
            PositionInfo positionInfo = currPI;
            positionInfo.m_origPos = positionInfo.m_origPos + moveLen;
        }
    }

    public class PositionInfo
    implements Serializable {
        static final long serialVersionUID = -7747351720249898499L;
        private long m_origPos;
        private long m_origLength;
        private long m_currPos;
        private long m_currLength;

        public PositionInfo(long orig, long origLen, long curr, long currLen) {
            this.m_origPos = orig;
            this.m_origLength = origLen;
            this.m_currPos = curr;
            this.m_currLength = currLen;
        }

        public long getCurrentPosition() {
            return this.m_currPos;
        }

        public long getOriginalPosition() {
            return this.m_origPos;
        }

        public long getOriginalLength() {
            return this.m_origLength;
        }

        public long getCurrentLength() {
            return this.m_currLength;
        }

        public String toString() {
            return "(" + this.m_origPos + "," + this.m_origLength + "," + this.m_currPos + "," + this.m_currLength + ")";
        }
    }
}

