/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.TextualDocument;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.corpora.ObjectWrapper;
import gate.event.StatusListener;
import gate.relations.Relation;
import gate.relations.RelationSet;
import gate.relations.SimpleRelation;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DocumentStaxUtils {
    private static XMLInputFactory inputFactory = null;
    public static final char INVALID_CHARACTER_REPLACEMENT = ' ';
    public static final String GATE_XML_VERSION = "3";
    public static final int LT_THRESHOLD = 5;
    public static final String XCES_VERSION = "1.0";
    public static final String XCES_NAMESPACE = "http://www.xces.org/schema/2003";
    private static XMLOutputFactory outputFactory = null;
    private static Pattern CDATA_END_PATTERN = Pattern.compile("\\]\\]>");
    public static final Comparator<Annotation> LONGEST_FIRST_OFFSET_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation left, Annotation right) {
            long roffset;
            long loffset = left.getStartNode().getOffset();
            if (loffset == (roffset = right.getStartNode().getOffset().longValue())) {
                loffset = left.getEndNode().getOffset();
                if (loffset == (roffset = right.getEndNode().getOffset().longValue())) {
                    return left.getId() - right.getId();
                }
                return (int)(roffset - loffset);
            }
            return (int)(loffset - roffset);
        }
    };

    public static void readGateXmlDocument(XMLStreamReader xsr, Document doc) throws XMLStreamException {
        DocumentStaxUtils.readGateXmlDocument(xsr, doc, null);
    }

    public static void readGateXmlDocument(XMLStreamReader xsr, Document doc, StatusListener statusListener) throws XMLStreamException {
        DocumentContent savedContent = null;
        xsr.require(1, null, "GateDocument");
        xsr.nextTag();
        xsr.require(1, null, "GateDocumentFeatures");
        if (statusListener != null) {
            statusListener.statusChanged("Reading document features");
        }
        FeatureMap documentFeatures = DocumentStaxUtils.readFeatureMap(xsr);
        xsr.nextTag();
        xsr.require(1, null, "TextWithNodes");
        HashMap<Integer, Long> nodeIdToOffsetMap = new HashMap<Integer, Long>();
        if (statusListener != null) {
            statusListener.statusChanged("Reading document content");
        }
        String documentText = DocumentStaxUtils.readTextWithNodes(xsr, nodeIdToOffsetMap);
        savedContent = doc.getContent();
        doc.setContent(new DocumentContentImpl(documentText));
        try {
            int numAnnots = 0;
            Integer maxAnnotId = null;
            Boolean requireAnnotationIds = null;
            int eventType = xsr.nextTag();
            while (eventType == 1 && xsr.getLocalName().equals("AnnotationSet")) {
                xsr.require(1, null, "AnnotationSet");
                String annotationSetName = xsr.getAttributeValue(null, "Name");
                AnnotationSet annotationSet = null;
                if (annotationSetName == null) {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading default annotation set");
                    }
                    annotationSet = doc.getAnnotations();
                } else {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading \"" + annotationSetName + "\" annotation set");
                    }
                    annotationSet = doc.getAnnotations(annotationSetName);
                }
                annotationSet.clear();
                TreeSet<Integer> annotIdsInSet = new TreeSet<Integer>();
                requireAnnotationIds = DocumentStaxUtils.readAnnotationSet(xsr, annotationSet, nodeIdToOffsetMap, annotIdsInSet, requireAnnotationIds);
                if (annotIdsInSet.size() > 0 && (maxAnnotId == null || (Integer)annotIdsInSet.last() > maxAnnotId)) {
                    maxAnnotId = (Integer)annotIdsInSet.last();
                }
                numAnnots += annotIdsInSet.size();
                eventType = xsr.nextTag();
            }
            while (eventType == 1 && xsr.getLocalName().equals("RelationSet")) {
                xsr.require(1, null, "RelationSet");
                String relationSetName = xsr.getAttributeValue(null, "Name");
                RelationSet relations = null;
                if (relationSetName == null) {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading relation set for default annotation set");
                    }
                    relations = doc.getAnnotations().getRelations();
                } else {
                    if (statusListener != null) {
                        statusListener.statusChanged("Reading relation set for \"" + relationSetName + "\" annotation set");
                    }
                    relations = doc.getAnnotations(relationSetName).getRelations();
                }
                TreeSet<Integer> relIdsInSet = new TreeSet<Integer>();
                DocumentStaxUtils.readRelationSet(xsr, relations, relIdsInSet);
                if (relIdsInSet.size() > 0 && (maxAnnotId == null || (Integer)relIdsInSet.last() > maxAnnotId)) {
                    maxAnnotId = (Integer)relIdsInSet.last();
                }
                numAnnots += relIdsInSet.size();
                eventType = xsr.nextTag();
            }
            xsr.require(2, null, "GateDocument");
            doc.setFeatures(documentFeatures);
            if (doc instanceof DocumentImpl && maxAnnotId != null) {
                ((DocumentImpl)doc).setNextAnnotationId(maxAnnotId + 1);
            }
            if (statusListener != null) {
                statusListener.statusChanged("Finished.  " + numAnnots + " annotation(s) processed");
            }
        }
        catch (XMLStreamException xse) {
            doc.setContent(savedContent);
            throw xse;
        }
        catch (RuntimeException re) {
            doc.setContent(savedContent);
            throw re;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean readAnnotationSet(XMLStreamReader xsr, AnnotationSet annotationSet, Map<Integer, Long> nodeIdToOffsetMap, Set<Integer> allAnnotIds, Boolean requireAnnotationIds) throws XMLStreamException {
        ArrayList<AnnotationObject> collectedAnnots = new ArrayList<AnnotationObject>();
        while (xsr.nextTag() == 1) {
            xsr.require(1, null, "Annotation");
            AnnotationObject annObj = new AnnotationObject();
            annObj.setElemName(xsr.getAttributeValue(null, "Type"));
            try {
                int startNodeId = Integer.parseInt(xsr.getAttributeValue(null, "StartNode"));
                if (nodeIdToOffsetMap != null) {
                    Long startOffset = nodeIdToOffsetMap.get(startNodeId);
                    if (startOffset == null) throw new XMLStreamException("Invalid start node ID", xsr.getLocation());
                    annObj.setStart(startOffset);
                } else {
                    annObj.setStart(Long.valueOf(startNodeId));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLStreamException("Non-integer value found for StartNode", xsr.getLocation());
            }
            try {
                int endNodeId = Integer.parseInt(xsr.getAttributeValue(null, "EndNode"));
                if (nodeIdToOffsetMap != null) {
                    Long endOffset = nodeIdToOffsetMap.get(endNodeId);
                    if (endOffset == null) throw new XMLStreamException("Invalid end node ID", xsr.getLocation());
                    annObj.setEnd(endOffset);
                } else {
                    annObj.setEnd(Long.valueOf(endNodeId));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLStreamException("Non-integer value found for EndNode", xsr.getLocation());
            }
            String annotIdString = xsr.getAttributeValue(null, "Id");
            if (annotIdString == null) {
                if (requireAnnotationIds == null) {
                    requireAnnotationIds = Boolean.FALSE;
                } else if (requireAnnotationIds.booleanValue()) {
                    throw new XMLStreamException("New style GATE XML format requires that every annotation specify its Id, but an annotation with no Id was found", xsr.getLocation());
                }
            } else {
                if (requireAnnotationIds == null) {
                    requireAnnotationIds = Boolean.TRUE;
                } else if (!requireAnnotationIds.booleanValue()) {
                    throw new XMLStreamException("Old style GATE XML format requires that no annotation specifies its Id, but an annotation with an Id was found", xsr.getLocation());
                }
                try {
                    Integer annotationId = Integer.valueOf(annotIdString);
                    if (allAnnotIds.contains(annotationId)) {
                        throw new XMLStreamException("Annotation IDs must be unique within an annotation set. Found duplicate ID", xsr.getLocation());
                    }
                    allAnnotIds.add(annotationId);
                    annObj.setId(annotationId);
                }
                catch (NumberFormatException nfe) {
                    throw new XMLStreamException("Non-integer annotation ID found", xsr.getLocation());
                }
            }
            annObj.setFM(DocumentStaxUtils.readFeatureMap(xsr));
            collectedAnnots.add(annObj);
        }
        for (AnnotationObject annObj : collectedAnnots) {
            try {
                if (annObj.getId() != null) {
                    annotationSet.add(annObj.getId(), annObj.getStart(), annObj.getEnd(), annObj.getElemName(), annObj.getFM());
                    continue;
                }
                annotationSet.add(annObj.getStart(), annObj.getEnd(), annObj.getElemName(), annObj.getFM());
            }
            catch (InvalidOffsetException ioe) {
                throw new XMLStreamException("Invalid offset when creating annotation " + annObj, ioe);
            }
        }
        return requireAnnotationIds;
    }

    public static void readRelationSet(XMLStreamReader xsr, RelationSet relations, Set<Integer> allAnnotIds) throws XMLStreamException {
        while (xsr.nextTag() == 1) {
            int eventType;
            xsr.require(1, null, "Relation");
            String type = xsr.getAttributeValue(null, "Type");
            String idString = xsr.getAttributeValue(null, "Id");
            String memberString = xsr.getAttributeValue(null, "Members");
            if (memberString == null) {
                throw new XMLStreamException("A relation must have members");
            }
            if (type == null) {
                throw new XMLStreamException("A relation must have a type");
            }
            if (idString == null) {
                throw new XMLStreamException("A relation must have an id");
            }
            String[] memberStrings = memberString.split(";");
            int[] members = new int[memberStrings.length];
            for (int i = 0; i < members.length; ++i) {
                members[i] = Integer.parseInt(memberStrings[i]);
            }
            xsr.nextTag();
            xsr.require(1, null, "UserData");
            StringBuilder stringRep = new StringBuilder(1024);
            block6: while ((eventType = xsr.next()) != 2) {
                switch (eventType) {
                    case 4: 
                    case 12: {
                        stringRep.append(xsr.getTextCharacters(), xsr.getTextStart(), xsr.getTextLength());
                        continue block6;
                    }
                    case 1: {
                        throw new XMLStreamException("Elements not allowed within user data.", xsr.getLocation());
                    }
                }
            }
            xsr.require(2, null, "UserData");
            FeatureMap features = DocumentStaxUtils.readFeatureMap(xsr);
            SimpleRelation r = new SimpleRelation(Integer.parseInt(idString), type, members);
            r.setFeatures(features);
            if (stringRep.length() > 0) {
                ObjectWrapper wrapper = new ObjectWrapper(stringRep.toString());
                r.setUserData(wrapper.getValue());
            }
            relations.add(r);
        }
    }

    public static String readTextWithNodes(XMLStreamReader xsr, Map<Integer, Long> nodeIdToOffsetMap) throws XMLStreamException {
        int eventType;
        StringBuffer textBuf = new StringBuffer(20480);
        block6: while ((eventType = xsr.next()) != 2) {
            switch (eventType) {
                case 4: 
                case 12: {
                    textBuf.append(xsr.getTextCharacters(), xsr.getTextStart(), xsr.getTextLength());
                    continue block6;
                }
                case 1: {
                    xsr.require(1, null, "Node");
                    String idString = xsr.getAttributeValue(null, "id");
                    if (idString == null) {
                        throw new XMLStreamException("Node element has no id", xsr.getLocation());
                    }
                    try {
                        Integer id = Integer.valueOf(idString);
                        Long offset = textBuf.length();
                        nodeIdToOffsetMap.put(id, offset);
                    }
                    catch (NumberFormatException nfe) {
                        throw new XMLStreamException("Node element must have integer id", xsr.getLocation());
                    }
                    if (xsr.next() == 2) continue block6;
                    throw new XMLStreamException("Node element within TextWithNodes must be empty.", xsr.getLocation());
                }
            }
        }
        return textBuf.toString();
    }

    public static FeatureMap readFeatureMap(XMLStreamReader xsr) throws XMLStreamException {
        FeatureMap fm = Factory.newFeatureMap();
        while (xsr.nextTag() == 1) {
            xsr.require(1, null, "Feature");
            Object featureName = null;
            Object featureValue = null;
            while (xsr.nextTag() == 1) {
                if ("Name".equals(xsr.getLocalName())) {
                    featureName = DocumentStaxUtils.readFeatureNameOrValue(xsr);
                    continue;
                }
                if ("Value".equals(xsr.getLocalName())) {
                    featureValue = DocumentStaxUtils.readFeatureNameOrValue(xsr);
                    continue;
                }
                throw new XMLStreamException("Feature element should contain only Name and Value children", xsr.getLocation());
            }
            fm.put(featureName, featureValue);
        }
        return fm;
    }

    static Object readFeatureNameOrValue(XMLStreamReader xsr) throws XMLStreamException {
        int eventType;
        String itemClassName;
        String className = xsr.getAttributeValue(null, "className");
        if (className == null) {
            className = "java.lang.String";
        }
        if ((itemClassName = xsr.getAttributeValue(null, "itemClassName")) == null) {
            itemClassName = "java.lang.String";
        }
        StringBuffer stringRep = new StringBuffer(1024);
        block17: while ((eventType = xsr.next()) != 2) {
            switch (eventType) {
                case 4: 
                case 12: {
                    stringRep.append(xsr.getTextCharacters(), xsr.getTextStart(), xsr.getTextLength());
                    continue block17;
                }
                case 1: {
                    throw new XMLStreamException("Elements not allowed within feature name or value element.", xsr.getLocation());
                }
            }
        }
        if ("java.lang.String".equals(className)) {
            return stringRep.toString();
        }
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className, true, Gate.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            return stringRep.toString();
        }
        if (Collection.class.isAssignableFrom(theClass)) {
            Class<?> itemClass = null;
            Constructor<?> itemConstructor = null;
            Collection featObject = null;
            boolean addItemAsString = false;
            try {
                featObject = (Collection)theClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                return stringRep.toString();
            }
            catch (InstantiationException ie) {
                return stringRep.toString();
            }
            if ("java.lang.String".equals(itemClassName)) {
                addItemAsString = true;
            } else {
                try {
                    itemClass = Class.forName(itemClassName, true, Gate.getClassLoader());
                    Class[] paramsArray = new Class[]{String.class};
                    itemConstructor = itemClass.getConstructor(paramsArray);
                }
                catch (ClassNotFoundException cnfex) {
                    Out.prln("Warning: Item class " + itemClassName + " not found.Adding items as Strings");
                    addItemAsString = true;
                }
                catch (NoSuchMethodException nsme) {
                    addItemAsString = true;
                }
                catch (SecurityException se) {
                    addItemAsString = true;
                }
            }
            StringTokenizer strTok = new StringTokenizer(stringRep.toString(), ";");
            Object[] params = new Object[1];
            Object itemObj = null;
            while (strTok.hasMoreTokens()) {
                String itemStrRep = strTok.nextToken();
                if (addItemAsString) {
                    featObject.add(itemStrRep);
                    continue;
                }
                params[0] = itemStrRep;
                try {
                    itemObj = itemConstructor.newInstance(params);
                }
                catch (Exception e) {
                    throw new XMLStreamException("An item(" + itemStrRep + ")  does not comply with its class definition(" + itemClassName + ")", xsr.getLocation());
                }
                featObject.add(itemObj);
            }
            return featObject;
        }
        Class[] params = new Class[]{String.class};
        try {
            Constructor<?> featConstr = theClass.getConstructor(params);
            Object[] featConstrParams = new Object[]{stringRep.toString()};
            Object featObject = featConstr.newInstance(featConstrParams);
            if (featObject instanceof ObjectWrapper) {
                featObject = ((ObjectWrapper)featObject).getValue();
            }
            return featObject;
        }
        catch (Exception e) {
            return stringRep.toString();
        }
    }

    public static void readXces(InputStream is, AnnotationSet as) throws XMLStreamException {
        if (inputFactory == null) {
            inputFactory = XMLInputFactory.newInstance();
        }
        try (XMLStreamReader xsr = inputFactory.createXMLStreamReader(is);){
            DocumentStaxUtils.nextTagSkipDTD(xsr);
            DocumentStaxUtils.readXces(xsr, as);
        }
    }

    private static int nextTagSkipDTD(XMLStreamReader xsr) throws XMLStreamException {
        int eventType = xsr.next();
        while (eventType == 4 && xsr.isWhiteSpace() || eventType == 12 && xsr.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5 || eventType == 11) {
            eventType = xsr.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", xsr.getLocation());
        }
        return eventType;
    }

    public static void readXces(XMLStreamReader xsr, AnnotationSet as) throws XMLStreamException {
        xsr.require(1, XCES_NAMESPACE, "cesAna");
        TreeSet<Integer> allAnnotIds = new TreeSet<Integer>();
        for (Annotation a : as) {
            allAnnotIds.add(a.getId());
        }
        ArrayList<AnnotationObject> collectedIdentifiedAnnots = new ArrayList<AnnotationObject>();
        ArrayList<AnnotationObject> collectedNonIdentifiedAnnots = new ArrayList<AnnotationObject>();
        while (xsr.nextTag() == 1) {
            xsr.require(1, XCES_NAMESPACE, "struct");
            AnnotationObject annObj = new AnnotationObject();
            annObj.setElemName(xsr.getAttributeValue(null, "type"));
            try {
                annObj.setStart(Long.valueOf(xsr.getAttributeValue(null, "from")));
            }
            catch (NumberFormatException nfe) {
                throw new XMLStreamException("Non-integer value found for struct/@from", xsr.getLocation());
            }
            try {
                annObj.setEnd(Long.valueOf(xsr.getAttributeValue(null, "to")));
            }
            catch (NumberFormatException nfe) {
                throw new XMLStreamException("Non-integer value found for struct/@to", xsr.getLocation());
            }
            String annotIdString = xsr.getAttributeValue(null, "n");
            if (annotIdString != null) {
                try {
                    Integer annotationId = Integer.valueOf(annotIdString);
                    if (allAnnotIds.contains(annotationId)) {
                        throw new XMLStreamException("Annotation IDs must be unique within an annotation set. Found duplicate ID", xsr.getLocation());
                    }
                    allAnnotIds.add(annotationId);
                    annObj.setId(annotationId);
                }
                catch (NumberFormatException nfe) {
                    throw new XMLStreamException("Non-integer annotation ID found", xsr.getLocation());
                }
            }
            annObj.setFM(DocumentStaxUtils.readXcesFeatureMap(xsr));
            if (annObj.getId() != null) {
                collectedIdentifiedAnnots.add(annObj);
                continue;
            }
            collectedNonIdentifiedAnnots.add(annObj);
        }
        AnnotationObject a2 = null;
        try {
            for (AnnotationObject a2 : collectedIdentifiedAnnots) {
                as.add(a2.getId(), a2.getStart(), a2.getEnd(), a2.getElemName(), a2.getFM());
            }
            for (AnnotationObject a2 : collectedNonIdentifiedAnnots) {
                as.add(a2.getStart(), a2.getEnd(), a2.getElemName(), a2.getFM());
            }
        }
        catch (InvalidOffsetException ioe) {
            throw new XMLStreamException("Invalid offset when creating annotation " + a2, ioe);
        }
    }

    public static FeatureMap readXcesFeatureMap(XMLStreamReader xsr) throws XMLStreamException {
        FeatureMap fm = Factory.newFeatureMap();
        while (xsr.nextTag() == 1) {
            xsr.require(1, XCES_NAMESPACE, "feat");
            String featureName = xsr.getAttributeValue(null, "name");
            String featureValue = xsr.getAttributeValue(null, "value");
            fm.put(featureName, featureValue);
            xsr.nextTag();
            xsr.require(2, XCES_NAMESPACE, "feat");
        }
        return fm;
    }

    public static String toXml(Document doc) {
        try {
            if (outputFactory == null) {
                outputFactory = XMLOutputFactory.newInstance();
            }
            StringWriter sw = new StringWriter(doc.getContent().size().intValue() * 40);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(sw);
            if (doc instanceof TextualDocument) {
                xsw.writeStartDocument(((TextualDocument)doc).getEncoding(), XCES_VERSION);
            } else {
                xsw.writeStartDocument(XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.writeDocument(doc, xsw, "");
            xsw.close();
            return sw.toString();
        }
        catch (XMLStreamException xse) {
            throw new GateRuntimeException("Error converting document to XML", xse);
        }
    }

    public static void writeDocument(Document doc, File file) throws XMLStreamException, IOException {
        DocumentStaxUtils.writeDocument(doc, file, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document doc, File file, String namespaceURI) throws XMLStreamException, IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            DocumentStaxUtils.writeDocument(doc, outputStream, namespaceURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document doc, OutputStream outputStream, String namespaceURI) throws XMLStreamException, IOException {
        if (outputFactory == null) {
            outputFactory = XMLOutputFactory.newInstance();
        }
        try (XMLStreamWriter xsw = null;){
            if (doc instanceof TextualDocument) {
                xsw = outputFactory.createXMLStreamWriter(outputStream, ((TextualDocument)doc).getEncoding());
                xsw.writeStartDocument(((TextualDocument)doc).getEncoding(), XCES_VERSION);
            } else {
                xsw = outputFactory.createXMLStreamWriter(outputStream);
                xsw.writeStartDocument(XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.writeDocument(doc, xsw, namespaceURI);
        }
    }

    public static void writeDocument(Document doc, Map<String, Collection<Annotation>> annotationSets, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        xsw.setDefaultNamespace(namespaceURI);
        xsw.writeStartElement(namespaceURI, "GateDocument");
        xsw.writeAttribute("version", GATE_XML_VERSION);
        if (namespaceURI.length() > 0) {
            xsw.writeDefaultNamespace(namespaceURI);
        }
        DocumentStaxUtils.newLine(xsw);
        xsw.writeComment(" The document's features");
        DocumentStaxUtils.newLine(xsw);
        DocumentStaxUtils.newLine(xsw);
        xsw.writeStartElement(namespaceURI, "GateDocumentFeatures");
        DocumentStaxUtils.newLine(xsw);
        DocumentStaxUtils.writeFeatures(doc.getFeatures(), xsw, namespaceURI);
        xsw.writeEndElement();
        DocumentStaxUtils.newLine(xsw);
        xsw.writeComment(" The document content area with serialized nodes ");
        DocumentStaxUtils.newLine(xsw);
        DocumentStaxUtils.newLine(xsw);
        DocumentStaxUtils.writeTextWithNodes(doc, annotationSets.values(), xsw, namespaceURI);
        DocumentStaxUtils.newLine(xsw);
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        if (annotationSets.containsKey(null)) {
            if (sListener != null) {
                sListener.statusChanged("Saving the default annotation set ");
            }
            xsw.writeComment(" The default annotation set ");
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.writeAnnotationSet(annotationSets.get(null), null, xsw, namespaceURI);
            DocumentStaxUtils.newLine(xsw);
        }
        for (Map.Entry<String, Collection<Annotation>> entry : annotationSets.entrySet()) {
            String annotationSetName = entry.getKey();
            if (annotationSetName == null) continue;
            Collection<Annotation> annots = entry.getValue();
            xsw.writeComment(" Named annotation set ");
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.newLine(xsw);
            if (sListener != null) {
                sListener.statusChanged("Saving " + annotationSetName + " annotation set ");
            }
            DocumentStaxUtils.writeAnnotationSet(annots, annotationSetName, xsw, namespaceURI);
            DocumentStaxUtils.newLine(xsw);
        }
        Iterator<String> iter = annotationSets.keySet().iterator();
        while (iter.hasNext()) {
            DocumentStaxUtils.writeRelationSet(doc.getAnnotations(iter.next()).getRelations(), xsw, namespaceURI);
        }
        xsw.writeEndElement();
        DocumentStaxUtils.newLine(xsw);
    }

    public static void writeDocument(Document doc, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        HashMap<String, Collection<Annotation>> asMap = new HashMap<String, Collection<Annotation>>();
        asMap.put(null, doc.getAnnotations());
        if (doc.getNamedAnnotationSets() != null) {
            asMap.putAll(doc.getNamedAnnotationSets());
        }
        DocumentStaxUtils.writeDocument(doc, asMap, xsw, namespaceURI);
    }

    public static void writeAnnotationSet(AnnotationSet annotations, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        DocumentStaxUtils.writeAnnotationSet((Collection<Annotation>)annotations, annotations.getName(), xsw, namespaceURI);
    }

    public static void writeAnnotationSet(Collection<Annotation> annotations, String asName, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        xsw.writeStartElement(namespaceURI, "AnnotationSet");
        if (asName != null) {
            xsw.writeAttribute("Name", asName);
        }
        DocumentStaxUtils.newLine(xsw);
        if (annotations != null) {
            for (Annotation annot : annotations) {
                xsw.writeStartElement(namespaceURI, "Annotation");
                xsw.writeAttribute("Id", String.valueOf(annot.getId()));
                xsw.writeAttribute("Type", annot.getType());
                xsw.writeAttribute("StartNode", String.valueOf(annot.getStartNode().getOffset()));
                xsw.writeAttribute("EndNode", String.valueOf(annot.getEndNode().getOffset()));
                DocumentStaxUtils.newLine(xsw);
                DocumentStaxUtils.writeFeatures(annot.getFeatures(), xsw, namespaceURI);
                xsw.writeEndElement();
                DocumentStaxUtils.newLine(xsw);
            }
        }
        xsw.writeEndElement();
        DocumentStaxUtils.newLine(xsw);
    }

    public static void writeRelationSet(RelationSet relations, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        if (relations == null || relations.size() == 0) {
            return;
        }
        xsw.writeComment(" Relation Set for " + relations.getAnnotationSet().getName() + " ");
        DocumentStaxUtils.newLine(xsw);
        DocumentStaxUtils.newLine(xsw);
        xsw.writeStartElement(namespaceURI, "RelationSet");
        if (relations.getAnnotationSet().getName() != null) {
            xsw.writeAttribute("Name", relations.getAnnotationSet().getName());
        }
        DocumentStaxUtils.newLine(xsw);
        for (Relation relation : relations.get()) {
            StringBuilder str = new StringBuilder();
            int[] members = relation.getMembers();
            for (int i = 0; i < members.length; ++i) {
                if (i > 0) {
                    str.append(";");
                }
                str.append(members[i]);
            }
            xsw.writeStartElement(namespaceURI, "Relation");
            xsw.writeAttribute("Id", String.valueOf(relation.getId()));
            xsw.writeAttribute("Type", relation.getType());
            xsw.writeAttribute("Members", str.toString());
            DocumentStaxUtils.newLine(xsw);
            xsw.writeStartElement(namespaceURI, "UserData");
            if (relation.getUserData() != null) {
                ObjectWrapper userData = new ObjectWrapper(relation.getUserData());
                DocumentStaxUtils.writeCharactersOrCDATA(xsw, DocumentStaxUtils.replaceXMLIllegalCharactersInString(userData.toString()));
            }
            xsw.writeEndElement();
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.writeFeatures(relation.getFeatures(), xsw, namespaceURI);
            xsw.writeEndElement();
            DocumentStaxUtils.newLine(xsw);
        }
        xsw.writeEndElement();
        DocumentStaxUtils.newLine(xsw);
    }

    public static void writeAnnotationSet(AnnotationSet annotations, String asName, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        DocumentStaxUtils.writeAnnotationSet((Collection<Annotation>)annotations, asName, xsw, namespaceURI);
    }

    public static void writeTextWithNodes(Document doc, Collection<Collection<Annotation>> annotationSets, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        String aText = doc.getContent().toString();
        if (aText == null) {
            xsw.writeEmptyElement(namespaceURI, "TextWithNodes");
            return;
        }
        TreeSet<Long> offsetsSet = new TreeSet<Long>();
        if (annotationSets != null) {
            for (Collection<Annotation> set : annotationSets) {
                if (set == null) continue;
                for (Annotation annot : set) {
                    offsetsSet.add(annot.getStartNode().getOffset());
                    offsetsSet.add(annot.getEndNode().getOffset());
                }
            }
        }
        char[] textArray = aText.toCharArray();
        xsw.writeStartElement(namespaceURI, "TextWithNodes");
        int lastNodeOffset = 0;
        Iterator offsetsIterator = offsetsSet.iterator();
        while (offsetsIterator.hasNext()) {
            int offset = ((Long)offsetsIterator.next()).intValue();
            DocumentStaxUtils.replaceXMLIllegalCharacters(textArray, lastNodeOffset, offset - lastNodeOffset);
            DocumentStaxUtils.writeCharactersOrCDATA(xsw, new String(textArray, lastNodeOffset, offset - lastNodeOffset));
            xsw.writeEmptyElement(namespaceURI, "Node");
            xsw.writeAttribute("id", String.valueOf(offset));
            lastNodeOffset = offset;
        }
        DocumentStaxUtils.replaceXMLIllegalCharacters(textArray, lastNodeOffset, textArray.length - lastNodeOffset);
        DocumentStaxUtils.writeCharactersOrCDATA(xsw, new String(textArray, lastNodeOffset, textArray.length - lastNodeOffset));
        xsw.writeEndElement();
    }

    public static void writeTextWithNodes(Document doc, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        ArrayList<Collection<Annotation>> annotationSets = new ArrayList<Collection<Annotation>>();
        annotationSets.add(doc.getAnnotations());
        if (doc.getNamedAnnotationSets() != null) {
            annotationSets.addAll(doc.getNamedAnnotationSets().values());
        }
        DocumentStaxUtils.writeTextWithNodes(doc, annotationSets, xsw, namespaceURI);
    }

    static void replaceXMLIllegalCharacters(char[] buf) {
        DocumentStaxUtils.replaceXMLIllegalCharacters(buf, 0, buf.length);
    }

    static void replaceXMLIllegalCharacters(char[] buf, int start, int len) {
        ArrayCharSequence bufSequence = new ArrayCharSequence(buf, start, len);
        for (int i = 0; i < len; ++i) {
            if (!DocumentStaxUtils.isInvalidXmlChar(bufSequence, i)) continue;
            buf[start + i] = 32;
        }
    }

    static String replaceXMLIllegalCharactersInString(String str) {
        StringBuilder builder = null;
        for (int i = 0; i < str.length(); ++i) {
            if (DocumentStaxUtils.isInvalidXmlChar(str, i)) {
                if (builder == null) {
                    builder = new StringBuilder(str.substring(0, i));
                }
                builder.append(' ');
                continue;
            }
            if (builder == null) continue;
            builder.append(str.charAt(i));
        }
        if (builder == null) {
            return str;
        }
        return builder.toString();
    }

    static final boolean isInvalidXmlChar(CharSequence buf, int i) {
        if (buf.charAt(i) <= '\b' || buf.charAt(i) == '\u000b' || buf.charAt(i) == '\f' || buf.charAt(i) >= '\u000e' && buf.charAt(i) <= '\u001f') {
            return true;
        }
        if (buf.charAt(i) >= '\ud800' && buf.charAt(i) <= '\udbff') {
            return i >= buf.length() - 1 || buf.charAt(i + 1) < '\udc00' || buf.charAt(i + 1) > '\udfff';
        }
        if (buf.charAt(i) >= '\udc00' && buf.charAt(i) <= '\udfff') {
            return i <= 0 || buf.charAt(i - 1) < '\ud800' || buf.charAt(i - 1) > '\udbff';
        }
        return buf.charAt(i) == '\ufffe' || buf.charAt(i) == '\uffff';
    }

    public static void writeFeatures(FeatureMap features, XMLStreamWriter xsw, String namespaceURI) throws XMLStreamException {
        if (features == null) {
            return;
        }
        Set keySet = features.keySet();
        for (Object key : keySet) {
            Object value = features.get(key);
            if (key == null || value == null) continue;
            String keyClassName = null;
            String valueClassName = null;
            String key2String = key.toString();
            String value2String = value.toString();
            if (key instanceof String || key instanceof Number) {
                keyClassName = key.getClass().getName();
            } else {
                keyClassName = ObjectWrapper.class.getName();
                key2String = new ObjectWrapper(key).toString();
            }
            if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                valueClassName = value.getClass().getName();
            } else {
                valueClassName = ObjectWrapper.class.getName();
                value2String = new ObjectWrapper(value).toString();
            }
            xsw.writeStartElement(namespaceURI, "Feature");
            xsw.writeCharacters("\n  ");
            xsw.writeStartElement(namespaceURI, "Name");
            if (keyClassName != null) {
                xsw.writeAttribute("className", keyClassName);
            }
            xsw.writeCharacters(key2String);
            xsw.writeEndElement();
            xsw.writeCharacters("\n  ");
            xsw.writeStartElement(namespaceURI, "Value");
            if (valueClassName != null) {
                xsw.writeAttribute("className", valueClassName);
            }
            DocumentStaxUtils.writeCharactersOrCDATA(xsw, DocumentStaxUtils.replaceXMLIllegalCharactersInString(value2String));
            xsw.writeEndElement();
            DocumentStaxUtils.newLine(xsw);
            xsw.writeEndElement();
            DocumentStaxUtils.newLine(xsw);
        }
    }

    static void newLine(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeCharacters("\n");
    }

    static void writeCharactersOrCDATA(XMLStreamWriter xsw, String string) throws XMLStreamException {
        if (DocumentStaxUtils.containsEnoughLTs(string)) {
            Matcher m = CDATA_END_PATTERN.matcher(string);
            int startFrom = 0;
            while (m.find()) {
                xsw.writeCData(string.substring(startFrom, m.start()));
                xsw.writeCharacters("]]>");
                startFrom = m.end();
            }
            if (startFrom == 0) {
                xsw.writeCData(string);
            } else if (startFrom < string.length()) {
                xsw.writeCData(string.substring(startFrom));
            }
        } else {
            xsw.writeCharacters(string);
        }
    }

    private static boolean containsEnoughLTs(String string) {
        int numLTs = 0;
        int index = -1;
        while ((index = string.indexOf(60, index + 1)) >= 0) {
            if (++numLTs < 5) continue;
            return true;
        }
        return false;
    }

    public static void writeXcesContent(Document doc, OutputStream out, String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String documentContent = doc.getContent().toString();
        OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
        BufferedWriter writer = new BufferedWriter(osw);
        writer.write(documentContent);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXcesAnnotations(Collection<Annotation> annotations, OutputStream os, String encoding) throws XMLStreamException {
        try (XMLStreamWriter xsw = null;){
            if (outputFactory == null) {
                outputFactory = XMLOutputFactory.newInstance();
            }
            if (encoding == null) {
                xsw = outputFactory.createXMLStreamWriter(os);
                xsw.writeStartDocument();
            } else {
                xsw = outputFactory.createXMLStreamWriter(os, encoding);
                xsw.writeStartDocument(encoding, XCES_VERSION);
            }
            DocumentStaxUtils.newLine(xsw);
            DocumentStaxUtils.writeXcesAnnotations(annotations, xsw);
        }
    }

    public static void writeXcesAnnotations(Collection<Annotation> annotations, XMLStreamWriter xsw) throws XMLStreamException {
        DocumentStaxUtils.writeXcesAnnotations(annotations, xsw, true);
    }

    public static void writeXcesAnnotations(Collection<Annotation> annotations, XMLStreamWriter xsw, boolean includeId) throws XMLStreamException {
        ArrayList<Annotation> annotsToDump = new ArrayList<Annotation>(annotations);
        Collections.sort(annotsToDump, LONGEST_FIRST_OFFSET_COMPARATOR);
        xsw.setDefaultNamespace(XCES_NAMESPACE);
        xsw.writeStartElement(XCES_NAMESPACE, "cesAna");
        xsw.writeDefaultNamespace(XCES_NAMESPACE);
        xsw.writeAttribute("version", XCES_VERSION);
        DocumentStaxUtils.newLine(xsw);
        String indent = "   ";
        String indentMore = indent + indent;
        for (Annotation a : annotsToDump) {
            long start = a.getStartNode().getOffset();
            long end = a.getEndNode().getOffset();
            FeatureMap fm = a.getFeatures();
            xsw.writeCharacters(indent);
            if (fm == null || fm.size() == 0) {
                xsw.writeEmptyElement(XCES_NAMESPACE, "struct");
            } else {
                xsw.writeStartElement(XCES_NAMESPACE, "struct");
            }
            xsw.writeAttribute("type", a.getType());
            xsw.writeAttribute("from", String.valueOf(start));
            xsw.writeAttribute("to", String.valueOf(end));
            if (includeId) {
                xsw.writeAttribute("n", String.valueOf(a.getId()));
            }
            DocumentStaxUtils.newLine(xsw);
            if (fm == null || fm.size() == 0) continue;
            for (Map.Entry att : fm.entrySet()) {
                if ("isEmptyAndSpan".equals(att.getKey())) continue;
                xsw.writeCharacters(indentMore);
                xsw.writeEmptyElement(XCES_NAMESPACE, "feat");
                xsw.writeAttribute("name", String.valueOf(att.getKey()));
                xsw.writeAttribute("value", DocumentStaxUtils.replaceXMLIllegalCharactersInString(String.valueOf(att.getValue())));
                DocumentStaxUtils.newLine(xsw);
            }
            xsw.writeCharacters(indent);
            xsw.writeEndElement();
            DocumentStaxUtils.newLine(xsw);
        }
        xsw.writeEndElement();
        DocumentStaxUtils.newLine(xsw);
    }

    static class ArrayCharSequence
    implements CharSequence {
        char[] array;
        int offset;
        int len;

        ArrayCharSequence(char[] array) {
            this(array, 0, array.length);
        }

        ArrayCharSequence(char[] array, int offset, int len) {
            this.array = array;
            this.offset = offset;
            this.len = len;
        }

        @Override
        public final char charAt(int i) {
            return this.array[this.offset + i];
        }

        @Override
        public final int length() {
            return this.len;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayCharSequence(this.array, this.offset + start, this.offset + end);
        }

        @Override
        public String toString() {
            return String.valueOf(this.array, this.offset, this.len);
        }
    }

    static class AnnotationObject {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setElemName(String anElemName) {
            this.elemName = anElemName;
        }

        public void setFM(FeatureMap aFm) {
            this.fm = aFm;
        }

        public void setStart(Long aStart) {
            this.start = aStart;
        }

        public void setEnd(Long anEnd) {
            this.end = anEnd;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer anId) {
            this.id = anId;
        }

        public String toString() {
            return " [id =" + this.id + " type=" + this.elemName + " startNode=" + this.start + " endNode=" + this.end + " features=" + this.fm + "] ";
        }
    }
}

