/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import gate.Annotation;
import gate.Document;
import gate.corpora.RepositioningInfo;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentJsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Pattern CHARS_TO_ESCAPE = Pattern.compile("[<>&\\x{" + Integer.toHexString(65536) + "}-\\x{" + Integer.toHexString(0x10FFFF) + "}]");

    public static void writeDocument(Document doc, Map<String, Collection<Annotation>> annotationsMap, OutputStream out) throws JsonGenerationException, IOException {
        try (JsonGenerator jsonG = JSON_FACTORY.createGenerator(out);){
            DocumentJsonUtils.writeDocument(doc, annotationsMap, jsonG);
        }
    }

    public static void writeDocument(Document doc, Map<String, Collection<Annotation>> annotationsMap, Writer out) throws JsonGenerationException, IOException {
        try (JsonGenerator jsonG = JSON_FACTORY.createGenerator(out);){
            DocumentJsonUtils.writeDocument(doc, annotationsMap, jsonG);
        }
    }

    public static void writeDocument(Document doc, Map<String, Collection<Annotation>> annotationsMap, File out) throws JsonGenerationException, IOException {
        try (JsonGenerator jsonG = JSON_FACTORY.createGenerator(out, JsonEncoding.UTF8);){
            DocumentJsonUtils.writeDocument(doc, annotationsMap, jsonG);
        }
    }

    public static String toJson(Document doc, Map<String, Collection<Annotation>> annotationsMap) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = JSON_FACTORY.createGenerator((Writer)sw);
        DocumentJsonUtils.writeDocument(doc, annotationsMap, gen);
        gen.close();
        return sw.toString();
    }

    public static void writeDocument(Document doc, Map<String, Collection<Annotation>> annotationsMap, JsonGenerator json) throws JsonGenerationException, IOException {
        try {
            DocumentJsonUtils.writeDocument(doc, 0L, doc.getContent().size(), annotationsMap, json);
        }
        catch (InvalidOffsetException e) {
            throw new GateRuntimeException("Got invalid offset exception when passing offsets that are known to be valid");
        }
    }

    public static void writeDocument(Document doc, Long start, Long end, Map<String, Collection<Annotation>> annotationsMap, JsonGenerator json) throws JsonGenerationException, IOException, InvalidOffsetException {
        DocumentJsonUtils.writeDocument(doc, start, end, annotationsMap, null, null, json);
    }

    public static void writeDocument(Document doc, Long start, Long end, Map<String, Collection<Annotation>> annotationsMap, Map<?, ?> extraFeatures, JsonGenerator json) throws JsonGenerationException, IOException, InvalidOffsetException {
        DocumentJsonUtils.writeDocument(doc, start, end, annotationsMap, extraFeatures, null, json);
    }

    public static void writeDocument(Document doc, Long start, Long end, Map<String, Collection<Annotation>> annotationsMap, Map<?, ?> extraFeatures, String annotationTypeProperty, JsonGenerator json) throws JsonGenerationException, IOException, InvalidOffsetException {
        DocumentJsonUtils.writeDocument(doc, start, end, annotationsMap, extraFeatures, annotationTypeProperty, null, json);
    }

    public static void writeDocument(Document doc, Long start, Long end, Map<String, Collection<Annotation>> annotationsMap, Map<?, ?> extraFeatures, String annotationTypeProperty, String annotationIDProperty, JsonGenerator json) throws JsonGenerationException, IOException, InvalidOffsetException {
        ObjectWriter writer = MAPPER.writer();
        json.writeStartObject();
        RepositioningInfo repos = new RepositioningInfo();
        String text = DocumentJsonUtils.escape(doc.getContent().getContent(start, end).toString(), repos);
        json.writeStringField("text", text);
        json.writeFieldName("entities");
        json.writeStartObject();
        Object entitiesExtraFeature = extraFeatures == null ? null : extraFeatures.get("entities");
        Map entitiesMap = null;
        if (entitiesExtraFeature instanceof Map) {
            entitiesMap = entitiesExtraFeature;
        }
        for (Map.Entry<String, Collection<Annotation>> entry : annotationsMap.entrySet()) {
            String annotationType = entry.getKey();
            Collection<Annotation> annotations = entry.getValue();
            json.writeFieldName(annotationType);
            json.writeStartArray();
            for (Annotation a : annotations) {
                json.writeStartObject();
                json.writeArrayFieldStart("indices");
                json.writeNumber(repos.getOriginalPos(a.getStartNode().getOffset() - start, true));
                json.writeNumber(repos.getOriginalPos(a.getEndNode().getOffset() - start, false));
                json.writeEndArray();
                if (annotationTypeProperty != null) {
                    json.writeStringField(annotationTypeProperty, a.getType());
                }
                if (annotationIDProperty != null) {
                    json.writeNumberField(annotationIDProperty, a.getId().intValue());
                }
                for (Map.Entry feature : a.getFeatures().entrySet()) {
                    if (annotationTypeProperty != null && annotationTypeProperty.equals(feature.getKey())) continue;
                    json.writeFieldName(String.valueOf(feature.getKey()));
                    writer.writeValue(json, feature.getValue());
                }
                json.writeEndObject();
            }
            if (entitiesMap != null && entitiesMap.get(annotationType) instanceof Collection) {
                for (Annotation ent : (Collection)entitiesMap.get(annotationType)) {
                    writer.writeValue(json, (Object)ent);
                }
            }
            json.writeEndArray();
        }
        if (entitiesMap != null) {
            for (Map.Entry<String, Collection<Annotation>> entry : entitiesMap.entrySet()) {
                if (annotationsMap.containsKey(entry.getKey())) continue;
                json.writeFieldName(String.valueOf(entry.getKey()));
                writer.writeValue(json, entry.getValue());
            }
        }
        json.writeEndObject();
        if (extraFeatures != null) {
            for (Map.Entry<String, Collection<Annotation>> entry : extraFeatures.entrySet()) {
                if ("text".equals(entry.getKey()) || "entities".equals(entry.getKey())) continue;
                json.writeFieldName(String.valueOf(entry.getKey()));
                writer.writeValue(json, entry.getValue());
            }
        }
        json.writeEndObject();
        json.flush();
    }

    private static String escape(String str, RepositioningInfo repos) {
        StringBuffer buf = new StringBuffer();
        int origOffset = 0;
        int extractedOffset = 0;
        Matcher mat = CHARS_TO_ESCAPE.matcher(str);
        while (mat.find()) {
            if (mat.start() != extractedOffset) {
                int nonMatchLen = mat.start() - extractedOffset;
                repos.addPositionInfo(origOffset, nonMatchLen, extractedOffset, nonMatchLen);
                origOffset += nonMatchLen;
                extractedOffset += nonMatchLen;
            }
            int extractedLen = mat.end() - mat.start();
            int origLen = 0;
            String replace = "?";
            switch (mat.group()) {
                case "&": {
                    replace = "&amp;";
                    origLen = 5;
                    break;
                }
                case ">": {
                    replace = "&gt;";
                    origLen = 4;
                    break;
                }
                case "<": {
                    replace = "&lt;";
                    origLen = 4;
                    break;
                }
                default: {
                    replace = mat.group();
                    origLen = 1;
                }
            }
            repos.addPositionInfo(origOffset, origLen, extractedOffset, extractedLen);
            mat.appendReplacement(buf, replace);
            origOffset += origLen;
            extractedOffset += extractedLen;
        }
        int tailLen = str.length() - extractedOffset;
        if (tailLen > 0) {
            repos.addPositionInfo(origOffset, tailLen + 1, extractedOffset, tailLen + 1);
        }
        mat.appendTail(buf);
        return buf.toString();
    }
}

