/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.DataStore;
import gate.Document;
import gate.DocumentContent;
import gate.DocumentFormat;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Node;
import gate.Resource;
import gate.TextualDocument;
import gate.annotation.AnnotationSetImpl;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentStaxUtils;
import gate.corpora.DocumentXmlUtils;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.XmlDocumentFormat;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.StatusListener;
import gate.persist.PersistenceException;
import gate.util.DocumentFormatException;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

@CreoleResource(name="GATE Document", interfaceName="gate.Document", comment="GATE transient document.", icon="document", helpURL="http://gate.ac.uk/userguide/sec:developer:documents")
public class DocumentImpl
extends AbstractLanguageResource
implements TextualDocument,
CreoleListener,
DatastoreListener {
    private static final boolean DEBUG = false;
    private Boolean preserveOriginalContent = Boolean.FALSE;
    private Boolean collectRepositioningInfo = Boolean.FALSE;
    private Annotation crossedOverAnnotation = null;
    private boolean serializeNamespaceInfo = false;
    private String namespaceURIFeature = null;
    private String namespacePrefixFeature = null;
    protected int nextAnnotationId = 0;
    protected int nextNodeId = 0;
    protected URL sourceUrl;
    protected String mimeType;
    protected DocumentContent content;
    protected String encoding = null;
    private Annotation theRootAnnotation = null;
    private static final int DOC_SIZE_MULTIPLICATION_FACTOR_AS = 3;
    private static final int ORDER_ON_START_OFFSET = 0;
    private static final int ORDER_ON_END_OFFSET = 1;
    private static final int ORDER_ON_ANNOT_ID = 2;
    private static final int ASC = 3;
    private static final int DESC = -3;
    protected Long sourceUrlStartOffset;
    protected Long sourceUrlEndOffset;
    protected AnnotationSet defaultAnnots;
    protected Map<String, AnnotationSet> namedAnnotSets;
    private String stringContent = "";
    protected Boolean markupAware = Boolean.FALSE;
    static final long serialVersionUID = -8456893608311510260L;
    private transient Vector<DocumentListener> documentListeners;

    public DocumentImpl() {
        this.content = new DocumentContentImpl();
        OptionsMap configData = Gate.getUserConfig();
        boolean addNSFeature = Boolean.parseBoolean((String)configData.get("addNamespaceFeatures"));
        this.namespaceURIFeature = (String)configData.get("namespaceURI");
        this.namespacePrefixFeature = (String)configData.get("namespacePrefix");
        this.serializeNamespaceInfo = addNSFeature && this.namespacePrefixFeature != null && !this.namespacePrefixFeature.isEmpty() && this.namespaceURIFeature != null && !this.namespaceURIFeature.isEmpty();
    }

    @Override
    public FeatureMap getFeatures() {
        if (this.features == null) {
            this.features = new SimpleFeatureMapImpl();
        }
        return this.features;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        if (this.sourceUrl == null) {
            if (this.stringContent == null) {
                throw new ResourceInstantiationException("The sourceURL and document's content were null.");
            }
            this.content = new DocumentContentImpl(this.stringContent);
            this.getFeatures().put("gate.SourceURL", "created from String");
        } else {
            try {
                this.content = new DocumentContentImpl(this.sourceUrl, this.getEncoding(), this.sourceUrlStartOffset, this.sourceUrlEndOffset);
                this.getFeatures().put("gate.SourceURL", this.sourceUrl.toExternalForm());
            }
            catch (IOException e) {
                throw new ResourceInstantiationException("DocumentImpl.init: " + e);
            }
        }
        if (this.preserveOriginalContent.booleanValue() && this.content != null) {
            String originalContent = ((DocumentContentImpl)this.content).getOriginalContent();
            this.getFeatures().put("Original_document_content_on_load", originalContent);
        }
        if (this.getMarkupAware().booleanValue()) {
            DocumentFormat docFormat = null;
            if (this.mimeType != null && this.mimeType.length() > 0) {
                MimeType theType = DocumentFormat.getMimeTypeForString(this.mimeType);
                if (theType == null) {
                    throw new ResourceInstantiationException("MIME type \"" + this.mimeType + " has no registered DocumentFormat");
                }
                docFormat = DocumentFormat.getDocumentFormat((Document)this, theType);
            } else {
                docFormat = DocumentFormat.getDocumentFormat((Document)this, this.sourceUrl);
            }
            try {
                if (docFormat != null) {
                    StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
                    if (sListener != null) {
                        docFormat.addStatusListener(sListener);
                    }
                    docFormat.setShouldCollectRepositioning(this.collectRepositioningInfo);
                    if (docFormat.getShouldCollectRepositioning().booleanValue()) {
                        RepositioningInfo info = new RepositioningInfo();
                        String origContent = (String)this.getFeatures().get("Original_document_content_on_load");
                        RepositioningInfo ampCodingInfo = new RepositioningInfo();
                        if (origContent != null) {
                            boolean shouldCorrectCR = docFormat instanceof XmlDocumentFormat;
                            this.collectInformationForAmpCodding(origContent, ampCodingInfo, shouldCorrectCR);
                            if (docFormat.getMimeType().equals(new MimeType("text", "html"))) {
                                this.collectInformationForWS(origContent, ampCodingInfo);
                            }
                        }
                        docFormat.unpackMarkup(this, info, ampCodingInfo);
                        if (origContent != null && docFormat instanceof XmlDocumentFormat) {
                            this.correctRepositioningForCRLFInXML(origContent, info);
                        }
                        this.getFeatures().put("Document_repositioning_info", info);
                    } else {
                        docFormat.unpackMarkup(this);
                    }
                    docFormat.removeStatusListener(sListener);
                }
            }
            catch (DocumentFormatException e) {
                throw new ResourceInstantiationException("Couldn't unpack markup in document " + (this.sourceUrl != null ? this.sourceUrl.toExternalForm() : "") + "!", e);
            }
        }
        return this;
    }

    private void correctRepositioningForCRLFInXML(String content, RepositioningInfo info) {
        int index = -1;
        do {
            if ((index = content.indexOf("\r\n", index + 1)) == -1) continue;
            info.correctInformationOriginalMove(index, 1L);
        } while (index != -1);
    }

    private void collectInformationForAmpCodding(String content, RepositioningInfo info, boolean shouldCorrectCR) {
        if (content == null || info == null) {
            return;
        }
        int ampIndex = -1;
        do {
            if ((ampIndex = content.indexOf(38, ampIndex + 1)) == -1) continue;
            int semiIndex = content.indexOf(59, ampIndex + 1);
            if (semiIndex != -1 && semiIndex - ampIndex < 8) {
                info.addPositionInfo(ampIndex, semiIndex - ampIndex + 1, 0L, 1L);
                continue;
            }
            int maxEnd = Math.min(ampIndex + 8, content.length());
            String ampCandidate = content.substring(ampIndex, maxEnd);
            int ampCodingSize = this.analyseAmpCodding(ampCandidate);
            if (ampCodingSize == -1) continue;
            info.addPositionInfo(ampIndex, ampCodingSize, 0L, 1L);
        } while (ampIndex != -1);
        int index = -1;
        if (shouldCorrectCR) {
            do {
                if ((index = content.indexOf("\r\n", index + 1)) == -1) continue;
                info.correctInformationOriginalMove(index, -1L);
            } while (index != -1);
        }
    }

    private int analyseAmpCodding(String content) {
        int result = -1;
        try {
            char ch = content.charAt(1);
            switch (ch) {
                case 'L': 
                case 'l': {
                    if (content.charAt(2) != 't' && content.charAt(2) != 'T') break;
                    result = 3;
                    break;
                }
                case 'G': 
                case 'g': {
                    if (content.charAt(2) != 't' && content.charAt(2) != 'T') break;
                    result = 3;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (!content.substring(2, 4).equalsIgnoreCase("mp")) break;
                    result = 4;
                    break;
                }
                case 'Q': 
                case 'q': {
                    if (!content.substring(2, 5).equalsIgnoreCase("uot")) break;
                    result = 5;
                    break;
                }
                case '#': {
                    int endIndex = 2;
                    boolean hexCoded = false;
                    if (content.charAt(2) == 'x' || content.charAt(2) == 'X') {
                        ++endIndex;
                        hexCoded = true;
                    }
                    while (endIndex < 8 && this.isNumber(content.charAt(endIndex), hexCoded)) {
                        ++endIndex;
                    }
                    result = endIndex;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private boolean isNumber(char ch, boolean hex) {
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (hex) {
            if (ch >= 'A' && ch <= 'F') {
                return true;
            }
            if (ch >= 'a' && ch <= 'f') {
                return true;
            }
        }
        return false;
    }

    private void collectInformationForWS(String content, RepositioningInfo info) {
        if (content == null || info == null) {
            return;
        }
        int endWS = -1;
        int startWS = -1;
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            char ch = content.charAt(i);
            if (ch <= ' ') {
                if (startWS == -1) {
                    startWS = i;
                }
                endWS = i;
                continue;
            }
            if (endWS - startWS > 0) {
                info.addPositionInfo(startWS, endWS - startWS + 1, 0L, 1L);
            }
            endWS = -1;
            startWS = -1;
        }
    }

    @Override
    public void cleanup() {
        this.defaultAnnots = null;
        if (this.namedAnnotSets != null && !this.namedAnnotSets.isEmpty()) {
            this.namedAnnotSets.clear();
        }
        if (this.lrPersistentId != null) {
            Gate.getCreoleRegister().removeCreoleListener(this);
        }
        if (this.getDataStore() != null) {
            this.getDataStore().removeDatastoreListener(this);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    @Optional
    @CreoleParameter(comment="MIME type of the document.  If unspecified it will be inferred from the file extension, etc.")
    public void setMimeType(String newMimeType) {
        this.mimeType = newMimeType;
    }

    @Override
    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    @CreoleParameter(disjunction="source", priority=1, comment="Source URL", suffixes="txt;text;xml;xhtm;xhtml;html;htm;sgml;sgm;mail;email;eml;rtf;pdf;doc;ppt;pptx;docx;xls;xlsx;ods;odt;odp;iob;conll")
    public void setSourceUrl(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @Override
    public Long[] getSourceUrlOffsets() {
        Long[] sourceUrlOffsets = new Long[]{this.sourceUrlStartOffset, this.sourceUrlEndOffset};
        return sourceUrlOffsets;
    }

    @Override
    @CreoleParameter(comment="Should the document preserve the original content?", defaultValue="false")
    public void setPreserveOriginalContent(Boolean b) {
        this.preserveOriginalContent = b;
    }

    @Override
    public Boolean getPreserveOriginalContent() {
        return this.preserveOriginalContent;
    }

    @Override
    @CreoleParameter(defaultValue="false", comment="Should the document collect repositioning information")
    public void setCollectRepositioningInfo(Boolean b) {
        this.collectRepositioningInfo = b;
    }

    @Override
    public Boolean getCollectRepositioningInfo() {
        return this.collectRepositioningInfo;
    }

    @Override
    public Long getSourceUrlStartOffset() {
        return this.sourceUrlStartOffset;
    }

    @Override
    @Optional
    @CreoleParameter(comment="Start offset for documents based on ranges")
    public void setSourceUrlStartOffset(Long sourceUrlStartOffset) {
        this.sourceUrlStartOffset = sourceUrlStartOffset;
    }

    @Override
    public Long getSourceUrlEndOffset() {
        return this.sourceUrlEndOffset;
    }

    @Override
    @Optional
    @CreoleParameter(comment="End offset for documents based on ranges")
    public void setSourceUrlEndOffset(Long sourceUrlEndOffset) {
        this.sourceUrlEndOffset = sourceUrlEndOffset;
    }

    @Override
    public DocumentContent getContent() {
        return this.content;
    }

    @Override
    public void setContent(DocumentContent content) {
        this.content = content;
    }

    @Override
    public String getEncoding() {
        if (this.encoding == null || this.encoding.trim().length() == 0) {
            this.encoding = Charset.forName(System.getProperty("file.encoding")).name();
        }
        return this.encoding;
    }

    @Optional
    @CreoleParameter(comment="Encoding")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public AnnotationSet getAnnotations() {
        if (this.defaultAnnots == null) {
            this.defaultAnnots = new AnnotationSetImpl(this, "");
            this.fireAnnotationSetAdded(new DocumentEvent(this, 101, ""));
        }
        return this.defaultAnnots;
    }

    @Override
    public AnnotationSet getAnnotations(String name) {
        AnnotationSet namedSet;
        if (name == null || "".equals(name)) {
            return this.getAnnotations();
        }
        if (this.namedAnnotSets == null) {
            this.namedAnnotSets = new HashMap<String, AnnotationSet>();
        }
        if ((namedSet = this.namedAnnotSets.get(name)) == null) {
            namedSet = new AnnotationSetImpl(this, name);
            this.namedAnnotSets.put(name, namedSet);
            DocumentEvent evt = new DocumentEvent(this, 101, name);
            this.fireAnnotationSetAdded(evt);
        }
        return namedSet;
    }

    @Override
    @CreoleParameter(defaultValue="true", comment="Should the document read the original markup?")
    public void setMarkupAware(Boolean newMarkupAware) {
        this.markupAware = newMarkupAware;
    }

    @Override
    public Boolean getMarkupAware() {
        return this.markupAware;
    }

    @Override
    public String toXml(Set<Annotation> aSourceAnnotationSet) {
        return this.toXml(aSourceAnnotationSet, true);
    }

    @Override
    public String toXml(Set<Annotation> aSourceAnnotationSet, boolean includeFeatures) {
        boolean wasXML;
        if (this.hasOriginalContentFeatures()) {
            return this.saveAnnotationSetAsXmlInOrig(aSourceAnnotationSet, includeFeatures);
        }
        AnnotationSet originalMarkupsAnnotSet = this.getAnnotations("Original markups");
        ArrayList<Annotation> dumpingList = new ArrayList<Annotation>(originalMarkupsAnnotSet.size());
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        if (sListener != null) {
            sListener.statusChanged("Constructing the dumping annotation set.");
        }
        dumpingList.addAll(originalMarkupsAnnotSet);
        if (aSourceAnnotationSet != null) {
            for (Annotation currentAnnot : aSourceAnnotationSet) {
                if (this.insertsSafety(dumpingList, currentAnnot)) {
                    dumpingList.add(currentAnnot);
                    continue;
                }
                if (this.crossedOverAnnotation == null) continue;
            }
        }
        Collections.sort(dumpingList, new OffsetComparator());
        if (sListener != null) {
            sListener.statusChanged("Dumping annotations as XML");
        }
        StringBuffer xmlDoc = new StringBuffer(40 * this.getContent().size().intValue());
        String mimeType = (String)this.getFeatures().get("MimeType");
        boolean bl = wasXML = mimeType != null && mimeType.equalsIgnoreCase("text/xml");
        if (wasXML) {
            xmlDoc.append("<?xml version=\"1.0\" encoding=\"");
            xmlDoc.append(this.getEncoding());
            xmlDoc.append("\" ?>");
            xmlDoc.append(Strings.getNl());
        }
        this.theRootAnnotation = this.identifyTheRootAnnotation(dumpingList);
        if (this.theRootAnnotation != null) {
            dumpingList.remove(this.theRootAnnotation);
            xmlDoc.append(this.writeStartTag(this.theRootAnnotation, includeFeatures));
        }
        xmlDoc.append(this.saveAnnotationSetAsXml(dumpingList, includeFeatures));
        if (this.theRootAnnotation != null) {
            xmlDoc.append(this.writeEndTag(this.theRootAnnotation));
        }
        if (sListener != null) {
            sListener.statusChanged("Done.");
        }
        return xmlDoc.toString();
    }

    private boolean insertsSafety(AnnotationSet aTargetAnnotSet, Annotation aSourceAnnotation) {
        if (aTargetAnnotSet == null || aSourceAnnotation == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (aSourceAnnotation.getStartNode() == null || aSourceAnnotation.getStartNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (aSourceAnnotation.getEndNode() == null || aSourceAnnotation.getEndNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        Long start = aSourceAnnotation.getStartNode().getOffset();
        Long end = aSourceAnnotation.getEndNode().getOffset();
        long s2 = start;
        long e2 = end;
        AnnotationSet as = aTargetAnnotSet.get(start, end);
        for (Annotation ann : as) {
            long s1 = ann.getStartNode().getOffset();
            long e1 = ann.getEndNode().getOffset();
            if (s1 < s2 && s2 < e1 && e1 < e2) {
                this.crossedOverAnnotation = ann;
                return false;
            }
            if (s2 >= s1 || s1 >= e2 || e2 >= e1) continue;
            this.crossedOverAnnotation = ann;
            return false;
        }
        return true;
    }

    private boolean insertsSafety(List<Annotation> aTargetAnnotList, Annotation aSourceAnnotation) {
        if (aTargetAnnotList == null || aSourceAnnotation == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (aSourceAnnotation.getStartNode() == null || aSourceAnnotation.getStartNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        if (aSourceAnnotation.getEndNode() == null || aSourceAnnotation.getEndNode().getOffset() == null) {
            this.crossedOverAnnotation = null;
            return false;
        }
        Long start = aSourceAnnotation.getStartNode().getOffset();
        Long end = aSourceAnnotation.getEndNode().getOffset();
        long s2 = start;
        long e2 = end;
        ArrayList<Annotation> as = new ArrayList<Annotation>();
        for (int i = 0; i < aTargetAnnotList.size(); ++i) {
            Annotation annot = aTargetAnnotList.get(i);
            if (annot.getStartNode().getOffset() >= s2 && annot.getStartNode().getOffset() <= e2) {
                as.add(annot);
                continue;
            }
            if (annot.getEndNode().getOffset() < s2 || annot.getEndNode().getOffset() > e2) continue;
            as.add(annot);
        }
        for (Annotation ann : as) {
            long s1 = ann.getStartNode().getOffset();
            long e1 = ann.getEndNode().getOffset();
            if (s1 < s2 && s2 < e1 && e1 < e2) {
                this.crossedOverAnnotation = ann;
                return false;
            }
            if (s2 >= s1 || s1 >= e2 || e2 >= e1) continue;
            this.crossedOverAnnotation = ann;
            return false;
        }
        return true;
    }

    private String saveAnnotationSetAsXml(AnnotationSet aDumpAnnotSet, boolean includeFeatures) {
        String content = null;
        content = this.getContent() == null ? "" : this.getContent().toString();
        StringBuffer docContStrBuff = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(content));
        if (aDumpAnnotSet == null) {
            return docContStrBuff.toString();
        }
        TreeMap<Long, Character> offsets2CharsMap = new TreeMap<Long, Character>();
        if (this.getContent().size() != 0L) {
            this.buildEntityMapFromString(content, offsets2CharsMap);
        }
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (Annotation annot : aDumpAnnotSet) {
            offsets.add(annot.getStartNode().getOffset());
            offsets.add(annot.getEndNode().getOffset());
        }
        while (!offsets.isEmpty()) {
            Long offset = (Long)offsets.last();
            offsets.remove(offset);
            List<Annotation> annotations = this.getAnnotationsForOffset(aDumpAnnotSet, offset);
            StringBuffer tmpBuff = new StringBuffer(3 * this.getContent().size().intValue());
            Stack<Annotation> stack = new Stack<Annotation>();
            Iterator<Annotation> it = annotations.iterator();
            while (it.hasNext()) {
                Annotation a1;
                Annotation a = it.next();
                it.remove();
                if (offset.equals(a.getEndNode().getOffset())) {
                    if (offset.equals(a.getStartNode().getOffset())) {
                        if (null != a.getFeatures().get("isEmptyAndSpan") && "true".equals(a.getFeatures().get("isEmptyAndSpan"))) {
                            tmpBuff.append(this.writeStartTag(a, includeFeatures));
                            stack.push(a);
                            continue;
                        }
                        tmpBuff.append(this.writeEmptyTag(a));
                        aDumpAnnotSet.remove(a);
                        continue;
                    }
                    if (!stack.isEmpty()) {
                        while (!stack.isEmpty()) {
                            a1 = (Annotation)stack.pop();
                            tmpBuff.append(this.writeEndTag(a1));
                        }
                    }
                    tmpBuff.append(this.writeEndTag(a));
                    continue;
                }
                if (!offset.equals(a.getStartNode().getOffset())) continue;
                if (!stack.isEmpty()) {
                    while (!stack.isEmpty()) {
                        a1 = (Annotation)stack.pop();
                        tmpBuff.append(this.writeEndTag(a1));
                    }
                }
                tmpBuff.append(this.writeStartTag(a, includeFeatures));
                aDumpAnnotSet.remove(a);
            }
            if (!stack.isEmpty()) {
                while (!stack.isEmpty()) {
                    Annotation a1 = (Annotation)stack.pop();
                    tmpBuff.append(this.writeEndTag(a1));
                }
            }
            if (!offsets2CharsMap.isEmpty()) {
                Long offsChar = offsets2CharsMap.lastKey();
                while (!offsets2CharsMap.isEmpty() && offsChar.intValue() >= offset.intValue()) {
                    docContStrBuff.replace(offsChar.intValue(), offsChar.intValue() + 1, DocumentXmlUtils.entitiesMap.get(offsets2CharsMap.get(offsChar)));
                    offsets2CharsMap.remove(offsChar);
                    if (offsets2CharsMap.isEmpty()) continue;
                    offsChar = offsets2CharsMap.lastKey();
                }
            }
            docContStrBuff.insert(offset.intValue(), tmpBuff.toString());
        }
        while (!offsets2CharsMap.isEmpty()) {
            Long offsChar = offsets2CharsMap.lastKey();
            docContStrBuff.replace(offsChar.intValue(), offsChar.intValue() + 1, DocumentXmlUtils.entitiesMap.get(offsets2CharsMap.get(offsChar)));
            offsets2CharsMap.remove(offsChar);
        }
        return docContStrBuff.toString();
    }

    private String saveAnnotationSetAsXml(List<Annotation> aDumpAnnotList, boolean includeFeatures) {
        String content = this.getContent() == null ? "" : this.getContent().toString();
        StringBuffer docContStrBuff = DocumentXmlUtils.filterNonXmlChars(new StringBuffer(content));
        if (aDumpAnnotList == null) {
            return docContStrBuff.toString();
        }
        StringBuffer resultStrBuff = new StringBuffer(3 * this.getContent().size().intValue());
        Long lastOffset = 0L;
        TreeMap<Long, Character> offsets2CharsMap = new TreeMap<Long, Character>();
        HashMap annotsForOffset = new HashMap(100);
        if (this.getContent().size() != 0L) {
            this.buildEntityMapFromString(content, offsets2CharsMap);
        }
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (Annotation annot : aDumpAnnotList) {
            ArrayList<Annotation> newList;
            Long start = annot.getStartNode().getOffset();
            Long end = annot.getEndNode().getOffset();
            offsets.add(start);
            offsets.add(end);
            if (annotsForOffset.containsKey(start)) {
                ((List)annotsForOffset.get(start)).add(annot);
            } else {
                newList = new ArrayList<Annotation>(10);
                newList.add(annot);
                annotsForOffset.put(start, newList);
            }
            if (annotsForOffset.containsKey(end)) {
                ((List)annotsForOffset.get(end)).add(annot);
                continue;
            }
            newList = new ArrayList(10);
            newList.add(annot);
            annotsForOffset.put(end, newList);
        }
        Iterator offsetIt = offsets.iterator();
        StringBuffer tmpBuff = new StringBuffer(255);
        Stack<Annotation> stack = new Stack<Annotation>();
        while (offsetIt.hasNext()) {
            Annotation annStack;
            Long offset = (Long)offsetIt.next();
            List<Annotation> annotations = (List<Annotation>)annotsForOffset.get(offset);
            annotations = this.getAnnotationsForOffset(annotations, offset);
            tmpBuff.setLength(0);
            stack.clear();
            for (Annotation a : annotations) {
                if (offset.equals(a.getEndNode().getOffset())) {
                    if (offset.equals(a.getStartNode().getOffset())) {
                        if (null != a.getFeatures().get("isEmptyAndSpan") && "true".equals(a.getFeatures().get("isEmptyAndSpan"))) {
                            tmpBuff.append(this.writeStartTag(a, includeFeatures));
                            stack.push(a);
                            continue;
                        }
                        tmpBuff.append(this.writeEmptyTag(a));
                        aDumpAnnotList.remove(a);
                        continue;
                    }
                    if (!stack.isEmpty()) {
                        while (!stack.isEmpty()) {
                            annStack = (Annotation)stack.pop();
                            tmpBuff.append(this.writeEndTag(annStack));
                        }
                    }
                    tmpBuff.append(this.writeEndTag(a));
                    continue;
                }
                if (!offset.equals(a.getStartNode().getOffset())) continue;
                if (!stack.isEmpty()) {
                    while (!stack.isEmpty()) {
                        annStack = (Annotation)stack.pop();
                        tmpBuff.append(this.writeEndTag(annStack));
                    }
                }
                tmpBuff.append(this.writeStartTag(a, includeFeatures));
            }
            if (!stack.isEmpty()) {
                while (!stack.isEmpty()) {
                    annStack = (Annotation)stack.pop();
                    tmpBuff.append(this.writeEndTag(annStack));
                }
            }
            StringBuffer partText = new StringBuffer();
            SortedMap<Long, Character> offsetsInRange = offsets2CharsMap.subMap(lastOffset, offset);
            Long tmpLastOffset = lastOffset;
            while (!offsetsInRange.isEmpty()) {
                Long tmpOffset = offsetsInRange.firstKey();
                String replacement = DocumentXmlUtils.entitiesMap.get(offsets2CharsMap.get(tmpOffset));
                partText.append(docContStrBuff.substring(tmpLastOffset.intValue(), tmpOffset.intValue()));
                partText.append(replacement);
                tmpLastOffset = tmpOffset + 1L;
                offsetsInRange.remove(tmpOffset);
            }
            partText.append(docContStrBuff.substring(tmpLastOffset.intValue(), offset.intValue()));
            resultStrBuff.append(partText);
            resultStrBuff.append(tmpBuff.toString());
            lastOffset = offset;
        }
        StringBuffer partText = new StringBuffer();
        SortedMap<Long, Character> offsetsInRange = offsets2CharsMap.subMap(lastOffset, Long.valueOf(docContStrBuff.length()));
        Long tmpLastOffset = lastOffset;
        while (!offsetsInRange.isEmpty()) {
            Long tmpOffset = offsetsInRange.firstKey();
            String replacement = DocumentXmlUtils.entitiesMap.get(offsets2CharsMap.get(tmpOffset));
            partText.append(docContStrBuff.substring(tmpLastOffset.intValue(), tmpOffset.intValue()));
            partText.append(replacement);
            tmpLastOffset = tmpOffset + 1L;
            offsetsInRange.remove(tmpOffset);
        }
        partText.append(docContStrBuff.substring(tmpLastOffset.intValue(), docContStrBuff.length()));
        resultStrBuff.append(partText);
        return resultStrBuff.toString();
    }

    private boolean hasOriginalContentFeatures() {
        FeatureMap features = this.getFeatures();
        boolean result = false;
        result = features.get("Original_document_content_on_load") != null && features.get("Document_repositioning_info") != null;
        return result;
    }

    private String saveAnnotationSetAsXmlInOrig(Set<Annotation> aSourceAnnotationSet, boolean includeFeatures) {
        String origContent = (String)this.features.get("Original_document_content_on_load");
        if (origContent == null) {
            origContent = "";
        }
        long originalContentSize = origContent.length();
        RepositioningInfo repositioning = (RepositioningInfo)this.getFeatures().get("Document_repositioning_info");
        StringBuffer docContStrBuff = new StringBuffer(origContent);
        if (aSourceAnnotationSet == null) {
            return docContStrBuff.toString();
        }
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        AnnotationSet originalMarkupsAnnotSet = this.getAnnotations("Original markups");
        AnnotationSetImpl dumpingSet = new AnnotationSetImpl(this);
        if (sListener != null) {
            sListener.statusChanged("Constructing the dumping annotation set.");
        }
        for (Annotation currentAnnot : aSourceAnnotationSet) {
            if (this.insertsSafety(originalMarkupsAnnotSet, currentAnnot) && this.insertsSafety(dumpingSet, currentAnnot)) {
                dumpingSet.add(currentAnnot);
                continue;
            }
            Out.prln("Warning: Annotation with ID=" + currentAnnot.getId() + ", startOffset=" + currentAnnot.getStartNode().getOffset() + ", endOffset=" + currentAnnot.getEndNode().getOffset() + ", type=" + currentAnnot.getType() + " was found to violate the crossed over condition. It will be discarded");
        }
        if (sListener != null) {
            sListener.statusChanged("Dumping annotations as XML");
        }
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (Annotation annot : aSourceAnnotationSet) {
            offsets.add(annot.getStartNode().getOffset());
            offsets.add(annot.getEndNode().getOffset());
        }
        while (!offsets.isEmpty()) {
            boolean backPositioning;
            Annotation a1;
            Long offset = (Long)offsets.last();
            offsets.remove(offset);
            List<Annotation> annotations = this.getAnnotationsForOffset(aSourceAnnotationSet, offset);
            StringBuffer tmpBuff = new StringBuffer("");
            Stack<Annotation> stack = new Stack<Annotation>();
            Iterator<Annotation> it = annotations.iterator();
            Annotation a = null;
            while (it.hasNext()) {
                a = it.next();
                it.remove();
                if (offset.equals(a.getEndNode().getOffset())) {
                    if (offset.equals(a.getStartNode().getOffset())) {
                        if (null != a.getFeatures().get("isEmptyAndSpan") && "true".equals(a.getFeatures().get("isEmptyAndSpan"))) {
                            tmpBuff.append(this.writeStartTag(a, includeFeatures, false));
                            stack.push(a);
                            continue;
                        }
                        tmpBuff.append(this.writeEmptyTag(a, false));
                        aSourceAnnotationSet.remove(a);
                        continue;
                    }
                    while (!stack.isEmpty()) {
                        a1 = (Annotation)stack.pop();
                        tmpBuff.append(this.writeEndTag(a1));
                    }
                    tmpBuff.append(this.writeEndTag(a));
                    continue;
                }
                if (!offset.equals(a.getStartNode().getOffset())) continue;
                while (!stack.isEmpty()) {
                    a1 = (Annotation)stack.pop();
                    tmpBuff.append(this.writeEndTag(a1));
                }
                tmpBuff.append(this.writeStartTag(a, includeFeatures, false));
                aSourceAnnotationSet.remove(a);
            }
            while (!stack.isEmpty()) {
                a1 = (Annotation)stack.pop();
                tmpBuff.append(this.writeEndTag(a1));
            }
            long originalPosition = -1L;
            boolean bl = backPositioning = a != null && offset.equals(a.getEndNode().getOffset());
            if (backPositioning) {
                originalPosition = repositioning.getOriginalPos(offset.intValue(), true);
            }
            if (originalPosition == -1L) {
                originalPosition = repositioning.getOriginalPos(offset.intValue());
            }
            if (originalPosition != -1L && originalPosition <= originalContentSize) {
                docContStrBuff.insert((int)originalPosition, tmpBuff.toString());
                continue;
            }
            Out.prln("Error in the repositioning. The offset (" + offset.intValue() + ") could not be positioned in the original document. \nCalculated position is: " + originalPosition + " placed back: " + backPositioning);
        }
        if (this.theRootAnnotation != null) {
            docContStrBuff.append(this.writeEndTag(this.theRootAnnotation));
        }
        return docContStrBuff.toString();
    }

    private List<Annotation> getAnnotationsForOffset(Set<Annotation> aDumpAnnotSet, Long offset) {
        LinkedList<Annotation> annotationList = new LinkedList<Annotation>();
        if (aDumpAnnotSet == null || offset == null) {
            return annotationList;
        }
        TreeSet<Annotation> annotThatStartAtOffset = new TreeSet<Annotation>(new AnnotationComparator(1, -3));
        TreeSet<Annotation> annotThatEndAtOffset = new TreeSet<Annotation>(new AnnotationComparator(0, -3));
        TreeSet<Annotation> annotThatStartAndEndAtOffset = new TreeSet<Annotation>(new AnnotationComparator(2, 3));
        for (Annotation ann : aDumpAnnotSet) {
            if (offset.equals(ann.getStartNode().getOffset())) {
                if (offset.equals(ann.getEndNode().getOffset())) {
                    annotThatStartAndEndAtOffset.add(ann);
                    continue;
                }
                annotThatStartAtOffset.add(ann);
                continue;
            }
            if (!offset.equals(ann.getEndNode().getOffset())) continue;
            annotThatEndAtOffset.add(ann);
        }
        annotationList.addAll(annotThatEndAtOffset);
        annotThatEndAtOffset = null;
        annotationList.addAll(annotThatStartAtOffset);
        annotThatStartAtOffset = null;
        Iterator<Annotation> iter = annotThatStartAndEndAtOffset.iterator();
        while (iter.hasNext()) {
            Annotation ann;
            ann = iter.next();
            Iterator it = annotationList.iterator();
            boolean breaked = false;
            while (it.hasNext()) {
                Annotation annFromList = (Annotation)it.next();
                if (annFromList.getId() <= ann.getId()) continue;
                annotationList.add(annotationList.indexOf(annFromList), ann);
                breaked = true;
                break;
            }
            if (!breaked) {
                annotationList.add(ann);
            }
            iter.remove();
        }
        return annotationList;
    }

    private List<Annotation> getAnnotationsForOffset(List<Annotation> aDumpAnnotList, Long offset) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        if (aDumpAnnotList == null || offset == null) {
            return annotationList;
        }
        TreeSet<Annotation> annotThatStartAtOffset = new TreeSet<Annotation>(new AnnotationComparator(1, -3));
        TreeSet<Annotation> annotThatEndAtOffset = new TreeSet<Annotation>(new AnnotationComparator(0, -3));
        TreeSet<Annotation> annotThatStartAndEndAtOffset = new TreeSet<Annotation>(new AnnotationComparator(2, 3));
        for (Annotation ann : aDumpAnnotList) {
            if (offset.equals(ann.getStartNode().getOffset())) {
                if (offset.equals(ann.getEndNode().getOffset())) {
                    annotThatStartAndEndAtOffset.add(ann);
                    continue;
                }
                annotThatStartAtOffset.add(ann);
                continue;
            }
            if (!offset.equals(ann.getEndNode().getOffset())) continue;
            annotThatEndAtOffset.add(ann);
        }
        annotationList.addAll(annotThatEndAtOffset);
        annotationList.addAll(annotThatStartAtOffset);
        annotThatEndAtOffset = null;
        annotThatStartAtOffset = null;
        Iterator<Annotation> iter = annotThatStartAndEndAtOffset.iterator();
        while (iter.hasNext()) {
            Annotation ann;
            ann = iter.next();
            Iterator it = annotationList.iterator();
            boolean breaked = false;
            while (it.hasNext()) {
                Annotation annFromList = (Annotation)it.next();
                if (annFromList.getId() <= ann.getId()) continue;
                annotationList.add(annotationList.indexOf(annFromList), ann);
                breaked = true;
                break;
            }
            if (!breaked) {
                annotationList.add(ann);
            }
            iter.remove();
        }
        return annotationList;
    }

    private String writeStartTag(Annotation annot, boolean includeFeatures) {
        return this.writeStartTag(annot, includeFeatures, true);
    }

    private String writeStartTag(Annotation annot, boolean includeFeatures, boolean includeNamespace) {
        String nsPrefix = null;
        if (this.serializeNamespaceInfo) {
            nsPrefix = (String)annot.getFeatures().get(this.namespacePrefixFeature);
        }
        AnnotationSet originalMarkupsAnnotSet = this.getAnnotations("Original markups");
        StringBuffer strBuff = new StringBuffer("");
        if (annot == null) {
            return strBuff.toString();
        }
        if (this.theRootAnnotation != null && annot.getId().equals(this.theRootAnnotation.getId())) {
            if (includeFeatures) {
                strBuff.append("<");
                if (nsPrefix != null && !nsPrefix.isEmpty()) {
                    strBuff.append(nsPrefix + ":");
                }
                strBuff.append(annot.getType());
                strBuff.append(" ");
                if (includeNamespace) {
                    if (annot.getFeatures().get("xmlns:gate") == null) {
                        strBuff.append("xmlns:gate=\"http://www.gate.ac.uk\"");
                    }
                    strBuff.append(" gate:");
                }
                strBuff.append("gateId=\"");
                strBuff.append(annot.getId());
                strBuff.append("\"");
                strBuff.append(" ");
                if (includeNamespace) {
                    strBuff.append("gate:");
                }
                strBuff.append("annotMaxId=\"");
                strBuff.append(this.nextAnnotationId);
                strBuff.append("\"");
                strBuff.append(this.writeFeatures(annot.getFeatures(), includeNamespace));
                strBuff.append(">");
            } else if (originalMarkupsAnnotSet.contains(annot)) {
                strBuff.append("<");
                if (nsPrefix != null && !nsPrefix.isEmpty()) {
                    strBuff.append(nsPrefix + ":");
                }
                strBuff.append(annot.getType());
                strBuff.append(this.writeFeatures(annot.getFeatures(), includeNamespace));
                strBuff.append(">");
            } else {
                strBuff.append("<");
                if (nsPrefix != null && !nsPrefix.isEmpty()) {
                    strBuff.append(nsPrefix + ":");
                }
                strBuff.append(annot.getType());
                strBuff.append(">");
            }
        } else if (includeFeatures) {
            strBuff.append("<");
            if (nsPrefix != null && !nsPrefix.isEmpty()) {
                strBuff.append(nsPrefix + ":");
            }
            strBuff.append(annot.getType());
            strBuff.append(" ");
            if (includeNamespace) {
                strBuff.append("gate:");
            }
            strBuff.append("gateId=\"");
            strBuff.append(annot.getId());
            strBuff.append("\"");
            strBuff.append(this.writeFeatures(annot.getFeatures(), includeNamespace));
            strBuff.append(">");
        } else if (originalMarkupsAnnotSet.contains(annot)) {
            strBuff.append("<");
            if (nsPrefix != null && !nsPrefix.isEmpty()) {
                strBuff.append(nsPrefix + ":");
            }
            strBuff.append(annot.getType());
            strBuff.append(this.writeFeatures(annot.getFeatures(), includeNamespace));
            strBuff.append(">");
        } else {
            strBuff.append("<");
            if (nsPrefix != null && !nsPrefix.isEmpty()) {
                strBuff.append(nsPrefix + ":");
            }
            strBuff.append(annot.getType());
            strBuff.append(">");
        }
        return strBuff.toString();
    }

    private Annotation identifyTheRootAnnotation(AnnotationSet anAnnotationSet) {
        if (anAnnotationSet == null) {
            return null;
        }
        Node startNode = anAnnotationSet.firstNode();
        Node endNode = anAnnotationSet.lastNode();
        if (startNode.getOffset() != 0L) {
            return null;
        }
        Annotation theRootAnnotation = null;
        long start = startNode.getOffset();
        long end = endNode.getOffset();
        for (Annotation currentAnnot : anAnnotationSet) {
            if (start != currentAnnot.getStartNode().getOffset() || end != currentAnnot.getEndNode().getOffset()) continue;
            if (theRootAnnotation == null) {
                theRootAnnotation = currentAnnot;
                continue;
            }
            if (theRootAnnotation.getId() <= currentAnnot.getId()) continue;
            theRootAnnotation = currentAnnot;
        }
        return theRootAnnotation;
    }

    private Annotation identifyTheRootAnnotation(List<Annotation> anAnnotationList) {
        if (anAnnotationList == null || anAnnotationList.isEmpty()) {
            return null;
        }
        if (anAnnotationList.get(0).getStartNode().getOffset() > 0L) {
            return null;
        }
        if (anAnnotationList.size() == 1) {
            Annotation onlyAnn = anAnnotationList.get(0);
            if (onlyAnn.getEndNode().getOffset().equals(this.content.size())) {
                return onlyAnn;
            }
            return null;
        }
        long start = 0L;
        long end = 0L;
        for (int i = 0; i < anAnnotationList.size(); ++i) {
            Annotation anAnnotation = anAnnotationList.get(i);
            long localEnd = anAnnotation.getEndNode().getOffset();
            if (localEnd <= end) continue;
            end = localEnd;
        }
        Annotation theRootAnnotation = null;
        for (int i = 0; i < anAnnotationList.size(); ++i) {
            Annotation currentAnnot = anAnnotationList.get(i);
            long localStart = currentAnnot.getStartNode().getOffset();
            long localEnd = currentAnnot.getEndNode().getOffset();
            if (start != localStart || end != localEnd) continue;
            if (theRootAnnotation == null) {
                theRootAnnotation = currentAnnot;
                continue;
            }
            if (theRootAnnotation.getId() <= currentAnnot.getId()) continue;
            theRootAnnotation = currentAnnot;
        }
        return theRootAnnotation;
    }

    private void buildEntityMapFromString(String aScanString, TreeMap<Long, Character> aMapToFill) {
        if (aScanString == null || aMapToFill == null) {
            return;
        }
        if (DocumentXmlUtils.entitiesMap == null || DocumentXmlUtils.entitiesMap.isEmpty()) {
            Err.prln("WARNING: Entities map was not initialised !");
            return;
        }
        for (Character c : DocumentXmlUtils.entitiesMap.keySet()) {
            int fromIndex = 0;
            while (-1 != fromIndex) {
                fromIndex = aScanString.indexOf(c.charValue(), fromIndex);
                if (-1 == fromIndex) continue;
                aMapToFill.put(Long.valueOf(fromIndex), c);
                ++fromIndex;
            }
        }
    }

    private String writeEmptyTag(Annotation annot) {
        return this.writeEmptyTag(annot, true);
    }

    private String writeEmptyTag(Annotation annot, boolean includeNamespace) {
        String nsPrefix = null;
        if (this.serializeNamespaceInfo) {
            nsPrefix = (String)annot.getFeatures().get(this.namespacePrefixFeature);
        }
        StringBuffer strBuff = new StringBuffer("");
        if (annot == null) {
            return strBuff.toString();
        }
        strBuff.append("<");
        if (nsPrefix != null && !nsPrefix.isEmpty()) {
            strBuff.append(nsPrefix + ":");
        }
        strBuff.append(annot.getType());
        AnnotationSet originalMarkupsAnnotSet = this.getAnnotations("Original markups");
        if (!originalMarkupsAnnotSet.contains(annot)) {
            strBuff.append(" gateId=\"");
            strBuff.append(annot.getId());
            strBuff.append("\"");
        }
        strBuff.append(this.writeFeatures(annot.getFeatures(), includeNamespace));
        strBuff.append("/>");
        return strBuff.toString();
    }

    private String writeEndTag(Annotation annot) {
        String nsPrefix = null;
        if (this.serializeNamespaceInfo) {
            nsPrefix = (String)annot.getFeatures().get(this.namespacePrefixFeature);
        }
        StringBuffer strBuff = new StringBuffer("");
        if (annot == null) {
            return strBuff.toString();
        }
        strBuff.append("</");
        if (nsPrefix != null && !nsPrefix.isEmpty()) {
            strBuff.append(nsPrefix + ":");
        }
        strBuff.append(annot.getType() + ">");
        return strBuff.toString();
    }

    private String writeFeatures(FeatureMap feat, boolean includeNamespace) {
        StringBuffer strBuff = new StringBuffer("");
        if (feat == null) {
            return strBuff.toString();
        }
        for (Object key : feat.keySet()) {
            Object value = feat.get(key);
            if (key == null || value == null) continue;
            if (this.serializeNamespaceInfo) {
                String nsPrefix = "xmlns:" + (String)feat.get(this.namespacePrefixFeature);
                if (nsPrefix.equals(key.toString()) || this.namespacePrefixFeature.equals(key.toString())) continue;
                if (this.namespaceURIFeature.equals(key.toString())) {
                    strBuff.append(" ");
                    strBuff.append(nsPrefix + "=\"" + value.toString() + "\"");
                    return strBuff.toString();
                }
            }
            if ("isEmptyAndSpan".equals(key.toString())) continue;
            if (!String.class.isAssignableFrom(key.getClass())) {
                Out.prln("Warning:Found a feature NAME(" + key + ") that isn't a String.(feature discarded)");
                continue;
            }
            if (!(String.class.isAssignableFrom(value.getClass()) || Number.class.isAssignableFrom(value.getClass()) || Collection.class.isAssignableFrom(value.getClass()) || Boolean.class.isAssignableFrom(value.getClass()))) {
                Out.prln("Warning:Found a feature VALUE(" + value + ") that doesn't came from String, Number, Boolean, or Collection.(feature discarded)");
                continue;
            }
            if ("matches".equals(key)) {
                strBuff.append(" ");
                if (includeNamespace) {
                    strBuff.append("gate:");
                }
                strBuff.append(DocumentXmlUtils.combinedNormalisation(key.toString()));
                strBuff.append("=\"");
            } else {
                strBuff.append(" ");
                strBuff.append(DocumentXmlUtils.combinedNormalisation(key.toString()));
                strBuff.append("=\"");
            }
            if (Collection.class.isAssignableFrom(value.getClass())) {
                for (Object item : (Collection)value) {
                    if (!String.class.isAssignableFrom(item.getClass()) && !Number.class.isAssignableFrom(item.getClass())) continue;
                    strBuff.append(DocumentXmlUtils.combinedNormalisation(item.toString()));
                    strBuff.append(";");
                }
                if (strBuff.charAt(strBuff.length() - 1) == ';') {
                    strBuff.deleteCharAt(strBuff.length() - 1);
                }
            } else {
                strBuff.append(DocumentXmlUtils.combinedNormalisation(value.toString()));
            }
            strBuff.append("\"");
        }
        return strBuff.toString();
    }

    @Override
    public String toXml() {
        return DocumentStaxUtils.toXml(this);
    }

    @Override
    public Map<String, AnnotationSet> getNamedAnnotationSets() {
        if (this.namedAnnotSets == null) {
            this.namedAnnotSets = new HashMap<String, AnnotationSet>();
        }
        return this.namedAnnotSets;
    }

    @Override
    public Set<String> getAnnotationSetNames() {
        if (this.namedAnnotSets == null) {
            this.namedAnnotSets = new HashMap<String, AnnotationSet>();
        }
        return this.namedAnnotSets.keySet();
    }

    @Override
    public void removeAnnotationSet(String name) {
        AnnotationSet removed;
        if (this.namedAnnotSets != null && (removed = this.namedAnnotSets.remove(name)) != null) {
            this.fireAnnotationSetRemoved(new DocumentEvent(this, 102, name));
        }
    }

    @Override
    public void edit(Long start, Long end, DocumentContent replacement) throws InvalidOffsetException {
        if (!this.isValidOffsetRange(start, end)) {
            throw new InvalidOffsetException("Offsets: " + start + "/" + end);
        }
        if (this.content != null) {
            ((DocumentContentImpl)this.content).edit(start, end, replacement);
        }
        if (this.defaultAnnots != null) {
            ((AnnotationSetImpl)this.defaultAnnots).edit(start, end, replacement);
        }
        if (this.namedAnnotSets != null) {
            Iterator<AnnotationSet> iter = this.namedAnnotSets.values().iterator();
            while (iter.hasNext()) {
                ((AnnotationSetImpl)iter.next()).edit(start, end, replacement);
            }
        }
        this.fireContentEdited(new DocumentEvent(this, 103, start, end));
    }

    public boolean isValidOffset(Long offset) {
        if (offset == null) {
            return false;
        }
        long o = offset;
        return o <= this.getContent().size() && o >= 0L;
    }

    public boolean isValidOffsetRange(Long start, Long end) {
        return this.isValidOffset(start) && this.isValidOffset(end) && start <= end;
    }

    public void setNextAnnotationId(int aNextAnnotationId) {
        this.nextAnnotationId = aNextAnnotationId;
    }

    public Integer getNextAnnotationId() {
        return this.nextAnnotationId++;
    }

    public Integer peakAtNextAnnotationId() {
        return this.nextAnnotationId;
    }

    public Integer getNextNodeId() {
        return this.nextNodeId++;
    }

    @Override
    public int compareTo(Object o) throws ClassCastException {
        DocumentImpl other = (DocumentImpl)o;
        return this.getOrderingString().compareTo(other.getOrderingString());
    }

    protected String getOrderingString() {
        if (this.sourceUrl == null) {
            return this.toString();
        }
        StringBuffer orderingString = new StringBuffer(this.sourceUrl.toString());
        if (this.sourceUrlStartOffset != null && this.sourceUrlEndOffset != null) {
            orderingString.append(this.sourceUrlStartOffset.toString());
            orderingString.append(this.sourceUrlEndOffset.toString());
        }
        return orderingString.toString();
    }

    public String getStringContent() {
        return this.stringContent;
    }

    @CreoleParameter(disjunction="source", priority=2, comment="The content of the document")
    public void setStringContent(String stringContent) {
        this.stringContent = stringContent;
    }

    @Override
    public String toString() {
        String n = Strings.getNl();
        StringBuffer s = new StringBuffer("DocumentImpl: " + n);
        s.append("  content:" + this.content + n);
        s.append("  defaultAnnots:" + this.defaultAnnots + n);
        s.append("  encoding:" + this.encoding + n);
        s.append("  features:" + this.features + n);
        s.append("  markupAware:" + this.markupAware + n);
        s.append("  namedAnnotSets:" + this.namedAnnotSets + n);
        s.append("  nextAnnotationId:" + this.nextAnnotationId + n);
        s.append("  nextNodeId:" + this.nextNodeId + n);
        s.append("  sourceUrl:" + this.sourceUrl + n);
        s.append("  sourceUrlStartOffset:" + this.sourceUrlStartOffset + n);
        s.append("  sourceUrlEndOffset:" + this.sourceUrlEndOffset + n);
        s.append(n);
        return s.toString();
    }

    @Override
    public synchronized void removeDocumentListener(DocumentListener l) {
        if (this.documentListeners != null && this.documentListeners.contains(l)) {
            Vector v = (Vector)this.documentListeners.clone();
            v.removeElement(l);
            this.documentListeners = v;
        }
    }

    @Override
    public synchronized void addDocumentListener(DocumentListener l) {
        Vector v;
        Vector vector = v = this.documentListeners == null ? new Vector(2) : (Vector)this.documentListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.documentListeners = v;
        }
    }

    protected void fireAnnotationSetAdded(DocumentEvent e) {
        if (this.documentListeners != null) {
            Vector<DocumentListener> listeners = this.documentListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).annotationSetAdded(e);
            }
        }
    }

    protected void fireAnnotationSetRemoved(DocumentEvent e) {
        if (this.documentListeners != null) {
            Vector<DocumentListener> listeners = this.documentListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).annotationSetRemoved(e);
            }
        }
    }

    protected void fireContentEdited(DocumentEvent e) {
        if (this.documentListeners != null) {
            Vector<DocumentListener> listeners = this.documentListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).contentEdited(e);
            }
        }
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
        if (!e.getDatastore().equals(this.getDataStore())) {
            return;
        }
        Factory.deleteResource(this);
    }

    @Override
    public void setLRPersistenceId(Object lrID) {
        super.setLRPersistenceId(lrID);
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public void resourceAdopted(DatastoreEvent evt) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent evt) {
        if (!evt.getSource().equals(this.getDataStore())) {
            return;
        }
        if (evt.getResourceID().equals(this.getLRPersistenceId())) {
            Factory.deleteResource(this);
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent evt) {
    }

    @Override
    public void setDataStore(DataStore dataStore) throws PersistenceException {
        super.setDataStore(dataStore);
        if (this.dataStore != null) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    public void setDefaultAnnotations(AnnotationSet defaultAnnotations) {
        this.defaultAnnots = defaultAnnotations;
    }

    static class AnnotationComparator
    implements Comparator<Annotation>,
    Serializable {
        private static final long serialVersionUID = -2405379880205707461L;
        int orderOn = -1;
        int orderType = 3;

        public AnnotationComparator(int anOrderOn, int anOrderType) {
            this.orderOn = anOrderOn;
            this.orderType = anOrderType;
        }

        @Override
        public int compare(Annotation a1, Annotation a2) {
            if (this.orderOn == 0) {
                int result = a1.getStartNode().getOffset().compareTo(a2.getStartNode().getOffset());
                if (this.orderType == 3) {
                    if (result == 0) {
                        return a1.getId().compareTo(a2.getId());
                    }
                    return result;
                }
                if (result == 0) {
                    return a2.getId().compareTo(a1.getId());
                }
                return -result;
            }
            if (this.orderOn == 1) {
                int result = a1.getEndNode().getOffset().compareTo(a2.getEndNode().getOffset());
                if (this.orderType == 3) {
                    if (result == 0) {
                        return a2.getId().compareTo(a1.getId());
                    }
                    return result;
                }
                if (result == 0) {
                    return a1.getId().compareTo(a2.getId());
                }
                return -result;
            }
            if (this.orderOn == 2) {
                if (this.orderType == 3) {
                    return a1.getId().compareTo(a2.getId());
                }
                return a2.getId().compareTo(a1.getId());
            }
            return 0;
        }
    }
}

