/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.DocumentContent;
import gate.util.BomStrippingInputStreamReader;
import gate.util.InvalidOffsetException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class DocumentContentImpl
implements DocumentContent {
    private static final int INTERNAL_BUFFER_SIZE = 16384;
    String content;
    String originalContent;
    static final long serialVersionUID = -1426940535575467461L;

    public DocumentContentImpl() {
        this.content = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentContentImpl(URL u, String encoding, Long start, Long end) throws IOException {
        int readLength = 0;
        char[] readBuffer = new char[16384];
        BomStrippingInputStreamReader uReader = null;
        InputStream uStream = null;
        StringBuffer buf = new StringBuffer();
        long s = 0L;
        long e = Long.MAX_VALUE;
        if (start != null && end != null) {
            s = start;
            e = end;
        }
        try {
            URLConnection conn = u.openConnection();
            uStream = conn.getInputStream();
            if ("gzip".equals(conn.getContentEncoding())) {
                uStream = new GZIPInputStream(uStream);
            }
            uReader = encoding != null && !encoding.equalsIgnoreCase("") ? new BomStrippingInputStreamReader(uStream, encoding, 16384) : new BomStrippingInputStreamReader(uStream, 16384);
            ((BufferedReader)uReader).skip(s);
            for (long toRead = e - s; toRead > 0L && (readLength = ((BufferedReader)uReader).read(readBuffer, 0, 16384)) != -1; toRead -= (long)readLength) {
                if (toRead < (long)readLength) {
                    readLength = (int)toRead;
                }
                buf.append(readBuffer, 0, readLength);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(uReader);
            IOUtils.closeQuietly((InputStream)uStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)uReader);
        IOUtils.closeQuietly((InputStream)uStream);
        this.originalContent = this.content = new String(buf);
    }

    void edit(Long start, Long end, DocumentContent replacement) {
        int s = start.intValue();
        int e = end.intValue();
        String repl = replacement == null ? "" : ((DocumentContentImpl)replacement).content;
        StringBuffer newContent = new StringBuffer(this.content);
        newContent.replace(s, e, repl);
        this.content = newContent.toString();
    }

    @Override
    public DocumentContent getContent(Long start, Long end) throws InvalidOffsetException {
        if (!this.isValidOffsetRange(start, end)) {
            throw new InvalidOffsetException("Invalid offset range " + start + " to " + end + " for document content of length " + this.size());
        }
        return new DocumentContentImpl(this.content.substring(start.intValue(), end.intValue()));
    }

    public String toString() {
        return this.content;
    }

    @Override
    public Long size() {
        return this.content.length();
    }

    boolean isValidOffset(Long offset) {
        long len;
        if (offset == null) {
            return false;
        }
        long o = offset;
        return o <= (len = (long)this.content.length()) && o >= 0L;
    }

    boolean isValidOffsetRange(Long start, Long end) {
        return this.isValidOffset(start) && this.isValidOffset(end) && start <= end;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DocumentContentImpl)) {
            return false;
        }
        DocumentContentImpl docImpl = (DocumentContentImpl)other;
        return this.content.equals(docImpl.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public DocumentContentImpl(String s) {
        this.originalContent = this.content = s;
    }
}

