/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.DocumentImpl;
import gate.creole.AbstractLanguageResource;
import gate.creole.CustomDuplication;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.event.StatusListener;
import gate.util.BomStrippingInputStreamReader;
import gate.util.Err;
import gate.util.Files;
import gate.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

@CreoleResource(name="GATE Corpus", comment="GATE transient corpus.", interfaceName="gate.Corpus", icon="corpus-trans", helpURL="http://gate.ac.uk/userguide/sec:developer:loadlr")
public class CorpusImpl
extends AbstractLanguageResource
implements Corpus,
CreoleListener,
CustomDuplication {
    protected List<Document> supportList = Collections.synchronizedList(new VerboseList());
    static final long serialVersionUID = -1113142759053898456L;
    private transient Vector<CorpusListener> corpusListeners;
    protected transient List<Document> documentsList;

    public CorpusImpl() {
        Gate.getCreoleRegister().addCreoleListener(this);
    }

    @Override
    public List<String> getDocumentNames() {
        ArrayList<String> res = new ArrayList<String>(this.supportList.size());
        for (Document document : this.supportList) {
            res.add(document.getName());
        }
        return res;
    }

    @Override
    public String getDocumentName(int index) {
        return this.supportList.get(index).getName();
    }

    @Override
    public void unloadDocument(Document doc) {
    }

    @Override
    public boolean isDocumentLoaded(int index) {
        return true;
    }

    protected void clearDocList() {
        if (this.supportList == null) {
            return;
        }
        this.supportList.clear();
    }

    @Override
    public int size() {
        return this.supportList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.supportList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.supportList.contains(o);
    }

    @Override
    public Iterator<Document> iterator() {
        return this.supportList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.supportList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.supportList.toArray(a);
    }

    @Override
    public boolean add(Document o) {
        return this.supportList.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.supportList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.supportList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Document> c) {
        return this.supportList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Document> c) {
        return this.supportList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.supportList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.supportList.retainAll(c);
    }

    @Override
    public void clear() {
        this.supportList.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CorpusImpl)) {
            return false;
        }
        return this.supportList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.supportList.hashCode();
    }

    @Override
    public Document get(int index) {
        return this.supportList.get(index);
    }

    @Override
    public Document set(int index, Document element) {
        return this.supportList.set(index, element);
    }

    @Override
    public void add(int index, Document element) {
        this.supportList.add(index, element);
    }

    @Override
    public Document remove(int index) {
        return this.supportList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.supportList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.supportList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Document> listIterator() {
        return this.supportList.listIterator();
    }

    @Override
    public ListIterator<Document> listIterator(int index) {
        return this.supportList.listIterator(index);
    }

    @Override
    public List<Document> subList(int fromIndex, int toIndex) {
        return this.supportList.subList(fromIndex, toIndex);
    }

    @Override
    public void cleanup() {
        Gate.getCreoleRegister().removeCreoleListener(this);
    }

    @Override
    public Resource init() {
        if (this.documentsList != null && !this.documentsList.isEmpty()) {
            this.addAll((Collection<? extends Document>)this.documentsList);
        }
        return this;
    }

    public static void populate(Corpus corpus, URL directory, FileFilter filter, String encoding, boolean recurseDirectories) throws IOException {
        CorpusImpl.populate(corpus, directory, filter, encoding, null, recurseDirectories);
    }

    public static void populate(Corpus corpus, URL directory, FileFilter filter, String encoding, String mimeType, boolean recurseDirectories) throws IOException {
        if (!directory.getProtocol().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("The URL provided is not of type \"file:\"!");
        }
        File dir = Files.fileFromURL(directory);
        if (!dir.exists()) {
            throw new FileNotFoundException(dir.toString());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory!");
        }
        File[] files = recurseDirectories ? Files.listFilesRecursively(dir, filter) : dir.listFiles(filter);
        if (files == null) {
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (File file : files) {
            if (file.isDirectory()) continue;
            StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
            if (sListener != null) {
                sListener.statusChanged("Reading: " + file.getName());
            }
            String docName = file.getName() + "_" + Gate.genSym();
            FeatureMap params = Factory.newFeatureMap();
            params.put("sourceUrl", file.toURI().toURL());
            if (encoding != null) {
                params.put("encoding", encoding);
            }
            if (mimeType != null) {
                params.put("mimeType", mimeType);
            }
            try {
                Document doc = (Document)Factory.createResource(DocumentImpl.class.getName(), params, null, docName);
                corpus.add(doc);
                if (corpus.getLRPersistenceId() != null) {
                    corpus.unloadDocument(doc);
                    Factory.deleteResource(doc);
                }
            }
            catch (Throwable t) {
                String nl = Strings.getNl();
                Err.prln("WARNING: Corpus.populate could not instantiate document" + nl + "  Document name was: " + docName + nl + "  Exception was: " + t + nl + nl);
                t.printStackTrace();
            }
            if (sListener == null) continue;
            sListener.statusChanged(file.getName() + " read");
        }
    }

    @Override
    public void populate(URL directory, FileFilter filter, String encoding, boolean recurseDirectories) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, directory, filter, encoding, null, recurseDirectories);
    }

    @Override
    public void populate(URL directory, FileFilter filter, String encoding, String mimeType, boolean recurseDirectories) throws IOException, ResourceInstantiationException {
        CorpusImpl.populate(this, directory, filter, encoding, mimeType, recurseDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long populate(Corpus corpus, URL singleConcatenatedFile, String documentRootElement, String encoding, int numberOfDocumentsToExtract, String documentNamePrefix, String mimeType, boolean includeRootElement) throws IOException {
        StatusListener sListener = (StatusListener)Gate.getListeners().get("gate.event.StatusListener");
        documentRootElement = documentRootElement.toLowerCase();
        documentNamePrefix = documentNamePrefix == null ? "" : documentNamePrefix.trim() + "_";
        try (BufferedReader br = null;){
            br = encoding != null && encoding.trim().length() != 0 ? new BomStrippingInputStreamReader(singleConcatenatedFile.openStream(), encoding, 0xA00000) : new BomStrippingInputStreamReader(singleConcatenatedFile.openStream(), 0xA00000);
            String line = br.readLine();
            StringBuilder documentString = new StringBuilder();
            boolean searchingForStartElement = true;
            int count = 1;
            long lengthInBytes = 0L;
            while (line != null) {
                int index;
                String lowerCasedLine = line.toLowerCase();
                if (searchingForStartElement) {
                    index = lowerCasedLine.indexOf("<" + documentRootElement + " ");
                    if (index == -1) {
                        index = lowerCasedLine.indexOf("<" + documentRootElement + ">");
                    }
                    if (index != -1) {
                        line = line.substring(index);
                        searchingForStartElement = false;
                        continue;
                    }
                    line = br.readLine();
                    continue;
                }
                index = lowerCasedLine.indexOf("</" + documentRootElement + ">");
                if (index == -1) {
                    documentString.append(line + "\n");
                    line = br.readLine();
                    continue;
                }
                documentString.append(line.substring(0, index + documentRootElement.length() + 3));
                searchingForStartElement = true;
                if (sListener != null) {
                    sListener.statusChanged("Creating Document Number :" + count);
                }
                String docName = documentNamePrefix + count + "_" + Gate.genSym();
                String docContent = documentString.toString();
                if (!includeRootElement) {
                    docContent = docContent.substring(docContent.indexOf(">") + 1, docContent.lastIndexOf("<"));
                }
                FeatureMap params = Factory.newFeatureMap();
                if (mimeType != null) {
                    params.put("mimeType", mimeType);
                }
                params.put("stringContent", docContent);
                if (encoding != null && encoding.trim().length() > 0) {
                    params.put("encoding", encoding);
                }
                lengthInBytes += (long)docContent.getBytes().length;
                try {
                    Document doc = (Document)Factory.createResource(DocumentImpl.class.getName(), params, null, docName);
                    ++count;
                    corpus.add(doc);
                    if (corpus.getLRPersistenceId() != null) {
                        corpus.unloadDocument(doc);
                        Factory.deleteResource(doc);
                    }
                    if (count - 1 == numberOfDocumentsToExtract) {
                        break;
                    }
                }
                catch (Throwable t) {
                    String nl = Strings.getNl();
                    Err.prln("WARNING: Corpus.populate could not instantiate document" + nl + "  Document name was: " + docName + nl + "  Exception was: " + t + nl + nl);
                    t.printStackTrace();
                }
                documentString = new StringBuilder();
                if (sListener != null) {
                    sListener.statusChanged(docName + " created!");
                }
                if (!(line = line.substring(index + documentRootElement.length() + 3)).trim().equals("")) continue;
                line = br.readLine();
            }
            long l = lengthInBytes;
            return l;
        }
    }

    @Override
    public long populate(URL singleConcatenatedFile, String documentRootElement, String encoding, int numberOfFilesToExtract, String documentNamePrefix, String mimeType, boolean includeRootElement) throws IOException, ResourceInstantiationException {
        return CorpusImpl.populate(this, singleConcatenatedFile, documentRootElement, encoding, numberOfFilesToExtract, documentNamePrefix, mimeType, includeRootElement);
    }

    @Override
    public synchronized void removeCorpusListener(CorpusListener l) {
        if (this.corpusListeners != null && this.corpusListeners.contains(l)) {
            Vector v = (Vector)this.corpusListeners.clone();
            v.removeElement(l);
            this.corpusListeners = v;
        }
    }

    @Override
    public synchronized void addCorpusListener(CorpusListener l) {
        Vector v;
        Vector vector = v = this.corpusListeners == null ? new Vector(2) : (Vector)this.corpusListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.corpusListeners = v;
        }
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext ctx) throws ResourceInstantiationException {
        Corpus newCorpus = (Corpus)Factory.defaultDuplicate(this, ctx);
        for (Document d : this) {
            newCorpus.add((Document)Factory.duplicate(d, ctx));
        }
        return newCorpus;
    }

    protected void fireDocumentAdded(CorpusEvent e) {
        if (this.corpusListeners != null) {
            Vector<CorpusListener> listeners = this.corpusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).documentAdded(e);
            }
        }
    }

    protected void fireDocumentRemoved(CorpusEvent e) {
        if (this.corpusListeners != null) {
            Vector<CorpusListener> listeners = this.corpusListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                listeners.elementAt(i).documentRemoved(e);
            }
        }
    }

    @Optional
    @CreoleParameter(collectionElementType=Document.class, comment="A list of GATE documents")
    public void setDocumentsList(List<Document> documentsList) {
        this.documentsList = documentsList;
    }

    public List<Document> getDocumentsList() {
        return this.documentsList;
    }

    @Override
    public void resourceLoaded(CreoleEvent e) {
    }

    @Override
    public void resourceUnloaded(CreoleEvent e) {
        Resource res = e.getResource();
        if (res instanceof Document) {
            while (this.contains(res)) {
                this.remove(res);
            }
        }
    }

    @Override
    public void resourceRenamed(Resource resource, String oldName, String newName) {
    }

    @Override
    public void datastoreOpened(CreoleEvent e) {
    }

    @Override
    public void datastoreCreated(CreoleEvent e) {
    }

    @Override
    public void datastoreClosed(CreoleEvent e) {
    }

    protected class VerboseList
    extends AbstractList<Document>
    implements Serializable {
        private static final long serialVersionUID = 3483062654980468826L;
        List<Document> data = new ArrayList<Document>();

        VerboseList() {
        }

        @Override
        public Document get(int index) {
            return this.data.get(index);
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public Document set(int index, Document element) {
            Document oldDoc = this.data.set(index, element);
            CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, oldDoc, index, 402));
            CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, element, index, 401));
            return oldDoc;
        }

        @Override
        public void add(int index, Document element) {
            this.data.add(index, element);
            CorpusImpl.this.fireDocumentAdded(new CorpusEvent(CorpusImpl.this, element, index, 401));
        }

        @Override
        public Document remove(int index) {
            Document oldDoc = this.data.remove(index);
            CorpusImpl.this.fireDocumentRemoved(new CorpusEvent(CorpusImpl.this, oldDoc, index, 402));
            return oldDoc;
        }
    }
}

