/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.CreoleRegister;
import gate.Gate;
import gate.creole.Plugin;
import gate.gui.MainFrame;
import gate.gui.OptionsDialog;
import gate.util.Err;
import gate.util.GateException;
import gate.util.OptionsMap;
import gate.util.Out;
import gate.util.Strings;
import gate.util.ThreadWarningSystem;
import gate.util.persistence.PersistenceManager;
import gnu.getopt.Getopt;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.lang.management.ThreadInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class Main {
    protected static final boolean DEBUG = false;
    protected static final int STATUS_NORMAL = 0;
    protected static final int STATUS_ERROR = 1;
    protected static MainFrame frame;
    public static final String name = "GATE Developer";
    public static final String version;
    public static final String build;
    private static final Logger log;
    protected static final List<URL> pendingCreoleUrls;

    public static void main(String[] args) throws GateException {
        if (System.getProperty("java.version").compareTo(Gate.getMinJdkVersion()) < 0) {
            throw new GateException("GATE requires JDK " + Gate.getMinJdkVersion() + " or newer");
        }
        ThreadWarningSystem tws = new ThreadWarningSystem();
        tws.addListener(new ThreadWarningSystem.Listener(){
            final PrintStream out = System.out;

            @Override
            public void deadlockDetected(ThreadInfo inf) {
                this.out.println("Deadlocked Thread:");
                this.out.println("------------------");
                this.out.println(inf);
                for (StackTraceElement ste : inf.getStackTrace()) {
                    this.out.println("\t" + ste);
                }
            }

            @Override
            public void thresholdExceeded(ThreadInfo[] threads) {
            }
        });
        Main.processArgs(args);
        Main.runGui();
    }

    protected static void registerCreoleUrls() {
        CreoleRegister reg = Gate.getCreoleRegister();
        for (URL u : pendingCreoleUrls) {
            try {
                reg.registerPlugin(new Plugin.Directory(u));
            }
            catch (GateException e) {
                Err.prln("Couldn't register CREOLE directory: " + u);
                Err.prln(e);
                System.exit(1);
            }
        }
    }

    public static MainFrame getMainFrame() throws GateException {
        if (frame == null) {
            Main.runGui();
        }
        return frame;
    }

    protected static void runGui() throws GateException {
        block2: {
            Thread.currentThread().setPriority(1);
            try {
                Gate.runInSandbox(false);
                Gate.init();
            }
            catch (Throwable t) {
                log.error((Object)"Problem while initialising GATE", t);
                int selection = JOptionPane.showOptionDialog(null, "Error during initialisation:\n" + t.toString() + "\nDo you still want to start GATE?", "GATE", 0, 0, null, new String[]{"Cancel", "Start anyway"}, "Cancel");
                if (selection == 1) break block2;
                System.exit(1);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                Main.applyUserPreferences();
                frame = MainFrame.getInstance(gc);
                frame.setTitleChangable(true);
                frame.setTitle("GATE Developer " + Gate.VERSION_STRING + " build " + Gate.BUILD);
                String title = System.getProperty("gate.slug.title");
                if (title != null) {
                    frame.setTitle(title);
                }
                frame.setTitleChangable(false);
                String iconName = System.getProperty("gate.slug.icon");
                if (iconName != null) {
                    try {
                        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(new URL(iconName)));
                    }
                    catch (MalformedURLException mue) {
                        log.warn((Object)"Could not load application icon.", (Throwable)mue);
                    }
                }
                frame.validate();
                Rectangle screenBounds = gc.getBounds();
                Dimension screenSize = screenBounds.getSize();
                Dimension frameSize = frame.getSize();
                if (frameSize.height > screenSize.height) {
                    frameSize.height = screenSize.height;
                }
                if (frameSize.width > screenSize.width) {
                    frameSize.width = screenSize.width;
                }
                frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                frame.setVisible(true);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            File sessionFile = Gate.getUserSessionFile();
                            if (sessionFile != null && sessionFile.exists()) {
                                MainFrame.lockGUI("Loading saved session...");
                                PersistenceManager.loadObjectFromFile(sessionFile);
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Failed to load session data", (Throwable)e);
                        }
                        finally {
                            MainFrame.unlockGUI();
                        }
                    }
                };
                Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Session loader");
                thread.setPriority(1);
                thread.start();
            }
        });
        Main.registerCreoleUrls();
    }

    public static void applyUserPreferences() {
        String lnfClassName = System.getProperty("swing.defaultlaf") != null ? System.getProperty("swing.defaultlaf") : Gate.getUserConfig().getString("Look_and_Feel");
        if (lnfClassName == null) {
            lnfClassName = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1 ? UIManager.getCrossPlatformLookAndFeelClassName() : UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(lnfClassName);
        }
        catch (Exception e) {
            System.err.print("Could not set your preferred Look and Feel. The error was:\n" + e.toString() + "\nReverting to using Java Look and Feel");
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e1) {
                System.err.print("Could not set the cross-platform Look and Feel either. The error was:\n" + e1.toString() + "\nGiving up on Look and Feel.");
            }
        }
        Gate.getUserConfig().put((Object)"Look_and_Feel", lnfClassName);
        OptionsMap userConfig = Gate.getUserConfig();
        Font font = userConfig.getFont("Text_components_font");
        if (font == null) {
            font = UIManager.getFont("TextPane.font");
        }
        if (font != null) {
            OptionsDialog.setTextComponentsFont(font);
        }
        if ((font = userConfig.getFont("Menus_font")) == null) {
            font = UIManager.getFont("Menu.font");
        }
        if (font != null) {
            OptionsDialog.setMenuComponentsFont(font);
        }
        if ((font = userConfig.getFont("Other_components_font")) == null) {
            font = UIManager.getFont("Button.font");
        }
        if (font != null) {
            OptionsDialog.setComponentsFont(font);
        }
    }

    public static void processArgs(String[] args) {
        int c;
        Getopt g = new Getopt("GATE main", args, "hd:ei:");
        block10: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 104: {
                    Main.help();
                    Main.usage();
                    System.exit(0);
                    continue block10;
                }
                case 100: {
                    String urlString = g.getOptarg();
                    URL u = null;
                    try {
                        u = new URL(urlString);
                    }
                    catch (MalformedURLException e) {
                        Err.prln("Bad URL: " + urlString);
                        Err.prln(e);
                        System.exit(1);
                    }
                    pendingCreoleUrls.add(u);
                    Out.prln("CREOLE Directory " + urlString + " queued for registration");
                    continue block10;
                }
                case 105: {
                    String optionString = g.getOptarg();
                    URL u2 = null;
                    File f = new File(optionString);
                    try {
                        u2 = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        Err.prln("Bad initialisation file: " + optionString);
                        Err.prln(e);
                        System.exit(1);
                    }
                    Gate.setSiteConfigFile(f);
                    continue block10;
                }
                case 63: {
                    System.exit(1);
                    continue block10;
                }
            }
            Err.prln("getopt() returned " + c + "\n");
            System.exit(1);
        }
    }

    public static void usage() {
        Out.prln("Usage: java gate.Main\n-h -- show this help file\n-d CREOLE-URL -- a creole directory to load\n-i SITE_CONFIG_FILE -- the site config file to use");
    }

    public static void help() {
        String nl = Strings.getNl();
        Out.prln("For help on command-line options and other information " + nl + "see the user manual in your GATE distribution or at " + nl + "http://gate.ac.uk/userguide/");
    }

    static {
        version = Gate.VERSION_STRING;
        build = Gate.BUILD;
        log = Logger.getLogger(Main.class);
        pendingCreoleUrls = new ArrayList<URL>();
    }
}

