/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.DataStore;
import gate.LanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.PersistenceManager;
import gate.util.persistence.ResourcePersistence;
import java.io.Serializable;
import java.util.Map;

public class LRPersistence
extends ResourcePersistence {
    protected Serializable dsData;
    protected Object persistenceID;
    static final long serialVersionUID = 3541034274225534363L;

    @Override
    public void extractDataFromSource(Object source) throws PersistenceException {
        if (!(source instanceof LanguageResource)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + LanguageResource.class.getName() + " objects!\n" + source.getClass().getName() + " is not a " + LanguageResource.class.getName());
        }
        super.extractDataFromSource(source);
        this.features = null;
        LanguageResource lr = (LanguageResource)source;
        if (lr.getDataStore() == null) {
            this.dsData = null;
        } else {
            this.dsData = PersistenceManager.getPersistentRepresentation(lr.getDataStore());
            this.persistenceID = lr.getLRPersistenceId();
        }
    }

    @Override
    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        if (this.dsData == null) {
            return super.createObject();
        }
        this.initParams = PersistenceManager.getTransientRepresentation(this.initParams, this.containingControllerName, this.initParamOverrides);
        DataStore ds = (DataStore)PersistenceManager.getTransientRepresentation(this.dsData, this.containingControllerName, this.initParamOverrides);
        ((Map)this.initParams).put("DataStore", ds);
        ((Map)this.initParams).put("LRPersistenceId", this.persistenceID);
        return super.createObject();
    }
}

