/*
 * Decompiled with CFR 0.152.
 */
package gate.util.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultProxySelector;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final String envM2Home = System.getenv("M2_HOME");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final String settingsXml = System.getProperty("M2_SETTINGS_XML", DEFAULT_USER_SETTINGS_FILE.getPath());
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", envM2Home != null ? envM2Home : ""), "conf/settings.xml");
    private static List<File> extraCacheDirectories = new CopyOnWriteArrayList<File>();

    public static List<File> getExtraCacheDirectories() {
        return Collections.unmodifiableList(extraCacheDirectories);
    }

    public static void addCacheDirectory(File dir) {
        extraCacheDirectories.add(0, dir);
    }

    public static boolean removeCacheDirectory(File dir) {
        return extraCacheDirectories.remove(dir);
    }

    public static Settings loadMavenSettings() throws SettingsBuildingException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(new File(settingsXml));
        settingsBuildingRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        Settings effectiveSettings = settingsBuildingResult.getEffectiveSettings();
        return effectiveSettings;
    }

    public static List<RemoteRepository> getRepositoryList() throws SettingsBuildingException {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
        RemoteRepository gateRepo = new RemoteRepository.Builder("gate", "default", "http://repo.gate.ac.uk/content/groups/public/").build();
        Settings effectiveSettings = Utils.loadMavenSettings();
        org.apache.maven.settings.Proxy proxy = effectiveSettings.getActiveProxy();
        DefaultProxySelector selector = null;
        if (proxy != null) {
            selector = new DefaultProxySelector();
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build()), proxy.getNonProxyHosts());
        }
        Map profilesMap = effectiveSettings.getProfilesAsMap();
        for (String profileName : effectiveSettings.getActiveProfiles()) {
            Profile profile = (Profile)profilesMap.get(profileName);
            List repositories = profile.getRepositories();
            for (Repository repo : repositories) {
                RemoteRepository remoteRepo = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl()).build();
                if (selector != null) {
                    remoteRepo = new RemoteRepository.Builder(remoteRepo).setProxy(selector.getProxy(remoteRepo)).build();
                }
                repos.add(remoteRepo);
            }
        }
        repos.add(central);
        repos.add(gateRepo);
        return repos;
    }

    public Artifact getArtifact() {
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession getRepositorySession(RepositorySystem repoSystem, WorkspaceReader workspace) {
        DefaultRepositorySystemSession repoSystemSession = MavenRepositorySystemUtils.newSession();
        String repoLocation = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository/";
        try {
            Settings effectiveSettings = Utils.loadMavenSettings();
            if (effectiveSettings.getLocalRepository() != null) {
                repoLocation = effectiveSettings.getLocalRepository();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to load Maven settings, using default repository location", (Throwable)e);
        }
        LocalRepository localRepo = new LocalRepository(repoLocation);
        log.debug((Object)("Using local repository at: " + repoLocation));
        repoSystemSession.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)repoSystemSession, localRepo));
        if (workspace != null) {
            repoSystemSession.setWorkspaceReader(workspace);
        }
        return repoSystemSession;
    }
}

