/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class RBTreeMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V>,
Cloneable,
Serializable {
    static final long serialVersionUID = -1454324265766936618L;
    private Comparator<? super K> comparator = null;
    private transient Entry<K, V> root = null;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient Set<K> keySet = null;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private transient Collection<V> values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static final boolean RED = false;
    private static final boolean BLACK = true;

    private void incrementSize() {
        ++this.modCount;
        ++this.size;
    }

    private void decrementSize() {
        ++this.modCount;
        --this.size;
    }

    public RBTreeMap() {
    }

    public RBTreeMap(Comparator<? super K> c) {
        this.comparator = c;
    }

    public RBTreeMap(Map<? extends K, ? extends V> m) {
        this.putAll(m);
    }

    public RBTreeMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return value == null ? this.valueSearchNull(this.root) : this.valueSearchNonNull(this.root, value);
    }

    private boolean valueSearchNull(Entry<K, V> n) {
        if (n.value == null) {
            return true;
        }
        return n.left != null && this.valueSearchNull(n.left) || n.right != null && this.valueSearchNull(n.right);
    }

    private boolean valueSearchNonNull(Entry<K, V> n, Object value) {
        if (value.equals(n.value)) {
            return true;
        }
        return n.left != null && this.valueSearchNonNull(n.left, value) || n.right != null && this.valueSearchNonNull(n.right, value);
    }

    public V[] getClosestMatch(K key) {
        if (this.root == null) {
            return new Object[]{null, null};
        }
        Entry<K, V> lub = this.getCeilEntry(key);
        if (lub == null) {
            return new Object[]{this.lastEntry().value, null};
        }
        int cmp = this.compare(key, lub.key);
        if (cmp == 0) {
            return new Object[]{lub.value, lub.value};
        }
        Entry<K, V> prec = this.getPrecedingEntry(lub.key);
        if (prec == null) {
            return new Object[]{null, lub.value};
        }
        return new Object[]{prec.value, lub.value};
    }

    public V getNextOf(K key) {
        if (this.root == null) {
            return null;
        }
        Entry<K, V> lub = this.getCeilEntry(key);
        if (lub == null) {
            return null;
        }
        return (V)lub.value;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return RBTreeMap.key(this.firstEntry());
    }

    @Override
    public K lastKey() {
        return RBTreeMap.key(this.lastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    private Entry<K, V> getEntry(Object key) {
        Entry<Object, Object> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp == 0) {
                return p;
            }
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            p = p.right;
        }
        return null;
    }

    private Entry<K, V> getCeilEntry(Object key) {
        Entry<Object, Object> p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) == 0) {
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right == null) break;
            p = p.right;
        }
        Entry parent = p.parent;
        Entry<Object, Object> ch = p;
        while (parent != null && ch == parent.right) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private Entry<K, V> getPrecedingEntry(Object key) {
        Entry<Object, Object> p = this.root;
        if (p == null) {
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, p.key)) > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left == null) break;
            p = p.left;
        }
        Entry parent = p.parent;
        Entry<Object, Object> ch = p;
        while (parent != null && ch == parent.left) {
            ch = parent;
            parent = parent.parent;
        }
        return parent;
    }

    private static <X, Y> X key(Entry<X, Y> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return (X)e.key;
    }

    @Override
    public V put(K key, V value) {
        Entry<Object, Object> t = this.root;
        if (t == null) {
            this.incrementSize();
            this.root = new Entry<K, V>(key, value, null);
            return null;
        }
        while (true) {
            int cmp;
            if ((cmp = this.compare(key, t.key)) == 0) {
                return t.setValue((Object)value);
            }
            if (cmp < 0) {
                if (t.left != null) {
                    t = t.left;
                    continue;
                }
                this.incrementSize();
                t.left = new Entry<K, V>(key, value, t);
                this.fixAfterInsertion(t.left);
                return null;
            }
            if (t.right == null) break;
            t = t.right;
        }
        this.incrementSize();
        t.right = new Entry<K, V>(key, value, t);
        this.fixAfterInsertion(t.right);
        return null;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return (V)oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        return new RBTreeMap<K, V>(this);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public java.util.Iterator<K> iterator() {
                    return new Iterator(0);
                }

                @Override
                public int size() {
                    return RBTreeMap.this.size();
                }

                @Override
                public boolean contains(Object o) {
                    return RBTreeMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    return RBTreeMap.this.remove(o) != null;
                }

                @Override
                public void clear() {
                    RBTreeMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public java.util.Iterator<V> iterator() {
                    return new Iterator(1);
                }

                @Override
                public int size() {
                    return RBTreeMap.this.size();
                }

                @Override
                public boolean contains(Object o) {
                    Entry e = RBTreeMap.this.firstEntry();
                    while (e != null) {
                        if (RBTreeMap.valEquals(e.getValue(), o)) {
                            return true;
                        }
                        e = RBTreeMap.this.successor(e);
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    Entry e = RBTreeMap.this.firstEntry();
                    while (e != null) {
                        if (RBTreeMap.valEquals(e.getValue(), o)) {
                            RBTreeMap.this.deleteEntry(e);
                            return true;
                        }
                        e = RBTreeMap.this.successor(e);
                    }
                    return false;
                }

                @Override
                public void clear() {
                    RBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public java.util.Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator(2);
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = RBTreeMap.this.getEntry(entry.getKey());
                    return p != null && RBTreeMap.valEquals(p.getValue(), value);
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object value = entry.getValue();
                    Entry p = RBTreeMap.this.getEntry(entry.getKey());
                    if (p != null && RBTreeMap.valEquals(p.getValue(), value)) {
                        RBTreeMap.this.deleteEntry(p);
                        return true;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return RBTreeMap.this.size();
                }

                @Override
                public void clear() {
                    RBTreeMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public SortedMap<K, V> subMap(Object fromKey, Object toKey) {
        return new SubMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new SubMap(toKey, true);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new SubMap(fromKey, false);
    }

    private int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    private Entry<K, V> firstEntry() {
        Entry<Object, Object> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    @Override
    private Entry<K, V> lastEntry() {
        Entry<Object, Object> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    private Entry<K, V> successor(Entry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            Entry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        Entry p = t.parent;
        Entry<Object, Object> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static boolean colorOf(Entry<?, ?> p) {
        return p == null ? true : p.color;
    }

    private static <X, Y> Entry<X, Y> parentOf(Entry<X, Y> p) {
        return p == null ? null : p.parent;
    }

    private static void setColor(Entry<?, ?> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <X, Y> Entry<X, Y> leftOf(Entry<X, Y> p) {
        return p == null ? null : p.left;
    }

    private static <X, Y> Entry<X, Y> rightOf(Entry<X, Y> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(Entry<K, V> p) {
        Entry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(Entry<K, V> p) {
        Entry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(Entry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            Entry<K, V> y;
            if (RBTreeMap.parentOf(x) == RBTreeMap.leftOf(RBTreeMap.parentOf(RBTreeMap.parentOf(x)))) {
                y = RBTreeMap.rightOf(RBTreeMap.parentOf(RBTreeMap.parentOf(x)));
                if (!RBTreeMap.colorOf(y)) {
                    RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
                    RBTreeMap.setColor(y, true);
                    RBTreeMap.setColor(RBTreeMap.parentOf(RBTreeMap.parentOf(x)), false);
                    x = RBTreeMap.parentOf(RBTreeMap.parentOf(x));
                    continue;
                }
                if (x == RBTreeMap.rightOf(RBTreeMap.parentOf(x))) {
                    x = RBTreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
                RBTreeMap.setColor(RBTreeMap.parentOf(RBTreeMap.parentOf(x)), false);
                if (RBTreeMap.parentOf(RBTreeMap.parentOf(x)) == null) continue;
                this.rotateRight(RBTreeMap.parentOf(RBTreeMap.parentOf(x)));
                continue;
            }
            y = RBTreeMap.leftOf(RBTreeMap.parentOf(RBTreeMap.parentOf(x)));
            if (!RBTreeMap.colorOf(y)) {
                RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
                RBTreeMap.setColor(y, true);
                RBTreeMap.setColor(RBTreeMap.parentOf(RBTreeMap.parentOf(x)), false);
                x = RBTreeMap.parentOf(RBTreeMap.parentOf(x));
                continue;
            }
            if (x == RBTreeMap.leftOf(RBTreeMap.parentOf(x))) {
                x = RBTreeMap.parentOf(x);
                this.rotateRight(x);
            }
            RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
            RBTreeMap.setColor(RBTreeMap.parentOf(RBTreeMap.parentOf(x)), false);
            if (RBTreeMap.parentOf(RBTreeMap.parentOf(x)) == null) continue;
            this.rotateLeft(RBTreeMap.parentOf(RBTreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(Entry<K, V> p) {
        Entry replacement;
        this.decrementSize();
        if (p.left != null && p.right != null) {
            Entry<K, V> s = this.successor(p);
            this.swapPosition(s, p);
        }
        Entry entry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(Entry<K, V> x) {
        while (x != this.root && RBTreeMap.colorOf(x)) {
            Entry<K, V> sib;
            if (x == RBTreeMap.leftOf(RBTreeMap.parentOf(x))) {
                sib = RBTreeMap.rightOf(RBTreeMap.parentOf(x));
                if (!RBTreeMap.colorOf(sib)) {
                    RBTreeMap.setColor(sib, true);
                    RBTreeMap.setColor(RBTreeMap.parentOf(x), false);
                    this.rotateLeft(RBTreeMap.parentOf(x));
                    sib = RBTreeMap.rightOf(RBTreeMap.parentOf(x));
                }
                if (RBTreeMap.colorOf(RBTreeMap.leftOf(sib)) && RBTreeMap.colorOf(RBTreeMap.rightOf(sib))) {
                    RBTreeMap.setColor(sib, false);
                    x = RBTreeMap.parentOf(x);
                    continue;
                }
                if (RBTreeMap.colorOf(RBTreeMap.rightOf(sib))) {
                    RBTreeMap.setColor(RBTreeMap.leftOf(sib), true);
                    RBTreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = RBTreeMap.rightOf(RBTreeMap.parentOf(x));
                }
                RBTreeMap.setColor(sib, RBTreeMap.colorOf(RBTreeMap.parentOf(x)));
                RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
                RBTreeMap.setColor(RBTreeMap.rightOf(sib), true);
                this.rotateLeft(RBTreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = RBTreeMap.leftOf(RBTreeMap.parentOf(x));
            if (!RBTreeMap.colorOf(sib)) {
                RBTreeMap.setColor(sib, true);
                RBTreeMap.setColor(RBTreeMap.parentOf(x), false);
                this.rotateRight(RBTreeMap.parentOf(x));
                sib = RBTreeMap.leftOf(RBTreeMap.parentOf(x));
            }
            if (RBTreeMap.colorOf(RBTreeMap.rightOf(sib)) && RBTreeMap.colorOf(RBTreeMap.leftOf(sib))) {
                RBTreeMap.setColor(sib, false);
                x = RBTreeMap.parentOf(x);
                continue;
            }
            if (RBTreeMap.colorOf(RBTreeMap.leftOf(sib))) {
                RBTreeMap.setColor(RBTreeMap.rightOf(sib), true);
                RBTreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = RBTreeMap.leftOf(RBTreeMap.parentOf(x));
            }
            RBTreeMap.setColor(sib, RBTreeMap.colorOf(RBTreeMap.parentOf(x)));
            RBTreeMap.setColor(RBTreeMap.parentOf(x), true);
            RBTreeMap.setColor(RBTreeMap.leftOf(sib), true);
            this.rotateRight(RBTreeMap.parentOf(x));
            x = this.root;
        }
        RBTreeMap.setColor(x, true);
    }

    private void swapPosition(Entry<K, V> x, Entry<K, V> y) {
        boolean yWasLeftChild;
        Entry px = x.parent;
        Entry lx = x.left;
        Entry rx = x.right;
        Entry py = y.parent;
        Entry ly = y.left;
        Entry ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        boolean c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<K> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, java.util.Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = RBTreeMap.buildFromSorted(0, 0, size - 1, RBTreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    private static <X, Y> Entry<X, Y> buildFromSorted(int level, int lo, int hi, int redLevel, java.util.Iterator<?> it, ObjectInputStream str, Y defaultVal) throws IOException, ClassNotFoundException {
        Object value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = (lo + hi) / 2;
        Entry<X, Y> left = null;
        if (lo < mid) {
            left = RBTreeMap.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        Entry<Object, Y> middle = new Entry<Object, Y>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            Entry<X, Y> right = RBTreeMap.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    private static class Entry<M, N>
    implements Map.Entry<M, N> {
        M key;
        N value;
        Entry<M, N> left = null;
        Entry<M, N> right = null;
        Entry<M, N> parent;
        boolean color = true;

        Entry(M key, N value, Entry<M, N> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public M getKey() {
            return this.key;
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public N setValue(N value) {
            N oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return RBTreeMap.valEquals(this.key, e.getKey()) && RBTreeMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Iterator<E>
    implements java.util.Iterator<E> {
        private int type;
        private int expectedModCount;
        private Entry<K, V> lastReturned;
        private Entry<K, V> next;
        private Entry<K, V> firstExcluded;

        Iterator(int type) {
            this.expectedModCount = RBTreeMap.this.modCount;
            this.lastReturned = null;
            this.firstExcluded = null;
            this.type = type;
            this.next = RBTreeMap.this.firstEntry();
        }

        Iterator(Entry<K, V> first, Entry<K, V> firstExcluded) {
            this.expectedModCount = RBTreeMap.this.modCount;
            this.lastReturned = null;
            this.firstExcluded = null;
            this.type = 2;
            this.next = first;
            this.firstExcluded = firstExcluded;
        }

        @Override
        public boolean hasNext() {
            return this.next != this.firstExcluded;
        }

        @Override
        public E next() {
            if (this.next == this.firstExcluded) {
                throw new NoSuchElementException();
            }
            if (RBTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            this.next = RBTreeMap.this.successor(this.next);
            return (E)(this.type == 0 ? this.lastReturned.key : (this.type == 1 ? this.lastReturned.value : this.lastReturned));
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (RBTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            RBTreeMap.this.deleteEntry(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = null;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private boolean fromStart = false;
        private boolean toEnd = false;
        private Object fromKey;
        private Object toKey;
        private transient Set<Map.Entry<K, V>> entrySet = new EntrySetView();
        static final long serialVersionUID = 4333473260468321526L;

        SubMap(Object fromKey, Object toKey) {
            if (RBTreeMap.this.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        SubMap(Object key, boolean headMap) {
            if (headMap) {
                this.fromStart = true;
                this.toKey = key;
            } else {
                this.toEnd = true;
                this.fromKey = key;
            }
        }

        SubMap(boolean fromStart, Object fromKey, boolean toEnd, Object toKey) {
            this.fromStart = fromStart;
            this.fromKey = fromKey;
            this.toEnd = toEnd;
            this.toKey = toKey;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange(key) && RBTreeMap.this.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return RBTreeMap.this.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return RBTreeMap.this.put(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return RBTreeMap.this.comparator;
        }

        @Override
        public K firstKey() {
            return RBTreeMap.key(this.fromStart ? RBTreeMap.this.firstEntry() : RBTreeMap.this.getCeilEntry(this.fromKey));
        }

        @Override
        public K lastKey() {
            return RBTreeMap.key(this.toEnd ? RBTreeMap.this.lastEntry() : RBTreeMap.this.getPrecedingEntry(this.toKey));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(Object fromKey, Object toKey) {
            if (!this.inRange(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> headMap(Object toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromStart, this.fromKey, false, toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(Object fromKey) {
            if (!this.inRange(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(false, fromKey, this.toEnd, this.toKey);
        }

        private boolean inRange(Object key) {
            return !(!this.fromStart && RBTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && RBTreeMap.this.compare(key, this.toKey) >= 0);
        }

        private boolean inRange2(Object key) {
            return !(!this.fromStart && RBTreeMap.this.compare(key, this.fromKey) < 0 || !this.toEnd && RBTreeMap.this.compare(key, this.toKey) > 0);
        }

        private class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            private EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != RBTreeMap.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = RBTreeMap.this.modCount;
                    java.util.Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RBTreeMap.this.getEntry(key);
                return node != null && RBTreeMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                Entry node = RBTreeMap.this.getEntry(key);
                if (node != null && RBTreeMap.valEquals(node.getValue(), entry.getValue())) {
                    RBTreeMap.this.deleteEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public java.util.Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator(SubMap.this.fromStart ? RBTreeMap.this.firstEntry() : RBTreeMap.this.getCeilEntry(SubMap.this.fromKey), SubMap.this.toEnd ? null : RBTreeMap.this.getCeilEntry(SubMap.this.toKey));
            }
        }
    }
}

