/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.CreoleRegister;
import gate.DataStore;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AbstractResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@CreoleResource(name="Serial Datastore Viewer", guiType=GuiType.LARGE, resourceDisplayed="gate.persist.SerialDataStore", mainViewer=true)
public class SerialDatastoreViewer
extends JScrollPane
implements VisualResource,
DatastoreListener {
    DefaultMutableTreeNode treeRoot;
    DefaultTreeModel treeModel;
    JTree mainTree;
    DataStore datastore;
    NameBearerHandle myHandle;
    protected DeleteAction deleteAction;
    protected LoadAction loadAction;
    protected JPopupMenu popup;
    protected FeatureMap features;

    @Override
    public void cleanup() {
        this.datastore.removeDatastoreListener(this);
        this.myHandle = null;
        this.datastore = null;
    }

    @Override
    public FeatureMap getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(FeatureMap features) {
        this.features = features;
    }

    @Override
    public Object getParameterValue(String paramaterName) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, paramaterName);
    }

    @Override
    public void setParameterValue(String paramaterName, Object parameterValue) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        AbstractResource.setParameterValue(this, resBeanInf, paramaterName, parameterValue);
    }

    @Override
    public void setParameterValues(FeatureMap parameters) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, parameters);
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void clear() {
    }

    @Override
    public void setTarget(Object target) {
        if (target == null) {
            this.datastore = null;
            return;
        }
        if (!(target instanceof DataStore)) {
            throw new IllegalArgumentException("SerialDatastoreViewers can only be used with GATE serial datastores!\n" + target.getClass().toString() + " is not a GATE serial datastore!");
        }
        this.datastore = (DataStore)target;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    @Override
    public void setHandle(Handle handle) {
        if (handle instanceof NameBearerHandle) {
            this.myHandle = (NameBearerHandle)handle;
        }
    }

    protected void fireProgressChanged(int e) {
        this.myHandle.fireProgressChanged(e);
    }

    protected void fireProcessFinished() {
        this.myHandle.fireProcessFinished();
    }

    protected void fireStatusChanged(String e) {
        this.myHandle.fireStatusChanged(e);
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.treeRoot = new DefaultMutableTreeNode(this.datastore.getName(), true);
        this.treeModel = new DefaultTreeModel(this.treeRoot, true);
        this.mainTree = new JTree();
        this.mainTree.setModel(this.treeModel);
        this.mainTree.setExpandsSelectedPaths(true);
        this.mainTree.expandPath(new TreePath(this.treeRoot));
        this.mainTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.getChildCount() == 0 && node.getUserObject() instanceof DSType) {
                    DSType dsType = (DSType)node.getUserObject();
                    if (dsType.expanded) {
                        return;
                    }
                    node.removeAllChildren();
                    try {
                        for (String id : SerialDatastoreViewer.this.datastore.getLrIds(dsType.type)) {
                            DSEntry entry = new DSEntry(SerialDatastoreViewer.this.datastore.getLrName(id), id, dsType.type);
                            DefaultMutableTreeNode lrNode = new DefaultMutableTreeNode(entry, false);
                            SerialDatastoreViewer.this.treeModel.insertNodeInto(lrNode, node, node.getChildCount());
                            node.add(lrNode);
                        }
                        dsType.expanded = true;
                    }
                    catch (PersistenceException pe) {
                        throw new GateRuntimeException(pe.toString());
                    }
                }
            }
        });
        try {
            Iterator<String> lrTypesIter = this.datastore.getLrTypes().iterator();
            CreoleRegister cReg = Gate.getCreoleRegister();
            while (lrTypesIter.hasNext()) {
                String type = lrTypesIter.next();
                ResourceData rData = (ResourceData)cReg.get(type);
                DSType dsType = new DSType(rData.getName(), type);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(dsType);
                this.treeModel.insertNodeInto(node, this.treeRoot, this.treeRoot.getChildCount());
            }
        }
        catch (PersistenceException pe) {
            throw new GateRuntimeException(pe.toString());
        }
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(4);
        this.mainTree.setSelectionModel(selectionModel);
        this.getViewport().setView(this.mainTree);
        this.popup = new JPopupMenu();
        this.deleteAction = new DeleteAction();
        this.loadAction = new LoadAction();
        this.popup.add(this.deleteAction);
        this.popup.add(this.loadAction);
    }

    protected void initListeners() {
        this.datastore.addDatastoreListener(this);
        this.mainTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    TreePath path = SerialDatastoreViewer.this.mainTree.getPathForLocation(e.getX(), e.getY());
                    Object value = null;
                    if (path != null) {
                        value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    }
                    if (value != null && value instanceof DSEntry) {
                        SerialDatastoreViewer.this.loadAction.ignoreSelection = true;
                        SerialDatastoreViewer.this.loadAction.setLocation(path);
                        SerialDatastoreViewer.this.loadAction.actionPerformed(null);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = SerialDatastoreViewer.this.mainTree.getPathForLocation(e.getX(), e.getY());
                    SerialDatastoreViewer.this.deleteAction.setLocation(path);
                    SerialDatastoreViewer.this.loadAction.setLocation(path);
                    SerialDatastoreViewer.this.popup.show(SerialDatastoreViewer.this, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = SerialDatastoreViewer.this.mainTree.getPathForLocation(e.getX(), e.getY());
                    SerialDatastoreViewer.this.deleteAction.setLocation(path);
                    SerialDatastoreViewer.this.loadAction.setLocation(path);
                    SerialDatastoreViewer.this.popup.show(SerialDatastoreViewer.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void resourceAdopted(DatastoreEvent e) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent e) {
        String resID = (String)e.getResourceID();
        DefaultMutableTreeNode node = null;
        Enumeration<TreeNode> nodesEnum = this.treeRoot.depthFirstEnumeration();
        boolean found = false;
        while (nodesEnum.hasMoreElements() && !found) {
            node = (DefaultMutableTreeNode)nodesEnum.nextElement();
            Object userObject = node.getUserObject();
            found = userObject instanceof DSEntry && ((DSEntry)userObject).id.equals(resID);
        }
        if (found) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            this.treeModel.removeNodeFromParent(node);
            if (parent.getChildCount() == 0) {
                this.treeModel.removeNodeFromParent(parent);
            }
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent e) {
        Resource res = e.getResource();
        String resID = (String)e.getResourceID();
        String resType = ((ResourceData)Gate.getCreoleRegister().get(res.getClass().getName())).getName();
        DefaultMutableTreeNode parent = this.treeRoot;
        DefaultMutableTreeNode node = null;
        Enumeration<TreeNode> childrenEnum = parent.children();
        boolean found = false;
        while (childrenEnum.hasMoreElements() && !found) {
            node = (DefaultMutableTreeNode)childrenEnum.nextElement();
            if (!(node.getUserObject() instanceof DSType)) continue;
            found = ((DSType)node.getUserObject()).name.equals(resType);
        }
        if (!found) {
            node = new DefaultMutableTreeNode(new DSType(resType, res.getClass().getName()));
            this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
        }
        if (node.getUserObject() instanceof DSType && !((DSType)node.getUserObject()).expanded) {
            return;
        }
        parent = node;
        childrenEnum = parent.children();
        found = false;
        while (childrenEnum.hasMoreElements() && !found) {
            node = (DefaultMutableTreeNode)childrenEnum.nextElement();
            found = ((DSEntry)node.getUserObject()).id.equals(resID);
        }
        if (!found) {
            try {
                DSEntry entry = new DSEntry(this.datastore.getLrName(resID), resID, res.getClass().getName());
                node = new DefaultMutableTreeNode(entry, false);
                this.treeModel.insertNodeInto(node, parent, parent.getChildCount());
            }
            catch (PersistenceException pe) {
                pe.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    static class DSType {
        String name;
        String type;
        boolean expanded = false;

        DSType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }

    static class DSEntry {
        String name;
        String type;
        String id;

        DSEntry(String name, String id, String type) {
            this.name = name;
            this.type = type;
            this.id = id;
        }

        public String toString() {
            return this.name;
        }
    }

    class LoadAction
    extends AbstractAction {
        protected TreePath location;
        protected boolean ignoreSelection;

        public LoadAction() {
            super("Load");
            this.ignoreSelection = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TreePath[] selectedPaths = SerialDatastoreViewer.this.mainTree.getSelectionPaths();
                    if (LoadAction.this.ignoreSelection) {
                        LoadAction.this.ignoreSelection = false;
                        selectedPaths = null;
                    }
                    if (selectedPaths == null && LoadAction.this.location != null) {
                        selectedPaths = new TreePath[]{LoadAction.this.location};
                        LoadAction.this.location = null;
                    }
                    if (selectedPaths != null) {
                        for (TreePath aPath : selectedPaths) {
                            Object value = ((DefaultMutableTreeNode)aPath.getLastPathComponent()).getUserObject();
                            if (!(value instanceof DSEntry)) continue;
                            DSEntry entry = (DSEntry)value;
                            try {
                                MainFrame.lockGUI("Loading " + entry.name);
                                long start = System.currentTimeMillis();
                                SerialDatastoreViewer.this.fireStatusChanged("Loading " + entry.name);
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                FeatureMap params = Factory.newFeatureMap();
                                params.put("DataStore", SerialDatastoreViewer.this.datastore);
                                params.put("LRPersistenceId", entry.id);
                                FeatureMap features = Factory.newFeatureMap();
                                Factory.createResource(entry.type, params, features, entry.name);
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                SerialDatastoreViewer.this.fireProcessFinished();
                                long end = System.currentTimeMillis();
                                SerialDatastoreViewer.this.fireStatusChanged(entry.name + " loaded in " + NumberFormat.getInstance().format((double)(end - start) / 1000.0) + " seconds");
                            }
                            catch (ResourceInstantiationException rie) {
                                MainFrame.unlockGUI();
                                JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + rie.toString(), "GATE", 0);
                                rie.printStackTrace(Err.getPrintWriter());
                                SerialDatastoreViewer.this.fireProgressChanged(0);
                                SerialDatastoreViewer.this.fireProcessFinished();
                            }
                            finally {
                                MainFrame.unlockGUI();
                            }
                        }
                    }
                }
            };
            Thread thread = new Thread(runner, SerialDatastoreViewer.this.getClass().getCanonicalName() + " DS Loader");
            thread.setPriority(1);
            thread.start();
        }

        public TreePath getLocation() {
            return this.location;
        }

        public void setLocation(TreePath location) {
            this.location = location;
        }
    }

    class DeleteAction
    extends AbstractAction {
        TreePath location;

        public DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] selectedPaths = SerialDatastoreViewer.this.mainTree.getSelectionPaths();
            if (selectedPaths == null && this.location != null) {
                selectedPaths = new TreePath[]{this.location};
                this.location = null;
            }
            if (selectedPaths != null) {
                for (TreePath aPath : selectedPaths) {
                    Object value = ((DefaultMutableTreeNode)aPath.getLastPathComponent()).getUserObject();
                    if (!(value instanceof DSEntry)) continue;
                    DSEntry entry = (DSEntry)value;
                    try {
                        SerialDatastoreViewer.this.datastore.delete(entry.type, entry.id);
                    }
                    catch (PersistenceException pe) {
                        JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + pe.toString(), "GATE", 0);
                        pe.printStackTrace(Err.getPrintWriter());
                    }
                    catch (SecurityException se) {
                        JOptionPane.showMessageDialog(SerialDatastoreViewer.this, "Error!\n" + se.toString(), "GATE", 0);
                        se.printStackTrace(Err.getPrintWriter());
                    }
                }
            }
        }

        public TreePath getLocation() {
            return this.location;
        }

        public void setLocation(TreePath location) {
            this.location = location;
        }
    }
}

