/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.gui.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class OkCancelDialog
extends JDialog {
    protected JButton okButton;
    protected JButton cancelButton;
    protected boolean userHasPressedOK;
    protected boolean userHasPressedCancel;

    protected OkCancelDialog(Frame owner, String title, Component contents) {
        super(owner, title);
        this.init(contents);
    }

    protected OkCancelDialog(Dialog owner, String title, Component contents) {
        super(owner, title);
        this.init(contents);
    }

    protected OkCancelDialog(String title, Component contents) {
        this.setTitle(title);
        this.init(contents);
    }

    protected void init(Component contents) {
        MainFrame.getGuiRoots().add(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(contents, "Center");
        JPanel buttonsBox = new JPanel();
        buttonsBox.setLayout(new BoxLayout(buttonsBox, 0));
        buttonsBox.setAlignmentX(0.5f);
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.okButton);
        buttonsBox.add(Box.createHorizontalStrut(20));
        buttonsBox.add(this.cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(buttonsBox);
        vBox.add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)vBox, "South");
        AbstractAction applyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkCancelDialog.this.userHasPressedOK = true;
                OkCancelDialog.this.setVisible(false);
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkCancelDialog.this.userHasPressedCancel = true;
                OkCancelDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", applyAction);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", cancelAction);
        this.okButton.addActionListener(applyAction);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(cancelAction);
    }

    @Override
    public void dispose() {
        MainFrame.getGuiRoots().remove(this);
        super.dispose();
    }

    public static boolean showDialog(Component parentComponent, Component contents, String title) {
        Window parent = null;
        if (parentComponent != null) {
            parent = SwingUtilities.getWindowAncestor(parentComponent);
        }
        OkCancelDialog dialog = parent == null ? new OkCancelDialog(title, contents) : (parent instanceof Frame ? new OkCancelDialog((Frame)parent, title, contents) : new OkCancelDialog((Dialog)parent, title, contents));
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        dialog.setSize(dialogSize);
        dialog.setModal(true);
        dialog.userHasPressedOK = false;
        dialog.userHasPressedCancel = false;
        dialog.setVisible(true);
        return dialog.userHasPressedOK;
    }
}

