/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Term
implements Comparable,
Serializable {
    String field;
    String text;
    String type;

    public Term(String fld, String txt) {
        this(fld, txt, true);
    }

    public Term(String fld, String txt, String type) {
        this(fld, txt, type, true);
    }

    Term(String fld, String txt, String type, boolean intern) {
        this.field = intern ? fld.intern() : fld;
        this.text = txt;
        this.type = type;
    }

    Term(String fld, String txt, boolean intern) {
        this.field = intern ? fld.intern() : fld;
        this.text = txt;
    }

    public final String field() {
        return this.field;
    }

    public final String type() {
        return this.type;
    }

    public final String text() {
        return this.text;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Term other = (Term)o;
        if (this.type != null) {
            boolean ret = this.field.equals(other.field) && this.text.equals(other.text) && this.type.equals(other.type);
            return ret;
        }
        boolean ret = this.field.equals(other.field) && this.text.equals(other.text);
        return ret;
    }

    public final int hashCode() {
        if (this.type != null) {
            return this.field.hashCode() + this.text.hashCode() + this.type.hashCode();
        }
        return this.field.hashCode() + this.text.hashCode();
    }

    public int compareTo(Object other) {
        return this.compareTo((Term)other);
    }

    public final int compareTo(Term other) {
        if (this.field == other.field) {
            int rank = this.text.compareTo(other.text);
            if (rank == 0) {
                rank = this.type.compareTo(other.type);
                return rank;
            }
            return rank;
        }
        return this.field.compareTo(other.field);
    }

    public final int indexCompareTo(Term other) {
        if (this.field.equals(other.field)) {
            int rank = this.text.compareTo(other.text);
            if (rank == 0 && this.type != null && other.type != null) {
                rank = this.type.compareTo(other.type);
                if (rank == 0) {
                    return 0;
                }
                return rank;
            }
            return rank;
        }
        int rank = this.field.compareTo(other.field);
        return rank;
    }

    private boolean isWildcharMatches(String text, String other) {
        Pattern p = Pattern.compile(text);
        Matcher m = p.matcher(other);
        return m.matches();
    }

    final void set(String fld, String txt) {
        this.field = fld;
        this.text = txt;
    }

    final void set(String fld, String text, String type) {
        this.field = fld;
        this.text = text;
        this.type = type;
    }

    public final String toString() {
        if (this.type == null) {
            return this.field + ":" + this.text;
        }
        return this.field + ":" + this.text + ":" + this.type;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.field = this.field.intern();
    }
}

